/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.restapi.model.WaterConnectionSearchRequest;
import org.egov.restapi.web.rest.ConnectionSearchAdaptor;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestWaterConnectionSearchController {
    @Autowired
    private SearchService searchService;

    @RequestMapping(value={"/watercharges/searchconnection"}, method={RequestMethod.POST})
    @ResponseBody
    public String searchConnection(@RequestBody WaterConnectionSearchRequest searchRequest) {
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.WATERCHARGES.toString()), Arrays.asList(IndexType.CONNECTIONSEARCH.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), Sort.NULL, Page.NULL);
        return this.convertSearchResultToJson((Object)searchResult);
    }

    private String convertSearchResultToJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(SearchResult.class, (Object)new ConnectionSearchAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

