/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.util;

import java.util.List;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.FloorDetails;
import org.egov.ptis.domain.model.OwnerDetails;
import org.egov.ptis.domain.model.PayPropertyTaxDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.restapi.model.AssessmentsDetails;
import org.egov.restapi.model.CreatePropertyDetails;
import org.egov.restapi.model.SurroundingBoundaryDetails;
import org.egov.restapi.model.VacantLandDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValidationUtil {
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PropertyExternalService propertyExternalService;

    public static ErrorDetails validateCreateRequest(CreatePropertyDetails createPropDetails) {
        List floorDetailsList;
        ErrorDetails errorDetails = null;
        String propertyTypeMasterCode = createPropDetails.getPropertyTypeMasterCode();
        if (propertyTypeMasterCode == null || propertyTypeMasterCode.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("01");
            errorDetails.setErrorMessage("Category of Ownership is required.");
            return errorDetails;
        }
        if (!(propertyTypeMasterCode == null || propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND") || propertyTypeMasterCode.equalsIgnoreCase("PRIVATE") || propertyTypeMasterCode.equalsIgnoreCase("STATE_GOVT") || propertyTypeMasterCode.equalsIgnoreCase("CENTRAL_GOVT_33.5") || propertyTypeMasterCode.equalsIgnoreCase("CENTRAL_GOVT_50") || propertyTypeMasterCode.equalsIgnoreCase("CENTRAL_GOVT_75"))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("02");
            errorDetails.setErrorMessage("Invalid Category of Ownership. It can be VAC_LAND/PRIVATE/STATE_GOVT/CENTRAL_GOVT_33.5/CENTRAL_GOVT_50/CENTRAL_GOVT_75.");
            return errorDetails;
        }
        String propertyCategoryCode = createPropDetails.getPropertyCategoryCode();
        if (propertyCategoryCode == null || propertyCategoryCode.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("03");
            errorDetails.setErrorMessage("Property Type is required.");
            return errorDetails;
        }
        if (!(propertyCategoryCode == null || propertyCategoryCode.equalsIgnoreCase("RESIDENTIAl") || propertyCategoryCode.equalsIgnoreCase("NON_RESIDENTIAL") || propertyCategoryCode.equalsIgnoreCase("MIXED"))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("04");
            errorDetails.setErrorMessage("Invalid Property Type. It can be RESIDENTIAl/NON_RESIDENTIAL/MIXED");
            return errorDetails;
        }
        List ownerDetailsList = createPropDetails.getOwnerDetails();
        if (ownerDetailsList == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("35");
            errorDetails.setErrorMessage("Owner Details is required.");
            return errorDetails;
        }
        for (OwnerDetails ownerDetails : ownerDetailsList) {
            if (ownerDetails.getMobileNumber() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("30");
                errorDetails.setErrorMessage("Mobile Number is required.");
                return errorDetails;
            }
            if (ownerDetails.getName() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("30");
                errorDetails.setErrorMessage("Owner Name is required.");
                return errorDetails;
            }
            if (ownerDetails.getGender() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("31");
                errorDetails.setErrorMessage("Gender is required.");
                return errorDetails;
            }
            if (ownerDetails.getGuardianRelation() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("32");
                errorDetails.setErrorMessage("Guardian Relation is required.");
                return errorDetails;
            }
            if (ownerDetails.getGuardian() != null) continue;
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("33");
            errorDetails.setErrorMessage("Guardian is required.");
            return errorDetails;
        }
        AssessmentsDetails assessmentsDetails = createPropDetails.getAssessmentDetails();
        if (assessmentsDetails == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("36");
            errorDetails.setErrorMessage("Assessment Details is required.");
            return errorDetails;
        }
        if (assessmentsDetails.getMutationReasonCode() == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("37");
            errorDetails.setErrorMessage("Reason For Creation is required.");
            return errorDetails;
        }
        if (assessmentsDetails.getExtentOfSite() == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("38");
            errorDetails.setErrorMessage("Extent of Site (Sq.Mtrs) is required.");
            return errorDetails;
        }
        if (assessmentsDetails.getRegdDocNo() == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("05");
            errorDetails.setErrorMessage("Registration Doc No is required.");
            return errorDetails;
        }
        if (assessmentsDetails.getRegdDocDate() == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("06");
            errorDetails.setErrorMessage("Registration Doc Date is required.");
            return errorDetails;
        }
        if (assessmentsDetails.getIsExtentAppurtenantLand().booleanValue()) {
            VacantLandDetails vacantLandDetails = createPropDetails.getVacantLandDetails();
            if (vacantLandDetails == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("39");
                errorDetails.setErrorMessage("Vacant Land Details is required.");
                return errorDetails;
            }
            if (vacantLandDetails.getSurveyNumber() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("07");
                errorDetails.setErrorMessage("Survey Number is required.");
                return errorDetails;
            }
            if (vacantLandDetails.getPattaNumber() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("08");
                errorDetails.setErrorMessage("Patta Number is required.");
                return errorDetails;
            }
            if (vacantLandDetails.getVacantLandArea() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("09");
                errorDetails.setErrorMessage("Vacant Land Area is required.");
                return errorDetails;
            }
            if (vacantLandDetails.getMarketValue() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("10");
                errorDetails.setErrorMessage("Market area Value per Sq.Mtrs (As Per Current Registration department) is required.");
                return errorDetails;
            }
            if (vacantLandDetails.getCurrentCapitalValue() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("11");
                errorDetails.setErrorMessage("Current Capital Value is required.");
                return errorDetails;
            }
            if (vacantLandDetails.getEffectiveDate() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("12");
                errorDetails.setErrorMessage("Effective Date is required.");
                return errorDetails;
            }
            SurroundingBoundaryDetails surBoundaryDetails = createPropDetails.getSurroundingBoundaryDetails();
            if (surBoundaryDetails == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("41");
                errorDetails.setErrorMessage("Surrounding Boundary Details is required.");
                return errorDetails;
            }
            if (surBoundaryDetails.getNorthBoundary() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("13");
                errorDetails.setErrorMessage("North is required.");
                return errorDetails;
            }
            if (surBoundaryDetails.getSouthBoundary() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("14");
                errorDetails.setErrorMessage("South is required.");
                return errorDetails;
            }
            if (surBoundaryDetails.getEastBoundary() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("15");
                errorDetails.setErrorMessage("East is required.");
                return errorDetails;
            }
            if (surBoundaryDetails.getWestBoundary() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("16");
                errorDetails.setErrorMessage("East is required.");
                return errorDetails;
            }
        }
        if ((floorDetailsList = createPropDetails.getFloorDetails()) == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("40");
            errorDetails.setErrorMessage("Floor Details is required.");
            return errorDetails;
        }
        for (FloorDetails floorDetails : floorDetailsList) {
            if (floorDetails.getFloorNoCode() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("17");
                errorDetails.setErrorMessage("Floor Number is required.");
                return errorDetails;
            }
            if (floorDetails.getBuildClassificationCode() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("18");
                errorDetails.setErrorMessage("Floor Number is required.");
                return errorDetails;
            }
            if (floorDetails.getNatureOfUsageCode() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("19");
                errorDetails.setErrorMessage("Nature of Usage is required.");
                return errorDetails;
            }
            if (floorDetails.getOccupancyCode() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("20");
                errorDetails.setErrorMessage("Occupancy is required.");
                return errorDetails;
            }
            if (floorDetails.getConstructionDate() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("21");
                errorDetails.setErrorMessage("Construction Date is required.");
                return errorDetails;
            }
            if (floorDetails.getPlinthArea() != null) continue;
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("22");
            errorDetails.setErrorMessage("Plinth area (Sq.Mtrs) is required.");
            return errorDetails;
        }
        return errorDetails;
    }

    public ErrorDetails validatePaymentDetails(PayPropertyTaxDetails payPropTaxDetails) {
        BillReceiptInfo billReceiptList;
        ErrorDetails errorDetails = null;
        if (payPropTaxDetails.getAssessmentNo() == null || payPropTaxDetails.getAssessmentNo().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-12");
            errorDetails.setErrorMessage("Assessment number is required");
        } else {
            if (payPropTaxDetails.getAssessmentNo().trim().length() > 0 && payPropTaxDetails.getAssessmentNo().trim().length() < 10) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-8");
                errorDetails.setErrorMessage("Assessment number length can not less than 10 digits");
            }
            if (!this.basicPropertyDAO.isAssessmentNoExist(payPropTaxDetails.getAssessmentNo()).booleanValue()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-11");
                errorDetails.setErrorMessage("Assessment number not found");
            }
        }
        if (payPropTaxDetails.getTransactionId() == null || "".equals(payPropTaxDetails.getTransactionId())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-25");
            errorDetails.setErrorMessage("Invalid Request, No transaction ID is associated");
        } else if (!(payPropTaxDetails.getTransactionId() == null && "".equals(payPropTaxDetails.getTransactionId()) || (billReceiptList = this.propertyExternalService.validateTransanctionIdPresent(payPropTaxDetails.getTransactionId())) == null)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-26");
            errorDetails.setErrorMessage("Invalid Request, Used transaction ID is associated");
        }
        if (payPropTaxDetails.getPaymentMode() == null || payPropTaxDetails.getPaymentMode().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-13");
            errorDetails.setErrorMessage("Payment mode is required");
        } else if (!("CASH".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()) || "CHEQUE".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-14");
            errorDetails.setErrorMessage("Payment mode is invalid");
        }
        if (payPropTaxDetails.getPaymentMode() != null && ("CHEQUE".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()))) {
            if (payPropTaxDetails.getChqddNo() == null || payPropTaxDetails.getChqddNo().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-34");
                errorDetails.setErrorMessage("Cheque/DD number is required");
            } else if (payPropTaxDetails.getChqddDate() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-35");
                errorDetails.setErrorMessage("Cheque/DD Date is required");
            } else if (payPropTaxDetails.getBankName() == null || payPropTaxDetails.getBankName().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-36");
                errorDetails.setErrorMessage("Bank Name is required");
            } else if (payPropTaxDetails.getBranchName() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-37");
                errorDetails.setErrorMessage("Branch Name  is required");
            }
        }
        return errorDetails;
    }
}

