/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.vacancyremission;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.entity.property.VacancyRemissionDetails;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.property.VacancyRemissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/vacancyremission/"})
public class VacanyRemissionMonthlyUpdateController {
    private VacancyRemissionService vacancyRemissionService;
    @Autowired
    private PropertyService propertyService;

    @Autowired
    public VacanyRemissionMonthlyUpdateController(VacancyRemissionService vacancyRemissionService, PropertyTaxUtil propertyTaxUtil) {
        this.vacancyRemissionService = vacancyRemissionService;
    }

    @ModelAttribute
    public VacancyRemission getVacancyRemission(@PathVariable String assessmentNo) {
        VacancyRemission vacancyRemission = this.vacancyRemissionService.getApprovedVacancyRemissionForProperty(assessmentNo);
        return vacancyRemission;
    }

    @ModelAttribute(value="documentsList")
    public List<DocumentType> documentsList(@ModelAttribute VacancyRemission vacancyRemission) {
        return this.vacancyRemissionService.getDocuments(TransactionType.VRMONTHLYUPDATE);
    }

    @RequestMapping(value={"/monthlyupdate/{assessmentNo}"}, method={RequestMethod.GET})
    public String newform(Model model, @PathVariable String assessmentNo, HttpServletRequest request) {
        VacancyRemission vacancyRemission = this.vacancyRemissionService.getApprovedVacancyRemissionForProperty(assessmentNo);
        VacancyRemissionDetails remissionDetails = new VacancyRemissionDetails();
        List documentTypes = this.propertyService.getDocumentTypesForTransactionType(TransactionType.VRMONTHLYUPDATE);
        model.addAttribute("remissionDetailsObj", (Object)remissionDetails);
        model.addAttribute("documentTypes", (Object)documentTypes);
        if (!vacancyRemission.getDocuments().isEmpty()) {
            model.addAttribute("attachedDocuments", (Object)vacancyRemission.getDocuments());
        }
        this.vacancyRemissionService.addModelAttributes(model, (BasicProperty)vacancyRemission.getBasicProperty());
        return "vacancyRemissionDetails-form";
    }

    public void populateRemissionDetails(VacancyRemissionDetails vacancyRemissionDetails, VacancyRemission vacancyRemission) {
        List<VacancyRemissionDetails> remissionDetailsList = new ArrayList<VacancyRemissionDetails>();
        if (vacancyRemissionDetails != null) {
            vacancyRemissionDetails.setVacancyRemission(vacancyRemission);
            if (vacancyRemission.getVacancyRemissionDetails() == null || vacancyRemission.getVacancyRemissionDetails().isEmpty()) {
                remissionDetailsList.add(vacancyRemissionDetails);
            } else {
                remissionDetailsList = vacancyRemission.getVacancyRemissionDetails();
                remissionDetailsList.add(vacancyRemissionDetails);
            }
            vacancyRemission.setVacancyRemissionDetails(remissionDetailsList);
        }
    }

    @RequestMapping(value={"/monthlyupdate/{assessmentNo}"}, method={RequestMethod.POST})
    public String saveRemissionDetails(@Valid @ModelAttribute VacancyRemission vacancyRemission, BindingResult errors, RedirectAttributes redirectAttrs, Model model, HttpServletRequest request) {
        String wfAction = request.getParameter("wfAction");
        String comments = request.getParameter("remissionComments");
        VacancyRemissionDetails remissionDetailsObj = new VacancyRemissionDetails();
        ArrayList documents = new ArrayList();
        remissionDetailsObj.setComments(comments);
        remissionDetailsObj.setCheckinDate(new Date());
        documents.addAll(vacancyRemission.getDocuments());
        vacancyRemission.getDocuments().clear();
        vacancyRemission.getDocuments().addAll(documents);
        this.processAndStoreApplicationDocuments(vacancyRemission);
        if ("Reject".equalsIgnoreCase(wfAction)) {
            this.vacancyRemissionService.rejectVacancyRemission(vacancyRemission, comments, request);
            model.addAttribute("successMessage", (Object)"Vacancy Remission application rejected !");
        } else {
            this.populateRemissionDetails(remissionDetailsObj, vacancyRemission);
            this.vacancyRemissionService.saveRemissionDetails(vacancyRemission);
            model.addAttribute("successMessage", (Object)"Remission details saved successfully!!");
        }
        return "vacancyRemission-success";
    }

    protected void processAndStoreApplicationDocuments(VacancyRemission vacancyRemission) {
        if (!vacancyRemission.getDocuments().isEmpty()) {
            for (Document applicationDocument : vacancyRemission.getDocuments()) {
                if (applicationDocument.getFile() == null) continue;
                applicationDocument.setType(this.vacancyRemissionService.getDocType(applicationDocument.getType().getName()));
                applicationDocument.setFiles(this.propertyService.addToFileStore(applicationDocument.getFile()));
            }
        }
    }
}

