/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.vacancyremission;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.Installment;
import org.egov.eis.entity.Assignment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.property.VacancyRemissionService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/vacancyremission"})
public class VacanyRemissionController
extends GenericWorkFlowController {
    private static final String STATE_TYPE = "stateType";
    private static final String VACANCY_REMISSION = "VACANCY_REMISSION";
    private static final String VACANCYREMISSION_FORM = "vacancyRemission-form";
    private static final String VACANCYREMISSION_SUCCESS = "vacancyRemission-success";
    private static final String ERROR_MSG = "errorMsg";
    private static final String APPLICATION_SOURCE = "applicationSource";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    private final PropertyTaxUtil propertyTaxUtil;
    private BasicProperty basicProperty;
    private VacancyRemission vacancyRemission;
    private final VacancyRemissionService vacancyRemissionService;
    private Boolean loggedUserIsMeesevaUser = Boolean.FALSE;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    @Autowired
    public VacanyRemissionController(VacancyRemissionService vacancyRemissionService, PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
        this.vacancyRemissionService = vacancyRemissionService;
    }

    @ModelAttribute
    public VacancyRemission vacancyRemissionModel(@PathVariable String assessmentNo) {
        this.vacancyRemission = new VacancyRemission();
        this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        if (this.basicProperty != null) {
            this.vacancyRemission.setBasicProperty((BasicPropertyImpl)this.basicProperty);
        }
        return this.vacancyRemission;
    }

    @ModelAttribute(value="documentsList")
    public List<DocumentType> documentsList(@ModelAttribute VacancyRemission vacancyRemission) {
        return this.vacancyRemissionService.getDocuments(TransactionType.VACANCYREMISSION);
    }

    @RequestMapping(value={"/create/{assessmentNo},{mode}"}, method={RequestMethod.GET})
    public String newForm(Model model, @PathVariable String assessmentNo, @PathVariable String mode, @RequestParam(required=false) String meesevaApplicationNumber, HttpServletRequest request, @RequestParam(required=false) String applicationSource) {
        if (this.basicProperty != null) {
            PropertyImpl property = this.basicProperty.getActiveProperty();
            User loggedInUser = this.securityUtils.getCurrentUser();
            List documentTypes = this.propertyService.getDocumentTypesForTransactionType(TransactionType.VACANCYREMISSION);
            if (!"Anonymous".equalsIgnoreCase(loggedInUser.getName()) && this.propertyService.isEmployee(loggedInUser).booleanValue() && !this.propertyTaxCommonUtils.isEligibleInitiator(loggedInUser.getId()).booleanValue()) {
                model.addAttribute(ERROR_MSG, (Object)"msg.initiator.noteligible");
                return "propertyValidation";
            }
            if (this.basicProperty.getActiveProperty().getPropertyDetail().isStructure()) {
                model.addAttribute(ERROR_MSG, (Object)"error.superstruc.prop.notallowed");
                return "propertyValidation";
            }
            if (this.vacancyRemissionService.isUnderWtmsWF(this.basicProperty.getUpicNo(), request).booleanValue()) {
                model.addAttribute(ERROR_MSG, (Object)"msg.under.wtms.wf.vr");
                return "propertyValidation";
            }
            if (property != null) {
                if ("commonSearch".equalsIgnoreCase(mode)) {
                    VacancyRemission vacancyRemission;
                    Boolean enableVacancyRemission = Boolean.FALSE;
                    if (property.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
                        model.addAttribute(ERROR_MSG, (Object)"msg.vlt.error");
                        return "propertyValidation";
                    }
                    if (property.getIsExemptedFromTax().booleanValue()) {
                        model.addAttribute(ERROR_MSG, (Object)"msg.property.exempted");
                        return "propertyValidation";
                    }
                    if (this.basicProperty.isUnderWorkflow()) {
                        model.addAttribute(ERROR_MSG, (Object)"msg.under.workflow");
                        return "propertyValidation";
                    }
                    List remissionList = this.vacancyRemissionService.getAllVacancyRemissionByUpicNo(this.basicProperty.getUpicNo());
                    if (!remissionList.isEmpty() && (vacancyRemission = (VacancyRemission)remissionList.get(remissionList.size() - 1)) != null) {
                        if (vacancyRemission.getStatus().equalsIgnoreCase("APPROVED")) {
                            if (org.apache.commons.lang.time.DateUtils.isSameDay((Date)vacancyRemission.getVacancyToDate(), (Date)new Date())) {
                                enableVacancyRemission = true;
                            } else if (vacancyRemission.getVacancyToDate().compareTo(new Date()) < 0) {
                                enableVacancyRemission = true;
                            }
                        } else if (vacancyRemission.getStatus().equalsIgnoreCase("Rejection Acknowledgement Generated")) {
                            enableVacancyRemission = true;
                        } else if (vacancyRemission.getStatus().equalsIgnoreCase("IN_WORKFLOW")) {
                            model.addAttribute(ERROR_MSG, (Object)"msg.under.workflow");
                            return "propertyValidation";
                        }
                    }
                    if (remissionList.isEmpty() || enableVacancyRemission.booleanValue()) {
                        BigDecimal currentPropertyTaxDue;
                        BigDecimal currentPropertyTax;
                        Map propertyTaxDetails = this.propertyService.getCurrentPropertyTaxDetails((Property)this.basicProperty.getActiveProperty());
                        Map installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                        Installment installmentFirstHalf = (Installment)installmentMap.get("Current 1st Half");
                        if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
                            currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD");
                            currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_COLL"));
                        } else {
                            currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD");
                            currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_COLL"));
                        }
                        BigDecimal arrearPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("ARR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("ARR_COLL"));
                        BigDecimal currentWaterTaxDue = this.vacancyRemissionService.getWaterTaxDues(this.basicProperty.getUpicNo(), request);
                        model.addAttribute("assessementNo", (Object)this.basicProperty.getUpicNo());
                        model.addAttribute("ownerName", (Object)this.basicProperty.getFullOwnerName());
                        model.addAttribute("doorNo", (Object)this.basicProperty.getAddress().getHouseNoBldgApt());
                        model.addAttribute("currentPropertyTax", (Object)currentPropertyTax);
                        model.addAttribute("currentPropertyTaxDue", (Object)currentPropertyTaxDue);
                        model.addAttribute("arrearPropertyTaxDue", (Object)arrearPropertyTaxDue);
                        model.addAttribute("currentWaterTaxDue", (Object)currentWaterTaxDue);
                        if (currentWaterTaxDue.add(currentPropertyTaxDue).add(arrearPropertyTaxDue).longValue() > 0L) {
                            model.addAttribute("taxDuesErrorMsg", (Object)"Please clear property tax due for availing vacancy remission for your property ");
                            return "taxdues";
                        }
                        this.prepareWorkflow(model, (StateAware)this.vacancyRemission, new WorkflowContainer());
                        model.addAttribute(STATE_TYPE, (Object)this.vacancyRemission.getClass().getSimpleName());
                        model.addAttribute("documentTypes", (Object)documentTypes);
                        model.addAttribute(APPLICATION_SOURCE, (Object)applicationSource);
                        this.vacancyRemissionService.addModelAttributes(model, this.basicProperty);
                    }
                    this.loggedUserIsMeesevaUser = this.propertyService.isMeesevaUser(this.vacancyRemissionService.getLoggedInUser());
                    if (this.loggedUserIsMeesevaUser.booleanValue()) {
                        if (meesevaApplicationNumber == null) {
                            throw new ApplicationRuntimeException("MEESEVA.005");
                        }
                        this.vacancyRemission.setMeesevaApplicationNumber(meesevaApplicationNumber);
                    }
                } else {
                    BigDecimal currentPropertyTaxDue;
                    BigDecimal currentPropertyTax;
                    boolean hasChildPropertyUnderWorkflow = this.propertyTaxUtil.checkForParentUsedInBifurcation(this.basicProperty.getUpicNo());
                    if (hasChildPropertyUnderWorkflow) {
                        model.addAttribute(ERROR_MSG, (Object)"Cannot proceed as this property is used in Bifurcation, which is under workflow");
                        return "propertyValidation";
                    }
                    Map propertyTaxDetails = this.propertyService.getCurrentPropertyTaxDetails((Property)this.basicProperty.getActiveProperty());
                    Map installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                    Installment installmentFirstHalf = (Installment)installmentMap.get("Current 1st Half");
                    if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
                        currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD");
                        currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_COLL"));
                    } else {
                        currentPropertyTax = (BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD");
                        currentPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_SECONDHALF_COLL"));
                    }
                    BigDecimal arrearPropertyTaxDue = ((BigDecimal)propertyTaxDetails.get("ARR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("ARR_COLL"));
                    BigDecimal currentWaterTaxDue = this.vacancyRemissionService.getWaterTaxDues(this.basicProperty.getUpicNo(), request);
                    model.addAttribute("currentPropertyTax", (Object)currentPropertyTax);
                    model.addAttribute("currentPropertyTaxDue", (Object)currentPropertyTaxDue);
                    model.addAttribute("arrearPropertyTaxDue", (Object)arrearPropertyTaxDue);
                    model.addAttribute("currentWaterTaxDue", (Object)currentWaterTaxDue);
                    if (currentWaterTaxDue.add(currentPropertyTaxDue).add(arrearPropertyTaxDue).longValue() > 0L) {
                        model.addAttribute("taxDuesErrorMsg", (Object)"Please clear property tax due for availing vacancy remission for your property ");
                        return "taxdues";
                    }
                    model.addAttribute("documentTypes", (Object)documentTypes);
                    this.prepareWorkflow(model, (StateAware)this.vacancyRemission, new WorkflowContainer());
                    model.addAttribute(STATE_TYPE, (Object)this.vacancyRemission.getClass().getSimpleName());
                    this.vacancyRemissionService.addModelAttributes(model, this.basicProperty);
                }
            }
        }
        return VACANCYREMISSION_FORM;
    }

    @RequestMapping(value={"/create/{assessmentNo},{mode}"}, method={RequestMethod.POST})
    public String saveVacancyRemission(@Valid @ModelAttribute VacancyRemission vacancyRemission, BindingResult resultBinder, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam String workFlowAction) {
        Assignment assignment;
        Boolean propertyByEmployee = Boolean.valueOf(request.getParameter("propertyByEmployee"));
        ArrayList documents = new ArrayList();
        this.loggedUserIsMeesevaUser = this.propertyService.isMeesevaUser(this.vacancyRemissionService.getLoggedInUser());
        this.validateDates(vacancyRemission, resultBinder, request);
        this.vacancyRemissionSource(vacancyRemission, request);
        Assignment assignment2 = assignment = this.propertyService.isCscOperator(this.vacancyRemissionService.getLoggedInUser()) != false ? this.propertyService.getAssignmentByDeptDesigElecWard(this.basicProperty) : null;
        if (resultBinder.hasErrors()) {
            if (this.basicProperty != null) {
                this.prepareWorkflow(model, (StateAware)vacancyRemission, new WorkflowContainer());
                model.addAttribute(STATE_TYPE, (Object)vacancyRemission.getClass().getSimpleName());
                this.vacancyRemissionService.addModelAttributes(model, this.basicProperty);
            }
            return VACANCYREMISSION_FORM;
        }
        if ((!propertyByEmployee.booleanValue() || this.loggedUserIsMeesevaUser.booleanValue()) && assignment == null && this.propertyService.getUserPositionByZone(this.basicProperty, false) == null) {
            this.prepareWorkflow(model, (StateAware)vacancyRemission, new WorkflowContainer());
            model.addAttribute(STATE_TYPE, (Object)vacancyRemission.getClass().getSimpleName());
            model.addAttribute(ERROR_MSG, (Object)"No Senior or Junior assistants exists,Please check");
            this.vacancyRemissionService.addModelAttributes(model, this.basicProperty);
            return VACANCYREMISSION_FORM;
        }
        Long approvalPosition = 0L;
        String approvalComent = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (!vacancyRemission.getDocuments().isEmpty()) {
            documents.addAll(vacancyRemission.getDocuments());
            vacancyRemission.getDocuments().clear();
            vacancyRemission.getDocuments().addAll(documents);
            this.processAndStoreApplicationDocuments(vacancyRemission);
        }
        if (this.loggedUserIsMeesevaUser.booleanValue()) {
            HashMap<String, String> meesevaParams = new HashMap<String, String>();
            meesevaParams.put("APPLICATIONNUMBER", vacancyRemission.getMeesevaApplicationNumber());
            if (StringUtils.isBlank((String)vacancyRemission.getApplicationNumber())) {
                vacancyRemission.setApplicationNumber(vacancyRemission.getMeesevaApplicationNumber());
            }
            this.vacancyRemissionService.saveVacancyRemission(vacancyRemission, approvalPosition, approvalComent, "", workFlowAction, propertyByEmployee, meesevaParams);
        } else {
            this.vacancyRemissionService.saveVacancyRemission(vacancyRemission, approvalPosition, approvalComent, null, workFlowAction, propertyByEmployee);
        }
        String successMsg = "Vacancy Remission Saved Successfully in the System and forwarded to : " + this.propertyTaxUtil.getApproverUserName(vacancyRemission.getState().getOwnerPosition().getId()) + " with application number : " + vacancyRemission.getApplicationNumber();
        model.addAttribute("successMessage", (Object)successMsg);
        model.addAttribute("showAckBtn", (Object)Boolean.TRUE);
        model.addAttribute("isOnlineApplication", (Object)"Anonymous".equalsIgnoreCase(this.vacancyRemissionService.getLoggedInUser().getName()));
        model.addAttribute("propertyId", (Object)this.basicProperty.getUpicNo());
        if (this.loggedUserIsMeesevaUser.booleanValue()) {
            return "redirect:/vacancyremission/generate-meesevareceipt/" + vacancyRemission.getBasicProperty().getUpicNo() + "?transactionServiceNumber=" + vacancyRemission.getApplicationNumber();
        }
        return VACANCYREMISSION_SUCCESS;
    }

    private void vacancyRemissionSource(VacancyRemission vacancyRemission, HttpServletRequest request) {
        User loggedInUser = this.securityUtils.getCurrentUser();
        if (StringUtils.isNotBlank((String)request.getParameter(APPLICATION_SOURCE)) && "ONLINE".equalsIgnoreCase(request.getParameter(APPLICATION_SOURCE)) && "Anonymous".equalsIgnoreCase(loggedInUser.getName())) {
            vacancyRemission.setSource(this.propertyTaxCommonUtils.setSourceOfProperty(loggedInUser, Boolean.TRUE));
        } else {
            vacancyRemission.setSource(this.propertyTaxCommonUtils.setSourceOfProperty(loggedInUser, Boolean.FALSE));
        }
    }

    @RequestMapping(value={"/generate-meesevareceipt/{assessmentNo}"}, method={RequestMethod.GET})
    public RedirectView generateMeesevaReceipt(HttpServletRequest request, Model model) {
        String keyNameArray = request.getParameter("transactionServiceNumber");
        RedirectView redirect = new RedirectView("/meeseva/generatereceipt?transactionServiceNumber=" + keyNameArray, false);
        FlashMap outputFlashMap = RequestContextUtils.getOutputFlashMap((HttpServletRequest)request);
        if (outputFlashMap != null) {
            outputFlashMap.put((Object)"url", (Object)request.getRequestURL());
        }
        return redirect;
    }

    private void validateDates(VacancyRemission vacancyRemission, BindingResult errors, HttpServletRequest request) {
        int noOfMonths = DateUtils.noOfMonthsBetween((Date)vacancyRemission.getVacancyFromDate(), (Date)vacancyRemission.getVacancyToDate());
        if (noOfMonths < 6) {
            errors.rejectValue("vacancyToDate", "vacancyToDate.incorrect");
        }
    }

    protected void processAndStoreApplicationDocuments(VacancyRemission vacancyRemission) {
        if (!vacancyRemission.getDocuments().isEmpty()) {
            for (Document applicationDocument : vacancyRemission.getDocuments()) {
                if (applicationDocument.getFile() == null) continue;
                applicationDocument.setType(this.vacancyRemissionService.getDocType(applicationDocument.getType().getName()));
                applicationDocument.setFiles(this.propertyService.addToFileStore(applicationDocument.getFile()));
            }
        }
    }

    @ResponseBody
    @RequestMapping(value={"/printAck/{assessmentNo}"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> printAck(HttpServletRequest request, Model model, @PathVariable(value="assessmentNo") String assessmentNo) {
        ReportOutput reportOutput = this.propertyTaxUtil.generateCitizenCharterAcknowledgement(assessmentNo, VACANCY_REMISSION, "Vacany Remission");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=CitizenCharterAcknowledgement.pdf");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

