/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.vacancyremission;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Designation;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.entity.property.VacancyRemissionApproval;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.property.VacancyRemissionService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/vacancyremissionapproval/update/{id}"})
public class UpdateVRApprovalController
extends GenericWorkFlowController {
    protected static final String VRAPPROVAL_EDIT = "vacancyRemissionApproval-edit";
    private static final String APPROVAL_POS = "approvalPosition";
    private static final String PROPERTY_MODIFY_REJECT_FAILURE = "Initiator is not active so can not do rejection with the Assessment number :";
    private final VacancyRemissionService vacancyRemissionService;
    private final PropertyTaxUtil propertyTaxUtil;
    private Designation designation;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private SecurityUtils securityUtils;

    @Autowired
    public UpdateVRApprovalController(VacancyRemissionService vacancyRemissionService, PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
        this.vacancyRemissionService = vacancyRemissionService;
    }

    @ModelAttribute
    public VacancyRemissionApproval vacancyRemissionApprovalModel(@PathVariable Long id) {
        VacancyRemissionApproval vacancyRemissionApproval = this.vacancyRemissionService.getVacancyRemissionApprovalById(id);
        this.designation = this.propertyTaxUtil.getDesignationForUser(this.vacancyRemissionService.getLoggedInUser().getId());
        return vacancyRemissionApproval;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String view(Model model, @PathVariable Long id, HttpServletRequest request) {
        VacancyRemissionApproval vacancyRemissionApproval = this.vacancyRemissionService.getVacancyRemissionApprovalById(id);
        VacancyRemission vacancyRemission = null;
        String userDesgn = "";
        String userDesignationList = this.propertyTaxCommonUtils.getAllDesignationsForUser(this.securityUtils.getCurrentUser().getId());
        if (null != this.designation) {
            userDesgn = this.designation.getName();
        }
        if (vacancyRemissionApproval != null) {
            String currentDesignation = this.vacancyRemissionService.getLoggedInUserDesignation(vacancyRemissionApproval.getCurrentState().getOwnerPosition().getId(), this.securityUtils.getCurrentUser());
            model.addAttribute("currentDesignation", (Object)currentDesignation);
            model.addAttribute("pendingActions", (Object)vacancyRemissionApproval.getCurrentState().getNextAction());
            model.addAttribute("stateType", (Object)vacancyRemissionApproval.getClass().getSimpleName());
            model.addAttribute("currentState", (Object)vacancyRemissionApproval.getCurrentState().getValue());
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setPendingActions(vacancyRemissionApproval.getCurrentState().getNextAction());
            this.prepareWorkflow(model, (StateAware)vacancyRemissionApproval, workflowContainer);
            BasicPropertyImpl basicProperty = vacancyRemissionApproval.getVacancyRemission().getBasicProperty();
            vacancyRemission = this.vacancyRemissionService.getApprovedVacancyRemissionForProperty(basicProperty.getUpicNo());
            this.vacancyRemissionService.addModelAttributes(model, (BasicProperty)basicProperty);
            model.addAttribute("detailsHistory", (Object)this.vacancyRemissionService.getMonthlyDetailsHistory(vacancyRemissionApproval.getVacancyRemission()));
            model.addAttribute("workflowHistory", (Object)vacancyRemissionApproval.getStateHistory());
            model.addAttribute("userDesgn", (Object)userDesgn);
            model.addAttribute("designation", (Object)"Commissioner");
            model.addAttribute("userDesignationList", (Object)userDesignationList);
            model.addAttribute("commissionerDesignation", (Object)"Commissioner");
            model.addAttribute("revenueClerkDesignation", (Object)"Assistant");
        }
        if (vacancyRemission != null && !vacancyRemission.getDocuments().isEmpty()) {
            model.addAttribute("attachedDocuments", (Object)vacancyRemission.getDocuments());
        }
        return VRAPPROVAL_EDIT;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute VacancyRemissionApproval vacancyRemissionApproval, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model) {
        String senderName = vacancyRemissionApproval.getCurrentState().getSenderName();
        if (!resultBinder.hasErrors()) {
            String workFlowAction = "";
            if (request.getParameter("workFlowAction") != null) {
                workFlowAction = request.getParameter("workFlowAction");
            }
            Long approvalPosition = 0L;
            String approvalComent = "";
            String successMsg = "";
            if (request.getParameter("approvalComent") != null) {
                approvalComent = request.getParameter("approvalComent");
            }
            if (this.isApprovalPosNotEmpty(request)) {
                approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POS));
            }
            if (this.isNotPreviewSignOrNoticeGen(workFlowAction)) {
                this.vacancyRemissionService.saveVacancyRemissionApproval(vacancyRemissionApproval, approvalPosition, approvalComent, null, workFlowAction);
            }
            if (StringUtils.isNotBlank((String)workFlowAction)) {
                if (this.isPreviewOrSignOrNoticeGen(workFlowAction)) {
                    String pathVars = vacancyRemissionApproval.getVacancyRemission().getBasicProperty().getUpicNo() + "," + senderName;
                    return "redirect:/vacancyremission/generatenotice?pathVar=" + pathVars + "&workFlowAction=" + workFlowAction;
                }
                successMsg = this.isReject(workFlowAction) ? this.wfReject(vacancyRemissionApproval, workFlowAction, approvalPosition, approvalComent) : (this.isApprove(workFlowAction) ? "Vacancy Remission Approved Successfully in the System and forwarded to " + this.propertyTaxUtil.getApproverUserName(vacancyRemissionApproval.getCurrentState().getOwnerPosition().getId()) : "Vacancy Remission Saved Successfully in the System and forwarded to : " + this.propertyTaxUtil.getApproverUserName(approvalPosition));
            }
            model.addAttribute("successMessage", (Object)successMsg);
        }
        return "vacancyRemission-success";
    }

    private boolean isApprovalPosNotEmpty(HttpServletRequest request) {
        return request.getParameter(APPROVAL_POS) != null && !request.getParameter(APPROVAL_POS).isEmpty();
    }

    private boolean isNotPreviewSignOrNoticeGen(String workFlowAction) {
        return !workFlowAction.equalsIgnoreCase("Preview") && !"Sign".equalsIgnoreCase(workFlowAction) && !this.isReject(workFlowAction);
    }

    private boolean isPreviewOrSignOrNoticeGen(String workFlowAction) {
        return workFlowAction.equalsIgnoreCase("Preview") || "Sign".equalsIgnoreCase(workFlowAction) || workFlowAction.equalsIgnoreCase("Generate Notice");
    }

    private boolean isReject(String workFlowAction) {
        return workFlowAction.equalsIgnoreCase("Reject");
    }

    private boolean isApprove(String workFlowAction) {
        return workFlowAction.equalsIgnoreCase("Approve");
    }

    private String wfReject(VacancyRemissionApproval vacancyRemissionApproval, String workFlowAction, Long approvalPosition, String approvalComent) {
        String successMsg;
        List history;
        Assignment wfInitiator;
        List loggedInUserAssign;
        String loggedInUserDesignation = "";
        User user = this.securityUtils.getCurrentUser();
        if (vacancyRemissionApproval.getState() != null && !(loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(vacancyRemissionApproval.getCurrentState().getOwnerPosition().getId(), user.getId(), new Date())).isEmpty()) {
            loggedInUserDesignation = ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName();
        }
        if ((wfInitiator = !(history = vacancyRemissionApproval.getStateHistory()).isEmpty() && this.vacancyRemissionService.isRoOrCommissioner(loggedInUserDesignation) ? this.propertyService.getUserOnRejection((StateAware)vacancyRemissionApproval) : this.vacancyRemissionService.getWorkflowInitiator((StateAware)vacancyRemissionApproval)) != null || this.designation.getName().equalsIgnoreCase("UD Revenue Inspector")) {
            this.vacancyRemissionService.saveVacancyRemissionApproval(vacancyRemissionApproval, approvalPosition, approvalComent, null, workFlowAction);
            if (this.designation.getName().equalsIgnoreCase("UD Revenue Inspector")) {
                successMsg = "Vacancy Remission rejected successfully";
            } else {
                Assignment assignment = this.assignmentService.getPrimaryAssignmentForUser(vacancyRemissionApproval.getCreatedBy().getId());
                successMsg = "Vacancy Remission rejected successfully and forwarded to : " + assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
            }
        } else {
            successMsg = PROPERTY_MODIFY_REJECT_FAILURE + vacancyRemissionApproval.getVacancyRemission().getBasicProperty().getUpicNo();
        }
        return successMsg;
    }
}

