/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.vacancyremission;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.service.property.VacancyRemissionService;
import org.egov.ptis.report.bean.PropertyAckNoticeInfo;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/vacancyremission"})
public class RejectionAcknowledgementController {
    @Autowired
    private ReportService reportService;
    public static final String REJECTION_ACK_TEMPLATE = "vacancyRemission_rejectionAck";
    private final Map<String, Object> reportParams = new HashMap();
    private ReportRequest reportInput = null;
    private ReportOutput reportOutput = null;
    @Autowired
    private VacancyRemissionService vacancyRemissionService;
    @Autowired
    private UserService userService;

    @RequestMapping(value={"/rejectionacknowledgement"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateRejectionAckNotice(HttpServletRequest request, HttpSession session) {
        String[] pathvars = request.getParameter("pathVar").split(",");
        VacancyRemission vacancyRemission = this.vacancyRemissionService.getLatestRejectAckGeneratedVacancyRemissionForProperty(pathvars[0]);
        return this.generateReport(vacancyRemission, request, session, pathvars[1]);
    }

    private ResponseEntity<byte[]> generateReport(VacancyRemission vacancyRemission, HttpServletRequest request, HttpSession session, String rejectingUser) {
        if (vacancyRemission != null) {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
            PropertyAckNoticeInfo ackBean = new PropertyAckNoticeInfo();
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
            String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
            DateTime dt = new DateTime((Object)vacancyRemission.getState().getCreatedDate());
            this.reportParams.put("logoPath", cityLogo);
            this.reportParams.put("cityName", cityName);
            this.reportParams.put("loggedInUsername", this.userService.getUserById(ApplicationThreadLocals.getUserId()).getName());
            this.reportParams.put("rejectionDate", dt.toString(formatter));
            this.reportParams.put("rejectingUser", rejectingUser);
            ackBean.setAssessmentNo(vacancyRemission.getBasicProperty().getUpicNo());
            ackBean.setOwnerAddress(vacancyRemission.getBasicProperty().getAddress().toString());
            this.reportInput = new ReportRequest(REJECTION_ACK_TEMPLATE, (Object)ackBean, this.reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=RejectionNotice.pdf");
        this.reportOutput = this.reportService.createReport(this.reportInput);
        return new ResponseEntity((Object)this.reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

