/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.exemption;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.TaxExemptionReason;
import org.egov.ptis.domain.service.exemption.TaxExemptionService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/exemption/update/{id}"})
public class UpdateTaxExemptionController
extends GenericWorkFlowController {
    private static final String APPROVAL_POSITION = "approvalPosition";
    protected static final String TAX_EXEMPTION_FORM = "taxExemption-form";
    protected static final String TAX_EXEMPTION_SUCCESS = "taxExemption-success";
    protected static final String TAX_EXEMPTION_VIEW = "taxExemption-view";
    public static final String EDIT = "edit";
    public static final String VIEW = "view";
    private static final String SUCCESSMESSAGE = "successMessage";
    private static final String TAXEXEMPTIONREASON = "taxExemptedReason";
    private static final String PROPERTY_MODIFY_REJECT_FAILURE = "Initiator is not active so can not do rejection with the Assessment number :";
    private static final String CHOULTRY_DOC = "choultryDocs";
    private static final String EDUINST_DOC = "eduinstDocs";
    private static final String NGO_DOC = "ngoDocs";
    private static final String WORSHIP_DOC = "worshipDocs";
    private static final String EXSERVICE_DOC = "exserviceDocs";
    private final TaxExemptionService taxExemptionService;
    private PropertyImpl property;
    private Boolean isExempted = Boolean.FALSE;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    @Autowired
    public UpdateTaxExemptionController(TaxExemptionService taxExemptionService) {
        this.taxExemptionService = taxExemptionService;
    }

    @ModelAttribute
    public Property propertyModel(@PathVariable String id) {
        this.property = (PropertyImpl)this.taxExemptionService.findByNamedQuery("WORKFLOW_PROPERTYIMPL_BYID", new Object[]{Long.valueOf(id)});
        if (this.property == null) {
            this.property = (PropertyImpl)this.taxExemptionService.findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(id)});
        }
        return this.property;
    }

    @ModelAttribute(value="taxExemptionReasons")
    public List<TaxExemptionReason> getTaxExemptionReasons() {
        return this.taxExemptionService.getSession().createQuery("from TaxExemptionReason where isActive = true order by name").list();
    }

    @ModelAttribute(value="documentsEduInst")
    public List<DocumentType> documentsEduInst(TransactionType transactionType) {
        return this.taxExemptionService.getDocuments(TransactionType.TE_EDU_INST);
    }

    @ModelAttribute(value="documentsWorship")
    public List<DocumentType> documentsWorship(TransactionType transactionType) {
        return this.taxExemptionService.getDocuments(TransactionType.TE_PUBLIC_WORSHIP);
    }

    @ModelAttribute(value="documentsNGO")
    public List<DocumentType> documentsNGO(TransactionType transactionType) {
        return this.taxExemptionService.getDocuments(TransactionType.TE_PENSIONER_NGO);
    }

    @ModelAttribute(value="documentsExService")
    public List<DocumentType> documentsExService(TransactionType transactionType) {
        return this.taxExemptionService.getDocuments(TransactionType.TE_EXSERVICE);
    }

    @ModelAttribute(value="documentsChoultries")
    public List<DocumentType> documentsChoultries(TransactionType transactionType) {
        return this.taxExemptionService.getDocuments(TransactionType.TE_CHOULTRY);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String view(Model model, @PathVariable Long id, HttpServletRequest request) {
        this.isExempted = this.property.getBasicProperty().getActiveProperty().getIsExemptedFromTax();
        String currState = this.property.getState().getValue();
        String nextAction = this.property.getState().getNextAction();
        String userDesignationList = this.propertyTaxCommonUtils.getAllDesignationsForUser(this.securityUtils.getCurrentUser().getId());
        model.addAttribute("stateType", (Object)this.property.getClass().getSimpleName());
        model.addAttribute("currentState", (Object)this.property.getCurrentState().getValue());
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setPendingActions(nextAction);
        workflowContainer.setAdditionalRule("EXEMPTION");
        this.prepareWorkflow(model, (StateAware)this.property, workflowContainer);
        model.addAttribute("userDesignationList", (Object)userDesignationList);
        model.addAttribute("designation", (Object)"Commissioner");
        model.addAttribute("isExempted", (Object)this.isExempted);
        model.addAttribute("pendingActions", (Object)nextAction);
        model.addAttribute("additionalRule", (Object)"EXEMPTION");
        model.addAttribute("isAlert", (Object)false);
        model.addAttribute(CHOULTRY_DOC, (Object)"");
        model.addAttribute(WORSHIP_DOC, (Object)"");
        model.addAttribute(EDUINST_DOC, (Object)"");
        model.addAttribute(EXSERVICE_DOC, (Object)"");
        model.addAttribute(NGO_DOC, (Object)"");
        String currentDesignation = this.taxExemptionService.getLoggedInUserDesignation(this.property.getCurrentState().getOwnerPosition().getId(), this.securityUtils.getCurrentUser());
        model.addAttribute("userDesignation", (Object)currentDesignation);
        if (!currState.endsWith("Rejected") && !currState.endsWith("NEW")) {
            model.addAttribute("currentDesignation", (Object)currentDesignation);
        }
        this.taxExemptionService.addModelAttributes(model, this.property.getBasicProperty());
        if (!this.property.getTaxExemptionDocuments().isEmpty()) {
            this.property.setTaxExemptionDocumentsProxy(this.property.getTaxExemptionDocuments());
            if (this.property.getTaxExemptedReason().getCode().equals("CHOULTRY")) {
                model.addAttribute(CHOULTRY_DOC, (Object)this.property.getTaxExemptionDocumentsProxy());
            } else if (this.property.getTaxExemptedReason().getCode().equals("EDU_INST")) {
                model.addAttribute(EDUINST_DOC, (Object)this.property.getTaxExemptionDocumentsProxy());
            } else if (this.property.getTaxExemptedReason().getCode().equals("EXSERVICE")) {
                model.addAttribute(EXSERVICE_DOC, (Object)this.property.getTaxExemptionDocumentsProxy());
            } else if (this.property.getTaxExemptedReason().getCode().equals("PUBLIC_WORSHIP")) {
                model.addAttribute(WORSHIP_DOC, (Object)this.property.getTaxExemptionDocumentsProxy());
            } else {
                model.addAttribute(NGO_DOC, (Object)this.property.getTaxExemptionDocumentsProxy());
            }
        }
        if (currState.endsWith("Rejected") || nextAction.equalsIgnoreCase("UD Revenue Inspector Approval Pending") || currState.endsWith("NEW")) {
            model.addAttribute("mode", (Object)EDIT);
            return TAX_EXEMPTION_FORM;
        }
        if (!this.property.getTaxExemptionDocuments().isEmpty()) {
            model.addAttribute("attachedDocuments", (Object)this.property.getTaxExemptionDocuments());
        }
        model.addAttribute("mode", (Object)VIEW);
        return TAX_EXEMPTION_VIEW;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Property property, BindingResult errors, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam String workFlowAction) {
        Character status = PropertyTaxConstants.STATUS_WORKFLOW;
        Long approvalPosition = 0L;
        String approvalComent = "";
        String workFlowAct = workFlowAction;
        PropertyImpl oldProperty = property.getBasicProperty().getActiveProperty();
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAct = request.getParameter("workFlowAction");
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        if (workFlowAct.equalsIgnoreCase("Approve")) {
            property.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
            oldProperty.setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
        }
        if (workFlowAct.equalsIgnoreCase("Generate Notice") || "Preview".equalsIgnoreCase(workFlowAct) || "Sign".equalsIgnoreCase(workFlowAct)) {
            if (property.getTaxExemptedReason() == null) {
                return "redirect:/notice/propertyTaxNotice-generateNotice.action?basicPropId=" + property.getBasicProperty().getId() + "&noticeType=" + "Special Notice" + "&noticeMode=" + "Tax_Exemption" + "&actionType=" + workFlowAct;
            }
            return "redirect:/notice/propertyTaxNotice-generateExemptionNotice.action?basicPropId=" + property.getBasicProperty().getId() + "&noticeType=" + "exemption" + "&noticeMode=" + "exemption" + "&actionType=" + workFlowAct;
        }
        return this.wfApproveReject(property, request, model, status, approvalPosition, approvalComent, workFlowAct);
    }

    private String wfApproveReject(Property property, HttpServletRequest request, Model model, Character status, Long approvalPosition, String approvalComent, String workFlowAct) {
        PropertyImpl oldProperty = property.getBasicProperty().getActiveProperty();
        Boolean propertyByEmployee = Boolean.valueOf(request.getParameter("propertyByEmployee"));
        if (!workFlowAct.equalsIgnoreCase("Reject")) {
            if (request.getParameter("mode").equalsIgnoreCase(VIEW)) {
                this.taxExemptionService.updateProperty(property, approvalComent, workFlowAct, approvalPosition, propertyByEmployee, "EXEMPTION");
            } else if (request.getParameter(TAXEXEMPTIONREASON) != null) {
                String taxExemptedReason = request.getParameter(TAXEXEMPTIONREASON);
                this.taxExemptionService.saveProperty(property, (Property)oldProperty, status, approvalComent, workFlowAct, approvalPosition, taxExemptedReason, propertyByEmployee, "EXEMPTION");
            }
        }
        if (property.getCreatedBy() != null) {
            this.assignmentService.getPrimaryAssignmentForUser(property.getCreatedBy().getId());
        }
        String successMessage = workFlowAct.equalsIgnoreCase("Approve") ? "Property Exemption approved successfully and forwarded to " + this.propertyTaxUtil.getApproverUserName(((PropertyImpl)property).getState().getOwnerPosition().getId()) + " with assessment number " + property.getBasicProperty().getUpicNo() : (workFlowAct.equalsIgnoreCase("Reject") ? this.wFReject(property, request, status, approvalPosition, approvalComent, workFlowAct) : "Successfully forwarded to " + this.propertyTaxUtil.getApproverUserName(approvalPosition) + " with application number " + property.getApplicationNo());
        model.addAttribute(SUCCESSMESSAGE, (Object)successMessage);
        return TAX_EXEMPTION_SUCCESS;
    }

    private String wFReject(Property property, HttpServletRequest request, Character status, Long approvalPosition, String approvalComent, String workFlowAct) {
        Boolean propertyByEmployee = Boolean.valueOf(request.getParameter("propertyByEmployee"));
        String taxExemptedReason = null;
        PropertyImpl oldProperty = property.getBasicProperty().getActiveProperty();
        String successMessage = null;
        Assignment assignment = null;
        PropertyImpl propertyImpl = (PropertyImpl)property;
        boolean isNotToReject = true;
        User user = this.securityUtils.getCurrentUser();
        String loggedInUserDesignation = this.loggedInUserDesignation(propertyImpl, user);
        if (loggedInUserDesignation != null && this.isRoOrCommissioner(loggedInUserDesignation)) {
            assignment = this.taxExemptionService.getUserAssignmentOnReject(loggedInUserDesignation, (PropertyImpl)property);
        }
        if (loggedInUserDesignation != null && !this.isRoOrCommissioner(loggedInUserDesignation)) {
            assignment = this.taxExemptionService.getWfInitiator((PropertyImpl)property);
        }
        if (assignment != null && assignment.getId() != null) {
            if (request.getParameter("mode").equalsIgnoreCase(VIEW)) {
                this.taxExemptionService.updateProperty(property, approvalComent, workFlowAct, approvalPosition, propertyByEmployee, "EXEMPTION");
            } else {
                taxExemptedReason = request.getParameter(TAXEXEMPTIONREASON);
                this.taxExemptionService.saveProperty(property, (Property)oldProperty, status, approvalComent, workFlowAct, approvalPosition, taxExemptedReason, propertyByEmployee, "EXEMPTION");
            }
            successMessage = "Property Exemption rejected successfully and forwared to " + assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName()) + " with application number " + property.getApplicationNo();
            isNotToReject = false;
        }
        if (isNotToReject) {
            successMessage = PROPERTY_MODIFY_REJECT_FAILURE + property.getBasicProperty().getUpicNo();
        }
        return successMessage;
    }

    private String loggedInUserDesignation(PropertyImpl propertyImpl, User user) {
        List loggedInUserAssign;
        String loggedInUserDesignation = null;
        if (propertyImpl.getState() != null && !(loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(propertyImpl.getCurrentState().getOwnerPosition().getId(), user.getId(), new Date())).isEmpty()) {
            loggedInUserDesignation = ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName();
        }
        return loggedInUserDesignation;
    }

    private boolean isRoOrCommissioner(String loggedInUserDesignation) {
        boolean isany = !"Revenue Officer".equalsIgnoreCase(loggedInUserDesignation) ? this.isCommissioner(loggedInUserDesignation) : true;
        return isany;
    }

    private boolean isCommissioner(String loggedInUserDesignation) {
        boolean isanyone = !"Assistant Commissioner".equalsIgnoreCase(loggedInUserDesignation) || !"Additional Commissioner".equalsIgnoreCase(loggedInUserDesignation) ? this.isDeputyOrAbove(loggedInUserDesignation) : true;
        return isanyone;
    }

    private boolean isDeputyOrAbove(String loggedInUserDesignation) {
        boolean isanyone = false;
        if ("Deputy Commissioner".equalsIgnoreCase(loggedInUserDesignation) || "Commissioner".equalsIgnoreCase(loggedInUserDesignation) || "Zonal Commissioner".equalsIgnoreCase(loggedInUserDesignation)) {
            isanyone = true;
        }
        return isanyone;
    }
}

