/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.editCollection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.dao.EgDemandDetailsDao;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.utils.StringUtils;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.bean.DemandDetail;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyReceipt;
import org.egov.ptis.domain.service.property.PropertyReceiptService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.egov.ptis.web.controller.transactions.editCollection.DemandDetailBeansForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/editCollection"})
public class EditCollectionController {
    private static final String EDIT_COLLECTION_FORM = "editCollection-form";
    private static final String EDIT_COLLECTION_ACK = "editCollection-ack";
    private static final String EDIT_COLLECTION_ERROR = "editCollection-error";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private EgDemandDetailsDao demandDetailsDao;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    @Qualifier(value="persistenceService")
    protected PersistenceService persistenceService;
    @Autowired
    @Qualifier(value="propertyReceiptService")
    private PropertyReceiptService propertyReceiptService;
    @Autowired
    private InstallmentHibDao installmentDao;
    private static final String QUERY_DEMAND_DETAILS = "select dd from Ptdemand ptd left join ptd.egDemandDetails dd left join dd.egDemandReason dr left join ptd.egptProperty p left join p.basicProperty bp where bp = ? and bp.active = true and p.status = 'A' and dd.amount > 0 and ptd.egInstallmentMaster = ?  and dr.egInstallmentMaster.finYearRange <> ?";

    @RequestMapping(value={"/editForm/{assessmentNo}"}, method={RequestMethod.GET})
    public String form(@ModelAttribute(value="demandDetailBeansForm") DemandDetailBeansForm demandDetailBeansForm, @PathVariable String assessmentNo, Model model) {
        ArrayList<DemandDetail> demandDetailBeans = new ArrayList<DemandDetail>();
        BasicPropertyImpl basicProperty = (BasicPropertyImpl)this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        if (!basicProperty.isEligible()) {
            return EDIT_COLLECTION_ERROR;
        }
        List demandDetails = this.persistenceService.findAllBy(QUERY_DEMAND_DETAILS, new Object[]{basicProperty, this.propertyTaxCommonUtils.getCurrentInstallment(), this.propertyTaxCommonUtils.getCurrentInstallment().getFinYearRange()});
        if (!demandDetails.isEmpty()) {
            Collections.sort(demandDetails, new /* Unavailable Anonymous Inner Class!! */);
        }
        if (!demandDetails.isEmpty()) {
            for (EgDemandDetails demandDetail : demandDetails) {
                Installment installment = demandDetail.getEgDemandReason().getEgInstallmentMaster();
                String reasonMaster = demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster();
                DemandDetail dmdDtl = this.createDemandDetailBean(installment, reasonMaster, demandDetail.getAmount(), demandDetail.getAmtCollected());
                demandDetailBeans.add(dmdDtl);
            }
        }
        demandDetailBeansForm.setDemandDetailBeans(demandDetailBeans);
        demandDetailBeansForm.setBasicProperty(basicProperty);
        model.addAttribute("demandDetailBeans", demandDetailBeans);
        model.addAttribute("property", (Object)basicProperty.getActiveProperty());
        model.addAttribute("basicProperty", (Object)basicProperty);
        return EDIT_COLLECTION_FORM;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@ModelAttribute(value="demandDetailBeansForm") DemandDetailBeansForm demandDetailBeansForm, BindingResult errors, Model model) {
        errors = this.validate(demandDetailBeansForm, errors);
        BasicPropertyImpl basicProperty = (BasicPropertyImpl)this.basicPropertyDAO.getBasicPropertyByPropertyID(demandDetailBeansForm.getBasicProperty().getUpicNo());
        if (errors.hasErrors()) {
            model.addAttribute("demandDetailBeans", (Object)demandDetailBeansForm.getDemandDetailBeans());
            model.addAttribute("property", (Object)basicProperty.getActiveProperty());
            model.addAttribute("basicProperty", (Object)basicProperty);
            return EDIT_COLLECTION_FORM;
        }
        Installment currentInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        List demandDetails = this.persistenceService.findAllBy(QUERY_DEMAND_DETAILS, new Object[]{basicProperty, currentInstallment, this.propertyTaxCommonUtils.getCurrentInstallment().getFinYearRange()});
        Boolean persistReceipt = Boolean.FALSE;
        block0: for (EgDemandDetails dmdDetails : demandDetails) {
            for (DemandDetail dmdDetailBean : demandDetailBeansForm.getDemandDetailBeans()) {
                Boolean isUpdateAmount = Boolean.FALSE;
                Boolean isUpdateCollection = Boolean.FALSE;
                if (dmdDetailBean.getRevisedAmount() != null && dmdDetailBean.getInstallment().equals((Object)dmdDetails.getEgDemandReason().getEgInstallmentMaster()) && dmdDetails.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().equalsIgnoreCase(dmdDetailBean.getReasonMaster())) {
                    isUpdateAmount = true;
                }
                if (dmdDetailBean.getRevisedCollection() != null && dmdDetails.getEgDemand().getEgInstallmentMaster().equals((Object)currentInstallment) && dmdDetails.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().equalsIgnoreCase(dmdDetailBean.getReasonMaster()) && dmdDetails.getEgDemandReason().getEgInstallmentMaster().equals((Object)dmdDetailBean.getInstallment())) {
                    isUpdateCollection = true;
                }
                if (isUpdateAmount.booleanValue()) {
                    dmdDetails.setAmount(dmdDetailBean.getRevisedAmount() != null ? dmdDetailBean.getRevisedAmount() : BigDecimal.ZERO);
                }
                if (isUpdateCollection.booleanValue()) {
                    dmdDetails.setAmtCollected(dmdDetailBean.getRevisedCollection() != null ? dmdDetailBean.getRevisedCollection() : BigDecimal.ZERO);
                }
                if (!isUpdateAmount.booleanValue() && !isUpdateCollection.booleanValue()) continue;
                persistReceipt = Boolean.TRUE;
                dmdDetails.setModifiedDate(new Date());
                this.demandDetailsDao.update(dmdDetails);
                continue block0;
            }
        }
        if (persistReceipt.booleanValue()) {
            PropertyReceipt propertyReceipt = demandDetailBeansForm.getPropertyReceipt();
            propertyReceipt.setSource(PropertyTaxConstants.SOURCEOFDATA_DATAENTRY);
            propertyReceipt.setBasicProperty(basicProperty);
            this.propertyReceiptService.persist((Object)propertyReceipt);
        }
        model.addAttribute("assessmentNo", (Object)basicProperty.getUpicNo());
        return EDIT_COLLECTION_ACK;
    }

    private DemandDetail createDemandDetailBean(Installment installment, String reasonMaster, BigDecimal amount, BigDecimal amountCollected) {
        DemandDetail demandDetail = new DemandDetail();
        demandDetail.setInstallment(installment);
        demandDetail.setReasonMaster(reasonMaster);
        demandDetail.setActualAmount(amount);
        demandDetail.setActualCollection(amountCollected);
        demandDetail.setIsCollectionEditable(Boolean.valueOf(true));
        return demandDetail;
    }

    private BindingResult validate(DemandDetailBeansForm demandDetailBeansForm, BindingResult errors) {
        Boolean editingCollection = Boolean.FALSE;
        int i = 0;
        BigDecimal totalRevisedCollection = BigDecimal.ZERO;
        BigDecimal totalActualCollection = BigDecimal.ZERO;
        for (DemandDetail dd : demandDetailBeansForm.getDemandDetailBeans()) {
            dd.setInstallment(this.installmentDao.findById(dd.getInstallment().getId().intValue(), false));
            if (dd.getReasonMaster().equals("Penalty Fines")) {
                if (dd.getRevisedAmount() != null && dd.getRevisedCollection() != null) {
                    if (dd.getRevisedCollection().compareTo(dd.getRevisedAmount()) > 0) {
                        errors.rejectValue("demandDetailBeans[" + i + "].revisedAmount", "revised.collection.greater.than.reviseddemand");
                        errors.rejectValue("demandDetailBeans[" + i + "].revisedCollection", "revised.demand.less.than.revisedcollection");
                    } else if (dd.getRevisedCollection().compareTo(dd.getRevisedAmount()) < 0) {
                        errors.rejectValue("demandDetailBeans[" + i + "].revisedCollection", "error.penalty.not.collected");
                    }
                    editingCollection = Boolean.TRUE;
                    totalRevisedCollection = totalRevisedCollection.add(dd.getRevisedCollection());
                    totalActualCollection = totalActualCollection.add(dd.getActualCollection());
                } else if (dd.getRevisedAmount() != null) {
                    if (dd.getActualCollection().compareTo(dd.getRevisedAmount()) > 0) {
                        errors.rejectValue("demandDetailBeans[" + i + "].revisedAmount", "actual.collection.greater.than.reviseddemand");
                    } else if (dd.getRevisedCollection().compareTo(dd.getRevisedAmount()) < 0 || dd.getActualCollection().compareTo(dd.getRevisedAmount()) < 0) {
                        errors.rejectValue("demandDetailBeans[" + i + "].revisedCollection", "error.penalty.not.collected");
                    }
                    editingCollection = Boolean.TRUE;
                } else if (dd.getRevisedCollection() != null) {
                    if (dd.getRevisedCollection().compareTo(dd.getActualAmount()) > 0) {
                        errors.rejectValue("demandDetailBeans[" + i + "].revisedCollection", "revised.collection.greater.than.actualdemand");
                    } else if (dd.getRevisedCollection().compareTo(dd.getActualAmount()) < 0) {
                        errors.rejectValue("demandDetailBeans[" + i + "].revisedCollection", "error.penalty.not.collected");
                    }
                    editingCollection = Boolean.TRUE;
                    totalRevisedCollection = totalRevisedCollection.add(dd.getRevisedCollection());
                    totalActualCollection = totalActualCollection.add(dd.getActualCollection());
                }
            } else if (null != dd.getRevisedCollection() && !PropertyTaxUtil.isZero((BigDecimal)dd.getRevisedCollection())) {
                if (dd.getRevisedCollection().compareTo(dd.getActualAmount()) > 0) {
                    errors.rejectValue("demandDetailBeans[" + i + "].revisedCollection", "revised.collection.greater.than.actualdemand");
                }
                editingCollection = Boolean.TRUE;
                totalRevisedCollection = totalRevisedCollection.add(dd.getRevisedCollection());
                totalActualCollection = totalActualCollection.add(dd.getActualCollection());
            }
            ++i;
        }
        if (editingCollection.booleanValue()) {
            if (StringUtils.isBlank((String)demandDetailBeansForm.getPropertyReceipt().getRemarks())) {
                errors.rejectValue("propertyReceipt.remarks", "mandatory.message");
            }
            if (StringUtils.isBlank((String)demandDetailBeansForm.getPropertyReceipt().getReceiptNumber())) {
                errors.rejectValue("propertyReceipt.receiptNumber", "mandatory.message");
            }
            if (demandDetailBeansForm.getPropertyReceipt().getReceiptDate() == null) {
                errors.rejectValue("propertyReceipt.receiptDate", "mandatory.message");
            }
            if (demandDetailBeansForm.getPropertyReceipt().getReceiptAmount() == null) {
                errors.rejectValue("propertyReceipt.receiptAmount", "mandatory.message");
            } else if (totalRevisedCollection.subtract(totalActualCollection).compareTo(demandDetailBeansForm.getPropertyReceipt().getReceiptAmount()) != 0) {
                errors.rejectValue("propertyReceipt.remarks", "error.receipt.amount");
            }
        } else if (!editingCollection.booleanValue()) {
            errors.rejectValue("propertyReceipt.remarks", "error.collection.notmodified");
        }
        return errors;
    }
}

