/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.egov.collection.entity.es.CollectionDocument;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.DailyCollectionReportSearch;
import org.egov.ptis.domain.entity.property.DailyCollectionReportSearchVLT;
import org.egov.ptis.domain.service.report.ReportService;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/dailyCollectionVLT"})
public class DailyCollectionReportVLTController {
    private static final String DAILY_COLLECTION_FORM = "dailyCollectionVLT-form";
    private static final Logger LOGGER = Logger.getLogger(DailyCollectionReportVLTController.class);
    @Autowired
    private ReportService reportService;
    @Autowired
    private EgwStatusHibernateDAO egwStatushibernateDAO;
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    @ModelAttribute
    public void getReportModel(Model model) {
        DailyCollectionReportSearchVLT dailyCollectionReportResutVLT = new DailyCollectionReportSearchVLT();
        model.addAttribute("dailyCollectionReportResutVLT", (Object)dailyCollectionReportResutVLT);
    }

    @ModelAttribute(value="operators")
    public Set<User> loadCollectionOperators() {
        return this.reportService.getCollectionOperators();
    }

    @ModelAttribute(value="status")
    public List<EgwStatus> loadStatus() {
        return this.egwStatushibernateDAO.getStatusByModule("ReceiptHeader");
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @RequestMapping(method={RequestMethod.GET})
    public String seachForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        model.addAttribute("collectionMode", (Object)Source.values());
        return DAILY_COLLECTION_FORM;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<CollectionDocument> searchCollection(@ModelAttribute DailyCollectionReportSearch searchRequest) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        BoolQueryBuilder boolQuery = this.getQueryBasedOnInput(searchRequest);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)"receipt_count").field("consumerCode")).build();
        Aggregations collCountAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        ValueCount aggr = (ValueCount)collCountAggr.get("receipt_count");
        searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)"receipt_count").field("consumerCode")).withPageable((Pageable)new PageRequest(0, Long.valueOf(aggr.getValue()).intValue() == 0 ? 1 : Long.valueOf(aggr.getValue()).intValue())).build();
        List collIndexList = this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, CollectionDocument.class);
        return collIndexList;
    }

    private BoolQueryBuilder getQueryBasedOnInput(DailyCollectionReportSearch searchRequest) {
        Date fromDate = org.egov.infra.utils.DateUtils.getDate((String)searchRequest.getFromDate(), (String)"yyyy-MM-dd");
        Date toDate = DateUtils.addDays((Date)org.egov.infra.utils.DateUtils.getDate((String)searchRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"billingService", (Object)"Property Tax (On Land)")).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCollectionMode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"channel", (Object)searchRequest.getCollectionMode()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCollectionOperator())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"receiptCreator", (Object)searchRequest.getCollectionOperator()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getStatus())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)searchRequest.getStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getUlbName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityName", (Object)searchRequest.getUlbName()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"revenueWard", (Object)searchRequest.getRevenueWard()));
        }
        return boolQuery;
    }
}

