/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.egov.ptis.domain.entity.property.DailyCollectionReportResult;

public class DailyCollectionReportAdaptor
implements JsonSerializer<DailyCollectionReportResult> {
    public JsonElement serialize(DailyCollectionReportResult dailyCollectionReportResult, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        SimpleDateFormat receiptDateFormatter = new SimpleDateFormat("dd/MM/yyyy");
        jsonObject.addProperty("receiptNo", dailyCollectionReportResult.getReceiptNumber());
        jsonObject.addProperty("receiptDate", receiptDateFormatter.format(dailyCollectionReportResult.getReceiptDate()));
        jsonObject.addProperty("assessmentNumber", dailyCollectionReportResult.getAssessmentNumber());
        jsonObject.addProperty("ownerName", dailyCollectionReportResult.getOwnerName());
        jsonObject.addProperty("doorNumber", StringUtils.isNotBlank((CharSequence)dailyCollectionReportResult.getDoorNumber()) ? dailyCollectionReportResult.getDoorNumber() : "N/A");
        jsonObject.addProperty("paidAt", dailyCollectionReportResult.getPaidAt());
        jsonObject.addProperty("paymentMode", dailyCollectionReportResult.getPaymentMode());
        jsonObject.addProperty("status", dailyCollectionReportResult.getStatus());
        jsonObject.addProperty("fromDate", dailyCollectionReportResult.getFromInstallment());
        jsonObject.addProperty("toDate", dailyCollectionReportResult.getToInstallment());
        jsonObject.addProperty("arrearAmt", (Number)(null != dailyCollectionReportResult.getArrearAmount() ? dailyCollectionReportResult.getArrearAmount().setScale(2, 4) : BigDecimal.ZERO));
        jsonObject.addProperty("currAmt", (Number)(null != dailyCollectionReportResult.getCurrentAmount() ? dailyCollectionReportResult.getCurrentAmount().setScale(2, 4) : BigDecimal.ZERO));
        jsonObject.addProperty("totalPenalty", (Number)(null != dailyCollectionReportResult.getTotalPenalty() ? dailyCollectionReportResult.getTotalPenalty().setScale(2, 4) : BigDecimal.ZERO));
        jsonObject.addProperty("arrearLibCess", (Number)(null != dailyCollectionReportResult.getArrearLibCess() ? dailyCollectionReportResult.getArrearLibCess().setScale(2, 4) : BigDecimal.ZERO));
        jsonObject.addProperty("currLibCess", (Number)(null != dailyCollectionReportResult.getCurrentLibCess() ? dailyCollectionReportResult.getCurrentLibCess().setScale(2, 4) : BigDecimal.ZERO));
        jsonObject.addProperty("totalLibCess", (Number)(null != dailyCollectionReportResult.getTotalLibCess() ? dailyCollectionReportResult.getTotalLibCess().setScale(2, 4) : BigDecimal.ZERO));
        jsonObject.addProperty("totalCollection", (Number)dailyCollectionReportResult.getTotalCollection().setScale(2, 4));
        jsonObject.addProperty("totalRebate", (Number)dailyCollectionReportResult.getTotalRebate().setScale(2, 4));
        jsonObject.addProperty("ward", dailyCollectionReportResult.getWard());
        return jsonObject;
    }
}

