/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.demolition;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.service.demolition.PropertyDemolitionService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/demolition/update/{id}"})
public class UpdatePropertyDemolitionController
extends GenericWorkFlowController {
    private static final String DEMOLITION_STATE_NEW = "Demolition:NEW";
    protected static final String DEMOLITION_FORM = "demolition-form";
    protected static final String DEMOLITION_VIEW = "demolition-view";
    protected static final String DEMOLITION_SUCCESS = "demolition-success";
    public static final String EDIT = "edit";
    public static final String VIEW = "view";
    private static final String APPROVAL_POSITION = "approvalPosition";
    private static final String SUCCESSMESSAGE = "successMessage";
    private static final String PROPERTY_MODIFY_REJECT_FAILURE = "Initiator is not active so can not do rejection with the Assessment number :";
    PropertyDemolitionService propertyDemolitionService;
    @Autowired
    private PersistenceService<Property, Long> persistenceService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private SecurityUtils securityUtils;
    private PropertyImpl property;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private transient PropertyService propService;

    @Autowired
    public UpdatePropertyDemolitionController(PropertyDemolitionService propertyDemolitionService) {
        this.propertyDemolitionService = propertyDemolitionService;
    }

    @ModelAttribute
    public Property propertyModel(@PathVariable String id) {
        this.property = (PropertyImpl)this.propertyDemolitionService.findByNamedQuery("WORKFLOW_PROPERTYIMPL_BYID", new Object[]{Long.valueOf(id)});
        if (null == this.property) {
            this.property = (PropertyImpl)this.propertyDemolitionService.findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(id)});
        }
        return this.property;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String view(Model model, @PathVariable Long id, HttpServletRequest request) {
        String userDesignationList = "";
        String currentDesignation = null;
        String currState = this.property.getState().getValue();
        String nextAction = this.property.getState().getNextAction();
        userDesignationList = this.propertyTaxCommonUtils.getAllDesignationsForUser(this.securityUtils.getCurrentUser().getId());
        model.addAttribute("stateType", (Object)this.property.getClass().getSimpleName());
        model.addAttribute("currentState", (Object)this.property.getCurrentState().getValue());
        model.addAttribute("pendingActions", (Object)nextAction);
        model.addAttribute("additionalRule", (Object)"DEMOLITION");
        if (!DEMOLITION_STATE_NEW.equals(currState)) {
            currentDesignation = this.propertyDemolitionService.getLoggedInUserDesignation(this.property.getCurrentState().getOwnerPosition().getId(), this.securityUtils.getCurrentUser());
        }
        if (!currState.endsWith("Rejected")) {
            model.addAttribute("currentDesignation", currentDesignation);
        }
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setPendingActions(nextAction);
        workflowContainer.setAdditionalRule("DEMOLITION");
        this.prepareWorkflow(model, (StateAware)this.property, workflowContainer);
        this.propertyDemolitionService.addModelAttributes(model, this.property.getBasicProperty());
        model.addAttribute("userDesignationList", (Object)userDesignationList);
        model.addAttribute("designation", (Object)"Commissioner");
        if (currState.endsWith("Rejected") || nextAction.equalsIgnoreCase("UD Revenue Inspector Approval Pending") || currState.endsWith("NEW")) {
            model.addAttribute("isEmployee", (Object)this.propService.isEmployee(this.securityUtils.getCurrentUser()));
            model.addAttribute("mode", (Object)EDIT);
            return DEMOLITION_FORM;
        }
        model.addAttribute("mode", (Object)VIEW);
        return DEMOLITION_VIEW;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Property property, BindingResult errors, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam String workFlowAction) throws TaxCalculatorExeption {
        String workFlowAct = workFlowAction;
        this.propertyDemolitionService.validateProperty(property, errors, request);
        if (errors.hasErrors()) {
            this.prepareWorkflow(model, (StateAware)((PropertyImpl)property), new WorkflowContainer());
            model.addAttribute("stateType", (Object)property.getClass().getSimpleName());
            return DEMOLITION_FORM;
        }
        Character status = PropertyTaxConstants.STATUS_WORKFLOW;
        Long approvalPosition = 0L;
        String approvalComent = "";
        PropertyImpl oldProperty = property.getBasicProperty().getActiveProperty();
        if (this.isApprovalCommentNotNull(request)) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (this.isWorkFlowActionNotNull(request)) {
            workFlowAct = request.getParameter("workFlowAction");
        }
        if (this.isApprovalPosNotNull(request)) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        this.approveAction(property, workFlowAct, (Property)oldProperty);
        if (this.isWfNoticeGenOrPrevOrSign(workFlowAct)) {
            return "redirect:/notice/propertyTaxNotice-generateNotice.action?basicPropId=" + property.getBasicProperty().getId() + "&noticeType=" + "Special Notice" + "&noticeMode=" + "Demolition" + "&actionType=" + workFlowAct;
        }
        return this.ifNotNoticeGenAndModeViewOrSave(property, request, model, workFlowAct, status, approvalPosition, approvalComent);
    }

    private void approveAction(Property property, String workFlowAct, Property oldProperty) {
        if (this.isActionApprove(property, workFlowAct)) {
            if (this.isOldPropStatActive(oldProperty)) {
                oldProperty.setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
                this.persistenceService.persist((Object)oldProperty);
            }
            if (this.isPropStatWF(property)) {
                property.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
                this.persistenceService.persist((Object)property);
            }
        }
    }

    private boolean isWfNoticeGenOrPrevOrSign(String workFlowAct) {
        return workFlowAct.equalsIgnoreCase("Generate Notice") || "Preview".equalsIgnoreCase(workFlowAct) || "Sign".equalsIgnoreCase(workFlowAct);
    }

    private boolean isPropStatWF(Property property) {
        return property.getStatus().equals(PropertyTaxConstants.STATUS_WORKFLOW);
    }

    private boolean isOldPropStatActive(Property oldProperty) {
        return oldProperty.getStatus().equals(PropertyTaxConstants.STATUS_ISACTIVE);
    }

    private boolean isActionApprove(Property property, String workFlowAct) {
        return "Approve".equalsIgnoreCase(workFlowAct) && this.isPropStatWF(property);
    }

    private boolean isApprovalPosNotNull(HttpServletRequest request) {
        return request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty();
    }

    private boolean isWorkFlowActionNotNull(HttpServletRequest request) {
        return request.getParameter("workFlowAction") != null;
    }

    private boolean isApprovalCommentNotNull(HttpServletRequest request) {
        return request.getParameter("approvalComent") != null;
    }

    private String ifNotNoticeGenAndModeViewOrSave(Property property, HttpServletRequest request, Model model, String workFlowAction, Character status, Long approvalPosition, String approvalComent) throws TaxCalculatorExeption {
        PropertyImpl oldProperty = property.getBasicProperty().getActiveProperty();
        this.ifNotRejectViewOrSave(property, request, workFlowAction, status, approvalPosition, approvalComent, (Property)oldProperty);
        if (this.isWfReject(workFlowAction)) {
            model.addAttribute(SUCCESSMESSAGE, (Object)("Property Demolition approved successfully and forwarded to  " + this.propertyTaxUtil.getApproverUserName(((PropertyImpl)property).getState().getOwnerPosition().getId()) + " with assessment number " + property.getBasicProperty().getUpicNo()));
        } else if (workFlowAction.equalsIgnoreCase("Reject")) {
            this.wFReject(property, request, model, workFlowAction, status, approvalPosition, approvalComent);
        } else {
            Assignment cscAssignment = this.getCscUserAssignment(property);
            Long approvalPos = cscAssignment != null ? cscAssignment.getPosition().getId() : approvalPosition;
            model.addAttribute(SUCCESSMESSAGE, (Object)("Successfully forwarded to " + this.propertyTaxUtil.getApproverUserName(approvalPos) + " with application number " + property.getApplicationNo()));
        }
        return DEMOLITION_SUCCESS;
    }

    private void wFReject(Property property, HttpServletRequest request, Model model, String workFlowAction, Character status, Long approvalPosition, String approvalComent) throws TaxCalculatorExeption {
        PropertyImpl oldProperty = property.getBasicProperty().getActiveProperty();
        Assignment assignment = null;
        PropertyImpl propertyImpl = (PropertyImpl)property;
        List history = propertyImpl.getStateHistory();
        Collections.reverse(history);
        User user = this.securityUtils.getCurrentUser();
        String loggedInUserDesignation = this.loggedInUserDesignation(propertyImpl, user);
        boolean isNotrejection = true;
        if (loggedInUserDesignation != null && this.isRoOrCommissioner(loggedInUserDesignation)) {
            assignment = this.propertyDemolitionService.getUserAssignmentOnReject(loggedInUserDesignation, (PropertyImpl)property);
        }
        if (loggedInUserDesignation != null && !this.isRoOrCommissioner(loggedInUserDesignation)) {
            assignment = this.propertyDemolitionService.getWfInitiator((PropertyImpl)property);
        }
        if (assignment != null && assignment.getId() != null) {
            if (request.getParameter("mode").equalsIgnoreCase(VIEW)) {
                this.propertyDemolitionService.updateProperty(property, approvalComent, workFlowAction, approvalPosition, "DEMOLITION");
            } else {
                this.propertyDemolitionService.saveProperty((Property)oldProperty, property, status, approvalComent, workFlowAction, approvalPosition, "DEMOLITION");
            }
            model.addAttribute(SUCCESSMESSAGE, (Object)("Property Demolition rejected successfully and forwared to " + assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName()) + " with application number " + property.getApplicationNo()));
            isNotrejection = false;
        }
        if (isNotrejection) {
            model.addAttribute(SUCCESSMESSAGE, (Object)(PROPERTY_MODIFY_REJECT_FAILURE + property.getBasicProperty().getUpicNo()));
        }
    }

    private String loggedInUserDesignation(PropertyImpl propertyImpl, User user) {
        String loggedInUserDesignation = null;
        if (propertyImpl.getState() != null) {
            List loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(propertyImpl.getCurrentState().getOwnerPosition().getId(), user.getId(), new Date());
            loggedInUserDesignation = !loggedInUserAssign.isEmpty() ? ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName() : null;
        }
        return loggedInUserDesignation;
    }

    private boolean isRoOrCommissioner(String loggedInUserDesignation) {
        boolean isany = !"Revenue Officer".equalsIgnoreCase(loggedInUserDesignation) ? this.isCommissioner(loggedInUserDesignation) : true;
        return isany;
    }

    private boolean isCommissioner(String loggedInUserDesignation) {
        boolean isanyone = !"Assistant Commissioner".equalsIgnoreCase(loggedInUserDesignation) || !"Additional Commissioner".equalsIgnoreCase(loggedInUserDesignation) ? this.isDeputyOrAbove(loggedInUserDesignation) : true;
        return isanyone;
    }

    private boolean isDeputyOrAbove(String loggedInUserDesignation) {
        boolean isanyone = false;
        if ("Deputy Commissioner".equalsIgnoreCase(loggedInUserDesignation) || "Commissioner".equalsIgnoreCase(loggedInUserDesignation) || "Zonal Commissioner".equalsIgnoreCase(loggedInUserDesignation)) {
            isanyone = true;
        }
        return isanyone;
    }

    private boolean isWfReject(String workFlowAction) {
        return workFlowAction.equalsIgnoreCase("Approve");
    }

    private void ifNotRejectViewOrSave(Property property, HttpServletRequest request, String workFlowAction, Character status, Long approvalPosition, String approvalComent, Property oldProperty) throws TaxCalculatorExeption {
        if (request.getParameter("mode").equalsIgnoreCase(VIEW)) {
            if (!workFlowAction.equalsIgnoreCase("Reject")) {
                this.propertyDemolitionService.updateProperty(property, approvalComent, workFlowAction, approvalPosition, "DEMOLITION");
            }
        } else if (!workFlowAction.equalsIgnoreCase("Reject")) {
            this.propertyDemolitionService.saveProperty(oldProperty, property, status, approvalComent, workFlowAction, approvalPosition, "DEMOLITION");
        }
    }

    private Assignment getCscUserAssignment(Property property) {
        Assignment cscAssignment = null;
        if (!this.propService.isEmployee(this.securityUtils.getCurrentUser()).booleanValue()) {
            cscAssignment = this.propertyDemolitionService.getUserAssignment(this.securityUtils.getCurrentUser(), property);
        }
        return cscAssignment;
    }
}

