/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.search;

import com.opensymphony.xwork2.validator.annotations.Validations;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.ptis.actions.common.CommonServices;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyMaterlizeView;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Validations
@Results(value={@Result(name={"new"}, location="searchProperty-new.jsp"), @Result(name={"result"}, location="searchProperty-result.jsp"), @Result(name={"commonForm"}, location="searchProperty-commonForm.jsp"), @Result(name={"Alter_Assessment"}, type="redirectAction", location="modifyProperty-modifyForm", params={"namespace", "${actionNamespace}", "indexNumber", "${assessmentNum}", "modifyRsn", "ADD_OR_ALTER", "applicationType", "${applicationType}", "applicationSource", "${applicationSource}"}), @Result(name={"Bifuracate_Assessment"}, type="redirectAction", location="modifyProperty-modifyForm", params={"namespace", "/modify", "indexNumber", "${assessmentNum}", "modifyRsn", "BIFURCATE", "applicationType", "${applicationType}"}), @Result(name={"Transfer_of_Ownership"}, type="redirectAction", location="redirect", params={"namespace", "${actionNamespace}", "assessmentNo", "${assessmentNum}", "applicationType", "${applicationType}", "applicationSource", "${applicationSource}"}), @Result(name={"Meeseva_Transfer_of_Ownership"}, type="redirectAction", location="redirect", params={"namespace", "/property/transfer", "assessmentNo", "${assessmentNum}", "meesevaApplicationNumber", "${meesevaApplicationNumber}", "meesevaServiceCode", "${meesevaServiceCode}", "applicationType", "${applicationType}"}), @Result(name={"Revision_Petition"}, type="redirectAction", location="revPetition-newForm", params={"namespace", "${actionNamespace}", "propertyId", "${assessmentNum}", "wfType", "RP", "applicationSource", "${applicationSource}"}), @Result(name={"General_Revision_Petition"}, type="redirectAction", location="genRevPetition-newForm", params={"namespace", "${actionNamespace}", "propertyId", "${assessmentNum}", "wfType", "GRP", "applicationSource", "${applicationSource}"}), @Result(name={"meesevaerror"}, location="/WEB-INF/jsp/common/meeseva-errorPage.jsp"), @Result(name={"Collect_Tax"}, type="redirectAction", location="searchProperty-searchOwnerDetails", params={"namespace", "/search", "assessmentNum", "${assessmentNum}"}), @Result(name={"Generate_demand_bill"}, type="redirectAction", location="billGeneration-generateDemandBill", params={"namespace", "/bills", "indexNumber", "${assessmentNum}"}), @Result(name={"Vacancy_Remission"}, type="redirect", location="../vacancyremission/create/${assessmentNum},${mode}", params={"meesevaApplicationNumber", "${meesevaApplicationNumber}", "applicationSource", "${applicationSource}"}), @Result(name={"Tax_Exemption"}, type="redirect", location="../exemption/form/${assessmentNum}", params={"meesevaApplicationNumber", "${meesevaApplicationNumber}", "applicationSource", "${applicationSource}"}), @Result(name={"Edit_demand"}, type="redirectAction", location="editDemand-newEditForm", params={"namespace", "/edit", "propertyId", "${assessmentNum}"}), @Result(name={"Add_demand"}, type="redirectAction", location="addDemand-newAddForm", params={"namespace", "/edit", "propertyId", "${assessmentNum}"}), @Result(name={"Edit_Collection"}, type="redirect", location="../editCollection/editForm/${assessmentNum}"), @Result(name={"Demolition"}, type="redirect", location="../property/demolition/${assessmentNum}/${applicationSource}"), @Result(name={"Edit_owner"}, type="redirect", location="../editowner/${assessmentNum}"), @Result(name={"ownerDetails"}, location="searchProperty-ownerDetails.jsp"), @Result(name={"Edit_Data_Entry"}, type="redirectAction", location="createProperty-editDataEntryForm", params={"namespace", "/create", "indexNumber", "${assessmentNum}", "modifyRsn", "EDIT_DATA_ENTRY", "modelId", "${activePropertyId}"}), @Result(name={"Meeseva_General_Revision_Petition"}, type="redirectAction", location="genRevPetition-newForm", params={"namespace", "/revPetition", "propertyId", "${assessmentNum}", "meesevaApplicationNumber", "${meesevaApplicationNumber}", "meesevaServiceCode", "${meesevaServiceCode}", "wfType", "GRP", "applicationType", "${applicationType}"}), @Result(name={"Meeseva_Revision_Petition"}, type="redirectAction", location="revPetition-newForm", params={"namespace", "/revPetition", "propertyId", "${assessmentNum}", "meesevaApplicationNumber", "${meesevaApplicationNumber}", "meesevaServiceCode", "${meesevaServiceCode}", "applicationType", "${applicationType}", "wfType", "RP"}), @Result(name={"Amalgamation"}, type="redirectAction", location="amalgamation-newForm", params={"namespace", "/amalgamation", "indexNumber", "${assessmentNum}", "applicationType", "${applicationType}", "modifyRsn", "AMALG"})})
public class SearchPropertyAction
extends BaseFormAction {
    private static final long serialVersionUID = 6978874588028662454L;
    protected static final String COMMON_FORM = "commonForm";
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private static final String RESULT_ERROR = "meesevaerror";
    protected static final String USER_DETAILS = "ownerDetails";
    protected static final String UPDATEMOBILE_FORM = "updateMobileNo";
    public static final String TARGET = "result";
    private Long zoneId;
    private Long wardId;
    private Long propertyTypeMasterId;
    private Integer locationId;
    private Integer areaName;
    private String assessmentNum;
    private String houseNumBndry;
    private String ownerNameBndry;
    private String houseNumArea;
    private String ownerName;
    private String oldHouseNum;
    private String oldMuncipalNum;
    private String mode;
    private String searchUri;
    private String searchCriteria;
    private String searchValue;
    private String roleName;
    private String markedForDeactive = "N";
    private String fromDemand;
    private String toDemand;
    private String applicationType;
    private String doorNo;
    private String mobileNumber;
    private String meesevaApplicationNumber;
    private String meesevaServiceCode;
    private String applicationSource;
    private String actionNamespace;
    private List<Map<String, String>> searchResultList;
    List<Map<String, String>> searchList = new ArrayList();
    private Map<Long, String> ZoneBndryMap;
    private Map<Long, String> WardndryMap;
    private User propertyOwner;
    private BasicProperty basicProperty;
    private boolean isDemandActive;
    private Boolean loggedUserIsMeesevaUser = Boolean.FALSE;
    private String activePropertyId;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private RevisionPetitionService revisionPetitionService;

    public Object getModel() {
        return null;
    }

    @SkipValidation
    @Action(value="/search/searchProperty-searchForm")
    public String searchForm() {
        this.setAssessmentNum("");
        this.setOldMuncipalNum("");
        this.setDoorNo("");
        this.setMobileNumber("");
        return "new";
    }

    public String commonForm() {
        this.loggedUserIsMeesevaUser = this.propertyService.isMeesevaUser(this.securityUtils.getCurrentUser());
        if (this.loggedUserIsMeesevaUser.booleanValue()) {
            HttpServletRequest request = ServletActionContext.getRequest();
            if (request.getParameter("applicationNo") == null || request.getParameter("meesevaServicecode") == null) {
                this.addActionMessage(this.getText("MEESEVA.005"));
                return RESULT_ERROR;
            }
            this.setMeesevaApplicationNumber(request.getParameter("applicationNo"));
            this.setMeesevaServiceCode(request.getParameter("meesevaServicecode"));
        }
        return COMMON_FORM;
    }

    @ValidationErrorPage(value="commonForm")
    @Action(value="/search/searchProperty-commonSearch")
    public String commonSearch() {
        List propertyStatusValues;
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByIndexNumAndParcelID(this.assessmentNum, null);
        if (basicProperty == null) {
            this.addActionError(this.getText("validation.property.doesnot.exists"));
            return COMMON_FORM;
        }
        this.checkIsDemandActive(basicProperty.getProperty());
        if (!(this.applicationType.equalsIgnoreCase("Collect_Tax") || this.applicationType.equalsIgnoreCase("Generate_demand_bill") || this.applicationType.equalsIgnoreCase("Revision_Petition"))) {
            if (!this.isDemandActive) {
                this.addActionError(this.getText("error.msg.demandInactive"));
                return COMMON_FORM;
            }
            if (basicProperty.getActiveProperty().getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("EWSHS") && !this.applicationType.equalsIgnoreCase("Alter_Assessment") && !this.applicationType.equalsIgnoreCase("Tax_Exemption")) {
                this.addActionError(this.getText("EWSHS.transaction.error"));
                return COMMON_FORM;
            }
        }
        if ("Amalgamation".equalsIgnoreCase(this.applicationType)) {
            Property property = basicProperty.getProperty();
            if (property != null && property.getPropertyDetail().getPropertyTypeMaster().getCode().equals("VAC_LAND")) {
                this.addActionError(this.getText("amalgamation.vlt.error"));
                return COMMON_FORM;
            }
            if (basicProperty.isUnderWorkflow()) {
                this.addActionError(this.getText("amalgamation.wf.error"));
                return COMMON_FORM;
            }
        }
        if (this.applicationType.equalsIgnoreCase("Edit_Data_Entry")) {
            Property activeProperty = basicProperty.getProperty();
            if (!basicProperty.getSource().toString().equalsIgnoreCase(PropertyTaxConstants.SOURCEOFDATA_DATAENTRY.toString())) {
                this.addActionError(this.getText("edit.dataEntry.source.error"));
                return COMMON_FORM;
            }
            if (basicProperty.getSource().toString().equalsIgnoreCase(PropertyTaxConstants.SOURCEOFDATA_DATAENTRY.toString())) {
                if (basicProperty.getPropertySet().size() > 1) {
                    this.addActionError(this.getText("edit.dataEntry.transaction.error"));
                    return COMMON_FORM;
                }
                if (!activeProperty.getPtDemandSet().isEmpty()) {
                    Object arrearCollection = BigDecimal.ZERO;
                    BigDecimal currentCollection = BigDecimal.ZERO;
                    Map demandCollectionMap = this.propertyTaxUtil.getDemandAndCollection(activeProperty);
                    if (!demandCollectionMap.isEmpty()) {
                        arrearCollection = (BigDecimal)demandCollectionMap.get("ARR_COLL");
                        currentCollection = (BigDecimal)demandCollectionMap.get("CURR_COLL");
                        if (((BigDecimal)arrearCollection).compareTo(BigDecimal.ZERO) > 0 || currentCollection.compareTo(BigDecimal.ZERO) > 0) {
                            this.addActionError(this.getText("edit.dataEntry.collection.done.error"));
                            return COMMON_FORM;
                        }
                    }
                }
            }
            this.activePropertyId = basicProperty.getActiveProperty().getId().toString();
        }
        if ("Bifuracate_Assessment".equals(this.applicationType) && (propertyStatusValues = this.propertyService.findChildrenForProperty(basicProperty)).isEmpty()) {
            this.addActionError(this.getText("error.nochild.exists.bifurcation"));
            return COMMON_FORM;
        }
        if ("Revision_Petition".equals(this.applicationType)) {
            if (this.isDemandActive) {
                this.addActionError(this.getText("revPetition.demandActive"));
                return COMMON_FORM;
            }
        } else if ("Alter_Assessment".equals(this.applicationType) || "Bifuracate_Assessment".equals(this.applicationType) || "Transfer_of_Ownership".equals(this.applicationType) || "General_Revision_Petition".equals(this.applicationType) || "Demolition".equals(this.applicationType)) {
            if (!this.isDemandActive) {
                this.addActionError(this.getText("error.msg.demandInactive"));
                return COMMON_FORM;
            }
        } else if ("Generate_demand_bill".equals(this.applicationType)) {
            Ptdemand currentDemand = null;
            for (Ptdemand ptdemand : basicProperty.getProperty().getPtDemandSet()) {
                if (!ptdemand.getEgInstallmentMaster().equals((Object)this.propertyTaxCommonUtils.getCurrentInstallment())) continue;
                currentDemand = ptdemand;
                break;
            }
            if (currentDemand == null) {
                this.addActionError(this.getText("error.msg.no.demand") + basicProperty.getUpicNo());
                return COMMON_FORM;
            }
            if (basicProperty.getProperty().getIsExemptedFromTax().booleanValue()) {
                this.addActionError(this.getText("error.msg.taxExempted"));
                return COMMON_FORM;
            }
        }
        this.loggedUserIsMeesevaUser = this.propertyService.isMeesevaUser(this.securityUtils.getCurrentUser());
        if (this.loggedUserIsMeesevaUser.booleanValue()) {
            if ("Transfer_of_Ownership".equals(this.applicationType)) {
                return "Meeseva_Transfer_of_Ownership";
            }
            if ("General_Revision_Petition".equals(this.applicationType)) {
                return "Meeseva_General_Revision_Petition";
            }
            if ("Revision_Petition".equals(this.applicationType)) {
                return "Meeseva_Revision_Petition";
            }
        }
        if ("Edit_demand".equals(this.applicationType)) {
            boolean grpDone = false;
            RevisionPetition oldObjection = this.revisionPetitionService.getExistingGRP(basicProperty);
            if (oldObjection != null || oldObjection == null && "GRP".equalsIgnoreCase(basicProperty.getActiveProperty().getPropertyModifyReason())) {
                grpDone = true;
            }
            boolean dataEntryDone = false;
            if (PropertyTaxConstants.SOURCEOFDATA_DATAENTRY.toString().equalsIgnoreCase(basicProperty.getSource().toString()) && basicProperty.getPropertySet().size() == 1 || PropertyTaxConstants.SOURCEOFDATA_DATAENTRY.toString().equalsIgnoreCase(basicProperty.getSource().toString()) && grpDone) {
                dataEntryDone = true;
            }
            if (!(dataEntryDone || PropertyTaxConstants.SOURCEOFDATA_MIGRATION.toString().equalsIgnoreCase(basicProperty.getSource().toString()) && grpDone)) {
                this.addActionError(this.getText("edit.dataEntry.source.error"));
                return COMMON_FORM;
            }
        }
        if ("Add_demand".equals(this.applicationType)) {
            if (!basicProperty.getSource().toString().equalsIgnoreCase(PropertyTaxConstants.SOURCEOFDATA_DATAENTRY.toString()) && !basicProperty.getSource().toString().equalsIgnoreCase(PropertyTaxConstants.SOURCEOFDATA_MIGRATION.toString())) {
                this.addActionError(this.getText("add.dataEntry.source.error"));
                return COMMON_FORM;
            }
            return "Add_demand";
        }
        if (basicProperty.getProperty().getIsExemptedFromTax().booleanValue() && !this.applicationType.equalsIgnoreCase("Tax_Exemption") && !this.applicationType.equalsIgnoreCase("Edit_Data_Entry")) {
            this.addActionError(this.getText("action.error.msg.for.taxExempted"));
            return COMMON_FORM;
        }
        if ("Edit_owner".equals(this.applicationType)) {
            return "Edit_owner";
        }
        if (this.applicationType.equalsIgnoreCase("Vacancy_Remission") || this.applicationType.equalsIgnoreCase("Tax_Exemption")) {
            if (!this.isDemandActive) {
                this.addActionError(this.getText("error.msg.demandInactive"));
                return COMMON_FORM;
            }
            this.mode = "commonSearch";
        }
        if ("Edit_Collection".equals(this.applicationType)) {
            if (!basicProperty.isEligible()) {
                this.addActionError(this.getText("error.msg.editCollection.noteligible"));
                return COMMON_FORM;
            }
            return "Edit_Collection";
        }
        return this.applicationType;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/search/searchProperty-srchByAssessment")
    public String srchByAssessment() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into srchByAssessment  method. Assessment Number : " + this.assessmentNum));
        }
        try {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)("srchByAssessment : BasicProperty : " + this.basicProperty));
            }
            if (this.basicProperty != null) {
                this.setSearchResultList(this.getSearchResults(this.basicProperty.getUpicNo()));
                this.checkIsMarkForDeactive(this.basicProperty);
            }
            if (this.assessmentNum != null && !this.assessmentNum.equals("")) {
                this.setSearchValue("Assessment Number : " + this.assessmentNum);
            }
            this.setSearchUri("../search/searchProperty-srchByAssessment.action");
            this.setSearchCriteria("Search By Assessment number");
            this.setSearchValue("Assessment number :" + this.assessmentNum);
        }
        catch (IndexOutOfBoundsException iob) {
            String msg = "Rollover is not done for " + this.assessmentNum;
            throw new ValidationException(Arrays.asList(new ValidationError(msg, msg)));
        }
        catch (Exception e) {
            this.LOGGER.error((Object)"Exception in Search Property By Assessment ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception : ", (Throwable)e);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from srchByAssessment method ");
        }
        return TARGET;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/search/searchProperty-srchByOldMuncipalNumber")
    public String srcByOldAssesementNum() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into srcByOldAssesementNum  method. Old Assessment Number : " + this.oldMuncipalNum));
        }
        if (this.oldMuncipalNum != null) {
            try {
                List propertyList = this.propertyService.getPropertyByOldMunicipalNo(this.oldMuncipalNum);
                for (PropertyMaterlizeView propMatview : propertyList) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug((Object)("srchByBndry : Property : " + propMatview));
                    }
                    this.setSearchResultList(this.getResultsFromMv(propMatview));
                }
                if (this.oldMuncipalNum != null && !this.oldMuncipalNum.equals("")) {
                    this.setSearchValue("Assessment Number : " + this.oldMuncipalNum);
                }
                this.setSearchUri("../search/searchProperty-srchByOldMuncipalNumber.action");
                this.setSearchCriteria("Search By Old Muncipal Number");
                this.setSearchValue("Old Muncipal number :" + this.oldMuncipalNum);
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Exception in Search Property By OldMuncipal Number ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception : ", (Throwable)e);
            }
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from srcByOldAssesementNum method ");
        }
        return TARGET;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/search/searchProperty-srchByDoorNo")
    public String srchByDoorNo() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into srchByDoorNo  method. Door No : " + this.doorNo));
        }
        if (null != this.doorNo) {
            try {
                List propertyList = this.propertyService.getPropertyByDoorNo(this.doorNo);
                for (PropertyMaterlizeView propMatview : propertyList) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug((Object)("srchByBndry : Property : " + propMatview));
                    }
                    this.setSearchResultList(this.getResultsFromMv(propMatview));
                }
                if (this.assessmentNum != null && !this.assessmentNum.equals("")) {
                    this.setSearchValue("Assessment Number : " + this.assessmentNum);
                }
                this.setSearchUri("../search/searchProperty-srchByDoorNo.action");
                this.setSearchCriteria("Search By Door Number");
                this.setSearchValue("Door number :" + this.doorNo);
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Exception in Search Property By Door number ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception : ", (Throwable)e);
            }
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from srchByDoorNo method ");
        }
        return TARGET;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/search/searchProperty-srchByMobileNumber")
    public String srchByMobileNumber() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into srchByMobileNumber  method. Mobile No : " + this.mobileNumber));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.mobileNumber)) {
            try {
                List propertyList = this.propertyService.getPropertyByMobileNumber(this.mobileNumber);
                for (PropertyMaterlizeView propMatview : propertyList) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug((Object)("srchByBndry : Property : " + propMatview));
                    }
                    this.setSearchResultList(this.getResultsFromMv(propMatview));
                }
                if (this.mobileNumber != null && !this.mobileNumber.equals("")) {
                    this.setSearchValue("Mobile Number : " + this.mobileNumber);
                }
                this.setSearchUri("../search/searchProperty-srchByMobileNumber.action");
                this.setSearchCriteria("Search By Mobile Number");
                this.setSearchValue("Mobile number :" + this.mobileNumber);
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Exception in Search Property By MobileNumber number ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception : ", (Throwable)e);
            }
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from srchByMobileNumber method ");
        }
        return TARGET;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/search/searchProperty-srchByBndry")
    public String srchByBndry() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into srchByBndry method");
            this.LOGGER.debug((Object)("srchByBndry : Zone Id : " + this.zoneId + ", ward Id : " + this.wardId + ", House Num : " + this.houseNumBndry + ", Owner Name : " + this.ownerNameBndry));
        }
        String strZoneNum = "";
        String strWardNum = "";
        if (null != this.zoneId && this.zoneId != -1L) {
            strZoneNum = this.boundaryService.getBoundaryById(this.zoneId).getName();
        }
        if (null != this.wardId && this.wardId != -1L) {
            strWardNum = this.boundaryService.getBoundaryById(this.wardId).getName();
        }
        if (this.zoneId != null && this.zoneId != -1L || this.wardId != null && this.wardId != -1L) {
            try {
                List propertyList = this.propertyService.getPropertyByBoundary(this.zoneId, this.wardId, this.ownerNameBndry, this.houseNumBndry);
                if (!propertyList.isEmpty() && propertyList.size() > Integer.parseInt("500")) {
                    throw new ValidationException(Arrays.asList(new ValidationError("resultCountValidation", this.getText("search.validate.resultcountexceed500"))));
                }
                for (PropertyMaterlizeView propMatview : propertyList) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug((Object)("srchByBndry : Property : " + propMatview));
                    }
                    this.setSearchResultList(this.getResultsFromMv(propMatview));
                }
                this.setSearchUri("../search/searchProperty-srchByBndry.action");
                this.setSearchCriteria("Search By Zone, Ward, Plot No/House No, Owner Name");
                this.setSearchValue("Zone Num: " + strZoneNum + ", Ward Num: " + strWardNum + ", Plot No/House No: " + this.houseNumBndry + ", Owner Name: " + this.ownerNameBndry);
            }
            catch (ValidationException e) {
                throw new ValidationException(e.getErrors());
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Exception in Search Property By Bndry ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception : " + e);
            }
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from srchByBndry method");
        }
        return TARGET;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/search/searchProperty-srchByLocation")
    public String srchByLocation() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into srchByArea  method");
            this.LOGGER.debug((Object)("srchByLocation : Location Id : " + this.locationId + ", Owner Name : " + this.ownerName + ", Plot No/House No : " + this.houseNumArea));
        }
        String strLocationNum = this.boundaryService.getBoundaryById(Long.valueOf(this.locationId.longValue())).getName();
        if (null != this.ownerName && StringUtils.isNotEmpty((String)this.ownerName) && this.locationId != null && this.locationId != -1) {
            try {
                List propertyList = this.propertyService.getPropertyByLocation(this.locationId, this.houseNumArea, this.ownerName);
                if (!propertyList.isEmpty() && propertyList.size() > Integer.parseInt("500")) {
                    ValidationError vr = new ValidationError("search.validate.resultcountexceed500", "search.validate.resultcountexceed500");
                    throw new ValidationException(Arrays.asList(vr));
                }
                for (PropertyMaterlizeView propMatview : propertyList) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug((Object)("srchByLocation : Property : " + propMatview));
                    }
                    this.setSearchResultList(this.getResultsFromMv(propMatview));
                }
                this.setSearchUri("../search/searchProperty-srchByLocation.action");
                this.setSearchCriteria("Search By Location, Owner Name");
                this.setSearchValue("Location : " + strLocationNum + ", Owner Name : " + this.ownerName);
            }
            catch (ValidationException e) {
                throw new ValidationException(e.getErrors());
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Exception in Search Property By Bndry ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception : " + e);
            }
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from srchByArea  method");
        }
        return TARGET;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/search/searchProperty-searchByDemand")
    public String searchByDemand() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into searchByDemand  method");
            this.LOGGER.debug((Object)("From Demand No : " + this.fromDemand + ", To Demand No : " + this.toDemand));
        }
        if (this.fromDemand != null && this.fromDemand != "" && this.toDemand != null && this.toDemand != "") {
            try {
                List propertyList = this.propertyService.getPropertyByDemand(this.fromDemand, this.toDemand);
                if (!propertyList.isEmpty() && propertyList.size() > Integer.parseInt("500")) {
                    ValidationError vr = new ValidationError("search.validate.resultcountexceed500", "search.validate.resultcountexceed500");
                    throw new ValidationException(Arrays.asList(vr));
                }
                for (PropertyMaterlizeView propMatview : propertyList) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug((Object)("searchByDemand : Property : " + propMatview));
                    }
                    this.setSearchResultList(this.getResultsFromMv(propMatview));
                }
                this.setSearchUri("../search/searchProperty-searchByDemand.action");
                this.setSearchCriteria("Search By FromDemand, ToDemand");
                this.setSearchValue("From Demand: " + this.fromDemand + ", To Demand: " + this.toDemand);
            }
            catch (ValidationException e) {
                throw new ValidationException(e.getErrors());
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Exception in Search Property By Bndry ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception : " + e);
            }
        }
        return TARGET;
    }

    public void prepare() {
        List zoneList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
        List wardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
        List locationList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Locality", "LOCATION");
        this.setZoneBndryMap(CommonServices.getFormattedBndryMap((List)zoneList));
        this.setWardndryMap(CommonServices.getFormattedBndryMap((List)wardList));
        this.prepareWardDropDownData(this.zoneId != null, this.wardId != null);
        this.addDropdownData("Location", locationList);
        this.addDropdownData("PropTypeMaster", this.getPersistenceService().findAllByNamedQuery("getPropertyTypes", new Object[0]));
        Long userId = (Long)this.session().get("userid");
        if (userId != null) {
            this.setRoleName(this.propertyTaxUtil.getRolesForUserId(userId));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.assessmentNum)) {
            this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(this.assessmentNum);
        }
    }

    @SkipValidation
    private void prepareWardDropDownData(boolean zoneExists, boolean wardExists) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into prepareWardDropDownData method");
            this.LOGGER.debug((Object)("Zone exists ? : " + zoneExists + ", Ward exists ? : " + wardExists));
        }
        if (zoneExists && wardExists) {
            List wardNewList = new ArrayList();
            wardNewList = this.boundaryService.getActiveChildBoundariesByBoundaryId(this.getZoneId());
            this.addDropdownData("wardList", wardNewList);
        } else {
            this.addDropdownData("wardList", Collections.EMPTY_LIST);
        }
    }

    public void validate() {
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.mode, (CharSequence)"assessment")) {
            if (StringUtils.isEmpty((String)this.assessmentNum) || StringUtils.isBlank((String)this.assessmentNum)) {
                this.addActionError(this.getText("mandatory.assessmentNo"));
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.mode, (CharSequence)"oldAssessment")) {
            if (StringUtils.isEmpty((String)this.oldMuncipalNum) || StringUtils.isBlank((String)this.oldMuncipalNum)) {
                this.addActionError(this.getText("mandatory.oldMuncipleNum"));
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.mode, (CharSequence)"bndry")) {
            if (!(this.zoneId != null && this.zoneId != -1L || this.wardId != null && this.wardId != -1L)) {
                this.addActionError(this.getText("mandatory.zoneorward"));
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.mode, (CharSequence)"location")) {
            if (this.locationId == null || this.locationId == -1) {
                this.addActionError(this.getText("mandatory.location"));
            }
            if (this.ownerName == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.ownerName)) {
                this.addActionError(this.getText("search.ownerName.null"));
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.mode, (CharSequence)"demand")) {
            if (this.fromDemand == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.fromDemand)) {
                this.addActionError(this.getText("mandatory.fromdemand"));
            }
            if (this.toDemand == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.toDemand)) {
                this.addActionError(this.getText("mandatory.todemand"));
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.mode, (CharSequence)"doorNo")) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.doorNo)) {
                this.addActionError(this.getText("mandatory.doorNo"));
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)this.mode, (CharSequence)"mobileNo") && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.mobileNumber)) {
            this.addActionError(this.getText("mandatory.MobileNumber"));
        }
    }

    private List<Map<String, String>> getSearchResults(String assessmentNumber) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into getSearchResults method");
            this.LOGGER.debug((Object)("Assessment Number : " + assessmentNumber));
        }
        if (assessmentNumber != null || StringUtils.isNotEmpty((String)assessmentNumber)) {
            BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNumber);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)("BasicProperty : " + basicProperty));
            }
            if (basicProperty != null) {
                Property property = basicProperty.getProperty();
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug((Object)("Property : " + property));
                }
                this.checkIsDemandActive(property);
                Map demandCollMap = this.ptDemandDAO.getDemandCollMap(property);
                HashMap<String, String> searchResultMap = new HashMap<String, String>();
                searchResultMap.put("assessmentNum", assessmentNumber);
                searchResultMap.put("ownerName", basicProperty.getFullOwnerName());
                searchResultMap.put("address", basicProperty.getAddress().toString());
                searchResultMap.put("source", basicProperty.getSource().toString());
                searchResultMap.put("isDemandActive", String.valueOf(this.isDemandActive));
                searchResultMap.put("propType", property.getPropertyDetail().getPropertyTypeMaster().getCode());
                searchResultMap.put("isTaxExempted", String.valueOf(property.getIsExemptedFromTax()));
                searchResultMap.put("isUnderWorkflow", String.valueOf(basicProperty.isUnderWorkflow()));
                searchResultMap.put("enableVacancyRemission", String.valueOf(this.propertyTaxUtil.enableVacancyRemission(basicProperty.getUpicNo())));
                searchResultMap.put("enableMonthlyUpdate", String.valueOf(this.propertyTaxUtil.enableMonthlyUpdate(basicProperty.getUpicNo())));
                searchResultMap.put("enableVRApproval", String.valueOf(this.propertyTaxUtil.enableVRApproval(basicProperty.getUpicNo())));
                if (!property.getIsExemptedFromTax().booleanValue()) {
                    searchResultMap.put("currFirstHalfDemand", ((BigDecimal)demandCollMap.get("CURR_FIRSTHALF_DMD")).toString());
                    searchResultMap.put("currSecondHalfDemand", ((BigDecimal)demandCollMap.get("CURR_SECONDHALF_DMD")).toString());
                    searchResultMap.put("arrDemandDue", ((BigDecimal)demandCollMap.get("ARR_DMD")).subtract((BigDecimal)demandCollMap.get("ARR_COLL")).toString());
                    searchResultMap.put("currFirstHalfDemandDue", ((BigDecimal)demandCollMap.get("CURR_FIRSTHALF_DMD")).subtract((BigDecimal)demandCollMap.get("CURR_FIRSTHALF_COLL")).toString());
                    searchResultMap.put("currSecondHalfDemandDue", ((BigDecimal)demandCollMap.get("CURR_SECONDHALF_DMD")).subtract((BigDecimal)demandCollMap.get("CURR_SECONDHALF_COLL")).toString());
                } else {
                    searchResultMap.put("currFirstHalfDemand", "0");
                    searchResultMap.put("currFirstHalfDemandDue", "0");
                    searchResultMap.put("currSecondHalfDemand", "0");
                    searchResultMap.put("currSecondHalfDemandDue", "0");
                    searchResultMap.put("arrDemandDue", "0");
                }
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug((Object)("Assessment Number : " + (String)searchResultMap.get("assessmentNum") + ", Owner Name : " + (String)searchResultMap.get("ownerName") + ", Parcel id : " + (String)searchResultMap.get("parcelId") + ", Address : " + (String)searchResultMap.get("address") + ", Current Demand : " + (String)searchResultMap.get("currDemand") + ", Arrears Demand Due : " + (String)searchResultMap.get("arrDemandDue") + ", Current Demand Due : " + (String)searchResultMap.get("currDemandDue")));
                }
                this.searchList.add(searchResultMap);
            }
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Search list : " + (this.searchList != null ? this.searchList : BigDecimal.ZERO)));
            this.LOGGER.debug((Object)"Exit from getSearchResults method");
        }
        return this.searchList;
    }

    private void checkIsMarkForDeactive(BasicProperty basicProperty) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into checkIsMarkForDeactive method");
            this.LOGGER.debug((Object)("BasicProperty : " + basicProperty));
        }
        Set propStatusValSet = new HashSet();
        propStatusValSet = basicProperty.getPropertyStatusValuesSet();
        for (PropertyStatusValues propStatusVal : propStatusValSet) {
            if (propStatusVal.getPropertyStatus().getStatusCode().equals("MARK_DEACTIVE")) {
                this.markedForDeactive = "Y";
            }
            if (!this.LOGGER.isDebugEnabled()) continue;
            this.LOGGER.debug((Object)("Property Status Values : " + propStatusVal));
            this.LOGGER.debug((Object)("Marked for Deactivation ? : " + this.markedForDeactive));
        }
    }

    private void checkIsDemandActive(Property property) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into checkIsDemandActive");
        }
        this.isDemandActive = !property.getStatus().equals(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("checkIsDemandActive - Is demand active? : " + this.isDemandActive));
            this.LOGGER.debug((Object)"Exiting from checkIsDemandActive");
        }
    }

    private List<Map<String, String>> getResultsFromMv(PropertyMaterlizeView pmv) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into getSearchResults method");
            this.LOGGER.debug((Object)("Assessment Number : " + pmv.getPropertyId()));
        }
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(pmv.getPropertyId());
        Property property = basicProperty.getProperty();
        if (basicProperty != null) {
            this.checkIsDemandActive(basicProperty.getProperty());
        }
        if ((pmv.getPropertyId() != null || StringUtils.isNotEmpty((String)pmv.getPropertyId())) && pmv != null) {
            HashMap<String, String> searchResultMap = new HashMap<String, String>();
            searchResultMap.put("assessmentNum", pmv.getPropertyId());
            searchResultMap.put("ownerName", pmv.getOwnerName());
            searchResultMap.put("parcelId", pmv.getGisRefNo());
            searchResultMap.put("address", pmv.getPropertyAddress());
            searchResultMap.put("source", pmv.getSource().toString());
            searchResultMap.put("isDemandActive", String.valueOf(this.isDemandActive));
            searchResultMap.put("propType", property.getPropertyDetail().getPropertyTypeMaster().getCode());
            searchResultMap.put("isTaxExempted", String.valueOf(property.getIsExemptedFromTax()));
            searchResultMap.put("isUnderWorkflow", String.valueOf(basicProperty.isUnderWorkflow()));
            searchResultMap.put("enableVacancyRemission", String.valueOf(this.propertyTaxUtil.enableVacancyRemission(basicProperty.getUpicNo())));
            searchResultMap.put("enableMonthlyUpdate", String.valueOf(this.propertyTaxUtil.enableMonthlyUpdate(basicProperty.getUpicNo())));
            searchResultMap.put("enableVRApproval", String.valueOf(this.propertyTaxUtil.enableVRApproval(basicProperty.getUpicNo())));
            if (pmv.getIsExempted().booleanValue()) {
                searchResultMap.put("currFirstHalfDemand", "0");
                searchResultMap.put("currFirstHalfDemandDue", "0");
                searchResultMap.put("currSecondHalfDemand", "0");
                searchResultMap.put("currSecondHalfDemandDue", "0");
                searchResultMap.put("arrDemandDue", "0");
            } else {
                searchResultMap.put("currFirstHalfDemand", pmv.getAggrCurrFirstHalfDmd() == null ? "0" : pmv.getAggrCurrFirstHalfDmd().toString());
                searchResultMap.put("currFirstHalfDemandDue", (pmv.getAggrCurrFirstHalfDmd() == null ? BigDecimal.ZERO : pmv.getAggrCurrFirstHalfDmd()).subtract(pmv.getAggrCurrFirstHalfColl() == null ? BigDecimal.ZERO : pmv.getAggrCurrFirstHalfColl()).toString());
                searchResultMap.put("currSecondHalfDemand", pmv.getAggrCurrSecondHalfDmd() == null ? "0" : pmv.getAggrCurrSecondHalfDmd().toString());
                searchResultMap.put("currSecondHalfDemandDue", (pmv.getAggrCurrSecondHalfDmd() == null ? BigDecimal.ZERO : pmv.getAggrCurrSecondHalfDmd()).subtract(pmv.getAggrCurrSecondHalfColl() == null ? BigDecimal.ZERO : pmv.getAggrCurrSecondHalfColl()).toString());
                searchResultMap.put("arrDemandDue", (pmv.getAggrArrDmd() == null ? BigDecimal.ZERO : pmv.getAggrArrDmd()).subtract(pmv.getAggrArrColl() == null ? BigDecimal.ZERO : pmv.getAggrArrColl()).toString());
            }
            this.searchList.add(searchResultMap);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Search list : " + (this.searchList != null ? this.searchList : BigDecimal.ZERO)));
            this.LOGGER.debug((Object)"Exit from getSearchResults method");
        }
        return this.searchList;
    }

    @ValidationErrorPage(value="new")
    @Action(value="/search/searchProperty-searchOwnerDetails")
    public String searchOwnerDetails() {
        if (this.basicProperty == null) {
            this.addActionError(this.getText("validation.property.doesnot.exists"));
            return "new";
        }
        this.setPropertyOwner(this.basicProperty.getPrimaryOwner());
        this.setMobileNumber(this.getPropertyOwner().getMobileNumber());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.propertyOwner.getMobileNumber())) {
            this.propertyOwner.setMobileNumber("N/A");
        }
        this.setDoorNo(this.basicProperty.getAddress().getHouseNoBldgApt() == null ? "N/A" : this.basicProperty.getAddress().getHouseNoBldgApt());
        return USER_DETAILS;
    }

    @Action(value="/search/searchProperty-updateMobileNo")
    public String updateMobileNo() {
        if (null != this.basicProperty) {
            this.setPropertyOwner(this.basicProperty.getPrimaryOwner());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.mobileNumber)) {
            this.propertyOwner.setMobileNumber(this.mobileNumber);
            this.userService.updateUser(this.propertyOwner);
        }
        return UPDATEMOBILE_FORM;
    }

    @Action(value="/search/searchproperty-alter-assessment")
    public String alterAssessment() {
        this.setActionNamespace("/modify");
        this.setApplicationType("Alter_Assessment");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-bifurcation")
    public String bifurcation() {
        this.setApplicationType("Bifuracate_Assessment");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-taxexemption")
    public String taxExemption() {
        this.setApplicationType("Tax_Exemption");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-editcollection")
    public String editCollection() {
        this.setApplicationType("Edit_Collection");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-editdemand")
    public String editDemand() {
        this.setApplicationType("Edit_demand");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-transferownership")
    public String transferOwnership() {
        this.setActionNamespace("/property/transfer");
        this.setApplicationType("Transfer_of_Ownership");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-collecttax")
    public String collectTax() {
        this.setApplicationType("Collect_Tax");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-revisionpetition")
    public String revisionPetition() {
        this.setActionNamespace("/revPetition");
        this.setApplicationType("Revision_Petition");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-general-revisionpetition")
    public String generalRevisionPetition() {
        this.setActionNamespace("/revPetition");
        this.setApplicationType("General_Revision_Petition");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-demolition")
    public String demolition() {
        this.setApplicationType("Demolition");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.applicationSource)) {
            this.setApplicationSource("system");
        }
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-vacancyremission")
    public String vacancyRemission() {
        this.setApplicationType("Vacancy_Remission");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-generatedemandbill")
    public String generateDemandBill() {
        this.setApplicationType("Generate_demand_bill");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-editdataentry")
    public String editDataEntry() {
        this.setApplicationType("Edit_Data_Entry");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-editownerdetails")
    public String editOwnerDetails() {
        this.setApplicationType("Edit_owner");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-adddemand")
    public String AddDemand() {
        this.setApplicationType("Add_demand");
        return this.commonForm();
    }

    @Action(value="/search/searchproperty-amalgamation")
    public String amalgamation() {
        this.setApplicationType("Amalgamation");
        return this.commonForm();
    }

    public List<Map<String, String>> getSearchResultList() {
        return this.searchResultList;
    }

    public void setSearchResultList(List<Map<String, String>> searchResultList) {
        this.searchResultList = searchResultList;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public String getOldMuncipalNum() {
        return this.oldMuncipalNum;
    }

    public void setOldMuncipalNum(String oldMuncipalNum) {
        this.oldMuncipalNum = oldMuncipalNum;
    }

    public String getOldHouseNum() {
        return this.oldHouseNum;
    }

    public void setOldHouseNum(String oldHouseNum) {
        this.oldHouseNum = oldHouseNum;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getSearchUri() {
        return this.searchUri;
    }

    public void setSearchUri(String searchUri) {
        this.searchUri = searchUri;
    }

    public String getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(String searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public String getSearchValue() {
        return this.searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    public Integer getAreaName() {
        return this.areaName;
    }

    public void setAreaName(Integer areaName) {
        this.areaName = areaName;
    }

    public String getHouseNumBndry() {
        return this.houseNumBndry;
    }

    public void setHouseNumBndry(String houseNumBndry) {
        this.houseNumBndry = houseNumBndry;
    }

    public String getOwnerNameBndry() {
        return this.ownerNameBndry;
    }

    public void setOwnerNameBndry(String ownerNameBndry) {
        this.ownerNameBndry = ownerNameBndry;
    }

    public String getHouseNumArea() {
        return this.houseNumArea;
    }

    public void setHouseNumArea(String houseNumArea) {
        this.houseNumArea = houseNumArea;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public Long getPropertyTypeMasterId() {
        return this.propertyTypeMasterId;
    }

    public void setPropertyTypeMasterId(Long propertyTypeMasterId) {
        this.propertyTypeMasterId = propertyTypeMasterId;
    }

    public String getMarkedForDeactive() {
        return this.markedForDeactive;
    }

    public void setMarkedForDeactive(String markedForDeactive) {
        this.markedForDeactive = markedForDeactive;
    }

    public Map<Long, String> getZoneBndryMap() {
        return this.ZoneBndryMap;
    }

    public void setZoneBndryMap(Map<Long, String> zoneBndryMap) {
        this.ZoneBndryMap = zoneBndryMap;
    }

    public Map<Long, String> getWardndryMap() {
        return this.WardndryMap;
    }

    public void setWardndryMap(Map<Long, String> wardndryMap) {
        this.WardndryMap = wardndryMap;
    }

    public boolean getIsDemandActive() {
        return this.isDemandActive;
    }

    public void setIsDemandActive(boolean isDemandActive) {
        this.isDemandActive = isDemandActive;
    }

    public Integer getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Integer locationId) {
        this.locationId = locationId;
    }

    public String getFromDemand() {
        return this.fromDemand;
    }

    public void setFromDemand(String fromDemand) {
        this.fromDemand = fromDemand;
    }

    public String getToDemand() {
        return this.toDemand;
    }

    public void setToDemand(String toDemand) {
        this.toDemand = toDemand;
    }

    public String getAssessmentNum() {
        return this.assessmentNum;
    }

    public void setAssessmentNum(String assessmentNum) {
        this.assessmentNum = assessmentNum;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getDoorNo() {
        return this.doorNo;
    }

    public void setDoorNo(String doorNo) {
        this.doorNo = doorNo;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getMeesevaApplicationNumber() {
        return this.meesevaApplicationNumber;
    }

    public void setMeesevaApplicationNumber(String meesevaApplicationNumber) {
        this.meesevaApplicationNumber = meesevaApplicationNumber;
    }

    public String getMeesevaServiceCode() {
        return this.meesevaServiceCode;
    }

    public void setMeesevaServiceCode(String meesevaServiceCode) {
        this.meesevaServiceCode = meesevaServiceCode;
    }

    public boolean getIsNagarPanchayat() {
        return this.propertyTaxUtil.checkIsNagarPanchayat();
    }

    public User getPropertyOwner() {
        return this.propertyOwner;
    }

    public void setPropertyOwner(User propertyOwner) {
        this.propertyOwner = propertyOwner;
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public String getActivePropertyId() {
        return this.activePropertyId;
    }

    public void setActivePropertyId(String activePropertyId) {
        this.activePropertyId = activePropertyId;
    }

    public String getApplicationSource() {
        return this.applicationSource;
    }

    public void setApplicationSource(String applicationSource) {
        this.applicationSource = applicationSource;
    }

    public String getActionNamespace() {
        return this.actionNamespace;
    }

    public void setActionNamespace(String actionNamespace) {
        this.actionNamespace = actionNamespace;
    }
}

