/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.edit;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.dcb.bean.DCBDisplayInfo;
import org.egov.demand.dao.EgDemandDetailsDao;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.models.BaseModel;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.actions.edit.EditDemandAction;
import org.egov.ptis.bean.DemandDetail;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.entity.demand.PTDemandCalculations;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.DemandAudit;
import org.egov.ptis.domain.entity.property.DemandAuditDetails;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.service.DemandAuditService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Namespace(value="/edit")
@ResultPath(value="/WEB-INF/jsp/")
@Results(value={@Result(name={"editForm"}, location="edit/editDemand-editForm.jsp"), @Result(name={"error"}, location="edit/editDemand-error.jsp"), @Result(name={"ack"}, location="edit/editDemand-ack.jsp")})
public class EditDemandAction
extends BaseFormAction {
    private static final long serialVersionUID = -2456087421120805855L;
    private static final Logger LOGGER = Logger.getLogger(EditDemandAction.class);
    protected static final String RESULT_NEW = "editForm";
    protected static final String RESULT_ERROR = "error";
    protected static final String RESULT_ACK = "ack";
    private static final String QUERY_DEMAND_DETAILS = "SELECT dd FROM Ptdemand ptd LEFT JOIN ptd.egDemandDetails dd LEFT JOIN ptd.egptProperty p LEFT JOIN  p.basicProperty bp WHERE bp = ? AND bp.active = true AND p.status = 'A' ";
    private static final String queryInstallmentPTDemand = "select ptd from Ptdemand ptd inner join fetch ptd.egDemandDetails dd inner join fetch dd.egDemandReason dr inner join fetch dr.egDemandReasonMaster drm inner join fetch ptd.egptProperty p inner join fetch p.basicProperty bp where bp.active = true and (p.status = 'A' or p.status = 'I' or p.status = 'W') and bp = ? and ptd.egInstallmentMaster = ? ";
    private static final String QUERY_NONZERO_DEMAND_DETAILS = "SELECT dd FROM Ptdemand ptd LEFT JOIN ptd.egDemandDetails dd LEFT JOIN ptd.egptProperty p LEFT JOIN  p.basicProperty bp WHERE bp = ? AND bp.active = true AND p.status = 'A'  AND dd.amount >= 0 ";
    private static final String queryInstallmentDemandDetails = "SELECT dd FROM Ptdemand ptd LEFT JOIN ptd.egDemandDetails dd LEFT JOIN ptd.egptProperty p LEFT JOIN  p.basicProperty bp WHERE bp = ? AND bp.active = true AND p.status = 'A'  AND dd.amount >= 0  AND ptd.egInstallmentMaster = ? ";
    private static final String EDIT_DEMAND = "Edit Demand";
    private static final String EDIT_TYPE_POSTFIX = "-";
    private String propertyId;
    private String ownerName;
    private String mobileNumber;
    private String propertyAddress;
    private String remarks;
    private String errorMessage;
    private BasicProperty basicProperty;
    private PropertyService propService;
    private DCBDisplayInfo dcbDispInfo;
    @Autowired
    private InstallmentHibDao installmentDAO;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private DemandAuditService demandAuditService;
    @Autowired
    private RevisionPetitionService revisionPetitionService;
    @Autowired
    private EgDemandDetailsDao demandDetailsDao;
    @Autowired
    @Qualifier(value="propertyImplService")
    private PersistenceService propertyImplService;
    private final DemandAudit demandAudit = new DemandAudit();
    private List<EgDemandDetails> demandDetails = new ArrayList();
    private List<DemandDetail> demandDetailBeanList = new ArrayList();
    private List<Installment> allInstallments = new ArrayList();
    private final Set<Installment> propertyInstallments = new TreeSet();
    private Map<Installment, Map<String, Boolean>> collectionDetails = new HashMap();
    private Map<String, String> demandReasonMap = new HashMap();

    public Object getModel() {
        return this.demandDetailBeanList;
    }

    @SkipValidation
    public void prepare() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into prepare");
        }
        this.basicProperty = (BasicProperty)this.getPersistenceService().findByNamedQuery("getBasicPropertyByUpicNo", new Object[]{this.propertyId});
        if (null != this.basicProperty.getActiveProperty()) {
            this.demandReasonMap = this.basicProperty.getActiveProperty().getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND") ? PropertyTaxConstants.VACANT_PROPERTY_DMDRSN_CODE_MAP : PropertyTaxConstants.BUILTUP_PROPERTY_DMDRSN_CODE_MAP;
        }
        for (DemandDetail dd : this.demandDetailBeanList) {
            if (dd.getInstallment() == null || dd.getInstallment().getId() == null || dd.getInstallment().getId().equals(-1)) continue;
            dd.setInstallment(this.installmentDAO.findById(dd.getInstallment().getId().intValue(), false));
            if (dd.getIsNew().booleanValue()) continue;
            this.propertyInstallments.add(dd.getInstallment());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        try {
            this.allInstallments = this.propertyTaxUtil.getInstallmentListByStartDateToCurrFinYearDesc(dateFormat.parse("01/04/1963"));
        }
        catch (ParseException e) {
            throw new ApplicationRuntimeException("Error while getting all installments from start date", (Throwable)e);
        }
        this.allInstallments.removeAll(this.propertyInstallments);
        this.addDropdownData("allInstallments", this.allInstallments);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exiting from prepare");
        }
    }

    public void validate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into validate");
        }
        TreeSet<Installment> newInstallments = new TreeSet<Installment>();
        TreeSet installmentsChqPenalty = new TreeSet();
        HashSet<String> instDmdRsnMaster = new HashSet<String>();
        TreeSet<String> actAmtInstallments = new TreeSet<String>();
        ArrayList<String> errorParams = null;
        for (DemandDetail dd : this.demandDetailBeanList) {
            if (dd.getIsNew() != null && dd.getIsNew().booleanValue()) {
                ArrayList<String> instString = new ArrayList<String>();
                instString.add(dd.getReasonMaster());
                if ((dd.getReasonMaster().equalsIgnoreCase("General Tax") || dd.getReasonMaster().equalsIgnoreCase("Vacant Land Tax")) && (dd.getInstallment().getId() == null || dd.getInstallment().getId().equals(-1))) {
                    this.addActionError(this.getText("error.editDemand.selectInstallment"));
                }
                if (null != dd.getInstallment().getId() && !dd.getInstallment().getId().equals(-1)) {
                    if (null == dd.getActualAmount()) {
                        this.addActionError(this.getText("error.editDemand.actualAmount", instString));
                    }
                    if (null != dd.getActualAmount() && null != dd.getActualCollection() && dd.getActualAmount().intValue() < dd.getActualCollection().intValue()) {
                        this.addActionError(this.getText("error.collection.greaterThan.actualAmount"));
                    }
                }
                if (dd.getActualAmount() == null) {
                    if (dd.getActualCollection() == null) continue;
                    actAmtInstallments.add(dd.getInstallment().getDescription());
                    continue;
                }
                if (!dd.getReasonMaster().equalsIgnoreCase("General Tax") && !dd.getReasonMaster().equalsIgnoreCase("Vacant Land Tax")) continue;
                if (dd.getInstallment().getId() == null || dd.getInstallment().getId().equals(-1)) {
                    this.addActionError(this.getText("error.editDemand.selectInstallment"));
                    continue;
                }
                newInstallments.add(dd.getInstallment());
                String instRsn = dd.getInstallment().toString().concat(EDIT_TYPE_POSTFIX).concat(dd.getReasonMaster());
                if (instDmdRsnMaster.add(instRsn)) continue;
                instString.add(dd.getInstallment().toString());
                this.addActionError(this.getText("error.editDemand.duplicateInstallment", instString));
                continue;
            }
            newInstallments.add(dd.getInstallment());
            if (null != dd.getRevisedAmount() && PropertyTaxUtil.isZero((BigDecimal)dd.getRevisedAmount()) && dd.getActualCollection().compareTo(BigDecimal.ZERO) > 0 && PropertyTaxUtil.isNull((Object)dd.getRevisedCollection())) {
                errorParams = new ArrayList<String>();
                errorParams.add(dd.getReasonMaster());
                errorParams.add(dd.getInstallment().getDescription());
                this.addActionError(this.getText("error.editDemand.collectionForUpdatedDemand", errorParams));
            }
            if (null != dd.getRevisedAmount() && null != dd.getActualCollection() && dd.getRevisedAmount().intValue() < dd.getActualCollection().intValue()) {
                this.addActionError(this.getText("error.collection.greaterThan.revisedAmount"));
            }
            if (null == dd.getRevisedAmount() || null == dd.getRevisedCollection() || dd.getRevisedAmount().intValue() >= dd.getRevisedCollection().intValue()) continue;
            this.addActionError(this.getText("error.revisedCollecion.greaterThan.revisedAmount"));
        }
        if (actAmtInstallments.size() > 0) {
            String inst = ((Object)actAmtInstallments).toString().replace('[', ' ').replace(']', ' ');
            1 instStrings = new /* Unavailable Anonymous Inner Class!! */;
            this.addActionError(this.getText("error.editDemand.actualAmount", (List)instStrings));
        }
        List installmentsInOrder = null;
        if (!newInstallments.isEmpty()) {
            Map currYearInstMap;
            Date currDate;
            installmentsInOrder = this.propertyTaxUtil.getInstallmentListByStartDateToCurrFinYearDesc(((Installment)new ArrayList(newInstallments).get(0)).getFromDate());
            if (newInstallments.size() != installmentsInOrder.size()) {
                this.addActionError(this.getText("error.editDemand.badInstallmentSelection"));
            }
            if (!DateUtils.compareDates((Date)(currDate = new Date()), (Date)((Installment)(currYearInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(currDate)).get("Current 2nd Half")).getFromDate())) {
                if (newInstallments.contains(currYearInstMap.get("Current 1st Half")) && !newInstallments.contains(currYearInstMap.get("Current 2nd Half")) || !newInstallments.contains(currYearInstMap.get("Current 1st Half")) && newInstallments.contains(currYearInstMap.get("Current 2nd Half"))) {
                    this.addActionError(this.getText("error.currentyearinstallments"));
                }
            } else if (!newInstallments.contains(currYearInstMap.get("Current 2nd Half"))) {
                this.addActionError(this.getText("error.currentInst"));
            }
        }
        if (installmentsChqPenalty.size() > 0) {
            String inst = ((Object)installmentsChqPenalty).toString().replace('[', ' ').replace(']', ' ');
            ArrayList<String> instStrings = new ArrayList<String>();
            instStrings.add(inst);
            this.addActionError(this.getText("error.editDemand.chqBouncePenaltyIsZero", instStrings));
        }
        if (StringUtils.isBlank((String)this.remarks)) {
            this.addActionError(this.getText("mandatory.editDmdCollRemarks"));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exiting from validate");
        }
    }

    @SkipValidation
    @Action(value="/editDemand-newEditForm")
    public String newEditForm() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into newEditForm");
        }
        String resultPage = "";
        RevisionPetition oldObjection = this.revisionPetitionService.getExistingObjections(this.basicProperty);
        Date effectiveDate = null;
        if (oldObjection == null) {
            if ("GRP".equalsIgnoreCase(this.basicProperty.getActiveProperty().getPropertyModifyReason())) {
                effectiveDate = this.basicProperty.getActiveProperty().getEffectiveDate();
            }
        } else if ("GRP".equalsIgnoreCase(oldObjection.getType())) {
            effectiveDate = oldObjection.getProperty().getEffectiveDate();
        }
        this.ownerName = this.basicProperty.getFullOwnerName();
        this.mobileNumber = this.basicProperty.getMobileNumber();
        this.propertyAddress = this.basicProperty.getAddress().toString();
        this.demandDetails = this.getPersistenceService().findAllBy(queryInstallmentDemandDetails, new Object[]{this.basicProperty, this.propertyTaxCommonUtils.getCurrentInstallment()});
        if (!this.demandDetails.isEmpty()) {
            Collections.sort(this.demandDetails, (o1, o2) -> o1.getEgDemandReason().getEgInstallmentMaster().compareTo(o2.getEgDemandReason().getEgInstallmentMaster()));
        }
        PropertyTaxBillable billable = new PropertyTaxBillable();
        billable.setBasicProperty(this.basicProperty);
        HashMap newDDMap = new HashMap();
        String reason = null;
        Installment existingInst = null;
        if (!this.demandDetails.isEmpty()) {
            for (EgDemandDetails dd : this.demandDetails) {
                ArrayList<String> existingReasons = new ArrayList<String>();
                reason = dd.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster();
                existingInst = dd.getEgDemandReason().getEgInstallmentMaster();
                if (newDDMap.get(existingInst) == null) {
                    existingReasons = new ArrayList();
                    existingReasons.add(reason);
                    newDDMap.put(existingInst, existingReasons);
                    continue;
                }
                if (newDDMap.get(existingInst) != null) {
                    existingReasons.add(reason);
                    ((List)newDDMap.get(existingInst)).addAll(existingReasons);
                    continue;
                }
                existingReasons = new ArrayList();
                existingReasons.add(reason);
                ((List)newDDMap.get(existingInst)).addAll(existingReasons);
            }
        }
        LinkedHashMap<Installment, Object> newMap = new LinkedHashMap<Installment, Object>();
        LinkedHashMap rsnList = new LinkedHashMap();
        if (!this.demandDetails.isEmpty()) {
            for (EgDemandDetails egDemandDetails : this.demandDetails) {
                HashMap<String, Comparable<BigDecimal>> dtls;
                Object rsns;
                if (newMap.get(egDemandDetails.getEgDemandReason().getEgInstallmentMaster()) == null) {
                    rsns = new LinkedHashMap();
                    dtls = new HashMap<String, Comparable<BigDecimal>>();
                    dtls.put("amount", egDemandDetails.getAmount());
                    dtls.put("collection", egDemandDetails.getAmtCollected());
                    dtls.put("isNew", Boolean.valueOf(false));
                    rsns.put(egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster(), dtls);
                    newMap.put(egDemandDetails.getEgDemandReason().getEgInstallmentMaster(), rsns);
                    continue;
                }
                if (newMap.get(egDemandDetails.getEgDemandReason().getEgInstallmentMaster()) != null && egDemandDetails.getAmount().compareTo(BigDecimal.ZERO) == 0) {
                    HashMap<String, Comparable<BigDecimal>> dtls2 = new HashMap<String, Comparable<BigDecimal>>();
                    dtls2.put("amount", BigDecimal.ZERO);
                    dtls2.put("collection", BigDecimal.ZERO);
                    dtls2.put("isNew", Boolean.valueOf(false));
                    ((Map)newMap.get(egDemandDetails.getEgDemandReason().getEgInstallmentMaster())).put(egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster(), dtls2);
                    continue;
                }
                if (newMap.get(egDemandDetails.getEgDemandReason().getEgInstallmentMaster()) == null || egDemandDetails.getAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                rsns = new LinkedHashMap();
                dtls = new HashMap();
                dtls.put("amount", egDemandDetails.getAmount());
                dtls.put("collection", egDemandDetails.getAmtCollected());
                dtls.put("isNew", Boolean.valueOf(false));
                rsns.put(egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster(), dtls);
                ((Map)newMap.get(egDemandDetails.getEgDemandReason().getEgInstallmentMaster())).putAll(rsns);
            }
            for (String string : this.demandReasonMap.keySet()) {
                for (Installment inst : newDDMap.keySet()) {
                    HashMap<String, Comparable<BigDecimal>> dtls;
                    if (((List)newDDMap.get(inst)).contains(string)) continue;
                    if (newMap.get(inst) == null) {
                        dtls = new HashMap<String, Comparable<BigDecimal>>();
                        dtls.put("amount", BigDecimal.ZERO);
                        dtls.put("collection", BigDecimal.ZERO);
                        dtls.put("isNew", Boolean.valueOf(true));
                        rsnList.put(string, dtls);
                        newMap.put(inst, rsnList);
                        continue;
                    }
                    if (newMap.get(inst) == null) continue;
                    dtls = new HashMap();
                    dtls.put("amount", BigDecimal.ZERO);
                    dtls.put("collection", BigDecimal.ZERO);
                    dtls.put("isNew", Boolean.valueOf(true));
                    rsnList.put(string, dtls);
                    ((Map)newMap.get(inst)).put(string, dtls);
                }
            }
            for (Installment installment : newMap.keySet()) {
                for (String rsn : ((Map)newMap.get(installment)).keySet()) {
                    Map amtMap = (Map)newMap.get(installment);
                    Map dtls = (Map)amtMap.get(rsn);
                    DemandDetail dmdDtl2 = this.createDemandDetailBean(installment, rsn, (BigDecimal)dtls.get("amount"), (BigDecimal)dtls.get("collection"), (Boolean)dtls.get("isNew"), effectiveDate);
                    this.demandDetailBeanList.add(dmdDtl2);
                }
            }
        } else {
            for (Map.Entry entry : this.demandReasonMap.entrySet()) {
                DemandDetail dmdDtl = this.createDemandDetailBean(null, (String)entry.getKey(), null, null, Boolean.valueOf(true), null);
                this.demandDetailBeanList.add(dmdDtl);
            }
        }
        resultPage = RESULT_NEW;
        this.allInstallments.removeAll(this.propertyInstallments);
        this.addDropdownData("allInstallments", this.allInstallments);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exiting from newEditForm");
        }
        return resultPage;
    }

    private DemandDetail createDemandDetailBean(Installment installment, String reasonMaster, BigDecimal amount, BigDecimal amountCollected, Boolean isNew, Date effectiveDate) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into createDemandDetailBean");
            LOGGER.debug((Object)("createDemandDetailBean - installment=" + installment + ", reasonMaster=" + reasonMaster + ", amount=" + amount + ", amountCollected=" + amountCollected));
        }
        DemandDetail demandDetail = new DemandDetail();
        demandDetail.setInstallment(installment);
        demandDetail.setReasonMaster(reasonMaster);
        demandDetail.setActualAmount(amount);
        demandDetail.setActualCollection(amountCollected);
        demandDetail.setIsCollectionEditable(Boolean.valueOf(true));
        demandDetail.setIsNew(isNew);
        demandDetail.setReadOnly(Boolean.valueOf(false));
        if (effectiveDate == null) {
            demandDetail.setReadOnly(Boolean.valueOf(false));
        } else {
            List effectiveInstallment = this.propertyTaxUtil.getInstallmentsListByEffectiveDate(effectiveDate);
            for (Installment inst : effectiveInstallment) {
                if (!inst.equals((Object)demandDetail.getInstallment())) continue;
                demandDetail.setReadOnly(Boolean.valueOf(true));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("createDemandDetailBean - demandDetail= " + demandDetail + "\nExiting from createDemandDetailBean"));
        }
        return demandDetail;
    }

    @SkipValidation
    private void prepareDisplayInfo() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into method prepareDisplayInfo");
        }
        this.dcbDispInfo = new DCBDisplayInfo();
        this.dcbDispInfo.setReasonCategoryCodes(Collections.emptyList());
        ArrayList reasonList = new ArrayList();
        reasonList.addAll(PropertyTaxConstants.DEMAND_REASON_ORDER_MAP.keySet());
        this.dcbDispInfo.setReasonMasterCodes(reasonList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("DCB Display Info : " + this.dcbDispInfo));
            LOGGER.debug((Object)("Number of Demand Reasons : " + (reasonList != null ? Integer.valueOf(reasonList.size()) : BigDecimal.ZERO)));
            LOGGER.debug((Object)"Exit from method prepareDisplayInfo");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ValidationErrorPage(value="editForm")
    @Action(value="/editDemand-update")
    public String update() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info((Object)("Entered into update, basicProperty=" + this.basicProperty));
        }
        List demandDetailsFromDB = this.getPersistenceService().findAllBy(QUERY_NONZERO_DEMAND_DETAILS, new Object[]{this.basicProperty});
        Installment currentInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        TreeMap demandDetails = new TreeMap();
        String queryZeroDemandDetails = "SELECT dd FROM Ptdemand ptd LEFT JOIN ptd.egDemandDetails dd LEFT JOIN ptd.egptProperty p LEFT JOIN  p.basicProperty bp WHERE bp = ? AND bp.active = true AND p.status = 'A'  AND dd.amount = 0";
        List dmdDtlsWithZeroAmt = this.getPersistenceService().findAllBy("SELECT dd FROM Ptdemand ptd LEFT JOIN ptd.egDemandDetails dd LEFT JOIN ptd.egptProperty p LEFT JOIN  p.basicProperty bp WHERE bp = ? AND bp.active = true AND p.status = 'A'  AND dd.amount = 0", new Object[]{this.basicProperty});
        TreeSet<Installment> zeroInstallments = new TreeSet<Installment>();
        BigDecimal totalDmd = BigDecimal.ZERO;
        EgDemandDetails egDemandDtls = null;
        this.demandAudit.setBasicproperty(this.basicProperty.getUpicNo());
        this.demandAudit.setTransaction(EDIT_DEMAND);
        this.demandAudit.setRemarks(this.remarks);
        this.demandAudit.setLastModifiedDate(new Date());
        for (DemandDetail dmdDetail : this.demandDetailBeanList) {
            if (dmdDetail.getIsNew() == null || !dmdDetail.getIsNew().booleanValue() || dmdDetail.getActualAmount() == null) continue;
            EgDemandReason egDmdRsn = this.propertyTaxUtil.getDemandReasonByCodeAndInstallment((String)this.demandReasonMap.get(dmdDetail.getReasonMaster()), dmdDetail.getInstallment());
            for (EgDemandDetails details : dmdDtlsWithZeroAmt) {
                if (details.getEgDemandReason().equals((Object)egDmdRsn)) {
                    zeroInstallments.add(details.getEgDemandReason().getEgInstallmentMaster());
                    details.setAmount(dmdDetail.getActualAmount());
                    details.setAmtCollected(dmdDetail.getActualCollection() == null ? BigDecimal.ZERO : dmdDetail.getActualCollection());
                    egDemandDtls = details;
                    continue;
                }
                egDemandDtls = this.propService.createDemandDetails(dmdDetail.getActualAmount(), dmdDetail.getActualCollection(), egDmdRsn, dmdDetail.getInstallment());
                totalDmd = totalDmd.add(egDemandDtls.getAmount());
            }
            if (dmdDtlsWithZeroAmt.isEmpty()) {
                egDemandDtls = this.propService.createDemandDetails(dmdDetail.getActualAmount(), dmdDetail.getActualCollection(), egDmdRsn, dmdDetail.getInstallment());
                totalDmd = totalDmd.add(egDemandDtls.getAmount());
            }
            this.logAudit(dmdDetail);
            ArrayList<EgDemandDetails> dmdDtl = new ArrayList<EgDemandDetails>();
            if (demandDetails.get(dmdDetail.getInstallment()) == null) {
                dmdDtl.add(egDemandDtls);
                demandDetails.put(dmdDetail.getInstallment(), dmdDtl);
                continue;
            }
            ((List)demandDetails.get(dmdDetail.getInstallment())).add(egDemandDtls);
        }
        block2: for (EgDemandDetails ddFromDB : demandDetailsFromDB) {
            for (Object dmdDetail : this.demandDetailBeanList) {
                void var14_14;
                if (dmdDetail.getIsNew() == null || dmdDetail.getIsNew().booleanValue()) continue;
                Boolean isUpdateAmount = false;
                Boolean bl = false;
                if (dmdDetail.getRevisedAmount() != null && dmdDetail.getInstallment().equals((Object)ddFromDB.getEgDemandReason().getEgInstallmentMaster()) && ddFromDB.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase((String)this.demandReasonMap.get(dmdDetail.getReasonMaster()))) {
                    isUpdateAmount = true;
                }
                if (dmdDetail.getRevisedCollection() != null && ddFromDB.getEgDemand().getEgInstallmentMaster().equals((Object)currentInstallment) && ddFromDB.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase((String)this.demandReasonMap.get(dmdDetail.getReasonMaster()))) {
                    Installment inst = this.installmentDAO.findById(dmdDetail.getInstallment().getId().intValue(), false);
                    if (ddFromDB.getEgDemandReason().getEgInstallmentMaster().equals((Object)inst)) {
                        Boolean bl2 = true;
                    }
                }
                if (isUpdateAmount.booleanValue()) {
                    ddFromDB.setAmount(dmdDetail.getRevisedAmount() != null ? dmdDetail.getRevisedAmount() : BigDecimal.ZERO);
                }
                if (var14_14.booleanValue()) {
                    ddFromDB.setAmtCollected(dmdDetail.getRevisedCollection() != null ? dmdDetail.getRevisedCollection() : BigDecimal.ZERO);
                }
                if (!isUpdateAmount.booleanValue() && !var14_14.booleanValue()) continue;
                ddFromDB.setModifiedDate(new Date());
                this.logAudit((DemandDetail)dmdDetail);
                this.demandDetailsDao.update(ddFromDB);
                continue block2;
            }
        }
        if (this.demandAudit.getDemandAuditDetails() != null && this.demandAudit.getDemandAuditDetails().size() > 0) {
            this.demandAuditService.saveDetails(this.demandAudit);
        }
        List currentInstdemandDetailsFromDB = this.getPersistenceService().findAllBy(queryInstallmentDemandDetails, new Object[]{this.basicProperty, this.propertyTaxCommonUtils.getCurrentInstallment()});
        Map demandDetailsSetByInstallment = this.getEgDemandDetailsSetByInstallment(currentInstdemandDetailsFromDB);
        ArrayList installments = new ArrayList(demandDetailsSetByInstallment.keySet());
        Collections.sort(installments);
        for (Object inst : installments) {
            LinkedHashMap<String, BigDecimal> linkedHashMap = new LinkedHashMap<String, BigDecimal>();
            for (String rsn : PropertyTaxConstants.DEMAND_RSNS_LIST) {
                BigDecimal extraCollAmt;
                EgDemandDetails newDmndDtls = this.propService.getEgDemandDetailsForReason((Set)demandDetailsSetByInstallment.get(inst), rsn);
                if (newDmndDtls == null || newDmndDtls.getAmtCollected() == null || (extraCollAmt = newDmndDtls.getAmtCollected().subtract(newDmndDtls.getAmount())).compareTo(BigDecimal.ZERO) <= 0) continue;
                linkedHashMap.put(newDmndDtls.getEgDemandReason().getEgDemandReasonMaster().getCode(), extraCollAmt);
                newDmndDtls.setAmtCollected(newDmndDtls.getAmtCollected().subtract(extraCollAmt));
                newDmndDtls.setModifiedDate(new Date());
                this.demandDetailsDao.update(newDmndDtls);
            }
            this.propService.getExcessCollAmtMap().put(inst, linkedHashMap);
        }
        LOGGER.info((Object)("Excess Collection - " + this.propService.getExcessCollAmtMap()));
        HashSet demandDetailsToBeSaved = new HashSet();
        for (Map.Entry entry : demandDetails.entrySet()) {
            if (((EgDemandDetails)((List)entry.getValue()).get(0)).getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().equalsIgnoreCase("Cheque Bounce Penalty")) continue;
            demandDetailsToBeSaved.addAll(new HashSet((Collection)entry.getValue()));
        }
        List currPtdemand = this.getPersistenceService().findAllBy(queryInstallmentPTDemand, new Object[]{this.basicProperty, this.propertyTaxCommonUtils.getCurrentInstallment()});
        if (currPtdemand != null && currPtdemand.isEmpty()) {
            Ptdemand ptdemand = new Ptdemand();
            PTDemandCalculations ptDmdCalc = new PTDemandCalculations();
            ptdemand.setEgInstallmentMaster(this.propertyTaxCommonUtils.getCurrentInstallment());
            ptdemand.setEgDemandDetails(demandDetailsToBeSaved);
            ptdemand.setBaseDemand(totalDmd);
            ptdemand.setCreateDate(new Date());
            ptdemand.setModifiedDate(new Date());
            ptdemand.setIsHistory("N");
            ptdemand.setEgptProperty((PropertyImpl)this.basicProperty.getProperty());
            ptDmdCalc.setPtDemand(ptdemand);
            ptdemand.setDmdCalculations(ptDmdCalc);
            this.getPersistenceService().applyAuditing((BaseModel)ptDmdCalc);
            this.basicProperty.getProperty().getPtDemandSet().add(ptdemand);
        } else {
            Ptdemand ptdemand = (Ptdemand)currPtdemand.get(0);
            ptdemand.getBaseDemand().add(totalDmd);
            ptdemand.getEgDemandDetails().addAll(demandDetailsToBeSaved);
            this.getPersistenceService().applyAuditing((BaseModel)ptdemand.getDmdCalculations());
            this.basicProperty.getProperty().getPtDemandSet().add(ptdemand);
        }
        this.propertyImplService.update((Object)this.basicProperty.getProperty());
        LOGGER.info((Object)"Exiting from update");
        return RESULT_ACK;
    }

    public Map<Installment, Set<EgDemandDetails>> getEgDemandDetailsSetByInstallment(List<EgDemandDetails> demandDtls) {
        HashMap<Installment, Set<EgDemandDetails>> newEgDemandDetailsSetByInstallment = new HashMap<Installment, Set<EgDemandDetails>>();
        for (EgDemandDetails dd : demandDtls) {
            if (dd.getAmtCollected() == null) {
                dd.setAmtCollected(BigDecimal.ZERO);
            }
            if (newEgDemandDetailsSetByInstallment.get(dd.getEgDemandReason().getEgInstallmentMaster()) == null) {
                HashSet<EgDemandDetails> ddSet = new HashSet<EgDemandDetails>();
                ddSet.add(dd);
                newEgDemandDetailsSetByInstallment.put(dd.getEgDemandReason().getEgInstallmentMaster(), ddSet);
                continue;
            }
            ((Set)newEgDemandDetailsSetByInstallment.get(dd.getEgDemandReason().getEgInstallmentMaster())).add(dd);
        }
        return newEgDemandDetailsSetByInstallment;
    }

    private void logAudit(DemandDetail dmdDetail) {
        DemandAuditDetails dmdAdtDtls = new DemandAuditDetails();
        dmdAdtDtls.setYear(dmdDetail.getInstallment().toString());
        dmdAdtDtls.setAction(dmdDetail.getIsNew() == true ? "Add" : "Edit");
        dmdAdtDtls.setTaxType(dmdDetail.getReasonMaster());
        dmdAdtDtls.setActualDmd(dmdDetail.getActualAmount() != null ? dmdDetail.getActualAmount() : BigDecimal.ZERO);
        dmdAdtDtls.setModifiedDmd(dmdDetail.getRevisedAmount() != null ? dmdDetail.getRevisedAmount() : BigDecimal.ZERO);
        dmdAdtDtls.setActualColl(dmdDetail.getActualCollection() != null ? dmdDetail.getActualCollection() : BigDecimal.ZERO);
        dmdAdtDtls.setModifiedColl(dmdDetail.getRevisedCollection() != null ? dmdDetail.getRevisedCollection() : BigDecimal.ZERO);
        dmdAdtDtls.setDemandAudit(this.demandAudit);
        this.demandAudit.getDemandAuditDetails().add(dmdAdtDtls);
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public List<EgDemandDetails> getDemandDetails() {
        return this.demandDetails;
    }

    public void setDemandDetails(List<EgDemandDetails> demandDetails) {
        this.demandDetails = demandDetails;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getPropertyAddress() {
        return this.propertyAddress;
    }

    public void setPropertyAddress(String propertyAddress) {
        this.propertyAddress = propertyAddress;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public PropertyTaxUtil getPropertyTaxUtil() {
        return this.propertyTaxUtil;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public PropertyService getPropService() {
        return this.propService;
    }

    public void setPropService(PropertyService propService) {
        this.propService = propService;
    }

    public Map<Installment, Map<String, Boolean>> getCollectionDetails() {
        return this.collectionDetails;
    }

    public void setCollectionDetails(Map<Installment, Map<String, Boolean>> collectionDetails) {
        this.collectionDetails = collectionDetails;
    }

    public List<DemandDetail> getDemandDetailBeanList() {
        return this.demandDetailBeanList;
    }

    public void setDemandDetailBeanList(List<DemandDetail> demandDetailBeanList) {
        this.demandDetailBeanList = demandDetailBeanList;
    }

    public List<Installment> getAllInstallments() {
        return this.allInstallments;
    }

    public void setAllInstallments(List<Installment> allInstallments) {
        this.allInstallments = allInstallments;
    }

    public Map<String, String> getDemandReasonMap() {
        return this.demandReasonMap;
    }

    public void setDemandReasonMap(Map<String, String> demandReasonMap) {
        this.demandReasonMap = demandReasonMap;
    }
}

