/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.create;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Area;
import org.egov.commons.entity.Source;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.persistence.entity.CorrespondenceAddress;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.web.utils.WebUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.portal.entity.Citizen;
import org.egov.ptis.actions.common.CommonServices;
import org.egov.ptis.actions.common.PropertyTaxBaseAction;
import org.egov.ptis.client.service.calculator.APTaxCalculator;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.document.DocumentTypeDetails;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.Apartment;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.BuiltUpProperty;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.FloorType;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyDepartment;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyOccupation;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyStatus;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.RoofType;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.egov.ptis.domain.entity.property.TaxExemptionReason;
import org.egov.ptis.domain.entity.property.VacantProperty;
import org.egov.ptis.domain.entity.property.WallType;
import org.egov.ptis.domain.entity.property.WoodType;
import org.egov.ptis.domain.entity.property.vacantland.LayoutApprovalAuthority;
import org.egov.ptis.domain.entity.property.vacantland.VacantLandPlotArea;
import org.egov.ptis.domain.repository.PropertyDepartmentRepository;
import org.egov.ptis.domain.repository.master.vacantland.LayoutApprovalAuthorityRepository;
import org.egov.ptis.domain.repository.master.vacantland.VacantLandPlotAreaRepository;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Namespace(value="/create")
@ResultPath(value="/WEB-INF/jsp/")
@Results(value={@Result(name={"new"}, location="create/createProperty-new.jsp"), @Result(name={"dataEntry"}, location="create/createProperty-dataEntry.jsp"), @Result(name={"ack"}, location="create/createProperty-ack.jsp"), @Result(name={"dataEntry-ack"}, location="create/createProperty-dataEntryAck.jsp"), @Result(name={"view"}, location="create/createProperty-view.jsp"), @Result(name={"error"}, location="common/meeseva-errorPage.jsp"), @Result(name={"printAck"}, location="create/createProperty-printAck.jsp"), @Result(name={"meesevaAck"}, location="common/meesevaAck.jsp"), @Result(name={"editDataEntry"}, location="create/createProperty-editDataEntry.jsp")})
public class CreatePropertyAction
extends PropertyTaxBaseAction {
    private static final long serialVersionUID = -2329719786287615451L;
    private static final String RESULT_ACK = "ack";
    private static final String RESULT_NEW = "new";
    private static final String RESULT_ERROR = "error";
    private static final String RESULT_VIEW = "view";
    private static final String MSG_REJECT_SUCCESS = " Property Rejected Successfully ";
    private static final String CREATE = "create";
    private static final String RESULT_DATAENTRY = "dataEntry";
    public static final String PRINT_ACK = "printAck";
    public static final String MEESEVA_RESULT_ACK = "meesevaAck";
    protected static final String EDIT_DATA_ENTRY = "editDataEntry";
    private static final String MEESEVA_SERVICE_CODE_NEWPROPERTY = "PT01";
    private static final String MEESEVA_SERVICE_CODE_SUBDIVISION = "PT04";
    private static final String PROPTYPEMASTER_QUERY = "from PropertyTypeMaster ptm where ptm.id = ?";
    private static final String MEESEVA_SERVICE_CODE = "meesevaServicecode";
    private static final String MUTATION_MASTER_QUERY = "from PropertyMutationMaster pmm where pmm.type=? AND pmm.id=?";
    private static final String UNIT_RATE_ERROR = "unitrate.error";
    private static final String USAGE_LIST = "UsageList";
    private static final String EXEMPTED_REASON_LIST = "taxExemptedList";
    private static final String NOTEXISTS_POSITION = "notexists.position";
    private transient Logger logger = Logger.getLogger(this.getClass());
    private PropertyImpl property = new PropertyImpl();
    @Autowired
    transient PropertyPersistenceService basicPropertyService;
    @Autowired
    transient APTaxCalculator taxCalculator;
    private Long zoneId;
    private Long wardId;
    private Long blockId;
    private Long streetId;
    private Long locality;
    private Long floorTypeId;
    private Long roofTypeId;
    private Long wallTypeId;
    private Long woodTypeId;
    private Long ownershipType;
    private Long electionWardId;
    private String wardName;
    private String zoneName;
    private String blockName;
    private String houseNumber;
    private String addressStr;
    private String pinCode;
    private String areaOfPlot;
    private String dateOfCompletion;
    private String applicationNo;
    private String corrAddress1;
    private String corrAddress2;
    private String corrPinCode;
    private String upicNo;
    private String taxExemptionId;
    private String parentIndex;
    private String amenities;
    private String[] floorNoStr = new String[100];
    private String propTypeId;
    private String propUsageId;
    private String propOccId;
    private String propertyCategory;
    private String docNumber;
    private String nonResPlotArea;
    private String applicationNoMessage;
    private String assessmentNoMessage;
    private String propertyInitiatedBy;
    private String mode = "create";
    private String northBoundary;
    private String southBoundary;
    private String eastBoundary;
    private String westBoundary;
    private Long mutationId;
    private Map<String, String> propTypeCategoryMap;
    private SortedMap<Integer, String> floorNoMap;
    private Map<String, String> deviationPercentageMap;
    private Map<String, String> guardianRelationMap;
    private List<DocumentType> documentTypes = new ArrayList();
    private String reportId;
    private boolean approved;
    private boolean floorDetailsEntered;
    private transient BasicProperty basicProp;
    @Autowired
    private transient PropertyService propService;
    private PropertyTypeMaster propTypeMstr;
    @Autowired
    private transient PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    private PropertyImpl newProperty = new PropertyImpl();
    private Address ownerAddress = new CorrespondenceAddress();
    Date propCompletionDate = null;
    @Autowired
    private transient BoundaryService boundaryService;
    @Autowired
    private transient SecurityUtils securityUtils;
    @Autowired
    private transient ReportViewerUtil reportViewerUtil;
    private Boolean loggedUserIsMeesevaUser = Boolean.FALSE;
    private Boolean isCitizenPortalUser = Boolean.FALSE;
    private Boolean isDataEntryOperator = Boolean.FALSE;
    private String indexNumber;
    private String modifyRsn;
    private Boolean showTaxCalcBtn = Boolean.FALSE;
    private Long propertyDepartmentId;
    private List<PropertyDepartment> propertyDepartmentList = new ArrayList();
    private List<VacantLandPlotArea> vacantLandPlotAreaList = new ArrayList();
    private List<LayoutApprovalAuthority> layoutApprovalAuthorityList = new ArrayList();
    private Long vacantLandPlotAreaId;
    private Long layoutApprovalAuthorityId;
    private boolean allowEditDocument = Boolean.FALSE;
    private List<DocumentType> assessmentDocumentTypes = new ArrayList();
    private List<String> assessmentDocumentNames;
    private transient DocumentTypeDetails documentTypeDetails = new DocumentTypeDetails();
    private boolean eligibleInitiator = Boolean.TRUE;
    private boolean dataEntry = Boolean.FALSE;
    private String applicationSource;
    @Autowired
    private transient PropertyDepartmentRepository propertyDepartmentRepository;
    @Autowired
    private transient VacantLandPlotAreaRepository vacantLandPlotAreaRepository;
    @Autowired
    private transient LayoutApprovalAuthorityRepository layoutApprovalAuthorityRepository;
    @PersistenceContext
    private transient EntityManager entityManager;

    public CreatePropertyAction() {
        this.property.setPropertyDetail((PropertyDetail)new BuiltUpProperty());
        this.property.setBasicProperty((BasicProperty)new BasicPropertyImpl());
        this.addRelatedEntity("property", PropertyImpl.class);
        this.addRelatedEntity("property.propertyDetail.propertyTypeMaster", PropertyTypeMaster.class);
        this.addRelatedEntity("property.propertyDetail.floorDetails.unitType", PropertyTypeMaster.class);
        this.addRelatedEntity("property.propertyDetail.floorDetails.propertyUsage", PropertyUsage.class);
        this.addRelatedEntity("property.propertyDetail.floorDetails.propertyOccupation", PropertyOccupation.class);
        this.addRelatedEntity("property.propertyDetail.floorDetails.structureClassification", StructureClassification.class);
        this.addRelatedEntity("property.basicProperty.propertyOwnerInfo.owner", Citizen.class);
        this.addRelatedEntity("propertyDetail.apartment", Apartment.class);
        this.addRelatedEntity("property.propertyDetail.floorType", FloorType.class);
        this.addRelatedEntity("property.propertyDetail.roofType", RoofType.class);
        this.addRelatedEntity("property.propertyDetail.wallType", WallType.class);
        this.addRelatedEntity("property.propertyDetail.woodType", WoodType.class);
        this.addRelatedEntity("property.taxExemptedReason", TaxExemptionReason.class);
        this.addRelatedEntity("property.propertyDetail.propertyDepartment", PropertyDepartment.class);
    }

    public StateAware getModel() {
        return this.property;
    }

    @SkipValidation
    @Action(value="/createProperty-newForm")
    public String newForm() {
        if (this.loggedUserIsMeesevaUser.booleanValue()) {
            HttpServletRequest request = ServletActionContext.getRequest();
            if (request.getParameter("applicationNo") == null || request.getParameter(MEESEVA_SERVICE_CODE) == null) {
                this.addActionMessage(this.getText("MEESEVA.005"));
                return RESULT_ERROR;
            }
            if (request.getParameter(MEESEVA_SERVICE_CODE).equalsIgnoreCase(MEESEVA_SERVICE_CODE_NEWPROPERTY)) {
                this.getMutationListByCode("NEW");
            } else if (request.getParameter(MEESEVA_SERVICE_CODE).equalsIgnoreCase(MEESEVA_SERVICE_CODE_SUBDIVISION)) {
                this.getMutationListByCode("BIFUR");
            }
            this.property.setMeesevaApplicationNumber(request.getParameter("applicationNo"));
            this.property.setMeesevaServiceCode(request.getParameter(MEESEVA_SERVICE_CODE));
        }
        this.showCalculateTaxButton();
        return RESULT_NEW;
    }

    private void showCalculateTaxButton() {
        if (org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.userDesignationList, (CharSequence)"UD Revenue Inspector") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.userDesignationList, (CharSequence)"Junior Assistant") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.userDesignationList, (CharSequence)"Senior Assistant") || "ONLINE".equalsIgnoreCase(this.applicationSource)) {
            this.showTaxCalcBtn = Boolean.TRUE;
        }
    }

    private void getMutationListByCode(String code) {
        List mutationList = this.getPersistenceService().findAllBy("from PropertyMutationMaster pmm where pmm.type=? and pmm.code=?", new Object[]{"CREATE", code});
        this.addDropdownData("MutationList", mutationList);
    }

    @Action(value="/createProperty-create")
    public String create() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("create: Property creation started, Property: " + this.property + ", ZoneId: " + this.zoneId + ", Wardid: " + this.wardId + ", BlockId: " + this.blockId + ", AreaOfPlot: " + this.areaOfPlot + ", DateOfCompletion: " + this.dateOfCompletion + ", PropTypeId: " + this.propTypeId + ", PropUsageId: " + this.propUsageId + ", PropOccId: " + this.propOccId));
        }
        long startTimeMillis = System.currentTimeMillis();
        if (this.loggedUserIsMeesevaUser.booleanValue() && this.property.getMeesevaApplicationNumber() != null) {
            this.property.setApplicationNo(this.property.getMeesevaApplicationNumber());
            this.property.setSource("MEESEVA");
        }
        if (this.isCitizenPortalUser.booleanValue()) {
            this.property.setSource(Source.CITIZENPORTAL.toString());
        }
        if ("ONLINE".equalsIgnoreCase(this.applicationSource) && ApplicationThreadLocals.getUserId() == null) {
            ApplicationThreadLocals.setUserId((Long)this.securityUtils.getCurrentUser().getId());
        }
        if (this.property.getPropertyDetail().isAppurtenantLandChecked().booleanValue()) {
            this.propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find(PROPTYPEMASTER_QUERY, new Object[]{Long.valueOf(this.propTypeId)});
            if (this.propTypeMstr.getCode().equals("VAC_LAND")) {
                this.property.getPropertyDetail().setPropertyType("VacantProperty");
            } else {
                this.property.getPropertyDetail().setPropertyType("BuiltUpProperty");
            }
            return this.createAppurTenantProperties(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
        }
        BasicProperty basicProperty = this.createBasicProp(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
        try {
            this.addDemandAndCompleteDate(PropertyTaxConstants.STATUS_DEMAND_INACTIVE, basicProperty, basicProperty.getPropertyMutationMaster());
        }
        catch (TaxCalculatorExeption e) {
            basicProperty.setPropertyOwnerInfoProxy(basicProperty.getPropertyOwnerInfo());
            this.addActionError(this.getText(UNIT_RATE_ERROR));
            this.logger.error((Object)"create : There are no Unit rates defined for chosen combinations", (Throwable)e);
            return RESULT_NEW;
        }
        basicProperty.setUnderWorkflow(Boolean.TRUE.booleanValue());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("create: BasicProperty after creation: " + basicProperty));
        }
        basicProperty.setIsTaxXMLMigrated(PropertyTaxConstants.STATUS_YES_XML_MIGRATION);
        this.transitionWorkFlow(this.property);
        this.basicPropertyService.applyAuditing((AbstractAuditable)this.property.getState());
        if (this.loggedUserIsMeesevaUser.booleanValue() && this.property.getMeesevaApplicationNumber() != null) {
            basicProperty.setSource(PropertyTaxConstants.SOURCEOFDATA_MEESEWA);
        }
        this.propService.updateIndexes((StateAware)this.property, "New_Assessment");
        this.propService.processAndStoreDocument(this.property.getAssessmentDocuments());
        if (!this.loggedUserIsMeesevaUser.booleanValue()) {
            this.basicPropertyService.persist((Object)basicProperty);
        } else {
            HashMap<String, String> meesevaParams = new HashMap<String, String>();
            meesevaParams.put("ADMISSIONFEE", "0");
            meesevaParams.put("APPLICATIONNUMBER", this.property.getMeesevaApplicationNumber());
            this.basicPropertyService.createBasicProperty(basicProperty, meesevaParams);
        }
        if (this.isCitizenPortalUser.booleanValue()) {
            this.propService.pushPortalMessage(this.property, "New_Assessment");
        }
        this.buildEmailandSms(this.property, "New_Assessment");
        this.setBasicProp(basicProperty);
        this.propService.saveDocumentTypeDetails(basicProperty, this.getDocumentTypeDetails());
        this.setAckMessage("Property Data Saved Successfully in the System and forwarded to : ");
        this.setApplicationNoMessage(" with application number : ");
        long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("create: Property created successfully in system; Time taken(ms) = " + elapsedTimeMillis));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"create: Property creation ended");
        }
        if (!this.loggedUserIsMeesevaUser.booleanValue()) {
            return RESULT_ACK;
        }
        return MEESEVA_RESULT_ACK;
    }

    private String createAppurTenantProperties(Character status) {
        BasicProperty nonVacantBasicProperty = this.createBasicProp(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
        this.updatePropertyStatusValuesRemarks(nonVacantBasicProperty);
        PropertyImpl nonVacantProperty = null;
        try {
            nonVacantProperty = this.createNonVacantProperty(status, nonVacantBasicProperty);
            BasicProperty vacantBasicProperty = this.createBasicProp(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
            this.updatePropertyStatusValuesRefProperty(nonVacantBasicProperty, vacantBasicProperty);
            this.createVacantProperty(status, nonVacantProperty, vacantBasicProperty);
        }
        catch (TaxCalculatorExeption e) {
            nonVacantBasicProperty.setPropertyOwnerInfoProxy(nonVacantBasicProperty.getPropertyOwnerInfo());
            this.addActionError(this.getText(UNIT_RATE_ERROR));
            this.logger.error((Object)"create : There are no Unit rates defined for chosen combinations", (Throwable)e);
            return RESULT_NEW;
        }
        this.setBasicProp(nonVacantBasicProperty);
        if (this.isCitizenPortalUser.booleanValue()) {
            nonVacantProperty.setSource(Source.CITIZENPORTAL.toString());
            this.propService.pushPortalMessage(nonVacantProperty, "New_Assessment");
        }
        this.setAckMessage("Property Created Successfully in the System and Forwarded to : ");
        this.setAssessmentNoMessage(" for Digital Signature with assessment number : ");
        this.property = nonVacantProperty;
        if (!this.loggedUserIsMeesevaUser.booleanValue()) {
            return RESULT_ACK;
        }
        return MEESEVA_RESULT_ACK;
    }

    private PropertyImpl createNonVacantProperty(Character status, BasicProperty nonVacantBasicProperty) throws TaxCalculatorExeption {
        PropertyImpl nonVacantProperty = this.createAppurTenantProperty(status, nonVacantBasicProperty, Boolean.TRUE);
        this.persistAndMessage(nonVacantBasicProperty, nonVacantProperty);
        return nonVacantProperty;
    }

    private void createVacantProperty(Character status, PropertyImpl nonVacantProperty, BasicProperty vacantBasicProperty) throws TaxCalculatorExeption {
        PropertyImpl vacantProperty = this.createAppurTenantProperty(status, vacantBasicProperty, Boolean.FALSE);
        vacantProperty.setPropertyDetail((PropertyDetail)this.changePropertyDetail(vacantProperty));
        vacantProperty.getPropertyDetail().setCategoryType(this.getCategoryByNonVacantPropertyType(nonVacantProperty));
        vacantProperty.getPropertyDetail().setAppurtenantLandChecked(null);
        vacantBasicProperty.getAddress().setHouseNoBldgApt(null);
        this.persistAndMessage(vacantBasicProperty, vacantProperty);
    }

    private void updatePropertyStatusValuesRefProperty(BasicProperty nonVacantBasicProperty, BasicProperty vacantBasicProperty) {
        PropertyStatusValues propStatusVal = this.updatePropertyStatusValuesRemarks(vacantBasicProperty);
        propStatusVal.setReferenceBasicProperty(nonVacantBasicProperty);
    }

    private PropertyStatusValues updatePropertyStatusValuesRemarks(BasicProperty basicProperty) {
        PropertyStatusValues propStatusVal = (PropertyStatusValues)basicProperty.getPropertyStatusValuesSet().iterator().next();
        propStatusVal.setRemarks("AppurTenantProperty");
        return propStatusVal;
    }

    private String getCategoryByNonVacantPropertyType(PropertyImpl nonVacantProperty) {
        String propertyType = nonVacantProperty.getPropertyDetail().getPropertyTypeMaster().getCode();
        return "PRIVATE".equals(propertyType) || "VAC_LAND".equals(propertyType) ? "VACANTLAND" : ("STATE_GOVT".equals(propertyType) ? "STATE_GOVT" : "CENTRAL_GOVT");
    }

    private void persistAndMessage(BasicProperty basicProperty, PropertyImpl property) {
        if (!this.loggedUserIsMeesevaUser.booleanValue()) {
            this.basicPropertyService.persist((Object)basicProperty);
        } else {
            HashMap<String, String> meesevaParams = new HashMap<String, String>();
            meesevaParams.put("ADMISSIONFEE", "0");
            meesevaParams.put("APPLICATIONNUMBER", property.getMeesevaApplicationNumber());
            this.basicPropertyService.createBasicProperty(basicProperty, meesevaParams);
        }
        this.buildEmailandSms(property, "New_Assessment");
        DocumentTypeDetails docTypeDetails = this.cloneDocumentTypeDetails();
        this.propService.saveDocumentTypeDetails(basicProperty, docTypeDetails);
    }

    private DocumentTypeDetails cloneDocumentTypeDetails() {
        DocumentTypeDetails docTypeDetails = new DocumentTypeDetails();
        docTypeDetails.setCourtName(this.documentTypeDetails.getCourtName());
        docTypeDetails.setDocumentNo(this.documentTypeDetails.getDocumentNo());
        docTypeDetails.setDocumentDate(this.documentTypeDetails.getDocumentDate());
        docTypeDetails.setDocumentName(this.documentTypeDetails.getDocumentName());
        docTypeDetails.setProceedingNo(this.documentTypeDetails.getProceedingNo());
        docTypeDetails.setProceedingDate(this.documentTypeDetails.getProceedingDate());
        docTypeDetails.setSigned(this.documentTypeDetails.isSigned());
        return docTypeDetails;
    }

    private PropertyImpl createAppurTenantProperty(Character status, BasicProperty basicProperty, Boolean nonVacant) throws TaxCalculatorExeption {
        PropertyImpl clonedProp = (PropertyImpl)this.property.createPropertyclone();
        if (nonVacant.booleanValue()) {
            List flrDtlsSet = this.cloneFloorDetails();
            clonedProp.getPropertyDetail().setFloorDetailsProxy(flrDtlsSet);
        }
        clonedProp.setBasicProperty(basicProperty);
        clonedProp.setPropertyModifyReason("CREATE");
        this.taxExemptionId = this.taxExemptionId == null || this.taxExemptionId.isEmpty() ? "-1" : this.taxExemptionId;
        clonedProp = this.propService.createProperty(clonedProp, this.getAreaOfPlot(), basicProperty.getPropertyMutationMaster().getCode(), this.propTypeId, this.propUsageId, this.propOccId, status, this.getDocNumber(), this.getNonResPlotArea(), this.getFloorTypeId(), this.getRoofTypeId(), this.getWallTypeId(), this.getWoodTypeId(), Long.valueOf(this.taxExemptionId), this.getPropertyDepartmentId(), this.getVacantLandPlotAreaId(), this.getLayoutApprovalAuthorityId(), nonVacant);
        clonedProp.setStatus(status);
        this.propCompletionDate = !clonedProp.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND") ? this.propService.getLowestDtOfCompFloorWise(clonedProp.getPropertyDetail().getFloorDetails()) : clonedProp.getPropertyDetail().getDateOfCompletion();
        basicProperty.setPropOccupationDate(this.propCompletionDate);
        if (this.propTypeMstr != null && this.propTypeMstr.getCode().equals("VAC_LAND")) {
            clonedProp.setPropertyDetail((PropertyDetail)this.changePropertyDetail(clonedProp));
        }
        basicProperty.addProperty((Property)clonedProp);
        if (basicProperty.getSource() == PropertyTaxConstants.SOURCEOFDATA_APPLICATION) {
            if (!clonedProp.getDocuments().isEmpty()) {
                this.propService.processAndStoreDocument(clonedProp.getDocuments());
            }
            this.propService.createDemand(clonedProp, this.propCompletionDate);
        }
        basicProperty.setUnderWorkflow(Boolean.TRUE.booleanValue());
        basicProperty.setIsTaxXMLMigrated(PropertyTaxConstants.STATUS_YES_XML_MIGRATION);
        this.transitionWorkFlow(clonedProp);
        this.basicPropertyService.applyAuditing((AbstractAuditable)clonedProp.getState());
        if (this.loggedUserIsMeesevaUser.booleanValue() && clonedProp.getMeesevaApplicationNumber() != null) {
            basicProperty.setSource(PropertyTaxConstants.SOURCEOFDATA_MEESEWA);
        }
        this.propService.updateIndexes((StateAware)clonedProp, "New_Assessment");
        this.propService.processAndStoreDocument(clonedProp.getAssessmentDocuments());
        return clonedProp;
    }

    private List<Floor> cloneFloorDetails() {
        ArrayList<Floor> flrDtlsSet = new ArrayList<Floor>();
        for (Floor flr : this.property.getPropertyDetail().getFloorDetailsProxy()) {
            Floor floor = new Floor(flr.getConstructionTypeSet(), flr.getStructureClassification(), flr.getPropertyUsage(), flr.getPropertyOccupation(), flr.getFloorNo(), flr.getDepreciationMaster(), flr.getBuiltUpArea(), flr.getFloorArea(), flr.getWaterMeter(), flr.getElectricMeter(), null, null, flr.getRentPerMonth(), flr.getManualAlv(), flr.getUnitType(), flr.getUnitTypeCategory(), flr.getWaterRate(), flr.getAlv(), flr.getOccupancyDate(), flr.getOccupantName(), flr.getUnstructuredLand(), flr.getFloorDmdCalc(), flr.getFirmName(), flr.getBuildingPermissionNo(), flr.getBuildingPermissionDate(), flr.getBuildingPlanPlinthArea(), flr.getFloorUid(), flr.getConstructionDate());
            flrDtlsSet.add(floor);
        }
        return flrDtlsSet;
    }

    private void populateFormData() {
        PropertyDetail propertyDetail = this.property.getPropertyDetail();
        if (this.property.getTaxExemptedReason() != null) {
            this.taxExemptionId = this.property.getTaxExemptedReason().getId().toString();
        }
        if (propertyDetail != null) {
            if (!propertyDetail.getFloorDetails().isEmpty()) {
                this.setFloorDetails((Property)this.property);
            }
            this.setPropTypeId(propertyDetail.getPropertyTypeMaster().getId().toString());
            if (this.propTypeId != null && !this.propTypeId.trim().isEmpty() && !"-1".equals(this.propTypeId)) {
                this.propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find(PROPTYPEMASTER_QUERY, new Object[]{Long.valueOf(this.propTypeId)});
                if (this.propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
                    this.setPropTypeCategoryMap((Map)PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY);
                } else {
                    this.setPropTypeCategoryMap((Map)PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY);
                }
            }
            if (!propertyDetail.getPropertyType().equals("VacantProperty")) {
                propertyDetail.setCategoryType(propertyDetail.getCategoryType());
                if (this.property.getPropertyDetail().getFloorType() != null) {
                    this.floorTypeId = this.property.getPropertyDetail().getFloorType().getId();
                }
                if (this.property.getPropertyDetail().getRoofType() != null) {
                    this.roofTypeId = this.property.getPropertyDetail().getRoofType().getId();
                }
                if (this.property.getPropertyDetail().getWallType() != null) {
                    this.wallTypeId = this.property.getPropertyDetail().getWallType().getId();
                }
                if (this.property.getPropertyDetail().getWoodType() != null) {
                    this.woodTypeId = this.property.getPropertyDetail().getWoodType().getId();
                }
                if (this.property.getPropertyDetail().getSitalArea() != null) {
                    this.setAreaOfPlot(this.property.getPropertyDetail().getSitalArea().getArea().toString());
                }
            }
            if (this.propTypeId != null && !this.propTypeId.trim().isEmpty() && !"-1".equals(this.propTypeId)) {
                this.propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find(PROPTYPEMASTER_QUERY, new Object[]{Long.valueOf(this.propTypeId)});
                this.setPropertyDepartmentId(this.property.getPropertyDetail().getPropertyDepartment() != null ? this.property.getPropertyDetail().getPropertyDepartment().getId() : null);
                if (this.propTypeMstr.getCode().equalsIgnoreCase("STATE_GOVT")) {
                    this.setPropertyDepartmentList(this.propertyDepartmentRepository.getAllStateDepartments());
                } else if (this.propTypeMstr.getCode().startsWith("CENTRAL_GOVT")) {
                    this.setPropertyDepartmentList(this.propertyDepartmentRepository.getAllCentralDepartments());
                } else if (this.propTypeMstr.getCode().equals("PRIVATE")) {
                    this.setPropertyDepartmentList(this.propertyDepartmentRepository.getAllPrivateDepartments());
                }
            }
            if (this.property.getPropertyDetail().getVacantLandPlotArea() != null) {
                this.vacantLandPlotAreaId = this.property.getPropertyDetail().getVacantLandPlotArea().getId();
            }
            if (this.property.getPropertyDetail().getLayoutApprovalAuthority() != null) {
                this.layoutApprovalAuthorityId = this.property.getPropertyDetail().getLayoutApprovalAuthority().getId();
            }
        }
        if (this.basicProp != null) {
            this.basicProp.setPropertyOwnerInfoProxy(this.basicProp.getPropertyOwnerInfo());
            this.setMutationId(this.basicProp.getPropertyMutationMaster().getId());
            PropertyStatusValues statusValues = (PropertyStatusValues)this.getPersistenceService().find("From PropertyStatusValues where basicProperty.id = ?", new Object[]{this.basicProp.getId()});
            if (null != statusValues && null != statusValues.getReferenceBasicProperty()) {
                this.setParentIndex(statusValues.getReferenceBasicProperty().getUpicNo());
            }
            if (null != this.basicProp.getAddress()) {
                this.setHouseNumber(this.basicProp.getAddress().getHouseNoBldgApt());
                this.setPinCode(this.basicProp.getAddress().getPinCode());
            }
            for (PropertyOwnerInfo ownerInfo : this.basicProp.getPropertyOwnerInfo()) {
                for (Address userAddress : ownerInfo.getOwner().getAddress()) {
                    if (null == userAddress) continue;
                    String corrAddress = userAddress.getHouseNoBldgApt() + "," + userAddress.getAreaLocalitySector();
                    this.setCorrAddress1(corrAddress);
                    this.setCorrAddress2(userAddress.getStreetRoadLine());
                    this.setCorrPinCode(userAddress.getPinCode());
                }
            }
            if (null != this.basicProp.getPropertyID()) {
                PropertyID propBoundary = this.basicProp.getPropertyID();
                this.setNorthBoundary(propBoundary.getNorthBoundary());
                this.setSouthBoundary(propBoundary.getSouthBoundary());
                this.setEastBoundary(propBoundary.getEastBoundary());
                this.setWestBoundary(propBoundary.getWestBoundary());
                if (null != propBoundary.getLocality().getId()) {
                    this.setLocality(this.boundaryService.getBoundaryById(propBoundary.getLocality().getId()).getId());
                }
                if (null != propBoundary.getElectionBoundary() && null != propBoundary.getElectionBoundary().getId()) {
                    this.setElectionWardId(this.boundaryService.getBoundaryById(propBoundary.getElectionBoundary().getId()).getId());
                }
                if (null != propBoundary.getZone().getId()) {
                    Boundary zone = propBoundary.getZone();
                    this.setZoneId(this.boundaryService.getBoundaryById(zone.getId()).getId());
                    this.setZoneName(zone.getName());
                }
                if (null != propBoundary.getWard().getId()) {
                    Boundary ward = propBoundary.getWard();
                    this.setWardId(this.boundaryService.getBoundaryById(ward.getId()).getId());
                    this.setWardName(ward.getName());
                }
                if (null != propBoundary.getArea().getId()) {
                    Boundary area = propBoundary.getArea();
                    this.setBlockId(this.boundaryService.getBoundaryById(area.getId()).getId());
                    this.setBlockName(area.getName());
                }
            }
            try {
                Query query = this.entityManager.createNamedQuery("DOCUMENT_TYPE_DETAILS_BY_ID");
                query.setParameter(1, (Object)this.basicProp.getId());
                this.setDocumentTypeDetails((DocumentTypeDetails)query.getSingleResult());
            }
            catch (Exception e) {
                this.logger.error((Object)("No Document type details present for Basicproperty " + e));
            }
        }
    }

    @SkipValidation
    @Action(value="/createProperty-view")
    public String view() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into view, BasicProperty: " + this.basicProp + ", Property: " + this.property + ", UserDesgn: " + this.userDesgn));
        }
        String currState = this.property.getState().getValue();
        this.populateFormData();
        if (!this.isCitizenPortalUser.booleanValue() && (currState.endsWith("Rejected") || this.property.getState().getNextAction() != null && this.property.getState().getNextAction().equalsIgnoreCase("UD Revenue Inspector Approval Pending") || currState.endsWith("NEW"))) {
            this.showCalculateTaxButton();
            this.mode = "edit";
            this.setAllowEditDocument(Boolean.TRUE.booleanValue());
            return RESULT_NEW;
        }
        this.mode = RESULT_VIEW;
        for (PropertyOwnerInfo ownerInfo : this.basicProp.getPropertyOwnerInfo()) {
            for (Address userAddress : ownerInfo.getOwner().getAddress()) {
                if (null == userAddress) continue;
                this.setCorrAddress1(userAddress.toString());
            }
        }
        this.setDocNumber(this.property.getDocNumber());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Amenities: " + this.amenities + "NoOfFloors: " + (this.getFloorDetails() != null ? Integer.valueOf(this.getFloorDetails().size()) : "Floor list is NULL") + " Exiting from view"));
        }
        return RESULT_VIEW;
    }

    @SkipValidation
    @Action(value="/createProperty-editDataEntryForm")
    public String editDataEntryForm() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into editDataEntryForm, BasicProperty: " + this.basicProp + ", Property: " + this.property + ", userDesgn: " + this.userDesgn));
        }
        this.upicNo = this.indexNumber;
        this.mode = "edit";
        this.setDataEntry(Boolean.TRUE.booleanValue());
        this.populateFormData();
        return EDIT_DATA_ENTRY;
    }

    @SkipValidation
    @Action(value="/createProperty-forward")
    public String forward() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into forward, BasicProperty: " + this.basicProp + ", Property: " + this.property + ", userDesgn: " + this.userDesgn));
        }
        String loggedInUserDesignation = "";
        if (this.property.getState() != null) {
            List loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(this.property.getCurrentState().getOwnerPosition().getId(), this.securityUtils.getCurrentUser().getId(), new Date());
            loggedInUserDesignation = !loggedInUserAssign.isEmpty() ? ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName() : null;
        }
        Assignment wfInitiator = this.getWorkflowInitiator(loggedInUserDesignation);
        if ("Reject".equalsIgnoreCase(this.workFlowAction) && wfInitiator == null) {
            if (this.propertyTaxCommonUtils.isRoOrCommissioner(loggedInUserDesignation)) {
                this.addActionError(this.getText("reject.error.initiator.inactive", Arrays.asList("UD Revenue Inspector")));
            } else {
                this.addActionError(this.getText("reject.error.initiator.inactive", Arrays.asList("Junior Assistant/Senior Assistant")));
            }
            return this.mode.equalsIgnoreCase("edit") ? RESULT_NEW : RESULT_VIEW;
        }
        if (this.mode.equalsIgnoreCase("edit")) {
            this.validate();
            if (this.hasErrors() && (org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.userDesignationList, (CharSequence)"UD Revenue Inspector") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.userDesignationList, (CharSequence)"Junior Assistant") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.userDesignationList, (CharSequence)"Senior Assistant"))) {
                this.showTaxCalcBtn = Boolean.TRUE;
                this.setAllowEditDocument(Boolean.TRUE.booleanValue());
                return RESULT_NEW;
            }
            if (this.hasErrors()) {
                return RESULT_NEW;
            }
            this.updatePropertyDetails();
            try {
                this.propService.createDemand(this.property, this.basicProp.getPropOccupationDate());
            }
            catch (TaxCalculatorExeption e) {
                this.addActionError(this.getText(UNIT_RATE_ERROR));
                this.logger.error((Object)"forward : There are no Unit rates defined for chosen combinations", (Throwable)e);
                return RESULT_NEW;
            }
        } else {
            this.validateApproverDetails();
            if (this.hasErrors()) {
                return RESULT_VIEW;
            }
        }
        if (!"Reject".equalsIgnoreCase(this.workFlowAction)) {
            this.transitionWorkFlow(this.property);
        }
        if ("Approve".equalsIgnoreCase(this.workFlowAction)) {
            return this.approve();
        }
        if ("Reject".equalsIgnoreCase(this.workFlowAction)) {
            this.transitionWorkFlow(this.property);
            return this.reject();
        }
        this.basicProp.setUnderWorkflow(true);
        this.basicPropertyService.applyAuditing((AbstractAuditable)this.property.getState());
        this.basicProp.addProperty((Property)this.property);
        this.propService.updateIndexes((StateAware)this.property, "New_Assessment");
        if (this.property.getSource().equalsIgnoreCase(Source.CITIZENPORTAL.toString())) {
            this.propService.updatePortalMessage(this.property, "New_Assessment");
        }
        this.basicPropertyService.persist((Object)this.basicProp);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("forward: Property forward started " + this.property));
        }
        long startTimeMillis = System.currentTimeMillis();
        this.setDocNumber(this.getDocNumber());
        this.setApplicationNoMessage(" with application number : ");
        long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("forward: Time taken(ms) = " + elapsedTimeMillis));
            this.logger.debug((Object)"forward: Property forward ended");
        }
        return RESULT_ACK;
    }

    private Assignment getWorkflowInitiator(String loggedInUserDesignation) {
        Assignment wfInitiator = this.propertyTaxCommonUtils.isRoOrCommissioner(loggedInUserDesignation) ? this.propService.getUserOnRejection((StateAware)this.property) : this.propService.getWorkflowInitiator(this.property);
        return wfInitiator;
    }

    public void updatePropertyDetails() {
        this.updatePropertyId(this.basicProp);
        Character status = PropertyTaxConstants.STATUS_WORKFLOW;
        this.updatePropAddress(this.basicProp);
        this.basicPropertyService.createOwners((Property)this.property, this.basicProp, this.ownerAddress);
        PropertyMutationMaster propertyMutationMaster = (PropertyMutationMaster)this.getPersistenceService().find(MUTATION_MASTER_QUERY, new Object[]{"CREATE", this.mutationId});
        this.basicProp.setPropertyMutationMaster(propertyMutationMaster);
        this.taxExemptionId = this.taxExemptionId == null || this.taxExemptionId.isEmpty() ? "-1" : this.taxExemptionId;
        this.property = this.propService.createProperty(this.property, this.getAreaOfPlot(), propertyMutationMaster.getCode(), this.propTypeId, this.propUsageId, this.propOccId, status, this.getDocNumber(), this.getNonResPlotArea(), this.getFloorTypeId(), this.getRoofTypeId(), this.getWallTypeId(), this.getWoodTypeId(), Long.valueOf(this.taxExemptionId), this.getPropertyDepartmentId(), this.getVacantLandPlotAreaId(), this.getLayoutApprovalAuthorityId(), Boolean.FALSE);
        this.propCompletionDate = !this.property.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND") ? this.propService.getLowestDtOfCompFloorWise(this.property.getPropertyDetail().getFloorDetails()) : this.property.getPropertyDetail().getDateOfCompletion();
        this.basicProp.setPropOccupationDate(this.propCompletionDate);
        if (this.property != null && !this.property.getDocuments().isEmpty()) {
            this.propService.processAndStoreDocument(this.property.getDocuments());
        }
        if (this.propTypeMstr != null && this.propTypeMstr.getCode().equals("VAC_LAND")) {
            this.property.setPropertyDetail(this.propService.changePropertyDetail(this.property, this.property.getPropertyDetail(), Integer.valueOf(0)).getPropertyDetail());
        }
        if (this.property.getPropertyDetail().getLayoutApprovalAuthority() != null && "No Approval".equals(this.property.getPropertyDetail().getLayoutApprovalAuthority().getName())) {
            this.property.getPropertyDetail().setLayoutPermitNo(null);
            this.property.getPropertyDetail().setLayoutPermitDate(null);
        }
        if (this.getDocumentTypeDetails().getDocumentName().equals("Un-registered Document / Notary document")) {
            this.property.getPropertyDetail().setStructure(true);
        } else {
            this.property.getPropertyDetail().setStructure(false);
        }
        if (this.property.getAssessmentDocuments() != null) {
            this.propService.clearOldDocumentAttachments(this.property.getAssessmentDocuments(), this.getDocumentTypeDetails());
            this.propService.processAndStoreDocument(this.property.getAssessmentDocuments());
        }
        this.property.setBasicProperty(this.basicProp);
        this.propService.updateReferenceBasicProperty(this.basicProp, this.getParentIndex());
        if (this.basicProp != null) {
            this.propService.updateDocumentTypeDetails(this.basicProp, this.getDocumentTypeDetails());
        }
    }

    private void updatePropertyId(BasicProperty basicProperty) {
        PropertyID propertyId = basicProperty.getPropertyID();
        propertyId.setZone(this.boundaryService.getBoundaryById(this.getZoneId()));
        propertyId.setWard(this.boundaryService.getBoundaryById(this.getWardId()));
        propertyId.setElectionBoundary(this.boundaryService.getBoundaryById(this.getElectionWardId()));
        propertyId.setModifiedDate(new Date());
        propertyId.setArea(this.boundaryService.getBoundaryById(this.getBlockId()));
        propertyId.setLocality(this.boundaryService.getBoundaryById(this.getLocality()));
        propertyId.setEastBoundary(this.getEastBoundary());
        propertyId.setWestBoundary(this.getWestBoundary());
        propertyId.setNorthBoundary(this.getNorthBoundary());
        propertyId.setSouthBoundary(this.getSouthBoundary());
    }

    @SkipValidation
    @Action(value="/createProperty-approve")
    public String approve() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("approve: Property approval started for Property: " + this.property + " BasicProperty: " + this.basicProp));
        }
        if (this.property.getIsExemptedFromTax().booleanValue()) {
            this.property.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
        } else {
            this.property.setStatus(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
        }
        String assessmentNo = this.propertyTaxNumberGenerator.generateAssessmentNumber();
        this.basicProp.setUpicNo(assessmentNo);
        this.basicProp.setAssessmentdate(new Date());
        PropertyStatus propStatus = (PropertyStatus)this.getPersistenceService().find("from PropertyStatus where statusCode=?", new Object[]{"APPROVED"});
        this.basicProp.setStatus(propStatus);
        PropertyMutationMaster propertyMutationMaster = (PropertyMutationMaster)this.getPersistenceService().find(MUTATION_MASTER_QUERY, new Object[]{"CREATE", this.basicProp.getPropertyMutationMaster().getId()});
        if (!propertyMutationMaster.getCode().equals("BIFUR") && this.basicProp.getPropertyStatusValuesSet().isEmpty() && "Approve".equalsIgnoreCase(this.workFlowAction)) {
            this.basicProp.addPropertyStatusValues(this.propService.createPropStatVal(this.basicProp, "CREATE", null, null, null, null, this.getParentIndex()));
        }
        this.approved = true;
        this.setWardId(this.basicProp.getPropertyID().getWard().getId());
        this.basicPropertyService.applyAuditing((AbstractAuditable)this.property.getState());
        this.propService.updateIndexes((StateAware)this.property, "New_Assessment");
        if (this.property.getSource().equalsIgnoreCase(Source.CITIZENPORTAL.toString())) {
            this.propService.updatePortalMessage(this.property, "New_Assessment");
        }
        this.basicPropertyService.update((Object)this.basicProp);
        this.buildEmailandSms(this.property, "New_Assessment");
        this.approverName = "";
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(this.securityUtils.getCurrentUser().getId());
        if (null != userAssignment) {
            this.propertyInitiatedBy = userAssignment.getEmployee().getName().concat("~").concat(userAssignment.getPosition().getName());
        }
        this.setAckMessage("Property Created Successfully in the System and Forwarded to : ");
        this.setAssessmentNoMessage(" for Digital Signature with assessment number : ");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("approve: BasicProperty: " + this.getBasicProp() + "AckMessage: " + this.getAckMessage()));
            this.logger.debug((Object)"approve: Property approval ended");
        }
        return RESULT_ACK;
    }

    @SkipValidation
    @Action(value="/createProperty-reject")
    public String reject() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"reject: Property rejection started");
        }
        this.basicPropertyService.applyAuditing((AbstractAuditable)this.property.getState());
        if (this.property.getStatus().equals(PropertyTaxConstants.STATUS_CANCELLED)) {
            this.basicProp.setUnderWorkflow(false);
        } else {
            this.basicProp.setUnderWorkflow(true);
        }
        this.propService.updateIndexes((StateAware)this.property, "New_Assessment");
        this.basicPropertyService.persist((Object)this.basicProp);
        if (this.property.getSource().equalsIgnoreCase(Source.CITIZENPORTAL.toString())) {
            this.propService.updatePortalMessage(this.property, "New_Assessment");
        }
        this.approverName = "";
        this.buildEmailandSms(this.property, "New_Assessment");
        if (this.property.getBasicProperty().getSource().equals(PropertyTaxConstants.SOURCEOFDATA_ONLINE) || this.property.getBasicProperty().getSource().equals(PropertyTaxConstants.SOURCEOFDATA_MOBILE)) {
            this.propertyInitiatedBy = this.propertyTaxUtil.getApproverUserName(((StateHistory)this.property.getStateHistory().get(0)).getOwnerPosition().getId());
        } else {
            this.setPropertyInitiatedBy(this.getInitiator());
        }
        if ("Closed".equals(this.property.getState().getValue())) {
            Assignment assignment = this.assignmentService.getPrimaryAssignmentForUser(this.securityUtils.getCurrentUser().getId());
            this.propertyInitiatedBy = assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
            this.setPropertyInitiatedBy(this.getInitiator());
            this.setAckMessage(" Property Rejected Successfully  By ");
        } else {
            this.setAckMessage(" Property Rejected Successfully  and forwarded to : ");
        }
        this.setApplicationNoMessage(" with application No :");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("reject: BasicProperty: " + this.getBasicProp() + "AckMessage: " + this.getAckMessage()));
            this.logger.debug((Object)"reject: Property rejection ended");
        }
        return RESULT_ACK;
    }

    private void setFloorDetails(Property property) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into setFloorDetails, Property: " + property));
        }
        List floorList = property.getPropertyDetail().getFloorDetails();
        property.getPropertyDetail().setFloorDetailsProxy(floorList);
        int i = 0;
        for (Floor flr : floorList) {
            this.floorNoStr[i] = (String)PropertyTaxConstants.FLOOR_MAP.get(flr.getFloorNo());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("setFloorDetails: floorNoStr[" + i + "]->" + this.floorNoStr[i]));
            }
            ++i;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Exiting from setFloorDetails");
        }
    }

    public List<Floor> getFloorDetails() {
        return new ArrayList<Floor>(this.property.getPropertyDetail().getFloorDetails());
    }

    @SkipValidation
    public void prepare() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into prepare, ModelId: " + this.getModelId() + ", PropTypeId: " + this.propTypeId + ", ZoneId: " + this.zoneId + ", WardId: " + this.wardId));
        }
        this.setUserInfo();
        this.setUserDesignations();
        this.propertyByEmployee = this.propService.isEmployee(this.securityUtils.getCurrentUser()) != false && !"Anonymous".equalsIgnoreCase(this.securityUtils.getCurrentUser().getName());
        this.loggedUserIsMeesevaUser = this.propService.isMeesevaUser(this.securityUtils.getCurrentUser());
        this.isCitizenPortalUser = this.propService.isCitizenPortalUser(this.securityUtils.getCurrentUser());
        this.isDataEntryOperator = this.propService.isDataEntryOperator(this.securityUtils.getCurrentUser());
        if (StringUtils.isNotBlank((String)this.getModelId())) {
            this.property = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.modifyRsn)) {
                this.property = (PropertyImpl)this.persistenceService.merge((Object)this.property);
            }
            this.basicProp = this.property.getBasicProperty();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("prepare: Property by ModelId: " + this.property + "BasicProperty on property: " + this.basicProp));
            }
        }
        if (null != this.property && null != this.property.getId() && null != this.property.getState()) {
            if (!this.property.getStatus().toString().equalsIgnoreCase("C") || !this.isCitizenPortalUser.booleanValue()) {
                this.preparePropertyTaxDetails((Property)this.property);
            }
            this.historyMap = this.propService.populateHistory((StateAware)this.property);
        }
        this.documentTypes = this.propService.getDocumentTypesForTransactionType(TransactionType.CREATE);
        this.assessmentDocumentTypes = this.propService.getDocumentTypesForTransactionType(TransactionType.CREATE_ASMT_DOC);
        List floorTypeList = this.getPersistenceService().findAllBy("from FloorType order by name", new Object[0]);
        List roofTypeList = this.getPersistenceService().findAllBy("from RoofType order by name", new Object[0]);
        List wallTypeList = this.getPersistenceService().findAllBy("from WallType order by name", new Object[0]);
        List woodTypeList = this.getPersistenceService().findAllBy("from WoodType order by name", new Object[0]);
        List propTypeList = this.getPersistenceService().findAllBy("from PropertyTypeMaster where type != 'EWSHS' order by orderNo", new Object[0]);
        List propOccList = this.getPersistenceService().findAllBy("from PropertyOccupation", new Object[0]);
        List mutationList = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.applicationSource) ? this.getPersistenceService().findAllBy("from PropertyMutationMaster pmm where pmm.type=?", new Object[]{"CREATE"}) : this.getPersistenceService().findAllBy("from PropertyMutationMaster pmm where pmm.type=? and pmm.code=?", new Object[]{"CREATE", "NEW"});
        if (null != this.property && this.property.getMeesevaServiceCode() != null) {
            if (this.property.getMeesevaServiceCode().equalsIgnoreCase(MEESEVA_SERVICE_CODE_NEWPROPERTY)) {
                this.getMutationListByCode("NEW");
            }
            if (this.property.getMeesevaServiceCode().equalsIgnoreCase(MEESEVA_SERVICE_CODE_SUBDIVISION)) {
                this.getMutationListByCode("BIFUR");
            }
        }
        List usageList = this.getPersistenceService().findAllBy("from PropertyUsage where isActive = true order by usageName", new Object[0]);
        List ageFacList = this.getPersistenceService().findAllBy("from DepreciationMaster", new Object[0]);
        List structureList = this.getPersistenceService().findAllBy("from StructureClassification where isActive = true order by typeName ", new Object[0]);
        List apartmentsList = this.getPersistenceService().findAllBy("from Apartment order by name", new Object[0]);
        List taxExemptionReasonList = this.getPersistenceService().findAllBy("from TaxExemptionReason where isActive = true order by name", new Object[0]);
        List localityList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
        List zones = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
        List electionWardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION");
        List enumerationBlockList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Election Ward", "ELECTION");
        this.addDropdownData("zones", zones);
        this.addDropdownData("wards", Collections.emptyList());
        this.addDropdownData("blocks", Collections.emptyList());
        this.addDropdownData("streets", Collections.emptyList());
        this.setDeviationPercentageMap((Map)PropertyTaxConstants.DEVIATION_PERCENTAGE);
        this.setGuardianRelationMap((Map)PropertyTaxConstants.GUARDIAN_RELATION);
        this.addDropdownData("PropTypeMaster", propTypeList);
        this.addDropdownData("floorType", floorTypeList);
        this.addDropdownData("roofType", roofTypeList);
        this.addDropdownData("wallType", wallTypeList);
        this.addDropdownData("woodType", woodTypeList);
        this.addDropdownData("apartments", apartmentsList);
        this.addDropdownData("OccupancyList", propOccList);
        this.addDropdownData("StructureList", structureList);
        this.addDropdownData("AgeFactorList", ageFacList);
        this.addDropdownData("MutationList", mutationList);
        this.addDropdownData("LocationFactorList", Collections.emptyList());
        this.setFloorNoMap((SortedMap)PropertyTaxConstants.FLOOR_MAP);
        this.addDropdownData("localityList", localityList);
        this.addDropdownData("electionWardList", electionWardList);
        this.addDropdownData("enumerationBlockList", enumerationBlockList);
        this.addDropdownData("taxExemptionReasonList", taxExemptionReasonList);
        if (this.propTypeId != null && !this.propTypeId.trim().isEmpty() && !"-1".equals(this.propTypeId)) {
            this.propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find(PROPTYPEMASTER_QUERY, new Object[]{Long.valueOf(this.propTypeId)});
            if (this.propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
                this.setPropTypeCategoryMap((Map)PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY);
            } else {
                this.setPropTypeCategoryMap((Map)PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY);
            }
        } else {
            this.setPropTypeCategoryMap(Collections.emptyMap());
        }
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.propertyCategory})) {
            if (this.propertyCategory.equals("MIXED")) {
                usageList = this.getPersistenceService().findAllBy("From PropertyUsage order by usageName", new Object[0]);
            } else if (this.propertyCategory.equals("RESIDENTIAl")) {
                usageList = this.getPersistenceService().findAllBy("From PropertyUsage where isResidential = true order by usageName", new Object[0]);
            } else if (this.propertyCategory.equals("NON_RESIDENTIAL")) {
                usageList = this.getPersistenceService().findAllBy("From PropertyUsage where isResidential = false order by usageName", new Object[0]);
            }
        }
        this.addDropdownData(USAGE_LIST, usageList);
        this.addDropdownData(EXEMPTED_REASON_LIST, CommonServices.getTaxExemptedList());
        if (this.propTypeId != null && !this.propTypeId.trim().isEmpty() && !"-1".equals(this.propTypeId)) {
            this.propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find(PROPTYPEMASTER_QUERY, new Object[]{Long.valueOf(this.propTypeId)});
            if (this.propTypeMstr.getCode().equalsIgnoreCase("STATE_GOVT")) {
                this.setPropertyDepartmentList(this.propertyDepartmentRepository.getAllStateDepartments());
            } else if (this.propTypeMstr.getCode().startsWith("CENTRAL_GOVT")) {
                this.setPropertyDepartmentList(this.propertyDepartmentRepository.getAllCentralDepartments());
            } else if (this.propTypeMstr.getCode().equals("PRIVATE")) {
                this.setPropertyDepartmentList(this.propertyDepartmentRepository.getAllPrivateDepartments());
            }
        }
        this.setVacantLandPlotAreaList(this.vacantLandPlotAreaRepository.findAll());
        this.setLayoutApprovalAuthorityList(this.layoutApprovalAuthorityRepository.findAll());
        this.addDropdownData("vacantLandPlotAreaList", this.vacantLandPlotAreaList);
        this.addDropdownData("layoutApprovalAuthorityList", this.layoutApprovalAuthorityList);
        this.setAssessmentDocumentNames(PropertyTaxConstants.ASSESSMENT_DOCUMENT_NAMES);
        this.addDropdownData("assessmentDocumentNameList", this.assessmentDocumentNames);
        super.prepare();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("prepare: PropTypeList: " + (propTypeList != null ? propTypeList : "NULL") + ", PropOccuList: " + (propOccList != null ? propOccList : "NLL") + ", MutationList: " + (mutationList != null ? mutationList : "NULL") + ", AgeFactList: " + (ageFacList != null ? ageFacList : "NULL") + "UsageList: " + (this.getDropdownData().get(USAGE_LIST) != null ? this.getDropdownData().get(USAGE_LIST) : "List is NULL") + ", TaxExemptedReasonList: " + (this.getDropdownData().get(EXEMPTED_REASON_LIST) != null ? this.getDropdownData().get(EXEMPTED_REASON_LIST) : "List is NULL")));
            this.logger.debug((Object)"Exiting from prepare");
        }
    }

    private BasicProperty createBasicProp(Character status) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into createBasicProp, Property: " + this.property + ", status: " + status + ", WardId: " + this.wardId));
        }
        BasicPropertyImpl basicProperty = new BasicPropertyImpl();
        PropertyStatus propStatus = (PropertyStatus)this.getPersistenceService().find("from PropertyStatus where statusCode=?", new Object[]{"WORKFLOW"});
        basicProperty.setRegdDocDate(this.property.getBasicProperty().getRegdDocDate());
        basicProperty.setRegdDocNo(this.property.getBasicProperty().getRegdDocNo());
        basicProperty.setActive(Boolean.TRUE);
        basicProperty.setAddress(this.createPropAddress());
        basicProperty.setPropertyID(this.createPropertyID((BasicProperty)basicProperty));
        basicProperty.setStatus(propStatus);
        basicProperty.setUnderWorkflow(true);
        PropertyMutationMaster propertyMutationMaster = (PropertyMutationMaster)this.getPersistenceService().find(MUTATION_MASTER_QUERY, new Object[]{"CREATE", this.mutationId});
        basicProperty.setPropertyMutationMaster(propertyMutationMaster);
        if (propertyMutationMaster.getCode().equals("BIFUR") || this.property.getPropertyDetail().isAppurtenantLandChecked().booleanValue()) {
            basicProperty.addPropertyStatusValues(this.propService.createPropStatVal((BasicProperty)basicProperty, "CREATE", null, null, null, null, this.getParentIndex()));
        }
        basicProperty.setBoundary(this.boundaryService.getBoundaryById(this.getElectionWardId()));
        basicProperty.setIsBillCreated(PropertyTaxConstants.STATUS_BILL_NOTCREATED);
        if (!this.property.getPropertyDetail().isAppurtenantLandChecked().booleanValue()) {
            this.basicPropertyService.createOwners((Property)this.property, (BasicProperty)basicProperty, this.ownerAddress);
            this.property.setBasicProperty((BasicProperty)basicProperty);
        } else {
            this.basicPropertyService.createOwnersForAppurTenant((Property)this.property, (BasicProperty)basicProperty, this.ownerAddress);
        }
        this.property.setPropertyModifyReason("CREATE");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("BasicProperty: " + basicProperty + "\nExiting from createBasicProp"));
        }
        return basicProperty;
    }

    private void addDemandAndCompleteDate(Character status, BasicProperty basicProperty, PropertyMutationMaster propertyMutationMaster) throws TaxCalculatorExeption {
        this.taxExemptionId = this.taxExemptionId == null || this.taxExemptionId.isEmpty() ? "-1" : this.taxExemptionId;
        this.property = this.propService.createProperty(this.property, this.getAreaOfPlot(), propertyMutationMaster.getCode(), this.propTypeId, this.propUsageId, this.propOccId, status, this.getDocNumber(), this.getNonResPlotArea(), this.getFloorTypeId(), this.getRoofTypeId(), this.getWallTypeId(), this.getWoodTypeId(), Long.valueOf(this.taxExemptionId), this.getPropertyDepartmentId(), this.getVacantLandPlotAreaId(), this.getLayoutApprovalAuthorityId(), Boolean.FALSE);
        this.property.setStatus(status);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("createBasicProp: Property after call to PropertyService.createProperty: " + this.property));
        }
        this.propCompletionDate = !this.property.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND") ? this.propService.getLowestDtOfCompFloorWise(this.property.getPropertyDetail().getFloorDetails()) : this.property.getPropertyDetail().getDateOfCompletion();
        basicProperty.setPropOccupationDate(this.propCompletionDate);
        if (this.propTypeMstr != null && this.propTypeMstr.getCode().equals("VAC_LAND")) {
            this.property.setPropertyDetail((PropertyDetail)this.changePropertyDetail(this.property));
        }
        basicProperty.addProperty((Property)this.property);
        try {
            if (basicProperty.getSource() == PropertyTaxConstants.SOURCEOFDATA_APPLICATION) {
                if (this.property != null && !this.property.getDocuments().isEmpty()) {
                    this.propService.processAndStoreDocument(this.property.getDocuments());
                }
                this.propService.createDemand(this.property, this.propCompletionDate);
            }
        }
        catch (TaxCalculatorExeption e) {
            throw new TaxCalculatorExeption();
        }
    }

    private VacantProperty changePropertyDetail(PropertyImpl property) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Entered into changePropertyDetail, Property is Vacant land");
        }
        PropertyDetail propertyDetail = property.getPropertyDetail();
        if (this.getDocumentTypeDetails().getDocumentName() != null && this.getDocumentTypeDetails().getDocumentName().equals("Un-registered Document / Notary document")) {
            propertyDetail.setStructure(true);
        }
        VacantProperty vacantProperty = new VacantProperty(propertyDetail.getSitalArea(), propertyDetail.getTotalBuiltupArea(), propertyDetail.getCommBuiltUpArea(), propertyDetail.getPlinthArea(), propertyDetail.getCommVacantLand(), propertyDetail.getNonResPlotArea(), Boolean.valueOf(false), propertyDetail.getSurveyNumber(), propertyDetail.getFieldVerified(), propertyDetail.getFieldVerificationDate(), propertyDetail.getFloorDetails(), propertyDetail.getPropertyDetailsID(), propertyDetail.getWater_Meter_Num(), propertyDetail.getElec_Meter_Num(), Integer.valueOf(0), propertyDetail.getFieldIrregular(), propertyDetail.getDateOfCompletion(), propertyDetail.getProperty(), propertyDetail.getUpdatedTime(), propertyDetail.getPropertyUsage(), null, propertyDetail.getPropertyTypeMaster(), propertyDetail.getPropertyType(), propertyDetail.getInstallment(), propertyDetail.getPropertyOccupation(), propertyDetail.getPropertyMutationMaster(), propertyDetail.getComZone(), propertyDetail.getCornerPlot(), Double.valueOf(propertyDetail.getExtentSite() != null ? propertyDetail.getExtentSite() : 0.0), Double.valueOf(propertyDetail.getExtentAppartenauntLand() != null ? propertyDetail.getExtentAppartenauntLand() : 0.0), propertyDetail.getFloorType(), propertyDetail.getRoofType(), propertyDetail.getWallType(), propertyDetail.getWoodType(), propertyDetail.isLift(), propertyDetail.isToilets(), propertyDetail.isWaterTap(), propertyDetail.isStructure(), propertyDetail.isElectricity(), propertyDetail.isAttachedBathRoom(), propertyDetail.isWaterHarvesting(), propertyDetail.isCable(), propertyDetail.getSiteOwner(), propertyDetail.getPattaNumber(), propertyDetail.getCurrentCapitalValue(), propertyDetail.getMarketValue(), propertyDetail.getCategoryType(), propertyDetail.getOccupancyCertificationNo(), propertyDetail.isAppurtenantLandChecked(), propertyDetail.isCorrAddressDiff(), propertyDetail.getPropertyDepartment(), propertyDetail.getVacantLandPlotArea(), propertyDetail.getLayoutApprovalAuthority(), propertyDetail.getLayoutPermitNo(), propertyDetail.getLayoutPermitDate());
        vacantProperty.setManualAlv(propertyDetail.getManualAlv());
        vacantProperty.setOccupierName(propertyDetail.getOccupierName());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Exiting from changePropertyDetail");
        }
        return vacantProperty;
    }

    private void updatePropAddress(BasicProperty basicProperty) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into createPropAddress, \nAreaId: " + this.getBlockId() + ", House Number: " + this.getHouseNumber() + ", OldHouseNo: , AddressStr: " + this.getAddressStr() + ", Pincode: " + this.getPinCode()));
        }
        PropertyAddress propAddr = basicProperty.getAddress();
        propAddr.setHouseNoBldgApt(this.getHouseNumber());
        propAddr.setAreaLocalitySector(this.boundaryService.getBoundaryById(this.getLocality()).getName());
        String cityName = ApplicationThreadLocals.getCityName();
        propAddr.setStreetRoadLine(this.boundaryService.getBoundaryById(this.getWardId()).getName());
        propAddr.setCityTownVillage(cityName);
        if (this.getPinCode() != null && !this.getPinCode().isEmpty()) {
            propAddr.setPinCode(this.getPinCode());
        }
        for (PropertyOwnerInfo owner : basicProperty.getPropertyOwnerInfo()) {
            for (Address address : owner.getOwner().getAddress()) {
                if (null == address) continue;
                this.ownerAddress = address;
            }
        }
        if (this.property.getPropertyDetail().isCorrAddressDiff() == null || !this.property.getPropertyDetail().isCorrAddressDiff().booleanValue()) {
            this.ownerAddress.setAreaLocalitySector(propAddr.getAreaLocalitySector());
            this.ownerAddress.setHouseNoBldgApt(propAddr.getHouseNoBldgApt());
            this.ownerAddress.setStreetRoadLine(propAddr.getStreetRoadLine());
            this.ownerAddress.setCityTownVillage(cityName);
            this.ownerAddress.setPinCode(propAddr.getPinCode());
        } else {
            String[] corrAddr = this.getCorrAddress1().split(",");
            if (corrAddr.length == 1) {
                this.ownerAddress.setAreaLocalitySector(this.getCorrAddress1());
            } else {
                this.ownerAddress.setAreaLocalitySector(corrAddr[1]);
            }
            this.ownerAddress.setHouseNoBldgApt(this.getHouseNumber());
            this.ownerAddress.setStreetRoadLine(this.getCorrAddress2());
            this.ownerAddress.setCityTownVillage(cityName);
            this.ownerAddress.setPinCode(this.getCorrPinCode());
        }
    }

    private PropertyAddress createPropAddress() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into createPropAddress, \nAreaId: " + this.getBlockId() + ", House Number: " + this.getHouseNumber() + ", OldHouseNo: , AddressStr: " + this.getAddressStr() + ", PinCode: " + this.getPinCode()));
        }
        PropertyAddress propAddr = new PropertyAddress();
        propAddr.setHouseNoBldgApt(this.getHouseNumber());
        propAddr.setAreaLocalitySector(this.boundaryService.getBoundaryById(this.getLocality()).getName());
        String cityName = ApplicationThreadLocals.getCityName();
        propAddr.setStreetRoadLine(this.boundaryService.getBoundaryById(this.getWardId()).getName());
        propAddr.setCityTownVillage(cityName);
        if (this.getPinCode() != null && !this.getPinCode().isEmpty()) {
            propAddr.setPinCode(this.getPinCode());
        }
        if (this.property.getPropertyDetail().isCorrAddressDiff() == null || !this.property.getPropertyDetail().isCorrAddressDiff().booleanValue()) {
            this.ownerAddress = new CorrespondenceAddress();
            this.ownerAddress.setAreaLocalitySector(propAddr.getAreaLocalitySector());
            this.ownerAddress.setHouseNoBldgApt(propAddr.getHouseNoBldgApt());
            this.ownerAddress.setStreetRoadLine(propAddr.getStreetRoadLine());
            this.ownerAddress.setCityTownVillage(cityName);
            this.ownerAddress.setPinCode(propAddr.getPinCode());
        } else {
            this.ownerAddress = new CorrespondenceAddress();
            this.ownerAddress.setHouseNoBldgApt(this.getHouseNumber());
            this.ownerAddress.setAreaLocalitySector(this.getCorrAddress1());
            this.ownerAddress.setStreetRoadLine(this.getCorrAddress2());
            this.ownerAddress.setCityTownVillage(cityName);
            this.ownerAddress.setPinCode(this.getCorrPinCode());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("PropertyAddress: " + propAddr + "\nExiting from createPropAddress"));
        }
        return propAddr;
    }

    private PropertyID createPropertyID(BasicProperty basicProperty) {
        PropertyID propertyId = new PropertyID();
        propertyId.setZone(this.boundaryService.getBoundaryById(this.getZoneId()));
        propertyId.setWard(this.boundaryService.getBoundaryById(this.getWardId()));
        propertyId.setElectionBoundary(this.boundaryService.getBoundaryById(this.getElectionWardId()));
        propertyId.setCreatedDate(new Date());
        propertyId.setModifiedDate(new Date());
        propertyId.setModifiedDate(new Date());
        propertyId.setArea(this.boundaryService.getBoundaryById(this.getBlockId()));
        propertyId.setLocality(this.boundaryService.getBoundaryById(this.getLocality()));
        if (this.getStreetId() != null && this.getStreetId() != -1L) {
            propertyId.setStreet(this.boundaryService.getBoundaryById(this.getStreetId()));
        }
        propertyId.setEastBoundary(this.getEastBoundary());
        propertyId.setWestBoundary(this.getWestBoundary());
        propertyId.setNorthBoundary(this.getNorthBoundary());
        propertyId.setSouthBoundary(this.getSouthBoundary());
        propertyId.setBasicProperty(basicProperty);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("PropertyID: " + propertyId + "\nExiting from createPropertyID"));
        }
        return propertyId;
    }

    public void validate() {
        Assignment initiator;
        if (null != this.property && this.property.getMeesevaServiceCode() != null && !"".equals(this.property.getMeesevaServiceCode())) {
            if (this.property.getMeesevaServiceCode().equalsIgnoreCase(MEESEVA_SERVICE_CODE_NEWPROPERTY)) {
                this.getMutationListByCode("NEW");
            }
            if (this.property.getMeesevaServiceCode().equalsIgnoreCase(MEESEVA_SERVICE_CODE_SUBDIVISION)) {
                this.getMutationListByCode("BIFUR");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into validate\nZoneId: " + this.zoneId + ", wardid: " + this.wardId + ", AreadId: " + this.blockId + ", HouseNumber: " + this.houseNumber + ", PinCode: " + this.pinCode + ", MutationId: " + this.mutationId + "DepartmentId: " + this.propertyDepartmentId));
        }
        if (this.locality == null || this.locality == -1L) {
            this.addActionError(this.getText("mandatory.localityId"));
        }
        if (null != this.propTypeId && !"-1".equals(this.propTypeId)) {
            this.propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find(PROPTYPEMASTER_QUERY, new Object[]{Long.valueOf(this.propTypeId)});
        }
        if (this.zoneId == null || this.zoneId == -1L) {
            this.addActionError(this.getText("mandatory.zone"));
        }
        if (this.wardId == null || this.wardId == -1L) {
            this.addActionError(this.getText("mandatory.ward"));
        }
        if (this.blockId == null || this.blockId == -1L) {
            this.addActionError(this.getText("mandatory.block"));
        } else if (null != this.propTypeMstr && !this.propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.houseNumber)) {
                if (this.propService.isDuplicateDoorNumber(this.houseNumber, this.basicProp)) {
                    this.addActionError(this.getText("houseNo.duplicate"));
                }
            } else if (this.property != null && this.property.getState() != null && this.property.getState().getNextAction() != null && this.property.getState().getNextAction().equalsIgnoreCase("UD Revenue Inspector Approval Pending")) {
                this.addActionError(this.getText("mandatory.doorNo"));
            }
        }
        if (this.electionWardId == null || this.electionWardId == -1L) {
            this.addActionError(this.getText("mandatory.election.ward"));
        }
        for (PropertyOwnerInfo owner : this.property.getBasicProperty().getPropertyOwnerInfoProxy()) {
            if (owner == null) continue;
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getName())) {
                this.addActionError(this.getText("mandatory.ownerName"));
            }
            if (null == owner.getOwner().getGender()) {
                this.addActionError(this.getText("mandatory.gender"));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getMobileNumber())) {
                this.addActionError(this.getText("mandatory.mobilenumber"));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getGuardianRelation())) {
                this.addActionError(this.getText("mandatory.guardianrelation"));
            }
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getGuardian())) continue;
            this.addActionError(this.getText("mandatory.guardian"));
        }
        int count = this.property.getBasicProperty().getPropertyOwnerInfoProxy().size();
        for (int i = 0; i < count; ++i) {
            PropertyOwnerInfo owner = (PropertyOwnerInfo)this.property.getBasicProperty().getPropertyOwnerInfoProxy().get(i);
            if (owner == null) continue;
            for (int j = i + 1; j <= count - 1; ++j) {
                PropertyOwnerInfo owner1 = (PropertyOwnerInfo)this.property.getBasicProperty().getPropertyOwnerInfoProxy().get(j);
                if (owner1 == null || !owner.getOwner().getMobileNumber().equalsIgnoreCase(owner1.getOwner().getMobileNumber()) || !owner.getOwner().getName().equalsIgnoreCase(owner1.getOwner().getName())) continue;
                this.addActionError(this.getText("error.owner.duplicateMobileNo", "", owner.getOwner().getMobileNumber().concat(",").concat(owner.getOwner().getName())));
            }
        }
        this.validateProperty((Property)this.property, this.areaOfPlot, this.dateOfCompletion, this.eastBoundary, this.westBoundary, this.southBoundary, this.northBoundary, this.propTypeId, null != this.zoneId && this.zoneId != -1L ? String.valueOf(this.zoneId) : "", this.propOccId, this.floorTypeId, this.roofTypeId, this.wallTypeId, this.woodTypeId, null, null, this.vacantLandPlotAreaId, this.layoutApprovalAuthorityId, this.getDocumentTypeDetails());
        if (StringUtils.isBlank((String)this.pinCode)) {
            this.addActionError(this.getText("mandatory.pincode"));
        }
        if (this.property.getPropertyDetail().isCorrAddressDiff() != null && this.property.getPropertyDetail().isCorrAddressDiff().booleanValue()) {
            if (StringUtils.isBlank((String)this.corrAddress1)) {
                this.addActionError(this.getText("mandatory.corr.addr1"));
            }
            if (StringUtils.isBlank((String)this.corrPinCode) && this.corrPinCode.length() < 6) {
                this.addActionError(this.getText("mandatory.corr.pincode.size"));
            }
        }
        if (null != this.mutationId && this.mutationId != -1L) {
            PropertyMutationMaster propertyMutationMaster = (PropertyMutationMaster)this.getPersistenceService().find("from PropertyMutationMaster pmm where pmm.id=?", new Object[]{this.mutationId});
            if (propertyMutationMaster.getCode().equals("BIFUR")) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.parentIndex)) {
                    BasicProperty basicProperty = (BasicProperty)this.basicPropertyService.find("From BasicPropertyImpl where upicNo = ? ", new Object[]{this.parentIndex});
                    if (basicProperty != null && basicProperty.isUnderWorkflow()) {
                        this.addActionError(this.getText("error.parent.underworkflow"));
                    } else if (this.areaOfPlot != null && !this.areaOfPlot.isEmpty()) {
                        Area area = new Area();
                        area.setArea(new Float(this.areaOfPlot));
                        this.property.getPropertyDetail().setSitalArea(area);
                        if (basicProperty != null && basicProperty.getActiveProperty() != null) {
                            this.property.getPropertyDetail().setPropertyTypeMaster(this.propTypeMstr);
                            String errorKey = this.propService.validationForBifurcation(this.property, basicProperty, propertyMutationMaster.getCode());
                            if (!StringUtils.isBlank((String)errorKey)) {
                                this.addActionError(this.getText(errorKey));
                            }
                        } else {
                            this.addActionError(this.getText("error.parent"));
                        }
                    }
                } else {
                    this.addActionError(this.getText("error.parent.index"));
                }
            }
        } else {
            this.addActionError(this.getText("mandatory.createRsn"));
        }
        if (this.loggedUserIsMeesevaUser.booleanValue() || this.isCitizenPortalUser.booleanValue() || !this.propertyByEmployee.booleanValue()) {
            PropertyID propertyid = new PropertyID();
            propertyid.setElectionBoundary(this.boundaryService.getBoundaryById(this.getElectionWardId()));
            this.property.getBasicProperty().setPropertyID(propertyid);
            if (null != this.getElectionWardId() && this.getElectionWardId() != -1L && null != this.property.getBasicProperty()) {
                Assignment assignment;
                Assignment assignment2 = assignment = this.propService.isCscOperator(this.securityUtils.getCurrentUser()) != false ? this.propService.getAssignmentByDeptDesigElecWard(this.property.getBasicProperty()) : null;
                if (assignment == null && this.propService.getUserPositionByZone(this.property.getBasicProperty(), false) == null) {
                    this.addActionError(this.getText(NOTEXISTS_POSITION));
                }
            }
        } else if (this.property.getId() == null && !this.isDataEntryOperator.booleanValue() && (initiator = this.propertyTaxCommonUtils.getWorkflowInitiatorAssignment(this.securityUtils.getCurrentUser().getId())) == null) {
            this.addActionError(this.getText(NOTEXISTS_POSITION));
        }
        this.validateApproverDetails();
        super.validate();
        if (StringUtils.isBlank((String)this.getModelId())) {
            this.showCalculateTaxButton();
        }
        if (this.propTypeMstr != null && this.propTypeMstr.getCode().equalsIgnoreCase("STATE_GOVT") && this.propertyDepartmentId == null) {
            this.addActionError(this.getText("mandatory.property.department"));
        }
        if (this.upicNo == null || "".equals(this.upicNo)) {
            this.validateDocumentDetails(this.getDocumentTypeDetails());
        }
    }

    @SkipValidation
    @Action(value="/createProperty-printAck")
    public String printAck() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        if ("Anonymous".equalsIgnoreCase(this.securityUtils.getCurrentUser().getName()) && ApplicationThreadLocals.getUserId() == null) {
            ApplicationThreadLocals.setUserId((Long)this.securityUtils.getCurrentUser().getId());
        }
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.basicPropertyService.propertyAcknowledgement(this.property, cityLogo, cityName));
        return PRINT_ACK;
    }

    @SkipValidation
    @Action(value="/createProperty-dataEntry")
    public String dataEntry() {
        this.setDataEntry(Boolean.TRUE.booleanValue());
        return RESULT_DATAENTRY;
    }

    @SkipValidation
    @Action(value="/createProperty-updateDataEntry")
    public String updateDataEntry() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("update data entry: Property updation started, Property: " + this.property + ", UpicNo: " + this.basicProp.getUpicNo() + ", zoneId: " + this.zoneId + ", wardId: " + this.wardId + ", blockId: " + this.blockId + ", areaOfPlot: " + this.areaOfPlot + ", dateOfCompletion: " + this.dateOfCompletion + ", taxExemptedReason: , propTypeId: " + this.propTypeId + ", propUsageId: " + this.propUsageId + ", propOccId: " + this.propOccId));
        }
        this.upicNo = this.indexNumber;
        this.validate();
        if (this.hasErrors()) {
            return EDIT_DATA_ENTRY;
        }
        this.basicProp.setRegdDocDate(this.property.getBasicProperty().getRegdDocDate());
        this.basicProp.setRegdDocNo(this.property.getBasicProperty().getRegdDocNo());
        this.basicProp.setActive(Boolean.TRUE);
        this.basicProp.setSource(PropertyTaxConstants.SOURCEOFDATA_DATAENTRY);
        PropertyMutationMaster propertyMutationMaster = (PropertyMutationMaster)this.getPersistenceService().find(MUTATION_MASTER_QUERY, new Object[]{"CREATE", this.mutationId});
        this.basicProp.setPropertyMutationMaster(propertyMutationMaster);
        this.basicProp.setBoundary(this.boundaryService.getBoundaryById(this.getElectionWardId()));
        this.updatePropAddress(this.basicProp);
        this.updatePropertyId(this.basicProp);
        this.basicPropertyService.updateOwners((Property)this.property, this.basicProp, this.ownerAddress);
        this.property.setBasicProperty(this.basicProp);
        this.propService.updatePropertyDetail((Property)this.property, this.floorTypeId, this.roofTypeId, this.wallTypeId, this.woodTypeId, this.areaOfPlot, this.propertyCategory, this.nonResPlotArea, this.propUsageId, this.propOccId, this.propTypeId);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.taxExemptionId) && !this.taxExemptionId.equals("-1")) {
            TaxExemptionReason taxExemptionReason = (TaxExemptionReason)this.persistenceService.find("From TaxExemptionReason where id = ?", new Object[]{Long.valueOf(this.taxExemptionId)});
            this.property.setTaxExemptedReason(taxExemptionReason);
            this.property.setIsExemptedFromTax(Boolean.TRUE);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.taxExemptionId)) {
            this.property.setTaxExemptedReason(null);
            this.property.setIsExemptedFromTax(Boolean.FALSE);
        }
        this.propService.updateFloorDetails((Property)this.property, this.getFloorDetails());
        this.basicPropertyService.update((Object)this.basicProp);
        this.setAckMessage("Property data entry modified successfully for Assessment No ");
        return RESULT_ACK;
    }

    @ValidationErrorPage(value="dataEntry")
    @Action(value="/createProperty-createDataEntry")
    public String save() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("create: Property creation started, Property: " + this.property + ", zoneId: " + this.zoneId + ", wardId: " + this.wardId + ", blockId: " + this.blockId + ", areaOfPlot: " + this.areaOfPlot + ", dateOfCompletion: " + this.dateOfCompletion + ", taxExemptedReason: , propTypeId: " + this.propTypeId + ", propUsageId: " + this.propUsageId + ", propOccId: " + this.propOccId));
        }
        if (this.upicNo == null || "".equals(this.upicNo)) {
            this.addActionError(this.getText("mandatory.indexNumber"));
            return RESULT_DATAENTRY;
        }
        this.propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find(PROPTYPEMASTER_QUERY, new Object[]{Long.valueOf(this.propTypeId)});
        if (!this.propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND") && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.houseNumber)) {
            this.addActionError(this.getText("mandatory.doorNo"));
            return RESULT_DATAENTRY;
        }
        long startTimeMillis = System.currentTimeMillis();
        BasicProperty basicProperty = this.createBasicProp(PropertyTaxConstants.STATUS_ISACTIVE);
        basicProperty.setUnderWorkflow(false);
        basicProperty.setSource(PropertyTaxConstants.SOURCEOFDATA_DATAENTRY);
        basicProperty.setOldMuncipalNum(this.upicNo);
        basicProperty.setUpicNo(this.propertyTaxNumberGenerator.generateAssessmentNumber());
        try {
            this.addDemandAndCompleteDate(PropertyTaxConstants.STATUS_ISACTIVE, basicProperty, basicProperty.getPropertyMutationMaster());
        }
        catch (TaxCalculatorExeption e) {
            basicProperty.setPropertyOwnerInfoProxy(basicProperty.getPropertyOwnerInfo());
            this.addActionError(this.getText(UNIT_RATE_ERROR));
            this.logger.error((Object)"save : There are no Unit rates defined for chosen combinations", (Throwable)e);
            return RESULT_NEW;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("create: BasicProperty after creatation: " + basicProperty));
        }
        basicProperty.setAssessmentdate(this.propCompletionDate);
        basicProperty.setIsTaxXMLMigrated(PropertyTaxConstants.STATUS_YES_XML_MIGRATION);
        this.basicPropertyService.persist((Object)basicProperty);
        this.setBasicProp(basicProperty);
        this.setAckMessage("Property data entry saved in the system successfully and created with Assessment No " + basicProperty.getUpicNo());
        long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
        if (this.logger.isDebugEnabled()) {
            this.logger.info((Object)("create: Property created successfully in system; Time taken(ms) = " + elapsedTimeMillis));
            this.logger.debug((Object)"create: Property creation ended");
        }
        return "dataEntry-ack";
    }

    @SkipValidation
    @Action(value="/createProperty-calculateTax")
    public void calculateTax() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"entering calculateTax()");
        }
        this.validate();
        if (this.hasErrors()) {
            try {
                ServletActionContext.getResponse().getWriter().write(this.getText("enter.mandatory.fields"));
            }
            catch (IOException e) {
                this.logger.error((Object)"calculateTax() : User has not entered all the mandatory fields", (Throwable)e);
            }
        } else {
            HashMap instTaxMap = new HashMap();
            PropertyMutationMaster propertyMutationMaster = (PropertyMutationMaster)this.getPersistenceService().find(MUTATION_MASTER_QUERY, new Object[]{"CREATE", this.mutationId});
            BasicPropertyImpl basicProperty = new BasicPropertyImpl();
            if (this.basicProp == null) {
                basicProperty = this.createBasicProp(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
                basicProperty.setPropertyMutationMaster(propertyMutationMaster);
            } else {
                this.updatePropertyId(this.basicProp);
                this.basicProp.setPropertyMutationMaster(propertyMutationMaster);
            }
            this.taxExemptionId = this.taxExemptionId == null || this.taxExemptionId.isEmpty() ? "-1" : this.taxExemptionId;
            this.property = this.propService.createProperty(this.property, this.getAreaOfPlot(), propertyMutationMaster.getCode(), this.propTypeId, this.propUsageId, this.propOccId, PropertyTaxConstants.STATUS_DEMAND_INACTIVE, this.getDocNumber(), this.getNonResPlotArea(), this.getFloorTypeId(), this.getRoofTypeId(), this.getWallTypeId(), this.getWoodTypeId(), Long.valueOf(this.taxExemptionId), this.getPropertyDepartmentId(), this.getVacantLandPlotAreaId(), this.getLayoutApprovalAuthorityId(), Boolean.FALSE);
            this.propCompletionDate = !this.propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND") ? this.propService.getLowestDtOfCompFloorWise(this.property.getPropertyDetail().getFloorDetails()) : this.property.getPropertyDetail().getDateOfCompletion();
            if (this.basicProp == null) {
                basicProperty.setPropOccupationDate(this.propCompletionDate);
                this.property.setBasicProperty((BasicProperty)basicProperty);
            } else {
                this.basicProp.setPropOccupationDate(this.propCompletionDate);
                this.property.setBasicProperty(this.basicProp);
            }
            if (this.propTypeMstr != null && this.propTypeMstr.getCode().equals("VAC_LAND")) {
                this.property.setPropertyDetail(this.propService.changePropertyDetail(this.property, this.property.getPropertyDetail(), Integer.valueOf(0)).getPropertyDetail());
            }
            try {
                instTaxMap = this.taxCalculator.calculatePropertyTax((Property)this.property, this.propCompletionDate);
            }
            catch (TaxCalculatorExeption e) {
                this.logger.error((Object)"calculateTax() : There are no Unit rates defined for chosen combinations", (Throwable)e);
            }
            String resultString = this.propertyTaxCommonUtils.getCurrentHalfyearTax(instTaxMap, this.propTypeMstr);
            String jsonsString = new GsonBuilder().create().toJson((Object)resultString);
            ServletActionContext.getResponse().setContentType("application/json");
            try {
                ServletActionContext.getResponse().getWriter().write(jsonsString);
            }
            catch (IOException e) {
                this.logger.error((Object)"calculateTax() : Error while writing response", (Throwable)e);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"exiting calculateTax()");
        }
    }

    public void validateInitiatorDesgn() {
        User currentUser = this.securityUtils.getCurrentUser();
        if (this.propService.isEmployee(currentUser).booleanValue() && !this.propertyTaxCommonUtils.isEligibleInitiator(currentUser.getId()).booleanValue()) {
            this.setEligibleInitiator(false);
            this.addActionError(this.getText("initiator.noteligible"));
        }
    }

    public PropertyImpl getProperty() {
        return this.property;
    }

    public void setProperty(PropertyImpl property) {
        this.property = property;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public Long getBlockId() {
        return this.blockId;
    }

    public void setBlockId(Long blockId) {
        this.blockId = blockId;
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public void setHouseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
    }

    public String getAddressStr() {
        return this.addressStr;
    }

    public void setAddressStr(String addressStr) {
        this.addressStr = addressStr;
    }

    public String getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    public String getAreaOfPlot() {
        return this.areaOfPlot;
    }

    public void setAreaOfPlot(String areaOfPlot) {
        this.areaOfPlot = areaOfPlot;
    }

    public String getDateOfCompletion() {
        return this.dateOfCompletion;
    }

    public void setDateOfCompletion(String dateOfCompletion) {
        this.dateOfCompletion = dateOfCompletion;
    }

    public SortedMap<Integer, String> getFloorNoMap() {
        return this.floorNoMap;
    }

    public void setFloorNoMap(SortedMap<Integer, String> floorNoMap) {
        this.floorNoMap = floorNoMap;
    }

    public String getCorrAddress1() {
        return this.corrAddress1;
    }

    public void setCorrAddress1(String corrAddress1) {
        this.corrAddress1 = corrAddress1;
    }

    public String getCorrAddress2() {
        return this.corrAddress2;
    }

    public void setCorrAddress2(String corrAddress2) {
        this.corrAddress2 = corrAddress2;
    }

    public String getCorrPinCode() {
        return this.corrPinCode;
    }

    public void setCorrPinCode(String corrPinCode) {
        this.corrPinCode = corrPinCode;
    }

    public BasicProperty getBasicProp() {
        return this.basicProp;
    }

    public void setBasicProp(BasicProperty basicProp) {
        this.basicProp = basicProp;
    }

    public PropertyService getPropService() {
        return this.propService;
    }

    public void setPropService(PropertyService propService) {
        this.propService = propService;
    }

    public Long getMutationId() {
        return this.mutationId;
    }

    public void setMutationId(Long mutationId) {
        this.mutationId = mutationId;
    }

    public String getParentIndex() {
        return this.parentIndex;
    }

    public void setParentIndex(String parentIndex) {
        this.parentIndex = parentIndex;
    }

    public String getAmenities() {
        return this.amenities;
    }

    public void setAmenities(String amenities) {
        this.amenities = amenities;
    }

    public String[] getFloorNoStr() {
        return this.floorNoStr;
    }

    public void setFloorNoStr(String[] floorNoStr) {
        this.floorNoStr = floorNoStr;
    }

    public String getPropTypeId() {
        return this.propTypeId;
    }

    public void setPropTypeId(String propTypeId) {
        this.propTypeId = propTypeId;
    }

    public String getPropUsageId() {
        return this.propUsageId;
    }

    public void setPropUsageId(String propUsageId) {
        this.propUsageId = propUsageId;
    }

    public String getPropOccId() {
        return this.propOccId;
    }

    public void setPropOccId(String propOccId) {
        this.propOccId = propOccId;
    }

    public String getAckMessage() {
        return this.ackMessage;
    }

    public void setAckMessage(String ackMessage) {
        this.ackMessage = ackMessage;
    }

    public Map<String, String> getPropTypeCategoryMap() {
        return this.propTypeCategoryMap;
    }

    public void setPropTypeCategoryMap(Map<String, String> propTypeCategoryMap) {
        this.propTypeCategoryMap = propTypeCategoryMap;
    }

    public String getPropertyCategory() {
        return this.propertyCategory;
    }

    public void setPropertyCategory(String propertyCategory) {
        this.propertyCategory = propertyCategory;
    }

    public PropertyTypeMaster getPropTypeMstr() {
        return this.propTypeMstr;
    }

    public void setPropTypeMstr(PropertyTypeMaster propTypeMstr) {
        this.propTypeMstr = propTypeMstr;
    }

    public String getDocNumber() {
        return this.docNumber;
    }

    public void setDocNumber(String docNumber) {
        this.docNumber = docNumber;
    }

    public String getNonResPlotArea() {
        return this.nonResPlotArea;
    }

    public void setNonResPlotArea(String nonResPlotArea) {
        this.nonResPlotArea = nonResPlotArea;
    }

    public void setPropertyTaxNumberGenerator(PropertyTaxNumberGenerator propertyTaxNumberGenerator) {
        this.propertyTaxNumberGenerator = propertyTaxNumberGenerator;
    }

    public PropertyImpl getNewProperty() {
        return this.newProperty;
    }

    public void setNewProperty(PropertyImpl newProperty) {
        this.newProperty = newProperty;
    }

    public Long getLocality() {
        return this.locality;
    }

    public void setLocality(Long locality) {
        this.locality = locality;
    }

    public Long getFloorTypeId() {
        return this.floorTypeId;
    }

    public void setFloorTypeId(Long floorTypeId) {
        this.floorTypeId = floorTypeId;
    }

    public Long getRoofTypeId() {
        return this.roofTypeId;
    }

    public void setRoofTypeId(Long roofTypeId) {
        this.roofTypeId = roofTypeId;
    }

    public Long getWallTypeId() {
        return this.wallTypeId;
    }

    public void setWallTypeId(Long wallTypeId) {
        this.wallTypeId = wallTypeId;
    }

    public Long getWoodTypeId() {
        return this.woodTypeId;
    }

    public void setWoodTypeId(Long woodTypeId) {
        this.woodTypeId = woodTypeId;
    }

    public Long getOwnershipType() {
        return this.ownershipType;
    }

    public void setOwnershipType(Long ownershipType) {
        this.ownershipType = ownershipType;
    }

    public String getWardName() {
        return this.wardName;
    }

    public void setWardName(String wardName) {
        this.wardName = wardName;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public AssignmentService getAssignmentService() {
        return this.assignmentService;
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getApplicationNo() {
        return this.applicationNo;
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public Long getElectionWardId() {
        return this.electionWardId;
    }

    public void setElectionWardId(Long electionWardId) {
        this.electionWardId = electionWardId;
    }

    public void setEisCommonService(EisCommonService eisCommonService) {
        this.eisCommonService = eisCommonService;
    }

    public void setBoundaryService(BoundaryService boundaryService) {
        this.boundaryService = boundaryService;
    }

    public void setSecurityUtils(SecurityUtils securityUtils) {
        this.securityUtils = securityUtils;
    }

    public void setbasicPropertyService(PropertyPersistenceService basicPropertyService) {
        this.basicPropertyService = basicPropertyService;
    }

    public void setPropCompletionDate(Date propCompletionDate) {
        this.propCompletionDate = propCompletionDate;
    }

    public String getReportId() {
        return this.reportId;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public String getNorthBoundary() {
        return this.northBoundary;
    }

    public void setNorthBoundary(String northBoundary) {
        this.northBoundary = northBoundary;
    }

    public String getSouthBoundary() {
        return this.southBoundary;
    }

    public void setSouthBoundary(String southBoundary) {
        this.southBoundary = southBoundary;
    }

    public String getEastBoundary() {
        return this.eastBoundary;
    }

    public void setEastBoundary(String eastBoundary) {
        this.eastBoundary = eastBoundary;
    }

    public String getWestBoundary() {
        return this.westBoundary;
    }

    public void setWestBoundary(String westBoundary) {
        this.westBoundary = westBoundary;
    }

    public Map<String, String> getDeviationPercentageMap() {
        return this.deviationPercentageMap;
    }

    public void setDeviationPercentageMap(Map<String, String> deviationPercentageMap) {
        this.deviationPercentageMap = deviationPercentageMap;
    }

    public Map<String, String> getGuardianRelationMap() {
        return this.guardianRelationMap;
    }

    public void setGuardianRelationMap(Map<String, String> guardianRelationMap) {
        this.guardianRelationMap = guardianRelationMap;
    }

    public List<DocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public void setDocumentTypes(List<DocumentType> documentTypes) {
        this.documentTypes = documentTypes;
    }

    public Address getOwnerAddress() {
        return this.ownerAddress;
    }

    public void setOwnerAddress(Address ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public String getApplicationNoMessage() {
        return this.applicationNoMessage;
    }

    public void setApplicationNoMessage(String applicationNoMessage) {
        this.applicationNoMessage = applicationNoMessage;
    }

    public String getAssessmentNoMessage() {
        return this.assessmentNoMessage;
    }

    public void setAssessmentNoMessage(String assessmentNoMessage) {
        this.assessmentNoMessage = assessmentNoMessage;
    }

    public String getPropertyInitiatedBy() {
        return this.propertyInitiatedBy;
    }

    public void setPropertyInitiatedBy(String propertyInitiatedBy) {
        this.propertyInitiatedBy = propertyInitiatedBy;
    }

    public String getAdditionalRule() {
        return "NEW ASSESSMENT";
    }

    public String getUpicNo() {
        return this.upicNo;
    }

    public void setUpicNo(String upicNo) {
        this.upicNo = upicNo;
    }

    public String getTaxExemptionId() {
        return this.taxExemptionId;
    }

    public void setTaxExemptionId(String taxExemptionId) {
        this.taxExemptionId = taxExemptionId;
    }

    public Long getStreetId() {
        return this.streetId;
    }

    public void setStreetId(Long streetId) {
        this.streetId = streetId;
    }

    public Map<String, BigDecimal> getPropertyTaxDetailsMap() {
        return this.propertyTaxDetailsMap;
    }

    public void setPropertyTaxDetailsMap(Map<String, BigDecimal> propertyTaxDetailsMap) {
        this.propertyTaxDetailsMap = propertyTaxDetailsMap;
    }

    public String getIndexNumber() {
        return this.indexNumber;
    }

    public void setIndexNumber(String indexNumber) {
        this.indexNumber = indexNumber;
    }

    public String getModifyRsn() {
        return this.modifyRsn;
    }

    public void setModifyRsn(String modifyRsn) {
        this.modifyRsn = modifyRsn;
    }

    public String getPendingActions() {
        return this.getProperty() != null ? this.getProperty().getCurrentState().getNextAction() : null;
    }

    public String getCurrentDesignation() {
        return this.getProperty().getId() != null && !this.getProperty().getCurrentState().getValue().endsWith("Rejected") && !this.getProperty().getCurrentState().getValue().endsWith("NEW") ? this.propService.getDesignationForPositionAndUser(this.getProperty().getCurrentState().getOwnerPosition().getId(), this.securityUtils.getCurrentUser().getId()) : null;
    }

    public Boolean getShowTaxCalcBtn() {
        return this.showTaxCalcBtn;
    }

    public void setShowTaxCalcBtn(Boolean showTaxCalcBtn) {
        this.showTaxCalcBtn = showTaxCalcBtn;
    }

    public Long getPropertyDepartmentId() {
        return this.propertyDepartmentId;
    }

    public void setPropertyDepartmentId(Long propertyDepartmentId) {
        this.propertyDepartmentId = propertyDepartmentId;
    }

    public List<PropertyDepartment> getPropertyDepartmentList() {
        return this.propertyDepartmentList;
    }

    public void setPropertyDepartmentList(List<PropertyDepartment> propertyDepartmentList) {
        this.propertyDepartmentList = propertyDepartmentList;
    }

    public List<VacantLandPlotArea> getVacantLandPlotAreaList() {
        return this.vacantLandPlotAreaList;
    }

    public void setVacantLandPlotAreaList(List<VacantLandPlotArea> vacantLandPlotAreaList) {
        this.vacantLandPlotAreaList = vacantLandPlotAreaList;
    }

    public List<LayoutApprovalAuthority> getLayoutApprovalAuthorityList() {
        return this.layoutApprovalAuthorityList;
    }

    public void setLayoutApprovalAuthorityList(List<LayoutApprovalAuthority> layoutApprovalAuthorityList) {
        this.layoutApprovalAuthorityList = layoutApprovalAuthorityList;
    }

    public Long getVacantLandPlotAreaId() {
        return this.vacantLandPlotAreaId;
    }

    public void setVacantLandPlotAreaId(Long vacantLandPlotAreaId) {
        this.vacantLandPlotAreaId = vacantLandPlotAreaId;
    }

    public Long getLayoutApprovalAuthorityId() {
        return this.layoutApprovalAuthorityId;
    }

    public void setLayoutApprovalAuthorityId(Long layoutApprovalAuthorityId) {
        this.layoutApprovalAuthorityId = layoutApprovalAuthorityId;
    }

    public boolean isAllowEditDocument() {
        return this.allowEditDocument;
    }

    public void setAllowEditDocument(boolean allowEditDocument) {
        this.allowEditDocument = allowEditDocument;
    }

    public List<DocumentType> getAssessmentDocumentTypes() {
        return this.assessmentDocumentTypes;
    }

    public void setAssessmentDocumentTypes(List<DocumentType> assessmentDocumentTypes) {
        this.assessmentDocumentTypes = assessmentDocumentTypes;
    }

    public List<String> getAssessmentDocumentNames() {
        return this.assessmentDocumentNames;
    }

    public void setAssessmentDocumentNames(List<String> assessmentDocumentNames) {
        this.assessmentDocumentNames = assessmentDocumentNames;
    }

    public DocumentTypeDetails getDocumentTypeDetails() {
        return this.documentTypeDetails;
    }

    public void setDocumentTypeDetails(DocumentTypeDetails documentTypeDetails) {
        this.documentTypeDetails = documentTypeDetails;
    }

    public boolean isFloorDetailsEntered() {
        return this.floorDetailsEntered;
    }

    public void setFloorDetailsEntered(boolean floorDetailsEntered) {
        this.floorDetailsEntered = floorDetailsEntered;
    }

    public boolean isEligibleInitiator() {
        return this.eligibleInitiator;
    }

    public void setEligibleInitiator(boolean eligibleInitiator) {
        this.eligibleInitiator = eligibleInitiator;
    }

    public boolean isDataEntry() {
        return this.dataEntry;
    }

    public void setDataEntry(boolean dataEntry) {
        this.dataEntry = dataEntry;
    }

    public String getApplicationSource() {
        return this.applicationSource;
    }

    public void setApplicationSource(String applicationSource) {
        this.applicationSource = applicationSource;
    }

    public Boolean getIsCitizenPortalUser() {
        return this.isCitizenPortalUser;
    }

    public void setIsCitizenPortalUser(Boolean isCitizenPortalUser) {
        this.isCitizenPortalUser = isCitizenPortalUser;
    }
}

