/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.vacancyremission;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.service.notice.NoticeService;
import org.egov.ptis.domain.service.property.VacancyRemissionService;
import org.egov.ptis.notice.PtNotice;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/vacancyremission"})
public class ApproveAcknowledgementController {
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    @Autowired
    private VacancyRemissionService vacancyRemissionService;
    public static final String VR_SPECIALNOTICE_TEMPLATE = "mainVRProceedings";
    public static final String SAMPLE_FILE = "VR Proceedings/";

    @RequestMapping(value={"/generatenotice"}, method={RequestMethod.GET})
    public String generateSpecialNotice(Model model, HttpServletRequest request, HttpSession session) {
        String fileStoreIds = null;
        String[] pathvars = request.getParameter("pathVar").split(",");
        String workFlowAction = request.getParameter("workFlowAction");
        String ulbCode = ApplicationThreadLocals.getCityCode();
        boolean digitalSignEnabled = this.propertyTaxCommonUtils.isDigitalSignatureEnabled();
        VacancyRemission vacancyRemission = this.vacancyRemissionService.getLatestSpecialNoticeGeneratedVacancyRemissionForProperty(pathvars[0]);
        PtNotice notice = this.noticeService.getNoticeByNoticeTypeAndApplicationNumber("VR Proceedings", vacancyRemission.getApplicationNumber());
        ByteArrayInputStream noticePdf = null;
        if ("Sign".equals(workFlowAction) && notice == null) {
            String noticeNo = this.propertyTaxNumberGenerator.generateNoticeNumber("VR Proceedings");
            ReportOutput reportOutput = this.vacancyRemissionService.generateReport(vacancyRemission, request, pathvars[1], noticeNo);
            if (reportOutput != null && reportOutput.getReportOutputData() != null) {
                noticePdf = new ByteArrayInputStream(reportOutput.getReportOutputData());
            }
            PtNotice savedNotice = this.noticeService.saveNotice(vacancyRemission.getApplicationNumber(), noticeNo, "VR Proceedings", (BasicProperty)vacancyRemission.getBasicProperty(), (InputStream)noticePdf);
            fileStoreIds = savedNotice.getFileStore().getFileStoreId();
        } else if (workFlowAction.equalsIgnoreCase("Preview")) {
            return "redirect:/vacancyremission/generatenotice/preview/" + pathvars[0] + "?approver=" + pathvars[1];
        }
        model.addAttribute("ulbCode", (Object)ulbCode);
        model.addAttribute("fileStoreIds", fileStoreIds);
        model.addAttribute("digitalSignEnabled", (Object)digitalSignEnabled);
        if ("Sign".equalsIgnoreCase(workFlowAction)) {
            return "vacancyremission-dig-sign";
        }
        return "redirect:/vacancyremission/generatenotice/proceedings/" + pathvars[0] + "?workFlowAction=" + workFlowAction;
    }

    @RequestMapping(value={"/generatenotice/preview/{assessmentNo}", "/generatenotice/proceedings/{assessmentNo}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateNotice(Model model, HttpServletRequest request, @PathVariable String assessmentNo) {
        String fileName;
        ReportOutput noticeOutput = new ReportOutput();
        String approverName = request.getParameter("approver");
        VacancyRemission vacancyRemission = this.vacancyRemissionService.getLatestSpecialNoticeGeneratedVacancyRemissionForProperty(assessmentNo);
        PtNotice notice = this.noticeService.getNoticeByNoticeTypeAndApplicationNumber("VR Proceedings", vacancyRemission.getApplicationNumber());
        if (notice != null) {
            byte[] bFile;
            FileStoreMapper fsm = notice.getFileStore();
            File file = this.fileStoreService.fetch(fsm, "PTIS");
            try {
                bFile = FileUtils.readFileToByteArray((File)file);
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException("Exception while generating VRSpecial Notcie : " + e);
            }
            noticeOutput.setReportOutputData(bFile);
            noticeOutput.setReportFormat(ReportConstants.FileFormat.PDF);
            fileName = notice.getNoticeNo();
        } else {
            noticeOutput = this.vacancyRemissionService.generateReport(vacancyRemission, request, approverName, null);
            fileName = SAMPLE_FILE.concat(assessmentNo);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=" + fileName + ".pdf");
        return new ResponseEntity((Object)noticeOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

