/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.editowner;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.persistence.entity.enums.Gender;
import org.egov.ptis.bean.PropertyOwner;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.service.property.OwnerAuditService;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/editowner/{assessmentNo}"})
public class EditOwnerDetailsController {
    protected static final String OWNERDETAILS_FROM = "ownerdetails-form";
    protected static final String OWNERDETAILS_SUCCESS = "ownerdetails-success";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PropertyPersistenceService basicPropertyService;
    @Autowired
    private OwnerAuditService ownerAuditService;

    @ModelAttribute
    public PropertyOwner getPropertyOwner(@PathVariable String assessmentNo) {
        PropertyOwner propertyOwner = new PropertyOwner();
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        if (null != basicProperty) {
            PropertyImpl property = (PropertyImpl)basicProperty.getProperty();
            propertyOwner.setProperty(property);
            propertyOwner.setPropertyOwnerInfo(basicProperty.getPropertyOwnerInfo());
        }
        return propertyOwner;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newForm(@ModelAttribute PropertyOwner propertyOwner, Model model, @PathVariable String assessmentNo) {
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        model.addAttribute("guardianRelationMap", (Object)PropertyTaxConstants.GUARDIAN_RELATION);
        model.addAttribute("gender", (Object)Gender.values());
        for (PropertyOwnerInfo ownerInfo : basicProperty.getPropertyOwnerInfo()) {
            for (Address address : ownerInfo.getOwner().getAddress()) {
                model.addAttribute("doorNumber", (Object)address.getHouseNoBldgApt());
                model.addAttribute("pinCode", (Object)address.getPinCode());
            }
        }
        List ownerAuditList = this.ownerAuditService.setOwnerAuditDetails(basicProperty);
        propertyOwner.setOwnerAudit(ownerAuditList);
        model.addAttribute("propertyOwner", (Object)propertyOwner);
        return OWNERDETAILS_FROM;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String updateOwnerDetails(@ModelAttribute PropertyOwner propertyOwner, RedirectAttributes redirectAttrs, BindingResult errors, Model model, HttpServletRequest request, @RequestParam String doorNumber) {
        model.addAttribute("doorNumber", (Object)doorNumber);
        model.addAttribute("guardianRelationMap", (Object)PropertyTaxConstants.GUARDIAN_RELATION);
        String errMsg = this.basicPropertyService.updateOwners((Property)propertyOwner.getProperty(), propertyOwner.getProperty().getBasicProperty(), doorNumber, errors);
        if (!errMsg.isEmpty()) {
            model.addAttribute("errorMsg", (Object)errMsg);
            return OWNERDETAILS_FROM;
        }
        this.ownerAuditService.saveOwnerDetails(propertyOwner.getOwnerAudit());
        return OWNERDETAILS_SUCCESS;
    }
}

