/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import java.util.List;
import org.egov.demand.model.EgBill;
import org.egov.ptis.domain.service.notice.RecoveryNoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/occupiernotice"})
public class OccupierNoticeController {
    @Autowired
    private RecoveryNoticeService recoveryNoticeService;

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("egBill", (Object)new EgBill());
        return "occupiernotice-form";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public String searchProperty(@ModelAttribute(value="egBill") EgBill egBill, Model model, BindingResult errors) {
        List errorList = this.recoveryNoticeService.validateRecoveryNotices(egBill.getConsumerId(), "Occupier Notice");
        for (String error : errorList) {
            if ("common.no.property.due".equals(error)) {
                errors.reject(error, (Object[])new String[]{"Occupier Notice"}, error);
                continue;
            }
            errors.reject(error, error);
        }
        if (errors.hasErrors()) {
            model.addAttribute("occupierNotice", (Object)new EgBill());
            return "occupiernotice-form";
        }
        return "redirect:/occupiernotice/generatenotice/" + egBill.getConsumerId();
    }

    @RequestMapping(value={"/generatenotice/{consumerId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateNotice(@PathVariable String consumerId, Model model) {
        return this.recoveryNoticeService.generateNotice(consumerId, "Occupier Notice");
    }
}

