/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.demolition;

import javax.servlet.http.HttpServletRequest;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/demolition/ack", "/citizen/demolition/ack"})
public class DemolitionAckController {
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;

    @RequestMapping(value={"/printAck/{assessmentNo}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> printAck(HttpServletRequest request, Model model, @PathVariable(value="assessmentNo") String assessmentNo) {
        ReportOutput reportOutput = this.propertyTaxUtil.generateCitizenCharterAcknowledgement(assessmentNo, "DEMOLITION", "Demolition");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=CitizenCharterAcknowledgement.pdf");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

