/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.dashboard;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.bean.dashboard.CollReceiptDetails;
import org.egov.ptis.bean.dashboard.CollectionAnalysis;
import org.egov.ptis.bean.dashboard.CollectionDetails;
import org.egov.ptis.bean.dashboard.CollectionDetailsRequest;
import org.egov.ptis.bean.dashboard.MISDCBDetails;
import org.egov.ptis.bean.dashboard.PropertyTaxDefaultersRequest;
import org.egov.ptis.bean.dashboard.StateCityInfo;
import org.egov.ptis.bean.dashboard.TaxDefaulters;
import org.egov.ptis.bean.dashboard.TaxPayerResponseDetails;
import org.egov.ptis.bean.dashboard.TotalCollectionStats;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.service.dashboard.PropTaxDashboardService;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public/dashboard", "/dashboard"})
public class CMDashboardController {
    private static final String MILLISECS = " (millisecs)";
    private static final Logger LOGGER = LoggerFactory.getLogger(CMDashboardController.class);
    @Autowired
    private PropTaxDashboardService propTaxDashboardService;

    @RequestMapping(value={"/statecityinfo"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<StateCityInfo> getStateCityInformation() throws IOException {
        Long startTime = System.currentTimeMillis();
        List stateDetails = this.propTaxDashboardService.getStateCityDetails();
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve statecityinfo is : " + timeTaken + MILLISECS);
        }
        return stateDetails;
    }

    @RequestMapping(value={"/collectionstats"}, method={RequestMethod.POST}, produces={"application/json"})
    public TotalCollectionStats getConsolidatedCollDetails(HttpServletRequest request) throws IOException {
        Long startTime = System.currentTimeMillis();
        TotalCollectionStats consolidatedCollectionDetails = this.propTaxDashboardService.getTotalCollectionStats(request);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve collectionstats is : " + timeTaken + MILLISECS);
        }
        return consolidatedCollectionDetails;
    }

    @RequestMapping(value={"/collectiondashboard"}, method={RequestMethod.POST}, produces={"application/json"})
    public CollectionDetails getCollectionDetails(@RequestBody CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CollectionDetailsRequest input : regionName = " + collectionDetailsRequest.getRegionName() + ", districtName = " + collectionDetailsRequest.getDistrictName() + ", ulbGrade = " + collectionDetailsRequest.getUlbGrade() + ", ulbCode = " + collectionDetailsRequest.getUlbCode() + ", fromDate = " + collectionDetailsRequest.getFromDate() + ", toDate = " + collectionDetailsRequest.getToDate() + ", type = " + collectionDetailsRequest.getType());
        }
        CollectionDetails collectionDetails = this.propTaxDashboardService.getCollectionIndexDetails(collectionDetailsRequest, false);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve collectiondashboard is : " + timeTaken + MILLISECS);
        }
        return collectionDetails;
    }

    @RequestMapping(value={"/receipttransactions"}, method={RequestMethod.POST}, produces={"application/json"})
    public CollReceiptDetails getReceiptTransactions(@RequestBody CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CollectionDetailsRequest input : regionName = " + collectionDetailsRequest.getRegionName() + ", districtName = " + collectionDetailsRequest.getDistrictName() + ", ulbGrade = " + collectionDetailsRequest.getUlbGrade() + ", ulbCode = " + collectionDetailsRequest.getUlbCode() + ", fromDate = " + collectionDetailsRequest.getFromDate() + ", toDate = " + collectionDetailsRequest.getToDate() + ", type = " + collectionDetailsRequest.getType());
        }
        CollReceiptDetails collReceiptDetails = this.propTaxDashboardService.getReceiptDetails(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve receipttransactions is : " + timeTaken + MILLISECS);
        }
        return collReceiptDetails;
    }

    @RequestMapping(value={"/toptentaxers"}, method={RequestMethod.POST}, produces={"application/json"})
    public TaxPayerResponseDetails getTopTenTaxProducers(@RequestBody CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CollectionDetailsRequest input : regionName = " + collectionDetailsRequest.getRegionName() + ", districtName = " + collectionDetailsRequest.getDistrictName() + ", ulbGrade = " + collectionDetailsRequest.getUlbGrade() + ", ulbCode = " + collectionDetailsRequest.getUlbCode() + ", fromDate = " + collectionDetailsRequest.getFromDate() + ", toDate = " + collectionDetailsRequest.getToDate() + ", type = " + collectionDetailsRequest.getType());
        }
        TaxPayerResponseDetails taxPayerDetails = this.propTaxDashboardService.getTopTenTaxProducers(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve toptentaxers is : " + timeTaken + MILLISECS);
        }
        return taxPayerDetails;
    }

    @RequestMapping(value={"/bottomtentaxers"}, method={RequestMethod.POST}, produces={"application/json"})
    public TaxPayerResponseDetails getBottomTenTaxProducers(@RequestBody CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CollectionDetailsRequest input : regionName = " + collectionDetailsRequest.getRegionName() + ", districtName = " + collectionDetailsRequest.getDistrictName() + ", ulbGrade = " + collectionDetailsRequest.getUlbGrade() + ", ulbCode = " + collectionDetailsRequest.getUlbCode() + ", fromDate = " + collectionDetailsRequest.getFromDate() + ", toDate = " + collectionDetailsRequest.getToDate() + ", type = " + collectionDetailsRequest.getType());
        }
        TaxPayerResponseDetails taxPayerDetails = this.propTaxDashboardService.getBottomTenTaxProducers(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve bottomtentaxers is : " + timeTaken + MILLISECS);
        }
        return taxPayerDetails;
    }

    @RequestMapping(value={"/topdefaulters"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<TaxDefaulters> getTopTaxDefaulters(@RequestBody PropertyTaxDefaultersRequest propertyTaxDefaultersRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PropertyTaxDefaultersRequest input : regionName = " + propertyTaxDefaultersRequest.getRegionName() + ", districtName = " + propertyTaxDefaultersRequest.getDistrictName() + ", type = " + propertyTaxDefaultersRequest.getType() + ", ulbCode = " + propertyTaxDefaultersRequest.getUlbCode() + ", wardName = " + propertyTaxDefaultersRequest.getWardName());
        }
        List taxDefaulters = this.propTaxDashboardService.getTaxDefaulters(propertyTaxDefaultersRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve topdefaulters is : " + timeTaken + MILLISECS);
        }
        return taxDefaulters;
    }

    @RequestMapping(value={"/targetmis"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public CollectionDetails getCollectionDetailsForTargetMIS(CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CollectionDetailsRequest input : regionName = " + collectionDetailsRequest.getRegionName() + ", districtName = " + collectionDetailsRequest.getDistrictName() + ", ulbGrade = " + collectionDetailsRequest.getUlbGrade() + ", ulbCode = " + collectionDetailsRequest.getUlbCode() + ", fromDate = " + collectionDetailsRequest.getFromDate() + ", toDate = " + collectionDetailsRequest.getToDate() + ", type = " + collectionDetailsRequest.getType());
        }
        CollectionDetails collectionDetails = this.propTaxDashboardService.getCollectionIndexDetails(collectionDetailsRequest, true);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve targetmis is : " + timeTaken + MILLISECS);
        }
        return collectionDetails;
    }

    @RequestMapping(value={"/citywisedcb"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public MISDCBDetails getDCBDetailsForMIS(CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        MISDCBDetails misDCBDetails = new MISDCBDetails();
        Long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)collectionDetailsRequest.getIntervalType())) {
            misDCBDetails.setDcbDetails(this.propTaxDashboardService.getDCBDetails(collectionDetailsRequest));
        } else if ("week".equalsIgnoreCase(collectionDetailsRequest.getIntervalType())) {
            String monthStartDateStr = collectionDetailsRequest.getYear().concat("-").concat(collectionDetailsRequest.getMonth()).concat("-").concat("01");
            LocalDate monthStDate = new LocalDate((Object)monthStartDateStr);
            LocalDate weekStart = monthStDate.dayOfWeek().withMinimumValue();
            LocalDate endOfMonth = monthStDate.dayOfMonth().withMaximumValue();
            String startDate = weekStart.toString("yyyy-MM-dd");
            String endDate = endOfMonth.toString("yyyy-MM-dd");
            collectionDetailsRequest.setFromDate(startDate);
            collectionDetailsRequest.setToDate(endDate);
        }
        if ("week".equalsIgnoreCase(collectionDetailsRequest.getIntervalType())) {
            List weekwiseDCBDetails = this.propTaxDashboardService.getWeekwiseDCBDetails(collectionDetailsRequest, collectionDetailsRequest.getIntervalType());
            misDCBDetails.setWeeklyDCBDetails(weekwiseDCBDetails);
        } else if ("month".equalsIgnoreCase(collectionDetailsRequest.getIntervalType())) {
            List monthwiseDCBDetails = this.propTaxDashboardService.getMonthwiseDCBDetails(collectionDetailsRequest, collectionDetailsRequest.getIntervalType());
            misDCBDetails.setMonthlyDCBDetails(monthwiseDCBDetails);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve citywisedcb is : " + timeTaken + MILLISECS);
        }
        return misDCBDetails;
    }

    @RequestMapping(value={"/collectionanalysis"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public CollectionAnalysis getCollectionAnalysisForMIS(CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getIntervalType())) {
            String startDate = "";
            String endDate = "";
            if ("week".equalsIgnoreCase(collectionDetailsRequest.getIntervalType())) {
                String monthStartDateStr = collectionDetailsRequest.getYear().concat("-").concat(collectionDetailsRequest.getMonth()).concat("-").concat("01");
                LocalDate monthStDate = new LocalDate((Object)monthStartDateStr);
                LocalDate weekStart = monthStDate.dayOfWeek().withMinimumValue();
                LocalDate endOfMonth = monthStDate.dayOfMonth().withMaximumValue();
                startDate = weekStart.toString("yyyy-MM-dd");
                endDate = endOfMonth.toString("yyyy-MM-dd");
            } else if ("day".equalsIgnoreCase(collectionDetailsRequest.getIntervalType())) {
                DateTime date = new DateTime().withYear(Integer.parseInt(collectionDetailsRequest.getYear())).withMonthOfYear(Integer.parseInt(collectionDetailsRequest.getMonth()));
                Calendar cal = date.toCalendar(Locale.getDefault());
                cal.set(7, 2);
                cal.set(4, Integer.parseInt(collectionDetailsRequest.getWeek()));
                DateTime weekStartDate = new DateTime((Object)cal).withMillisOfDay(0);
                startDate = weekStartDate.toString("yyyy-MM-dd");
                Date weekEndDate = DateUtils.addDays((Date)weekStartDate.toDate(), (int)6);
                endDate = PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(weekEndDate);
            }
            if ("week".equalsIgnoreCase(collectionDetailsRequest.getIntervalType()) || "day".equalsIgnoreCase(collectionDetailsRequest.getIntervalType())) {
                collectionDetailsRequest.setFromDate(startDate);
                collectionDetailsRequest.setToDate(endDate);
            }
        }
        Long startTime = System.currentTimeMillis();
        CollectionAnalysis collectionAnalysis = this.propTaxDashboardService.getCollectionAnalysisData(collectionDetailsRequest, collectionDetailsRequest.getIntervalType());
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve collectionanalysis is : " + timeTaken + MILLISECS);
        }
        return collectionAnalysis;
    }

    @RequestMapping(value={"/dailytarget"}, method={RequestMethod.GET}, produces={"application/json"})
    public CollectionDetails getDailyTargetDetails(CollectionDetailsRequest collectionDetailsRequest) throws IOException {
        Long startTime = System.currentTimeMillis();
        CollectionDetails collectionDetails = this.propTaxDashboardService.getDailyTarget(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve dailytarget is : " + timeTaken + MILLISECS);
        }
        return collectionDetails;
    }
}

