/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.bean.PropertyFloorDetailsInfo;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.model.calculator.MiscellaneousTax;
import org.egov.ptis.domain.model.calculator.MiscellaneousTaxDetail;
import org.egov.ptis.domain.model.calculator.TaxCalculationInfo;
import org.egov.ptis.domain.model.calculator.UnitTaxCalculationInfo;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;

public class PropertyInfo {
    private final PropertyImpl property;
    private TaxCalculationInfo taxCalInfo;
    private String noticeNo;
    private ModuleService moduleDao;
    PropertyTaxUtil propertyTaxUtil = new PropertyTaxUtil();
    private static final Logger LOGGER = Logger.getLogger(PropertyInfo.class);
    private static final String PROPERTY_TYPE = "PROPERTY-TYPE";
    private static final String PROPERTY_TYPE_CATEGORY = "PROPERTY-TYPE-CATEGORY";
    private static final String PROPERTY_AMENITY = "PROPERTY-AMENITY";
    private final Set<PropertyFloorDetailsInfo> propertyFloorDetails = new LinkedHashSet();
    private DateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
    private int isCentralGovtProp = 0;
    Map<Date, Map<Installment, TaxCalculationInfo>> installmentAndHistoryTaxCalcsByDate = new TreeMap();
    Map<Date, Map<String, String>> propertyInfoByCreatedDate = new TreeMap();
    @Autowired
    private PtDemandDao ptDemandDAO;
    @PersistenceContext
    private EntityManager entityManager;

    public Set<PropertyFloorDetailsInfo> getPropertyFloorDetails() {
        return this.propertyFloorDetails;
    }

    public PropertyInfo(PropertyImpl property, String noticeNo) {
        TaxCalculationInfo taxCalInfo;
        this.property = property;
        this.noticeNo = noticeNo;
        Ptdemand ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)property);
        this.taxCalInfo = taxCalInfo = this.propertyTaxUtil.getTaxCalInfo(ptDemand);
        Map taxAndMinEffDate = this.getMinEffectiveDateForDmdRsns();
        if (taxCalInfo.getPropertyType() != null && "CENTRAL_GOVT_50".equals(taxCalInfo.getPropertyType())) {
            this.isCentralGovtProp = 1;
        }
    }

    private Date getMinEffectiveDate(String demandReasonCode) throws ParseException {
        Date taxMinEffectiveDate = null;
        Module ptModule = this.moduleDao.getModuleByName("Property Tax");
        List minEffDate = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery("SELECT min(drd.from_date) FROM EG_DEMAND_REASON_DETAILS drd, EG_DEMAND_REASON dr, EG_DEMAND_REASON_MASTER drm WHERE drd.ID_DEMAND_REASON=dr.ID AND dr.ID_DEMAND_REASON_MASTER=drm.ID AND drm.code = ? AND drm.module_id = ?").setString(0, demandReasonCode).setLong(1, ptModule.getId().longValue()).list();
        String dateString = minEffDate.get(0).toString();
        int len = dateString.length();
        String dateInmmDDyyyy = dateString.substring(len - 2, len).concat("/").concat(dateString.substring(len - 5, len - 3)).concat("/").concat(dateString.substring(0, 4));
        taxMinEffectiveDate = this.dateFormatter.parse(dateInmmDDyyyy);
        return taxMinEffectiveDate;
    }

    public PropertyInfo(PropertyImpl property, String noticeNo, Boolean instwiseNoticeReport) {
        this.property = property;
        this.noticeNo = noticeNo;
        Set ptDmdSet = property.getPtDemandSet();
        Map taxAndMinEffDate = this.getMinEffectiveDateForDmdRsns();
        Map taxCalInfoMap = this.getTaxCalInfoMap(ptDmdSet);
        Map unitTaxCalculations = this.getTaxCalInfoList(taxCalInfoMap, property);
        try {
            this.addFloorDtls(taxCalInfoMap, unitTaxCalculations, taxAndMinEffDate);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Error while populating Unit details");
            throw new ApplicationRuntimeException("Error while populating Unit details", (Throwable)e);
        }
    }

    private Map<String, Date> getMinEffectiveDateForDmdRsns() {
        LOGGER.debug((Object)"Entered into getMinEffectiveDateForDmdRsns");
        TreeMap<String, Date> taxAndMinEffDate = new TreeMap<String, Date>();
        String errorMsg = "Error while parsing tax effective dates";
        try {
            taxAndMinEffDate.put("GEN_TAX", this.getMinEffectiveDate("GEN_TAX"));
            taxAndMinEffDate.put("EDU_CESS", this.getMinEffectiveDate("EDU_CESS"));
            taxAndMinEffDate.put("LIB_CESS", this.getMinEffectiveDate("LIB_CESS"));
        }
        catch (ParseException pe) {
            LOGGER.error((Object)errorMsg, (Throwable)pe);
            throw new ApplicationRuntimeException(errorMsg, (Throwable)pe);
        }
        LOGGER.info((Object)("getMinEffectiveDateForDmdRsns: " + taxAndMinEffDate));
        LOGGER.debug((Object)"Exiting from getMinEffectiveDateForDmdRsns");
        return taxAndMinEffDate;
    }

    public PropertyInfo(PropertyImpl property) {
        this.property = property;
    }

    private void addFloorDtls(Map<Installment, TaxCalculationInfo> taxCalcInfos, Map<Installment, Map<Integer, List<UnitTaxCalculationInfo>>> unitTaxCalculations, Map<String, Date> taxAndMinEffDate) throws ParseException {
        String propType = null;
        Boolean isHistoryTaxEffective = false;
        for (Map.Entry<Installment, Map<Integer, List<UnitTaxCalculationInfo>>> mapEntryByInstallment : unitTaxCalculations.entrySet()) {
            TaxCalculationInfo taxCalc;
            LOGGER.info((Object)("addFloorDtls- Installment: " + mapEntryByInstallment.getKey()));
            this.taxCalInfo = taxCalc = taxCalcInfos.get(mapEntryByInstallment.getKey());
            propType = taxCalc.getPropertyType();
            if (this.taxCalInfo.getPropertyType() != null && "CENTRAL_GOVT_50".equals(this.taxCalInfo.getPropertyType())) {
                this.isCentralGovtProp = 1;
            }
            Map unitsByDateUnitNo = this.orderByDate(mapEntryByInstallment.getValue());
            for (Map.Entry entry : unitsByDateUnitNo.entrySet()) {
                for (Map.Entry mapEntryByUnitNo : ((Map)entry.getValue()).entrySet()) {
                    for (UnitTaxCalculationInfo unit : (List)mapEntryByUnitNo.getValue()) {
                        isHistoryTaxEffective = false;
                        Object unitTaxWithAnnualTaxes = null;
                        for (MiscellaneousTax mt : unit.getMiscellaneousTaxes()) {
                            for (MiscellaneousTaxDetail detail : mt.getTaxDetails()) {
                                if (detail.getIsHistory() != null && detail.getIsHistory().equals(PropertyTaxConstants.HISTORY_TAX_DETAIL) && !this.propertyTaxUtil.between(detail.getFromDate(), mapEntryByInstallment.getKey().getFromDate(), mapEntryByInstallment.getKey().getToDate()).booleanValue()) continue;
                            }
                        }
                    }
                }
            }
        }
    }

    private void buildUnitOccupation(String propType, UnitTaxCalculationInfo unit) {
        LOGGER.debug((Object)("Entered into buildUnitOccupation, propType=" + propType));
        StringBuilder occupierName = new StringBuilder();
        if ("VAC_LAND".equals(propType)) {
            if ("OWNER".equals(unit.getUnitOccupation()) || "COMMERCIAL".equals(unit.getUnitOccupation())) {
                occupierName.append(propType);
            } else if ("TENANT".equals(unit.getUnitOccupation())) {
                occupierName.append("OP-" + unit.getUnitOccupier());
            }
        }
        if (!("Vacant Land".equals(propType) || "STATE_GOVT".equals(propType) || "CENTRAL_GOVT_50".equals(propType))) {
            if ("TENANT".equals(unit.getUnitOccupation()) || "OWNER".equals(unit.getUnitOccupation())) {
                occupierName.append("-" + unit.getUnitOccupier());
            } else if ("OWNER".equals(unit.getUnitOccupation()) || "OWNER".equals(unit.getUnitOccupation())) {
                occupierName.append("-" + unit.getUnitOccupation());
            }
        }
        unit.setUnitOccupation(occupierName.toString());
        LOGGER.debug((Object)("occupierName=" + occupierName + "\nExiting from buildUnitOccupation"));
    }

    private Map<Installment, Map<Integer, List<UnitTaxCalculationInfo>>> getTaxCalInfoList(Map<Installment, TaxCalculationInfo> taxCalInfoMap, PropertyImpl property) {
        TreeMap<Installment, Map<Integer, List<UnitTaxCalculationInfo>>> unitTaxCalcsOfInstallment = new TreeMap<Installment, Map<Integer, List<UnitTaxCalculationInfo>>>();
        TreeMap unitwiseAlVMap = new TreeMap();
        TreeMap dateAndTotalCalcTaxByTaxForUnit = new TreeMap();
        Boolean isPropertyModified = PropertyTaxUtil.isPropertyModified((Property)property);
        LOGGER.debug((Object)("getTaxCalInfoList - isPropertyModified : " + isPropertyModified));
        int i = 0;
        HashSet removalMappingKeys = new HashSet();
        HashSet oldRemovalMappingKeys = new HashSet();
        for (Map.Entry<Installment, TaxCalculationInfo> txCalInfo : taxCalInfoMap.entrySet()) {
            TreeMap unitTaxCalculations = new TreeMap();
            TreeMap instUnitwiseAlVMap = new TreeMap();
            oldRemovalMappingKeys = new HashSet();
            for (Integer key : removalMappingKeys) {
                unitwiseAlVMap.remove(key);
            }
            oldRemovalMappingKeys.addAll(removalMappingKeys);
            instUnitwiseAlVMap.putAll(unitwiseAlVMap);
            LOGGER.info((Object)("Installment===> " + txCalInfo.getKey()));
            unitwiseAlVMap.clear();
            removalMappingKeys.clear();
            if (!instUnitwiseAlVMap.isEmpty()) {
                ArrayList<Object> units = new ArrayList<Object>();
                if (isPropertyModified.booleanValue()) {
                    this.addHistoryUnitTax(property, txCalInfo.getKey(), null, units, unitwiseAlVMap);
                    if (!units.isEmpty()) {
                        this.prepareUnitTaxCalcsOfUnitNo(unitTaxCalculations, units);
                        units.clear();
                    }
                }
                for (Map.Entry map : unitwiseAlVMap.entrySet()) {
                    if (instUnitwiseAlVMap.get(map.getKey()) != null) {
                        BigDecimal previousALV = ((UnitTaxCalculationInfo)instUnitwiseAlVMap.get(map.getKey())).getNetARV();
                        BigDecimal currentALV = ((UnitTaxCalculationInfo)map.getValue()).getNetARV();
                        units.clear();
                        List taxNames = new ArrayList();
                        if (isPropertyModified.booleanValue() && this.propertyTaxUtil.between(((UnitTaxCalculationInfo)map.getValue()).getOccpancyDate(), txCalInfo.getKey().getFromDate(), txCalInfo.getKey().getToDate()).booleanValue()) {
                            ((UnitTaxCalculationInfo)map.getValue()).setOccpancyDate(((UnitTaxCalculationInfo)map.getValue()).getOccpancyDate());
                            units.add(this.propertyTaxUtil.getUnitTaxCalculationInfoClone((UnitTaxCalculationInfo)map.getValue()));
                            if (((UnitTaxCalculationInfo)map.getValue()).getOccpancyDate().after(txCalInfo.getKey().getFromDate()) && ((UnitTaxCalculationInfo)map.getValue()).getOccpancyDate().before(txCalInfo.getKey().getToDate()) && ((UnitTaxCalculationInfo)map.getValue()).getTotalTaxPayable().compareTo(((UnitTaxCalculationInfo)instUnitwiseAlVMap.get(map.getKey())).getTotalTaxPayable()) != 0) {
                                LOGGER.info((Object)"Tax Payable dont match");
                                ArrayList singleUnit = new ArrayList();
                                singleUnit.add(map.getValue());
                                taxNames = this.getSlabChangedTaxes(dateAndTotalCalcTaxByTaxForUnit, (UnitTaxCalculationInfo)map.getValue(), isPropertyModified, txCalInfo.getKey());
                                if (!taxNames.isEmpty()) {
                                    LOGGER.info((Object)("Tax Change for Installment: " + txCalInfo.getKey()));
                                    List localUnits = new ArrayList();
                                    localUnits = this.prepareRsnWiseTaxCalInfoList(txCalInfo.getKey(), (UnitTaxCalculationInfo)instUnitwiseAlVMap.get(map.getKey()), (UnitTaxCalculationInfo)map.getValue(), taxNames, isPropertyModified);
                                    this.prepareUnitTaxCalcsOfUnitNo(unitTaxCalculations, localUnits);
                                }
                                taxNames.clear();
                            }
                            if (((UnitTaxCalculationInfo)map.getValue()).getBaseRateEffectiveDate() != null && !((UnitTaxCalculationInfo)map.getValue()).getOccpancyDate().equals(txCalInfo.getKey().getFromDate()) && ((UnitTaxCalculationInfo)map.getValue()).getBaseRateEffectiveDate().equals(((UnitTaxCalculationInfo)map.getValue()).getOccpancyDate())) {
                                removalMappingKeys.add(map.getKey());
                            }
                        } else if (currentALV.compareTo(previousALV) != 0) {
                            LOGGER.info((Object)("ALV Change for Installment: " + txCalInfo.getKey()));
                            if (isPropertyModified.booleanValue() && (((UnitTaxCalculationInfo)map.getValue()).getOccpancyDate().after(txCalInfo.getKey().getFromDate()) || ((UnitTaxCalculationInfo)map.getValue()).getOccpancyDate().equals(txCalInfo.getKey().getFromDate()))) {
                                ((UnitTaxCalculationInfo)map.getValue()).setOccpancyDate(((UnitTaxCalculationInfo)map.getValue()).getOccpancyDate());
                                if (((UnitTaxCalculationInfo)map.getValue()).getBaseRateEffectiveDate().equals(((UnitTaxCalculationInfo)map.getValue()).getOccpancyDate())) {
                                    removalMappingKeys.add(map.getKey());
                                }
                            } else if (((UnitTaxCalculationInfo)map.getValue()).getBaseRateEffectiveDate() == null) {
                                ((UnitTaxCalculationInfo)map.getValue()).setOccpancyDate(txCalInfo.getKey().getFromDate());
                            } else if (((UnitTaxCalculationInfo)map.getValue()).getBaseRateEffectiveDate().before(((UnitTaxCalculationInfo)map.getValue()).getOccpancyDate())) {
                                ((UnitTaxCalculationInfo)map.getValue()).setOccpancyDate(txCalInfo.getKey().getFromDate());
                            } else {
                                ((UnitTaxCalculationInfo)map.getValue()).setOccpancyDate(((UnitTaxCalculationInfo)map.getValue()).getBaseRateEffectiveDate());
                                if (((UnitTaxCalculationInfo)map.getValue()).getBaseRateEffectiveDate().after(txCalInfo.getKey().getFromDate()) && ((UnitTaxCalculationInfo)map.getValue()).getBaseRateEffectiveDate().before(txCalInfo.getKey().getToDate())) {
                                    removalMappingKeys.add(map.getKey());
                                }
                            }
                            units.add(map.getValue());
                        } else if (((UnitTaxCalculationInfo)map.getValue()).getTotalTaxPayable().compareTo(((UnitTaxCalculationInfo)instUnitwiseAlVMap.get(map.getKey())).getTotalTaxPayable()) != 0) {
                            LOGGER.info((Object)"Tax Payable dont match / Total Tax of a Misc Tax dont match");
                            taxNames = this.getSlabChangedTaxes(dateAndTotalCalcTaxByTaxForUnit, (UnitTaxCalculationInfo)map.getValue(), isPropertyModified, txCalInfo.getKey());
                            if (!taxNames.isEmpty()) {
                                LOGGER.info((Object)("Tax Change for Installment: " + txCalInfo.getKey()));
                                units.add(map.getValue());
                                List localUnits = new ArrayList();
                                localUnits = this.prepareRsnWiseTaxCalInfoList(txCalInfo.getKey(), (UnitTaxCalculationInfo)instUnitwiseAlVMap.get(map.getKey()), (UnitTaxCalculationInfo)map.getValue(), taxNames, isPropertyModified);
                                this.prepareUnitTaxCalcsOfUnitNo(unitTaxCalculations, localUnits);
                            }
                        }
                        if (units.isEmpty()) continue;
                        this.prepareUnitTaxCalcsOfUnitNo(unitTaxCalculations, units);
                        this.getTaxSlabs(dateAndTotalCalcTaxByTaxForUnit, units, taxNames, txCalInfo.getKey());
                        continue;
                    }
                    ArrayList tmpUnits = new ArrayList();
                    if (oldRemovalMappingKeys.contains(map.getKey())) continue;
                    tmpUnits.add(map.getValue());
                    List emptyStringList = Collections.emptyList();
                    this.getTaxSlabs(dateAndTotalCalcTaxByTaxForUnit, tmpUnits, emptyStringList, txCalInfo.getKey());
                    this.prepareUnitTaxCalcsOfUnitNo(unitTaxCalculations, tmpUnits);
                }
            }
            LOGGER.info((Object)("no of units addedd to " + txCalInfo.getKey() + "are " + unitTaxCalculations.size()));
            unitTaxCalcsOfInstallment.put(txCalInfo.getKey(), unitTaxCalculations);
            ++i;
        }
        return unitTaxCalcsOfInstallment;
    }

    private void addHistoryUnitTax(PropertyImpl property, Installment installment, UnitTaxCalculationInfo unit, List<UnitTaxCalculationInfo> units, Map<Integer, UnitTaxCalculationInfo> unitsByUnitNo) {
        LOGGER.debug((Object)"Entered into addHistoryUnitTax");
        LOGGER.debug((Object)("addHistoryUnitTax - units : " + units.size() + ", installment=" + installment));
        TreeMap<Date, Property> historyProperties = new TreeMap<Date, Property>();
        for (Property historyProperty : property.getBasicProperty().getPropertySet()) {
            Date effectiveDate;
            Date date = effectiveDate = historyProperty.getPropertyDetail().getDateOfCompletion() == null ? historyProperty.getEffectiveDate() : historyProperty.getPropertyDetail().getDateOfCompletion();
            if (!PropertyTaxConstants.STATUS_ISHISTORY.equals(historyProperty.getStatus()) || !this.propertyTaxUtil.between(effectiveDate, installment.getFromDate(), installment.getToDate()).booleanValue()) continue;
            historyProperties.put(historyProperty.getCreatedDate(), historyProperty);
        }
        LOGGER.info((Object)("addHistoryUnitTax - No of histories : " + historyProperties.size()));
        TreeMap taxCalcInfoAndInstallment = null;
        Boolean isAddUnit = Boolean.FALSE;
        for (Map.Entry historyPropertyByDate : historyProperties.entrySet()) {
            taxCalcInfoAndInstallment = new TreeMap();
            Property historyProperty = (Property)historyPropertyByDate.getValue();
            for (Ptdemand ptDemand : historyProperty.getPtDemandSet()) {
                if (!ptDemand.getEgInstallmentMaster().equals((Object)installment)) continue;
                TaxCalculationInfo taxCalculationInfo = this.propertyTaxUtil.getTaxCalInfo(ptDemand);
            }
        }
        LOGGER.info((Object)("addHistoryUnitTax - units : " + units.size()));
        LOGGER.debug((Object)"Exiting addHistoryUnitTax");
    }

    private void getPropertyInfo(Property historyProperty, Installment installment, TaxCalculationInfo taxCalcInfo, Date propCreatedDate, Map<Installment, TaxCalculationInfo> taxCalcInfoAndInstallment) {
        HashMap<String, String> propertyInfo = new HashMap<String, String>();
        propertyInfo.put(PROPERTY_TYPE, historyProperty.getPropertyDetail().getPropertyTypeMaster().getCode());
        taxCalcInfoAndInstallment.put(installment, taxCalcInfo);
        this.installmentAndHistoryTaxCalcsByDate.put(propCreatedDate, taxCalcInfoAndInstallment);
        this.propertyInfoByCreatedDate.put(propCreatedDate, propertyInfo);
    }

    private boolean isNewTaxExists(UnitTaxCalculationInfo prevUnitTax, UnitTaxCalculationInfo currentUnitTax) {
        return currentUnitTax.getMiscellaneousTaxes().size() > prevUnitTax.getMiscellaneousTaxes().size();
    }

    private boolean checkIsUnitHasMultpleTaxSlab(UnitTaxCalculationInfo unittaxCalInfo) {
        for (MiscellaneousTax tax : unittaxCalInfo.getMiscellaneousTaxes()) {
            if (tax.getTaxDetails().size() <= 1) continue;
            return true;
        }
        return false;
    }

    private List<UnitTaxCalculationInfo> getNewTaxDetails(UnitTaxCalculationInfo prevUnitTax, UnitTaxCalculationInfo currentUnitTax) {
        HashSet<String> prevDemandReasons = new HashSet<String>();
        HashMap<Date, UnitTaxCalculationInfo> unitsByNewTaxDate = new HashMap<Date, UnitTaxCalculationInfo>();
        for (MiscellaneousTax miscTax : prevUnitTax.getMiscellaneousTaxes()) {
            prevDemandReasons.add(miscTax.getTaxName());
        }
        block1: for (MiscellaneousTax miscTax : currentUnitTax.getMiscellaneousTaxes()) {
            if (prevDemandReasons.contains(miscTax.getTaxName())) continue;
            Date taxFromDate = ((MiscellaneousTaxDetail)miscTax.getTaxDetails().get(0)).getFromDate();
            miscTax.setHasChanged(Boolean.valueOf(true));
            UnitTaxCalculationInfo unitTaxClone = this.propertyTaxUtil.getUnitTaxCalculationInfoClone(currentUnitTax);
            miscTax.setHasChanged(Boolean.valueOf(false));
            unitTaxClone.setOccpancyDate(taxFromDate);
            if (unitsByNewTaxDate.get(taxFromDate) == null) {
                unitsByNewTaxDate.put(taxFromDate, unitTaxClone);
                continue;
            }
            UnitTaxCalculationInfo unit = (UnitTaxCalculationInfo)unitsByNewTaxDate.get(taxFromDate);
            for (MiscellaneousTax tax : unit.getMiscellaneousTaxes()) {
                if (!miscTax.getTaxName().equals(tax.getTaxName())) continue;
                tax.setHasChanged(Boolean.valueOf(true));
                continue block1;
            }
        }
        return new ArrayList<UnitTaxCalculationInfo>(unitsByNewTaxDate.values());
    }

    private void getTaxSlabs(Map<Integer, Map<String, Map<Date, BigDecimal>>> dateAndTotalCalcTaxByTaxForUnit, List<UnitTaxCalculationInfo> unitTaxes, List<String> taxNames, Installment installment) {
        LOGGER.debug((Object)"Entered into getTaxSlabs");
        LOGGER.debug((Object)("getTaxSlabs - dateAndPercentageByTaxForUnit: " + dateAndTotalCalcTaxByTaxForUnit));
        LOGGER.debug((Object)("getTaxSlabs - taxNames: " + taxNames));
        for (UnitTaxCalculationInfo unitTax : unitTaxes) {
            TreeMap dateAndPercentageByTax;
            Map<String, Map<Object, Serializable>> map = dateAndPercentageByTax = dateAndTotalCalcTaxByTaxForUnit.get(unitTax.getFloorNumber()) == null ? new TreeMap() : dateAndTotalCalcTaxByTaxForUnit.get(unitTax.getFloorNumber());
            if (taxNames.isEmpty()) {
                block1: for (MiscellaneousTax mt1 : unitTax.getMiscellaneousTaxes()) {
                    TreeMap<Date, BigDecimal> dateAndPercentage1 = new TreeMap<Date, BigDecimal>();
                    for (MiscellaneousTaxDetail mtd : mt1.getTaxDetails()) {
                        if (mtd.getIsHistory() != null && !mtd.getIsHistory().equals(Character.valueOf('N'))) continue;
                        dateAndPercentage1.put(mtd.getFromDate(), mtd.getCalculatedTaxValue());
                        dateAndPercentageByTax.put(mt1.getTaxName(), dateAndPercentage1);
                        continue block1;
                    }
                }
            } else {
                block3: for (MiscellaneousTax mt2 : unitTax.getMiscellaneousTaxes()) {
                    if (!taxNames.contains(mt2.getTaxName())) continue;
                    TreeMap<Date, BigDecimal> dateAndPercentage2 = new TreeMap<Date, BigDecimal>();
                    for (MiscellaneousTaxDetail mtd : mt2.getTaxDetails()) {
                        if (mtd.getIsHistory() != null && !mtd.getIsHistory().equals(Character.valueOf('N'))) continue;
                        dateAndPercentage2.put(mtd.getFromDate(), mtd.getCalculatedTaxValue());
                        dateAndPercentageByTax.put(mt2.getTaxName(), dateAndPercentage2);
                        continue block3;
                    }
                }
            }
            dateAndTotalCalcTaxByTaxForUnit.put(Integer.valueOf(unitTax.getFloorNumber()), dateAndPercentageByTax);
        }
        LOGGER.debug((Object)("Exiting from getTaxSlabs - dateAndPercentageByTaxForUnit: " + dateAndTotalCalcTaxByTaxForUnit));
    }

    private List<String> getSlabChangedTaxes(Map<Integer, Map<String, Map<Date, BigDecimal>>> dateAndTotalCalcTaxByTaxForUnit, UnitTaxCalculationInfo unitTax, Boolean isPropertyModified, Installment installment) {
        LOGGER.debug((Object)"Entered into getSlabChangedTaxes");
        LOGGER.debug((Object)("getSlabChangedTaxes - dateAndPercentageByTaxForUnit: " + dateAndTotalCalcTaxByTaxForUnit));
        LOGGER.debug((Object)("getSlabChangedTaxes - UnitNumber : " + unitTax.getFloorNumber()));
        Map<String, Map<Date, BigDecimal>> taxAndListOfMapsOfDateAndPercentage = dateAndTotalCalcTaxByTaxForUnit.get(unitTax.getFloorNumber());
        ArrayList<String> taxNames = new ArrayList<String>();
        if (taxAndListOfMapsOfDateAndPercentage != null) {
            for (MiscellaneousTax tax : unitTax.getMiscellaneousTaxes()) {
                Map<Date, BigDecimal> taxDateAndPercentages = taxAndListOfMapsOfDateAndPercentage.get(tax.getTaxName());
                if (taxDateAndPercentages == null) continue;
                for (MiscellaneousTaxDetail mtd : tax.getTaxDetails()) {
                    if (mtd.getIsHistory() != null && !PropertyTaxConstants.NON_HISTORY_TAX_DETAIL.equals(mtd.getIsHistory()) || taxDateAndPercentages.get(((MiscellaneousTaxDetail)tax.getTaxDetails().get(0)).getFromDate()) != null) continue;
                    taxNames.add(tax.getTaxName());
                }
            }
        }
        LOGGER.debug((Object)("getSlabChangedTaxes - slab changed taxes : " + taxNames));
        LOGGER.debug((Object)"Exiting from getSlabChangedTaxes");
        return taxNames;
    }

    public void prepareUnitTaxCalcsOfUnitNo(Map<Integer, List<UnitTaxCalculationInfo>> unitTaxesMap, List<UnitTaxCalculationInfo> units) {
        LOGGER.debug((Object)("prepareUnitTaxCalcsOfUnitNo, map keys: " + unitTaxesMap.keySet()));
        LOGGER.debug((Object)("map size: " + unitTaxesMap.size()));
        for (UnitTaxCalculationInfo unit : units) {
            if (unitTaxesMap.get(unit.getFloorNumber()) == null) {
                ArrayList<UnitTaxCalculationInfo> tmpList = new ArrayList<UnitTaxCalculationInfo>();
                tmpList.add(unit);
                unitTaxesMap.put(Integer.valueOf(unit.getFloorNumber()), tmpList);
                continue;
            }
            unitTaxesMap.get(unit.getFloorNumber()).add(unit);
        }
        LOGGER.debug((Object)("prepareUnitTaxCalcsOfUnitNo, map keys: " + unitTaxesMap.keySet()));
        LOGGER.debug((Object)("map size: " + unitTaxesMap.size()));
        LOGGER.debug((Object)"Exit from prepareUnitTaxCalcsOfUnitNo");
    }

    public String getLeastEffectiveDate(UnitTaxCalculationInfo unitTax, Installment installment) {
        Date tempDate = null;
        for (MiscellaneousTax misTax : unitTax.getMiscellaneousTaxes()) {
            Date taxEffectiveDate = this.getLeastEffectiveDate(misTax);
            if (tempDate != null && !taxEffectiveDate.before(tempDate)) continue;
            tempDate = taxEffectiveDate;
        }
        return DateUtils.getDefaultFormattedDate(tempDate);
    }

    private Date getLeastEffectiveDate(MiscellaneousTax misTax) {
        Date taxEffectiveDate = null;
        for (MiscellaneousTaxDetail taxDetail : misTax.getTaxDetails()) {
            if (taxEffectiveDate != null && !taxDetail.getFromDate().before(taxEffectiveDate)) continue;
            taxEffectiveDate = taxDetail.getFromDate();
        }
        return taxEffectiveDate;
    }

    private Date getGreatestEffectiveDate(MiscellaneousTax misTax) {
        Date taxEffectiveDate = null;
        for (MiscellaneousTaxDetail taxDetail : misTax.getTaxDetails()) {
            if (taxEffectiveDate != null && !taxDetail.getFromDate().after(taxEffectiveDate)) continue;
            taxEffectiveDate = taxDetail.getFromDate();
        }
        return taxEffectiveDate;
    }

    private List<UnitTaxCalculationInfo> prepareRsnWiseTaxCalInfoList(Installment installment, UnitTaxCalculationInfo prevUnitTax, UnitTaxCalculationInfo currentUnitTax, List<String> changedTaxNames, Boolean isPropertyModified) {
        List prevMiscTaxes = prevUnitTax.getMiscellaneousTaxes();
        List currentMiscTaxes = currentUnitTax.getMiscellaneousTaxes();
        ArrayList<UnitTaxCalculationInfo> unitTaxCalcs = new ArrayList<UnitTaxCalculationInfo>();
        TreeMap unitTaxForChangeInTaxByDate = new TreeMap();
        ArrayList<String> prevTaxNames = new ArrayList<String>();
        for (MiscellaneousTax mt : prevMiscTaxes) {
            prevTaxNames.add(mt.getTaxName());
        }
        Boolean isModificationBetInstallment = this.propertyTaxUtil.between(currentUnitTax.getOccpancyDate(), installment.getFromDate(), installment.getToDate()) != false;
        Date taxEffectiveDate = null;
        for (MiscellaneousTax currentMiscTax : currentMiscTaxes) {
            Boolean dmdRsnExists = prevTaxNames.contains(currentMiscTax.getTaxName());
            if (currentMiscTax.getTaxDetails().size() != 1) continue;
            taxEffectiveDate = ((MiscellaneousTaxDetail)currentMiscTax.getTaxDetails().get(0)).getFromDate();
            if (dmdRsnExists.booleanValue()) {
                if (!changedTaxNames.contains(currentMiscTax.getTaxName())) continue;
                LOGGER.info((Object)(currentMiscTax.getTaxName() + " has changed, " + " for installment: " + installment + ", EffecDate: " + taxEffectiveDate));
                if (isPropertyModified.booleanValue() && isModificationBetInstallment.booleanValue() && currentUnitTax.getOccpancyDate().before(taxEffectiveDate)) {
                    currentUnitTax.setOccpancyDate(currentUnitTax.getOccpancyDate());
                } else {
                    currentMiscTax.setHasChanged(Boolean.valueOf(true));
                    currentUnitTax.setOccpancyDate(taxEffectiveDate);
                }
                this.putUnitTaxInMapByDate(currentUnitTax, unitTaxForChangeInTaxByDate, taxEffectiveDate, currentMiscTax, isPropertyModified, isModificationBetInstallment);
                currentMiscTax.setHasChanged(Boolean.valueOf(false));
                continue;
            }
            if (!this.propertyTaxUtil.between(taxEffectiveDate, installment.getFromDate(), installment.getToDate()).booleanValue()) continue;
            currentMiscTax.setHasChanged(Boolean.valueOf(true));
            currentUnitTax.setOccpancyDate(taxEffectiveDate);
            this.putUnitTaxInMapByDate(currentUnitTax, unitTaxForChangeInTaxByDate, taxEffectiveDate, currentMiscTax, isPropertyModified, isModificationBetInstallment);
            currentMiscTax.setHasChanged(Boolean.valueOf(false));
        }
        unitTaxCalcs.addAll(unitTaxForChangeInTaxByDate.values());
        return unitTaxCalcs;
    }

    private void putUnitTaxInMapByDate(UnitTaxCalculationInfo currentUnitTax, Map<Date, UnitTaxCalculationInfo> unitTaxForChangeInTaxByDate, Date taxEffectiveDate, MiscellaneousTax currentMiscTax, Boolean isPropertyModified, Boolean isModificationBetInstallment) {
        Date mayKey = null;
        mayKey = currentUnitTax.getOccpancyDate();
        if (unitTaxForChangeInTaxByDate.get(mayKey) == null) {
            unitTaxForChangeInTaxByDate.put(mayKey, this.propertyTaxUtil.getUnitTaxCalculationInfoClone(currentUnitTax));
        } else {
            for (MiscellaneousTax mt : unitTaxForChangeInTaxByDate.get(mayKey).getMiscellaneousTaxes()) {
                if (!mt.getTaxName().equals(currentMiscTax.getTaxName())) continue;
                mt.setHasChanged(Boolean.valueOf(true));
                break;
            }
            LOGGER.info((Object)("multiple miscTax change for date " + mayKey + unitTaxForChangeInTaxByDate.get(mayKey).getMiscellaneousTaxes()));
        }
    }

    private void updateTax(String taxName, MiscellaneousTaxDetail taxDetail, List<MiscellaneousTax> miscTaxes) {
        LOGGER.info((Object)("miscTaxes: " + miscTaxes));
        for (MiscellaneousTax tax : miscTaxes) {
            if (!tax.getTaxName().equals(taxName)) continue;
            tax.getTaxDetails().clear();
            tax.addMiscellaneousTaxDetail(taxDetail);
        }
    }

    public Map<Installment, TaxCalculationInfo> getTaxCalInfoMap(Set<Ptdemand> ptDmdSet) {
        TreeMap<Installment, TaxCalculationInfo> taxCalInfoMap = new TreeMap<Installment, TaxCalculationInfo>();
        for (Ptdemand ptdmd : ptDmdSet) {
            TaxCalculationInfo taxCalcInfo = this.propertyTaxUtil.getTaxCalInfo(ptdmd);
            if (taxCalcInfo == null) continue;
            taxCalInfoMap.put(ptdmd.getEgInstallmentMaster(), taxCalcInfo);
        }
        return taxCalInfoMap;
    }

    public Date getApprovalDate() {
        if (!this.property.getBasicProperty().getPropertyMutations().isEmpty()) {
            return this.property.getCreatedDate();
        }
        return null;
    }

    public String getNewOwnerName() {
        if (!this.property.getBasicProperty().getPropertyMutations().isEmpty()) {
            return this.property.getBasicProperty().getFullOwnerName();
        }
        return "";
    }

    public int getNoOfTenants() {
        int tenants = 0;
        if (this.taxCalInfo.getUnitTaxCalculationInfos().get(0) instanceof List) {
            for (UnitTaxCalculationInfo unit : this.taxCalInfo.getUnitTaxCalculationInfos()) {
                if (!"TENANT".equals(unit.getUnitOccupation())) continue;
                ++tenants;
            }
        } else {
            for (int i = 0; i < this.taxCalInfo.getUnitTaxCalculationInfos().size(); ++i) {
                UnitTaxCalculationInfo unit = (UnitTaxCalculationInfo)this.taxCalInfo.getUnitTaxCalculationInfos().get(i);
                if (!"TENANT".equals(unit.getUnitOccupation())) continue;
                ++tenants;
            }
        }
        return tenants;
    }

    public Date getTransferDate() {
        Set propMutSet = this.property.getBasicProperty().getPropertyMutations();
        if (propMutSet.isEmpty()) {
            return null;
        }
        TreeSet<Date> mutationDates = new TreeSet<Date>();
        for (PropertyMutation propertyMutation : propMutSet) {
            mutationDates.add(propertyMutation.getCreatedDate());
        }
        return (Date)mutationDates.last();
    }

    public BigDecimal getTotalTax() {
        return this.taxCalInfo.getTotalTaxPayable();
    }

    public BigDecimal getTotalALV() {
        return this.taxCalInfo.getTotalNetARV();
    }

    public String getPropertyNo() {
        return this.taxCalInfo.getPropertyId();
    }

    public String getHouseNo() {
        return this.taxCalInfo.getHouseNumber();
    }

    private String getWardNumber() {
        return this.property.getBasicProperty().getBoundary().getBoundaryNum().toString();
    }

    public String getWardNo() {
        return StringUtils.leftPad((String)this.getWardNumber(), (int)3, (char)'0');
    }

    public String getZoneNo() {
        return StringUtils.leftPad((String)this.property.getBasicProperty().getBoundary().getParent().getBoundaryNum().toString(), (int)2, (char)'0');
    }

    public String getWardName() {
        return this.getWardNumber() + "-" + this.taxCalInfo.getWard();
    }

    public String getZoneName() {
        return this.taxCalInfo.getZone();
    }

    public String getStreet() {
        return this.getOwnerAddress();
    }

    public String getOwnerName() {
        return this.taxCalInfo.getPropertyOwnerName();
    }

    public String getOwnerAddress() {
        return this.taxCalInfo.getPropertyAddress().concat(", Chennai");
    }

    public String getCompleteAddress() {
        StringBuilder completeAddr = new StringBuilder();
        completeAddr.append(this.getOwnerName());
        completeAddr.append("\n");
        completeAddr.append(this.getOwnerAddress());
        return completeAddr.toString();
    }

    public String getNoticeNo() {
        return this.noticeNo;
    }

    public String getNoticeDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
        return sdf.format(new Date());
    }

    public String getPropertyType() {
        return this.taxCalInfo.getPropertyType();
    }

    public int getIsCentralGovtProp() {
        return this.isCentralGovtProp;
    }

    public void setIsCentralGovtProp(int isCentralGovtProp) {
        this.isCentralGovtProp = isCentralGovtProp;
    }

    private void getTotalTaxForMiscTax(Map<Integer, Map<String, BigDecimal>> miscTaxAndTotalTaxForUnit, List<UnitTaxCalculationInfo> unitTaxes) {
        LOGGER.info((Object)"Entered into getTotalTaxForMiscTax");
        LOGGER.info((Object)("getTotalTaxForMiscTax - miscTaxAndTotalTaxForUnit: " + miscTaxAndTotalTaxForUnit));
        if (miscTaxAndTotalTaxForUnit.isEmpty()) {
            for (UnitTaxCalculationInfo unit : unitTaxes) {
                HashMap<String, BigDecimal> miscTaxAndTotalTax = new HashMap<String, BigDecimal>();
                for (MiscellaneousTax miscTax : unit.getMiscellaneousTaxes()) {
                    miscTaxAndTotalTax.put(miscTax.getTaxName(), miscTax.getTotalCalculatedTax());
                }
                miscTaxAndTotalTaxForUnit.put(Integer.valueOf(unit.getFloorNumber()), miscTaxAndTotalTax);
            }
        } else {
            for (UnitTaxCalculationInfo unit : unitTaxes) {
                HashMap<String, BigDecimal> miscTaxAndTotalTax = miscTaxAndTotalTaxForUnit.get(unit.getFloorNumber()) == null ? new HashMap<String, BigDecimal>() : miscTaxAndTotalTaxForUnit.get(unit.getFloorNumber());
                for (MiscellaneousTax miscTax : unit.getMiscellaneousTaxes()) {
                    miscTaxAndTotalTax.put(miscTax.getTaxName(), miscTax.getTotalCalculatedTax());
                }
                miscTaxAndTotalTaxForUnit.put(Integer.valueOf(unit.getFloorNumber()), miscTaxAndTotalTax);
            }
        }
        LOGGER.info((Object)("getTotalTaxForMiscTax - miscTaxAndTotalTaxForUnit: " + miscTaxAndTotalTaxForUnit));
        LOGGER.info((Object)"Exiting from getTotalTaxForMiscTax");
    }

    private Boolean hasAnyTotalTaxChangedForTaxes(Map<Integer, Map<String, BigDecimal>> miscTaxAndTotalTaxForUnit, UnitTaxCalculationInfo unitTax) {
        LOGGER.info((Object)"Entered into hasAnyTotalTaxChangedForTaxes");
        Map<String, BigDecimal> miscTaxAndTotalTax = miscTaxAndTotalTaxForUnit.get(unitTax.getFloorNumber());
        if (miscTaxAndTotalTax == null) {
            return true;
        }
        for (MiscellaneousTax miscTax : unitTax.getMiscellaneousTaxes()) {
            if (miscTax.getTotalCalculatedTax().equals(miscTaxAndTotalTax.get(miscTax.getTaxName()))) continue;
            LOGGER.info((Object)("hasAnyTotalTaxChangedForTaxes - " + miscTax.getTaxName() + "'s Total Tax is not matching..."));
            return true;
        }
        return false;
    }

    private Boolean isUnitHasHistoryTaxDetails(UnitTaxCalculationInfo unitTax) {
        LOGGER.debug((Object)"Entered into isUnitHasHistoryTaxDetails");
        for (MiscellaneousTax miscTax : unitTax.getMiscellaneousTaxes()) {
            for (MiscellaneousTaxDetail miscTaxDetail : miscTax.getTaxDetails()) {
                if (miscTaxDetail.getIsHistory() == null) {
                    return false;
                }
                if (!miscTaxDetail.getIsHistory().equals(Character.valueOf('Y')) && !miscTaxDetail.getIsHistory().equals(Character.valueOf('1'))) continue;
                return true;
            }
        }
        LOGGER.debug((Object)"Exiting from isUnitHasHistoryTaxDetails");
        return false;
    }

    private Map<Date, Map<Integer, List<UnitTaxCalculationInfo>>> orderByDate(Map<Integer, List<UnitTaxCalculationInfo>> unitsByUnitNo) throws ParseException {
        LOGGER.debug((Object)"Entered into orderByDate");
        TreeMap<Date, Map<Integer, List<UnitTaxCalculationInfo>>> unitTaxesByDateUnitNo = new TreeMap<Date, Map<Integer, List<UnitTaxCalculationInfo>>>();
        for (Map.Entry<Integer, List<UnitTaxCalculationInfo>> mapEntry : unitsByUnitNo.entrySet()) {
            for (UnitTaxCalculationInfo unit : mapEntry.getValue()) {
                Date date = unit.getOccpancyDate();
                if (unitTaxesByDateUnitNo.get(date) == null) {
                    TreeMap unByUnitNo = new TreeMap();
                    ArrayList<UnitTaxCalculationInfo> units = new ArrayList<UnitTaxCalculationInfo>();
                    units.add(unit);
                    unByUnitNo.put(mapEntry.getKey(), units);
                    unitTaxesByDateUnitNo.put(date, unByUnitNo);
                    continue;
                }
                if (((Map)unitTaxesByDateUnitNo.get(date)).get(mapEntry.getKey()) == null) {
                    ArrayList<UnitTaxCalculationInfo> units = new ArrayList<UnitTaxCalculationInfo>();
                    units.add(unit);
                    ((Map)unitTaxesByDateUnitNo.get(date)).put(mapEntry.getKey(), units);
                    continue;
                }
                ((List)((Map)unitTaxesByDateUnitNo.get(date)).get(mapEntry.getKey())).add(unit);
            }
        }
        LOGGER.debug((Object)"Entered into orderByDate");
        return unitTaxesByDateUnitNo;
    }

    public String getAssessmentDate() {
        return this.dateFormatter.format(this.property.getBasicProperty().getPropOccupationDate());
    }
}

