/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.bean;

import java.util.ArrayList;
import java.util.List;
import org.egov.ptis.client.model.ConsolidatedUnitTaxCalReport;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyID;

public class PropertyCalSheetInfo {
    private Property activeProperty;
    private BasicProperty basicProperty;
    private List<ConsolidatedUnitTaxCalReport> consolidatedUnitTaxCalReportList = new ArrayList();

    public PropertyCalSheetInfo() {
    }

    public PropertyCalSheetInfo(Property activeProperty) {
        this.activeProperty = activeProperty;
        this.basicProperty = activeProperty.getBasicProperty();
    }

    public static PropertyCalSheetInfo createCalSheetInfo(Property activeProperty) {
        return new PropertyCalSheetInfo(activeProperty);
    }

    public String getIndexNo() {
        return this.basicProperty.getUpicNo();
    }

    public String getParcelId() {
        return this.basicProperty.getGisReferenceNo();
    }

    public String getWard() {
        return this.getPropertyID().getArea().getId().toString();
    }

    public String getHouseNumber() {
        return this.basicProperty.getAddress().getHouseNoBldgApt();
    }

    public String getPropertyType() {
        return "";
    }

    public String getArea() {
        return this.getPropertyID().getArea().getId().toString();
    }

    public String getPropertyOwnerName() {
        return this.basicProperty.getFullOwnerName();
    }

    private PropertyID getPropertyID() {
        return this.basicProperty.getPropertyID();
    }

    public String getPropertyAddress() {
        return this.basicProperty.getAddress().toString();
    }

    public List<ConsolidatedUnitTaxCalReport> getConsolidatedUnitTaxCalReportList() {
        return this.consolidatedUnitTaxCalReportList;
    }

    public void setConsolidatedUnitTaxCalReportList(List<ConsolidatedUnitTaxCalReport> consolidatedUnitTaxCalReportList) {
        this.consolidatedUnitTaxCalReportList = consolidatedUnitTaxCalReportList;
    }
}

