/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.search;

import com.opensymphony.xwork2.validator.annotations.Validations;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.ptis.actions.common.CommonServices;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.property.PropertyMaterlizeView;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Validations
@Namespace(value="/search")
public class GisSearchPropertyAction
extends BaseFormAction {
    private static final long serialVersionUID = -5684216227835693553L;
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private Long zoneId;
    private Integer wardId;
    private Integer areaId;
    private String mode;
    private String houseNum;
    private String ownerName;
    private Integer propTypeId;
    private BigDecimal demandFromAmt;
    private BigDecimal demandToAmt;
    private BigDecimal defaulterFromAmt;
    private BigDecimal defaulterToAmt;
    private List<Map<String, String>> searchResultList;
    private String searchUri;
    private String searchCreteria;
    private String searchValue;
    List<Map<String, String>> searchList = new ArrayList();
    private String SESSION;
    private String searchResultString;
    private String gisVersion;
    private String gisCity;
    private Map<Long, String> ZoneBndryMap;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private PropertyTypeMasterDAO propertyTypeMasterDAO;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    private PtDemandDao ptDemandDAO;

    public Object getModel() {
        return null;
    }

    @SkipValidation
    public void gisFormRedirect() {
        this.LOGGER.debug((Object)"Entered into gisFormRedirect method : GISVERSION : /mapguide/ GISCITY : nmc");
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            response.sendRedirect(response.encodeRedirectURL("/mapguide/nmc/ajaxtiledviewersample.jsp?DomainName=nmc&mode=PTIS"));
        }
        catch (IOException e) {
            this.LOGGER.error((Object)"Exception in Gis Search Property : ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception : " + e);
        }
        this.LOGGER.debug((Object)"Exit from gisFormRedirect method");
    }

    @SkipValidation
    @Action(value="/gisSearchProperty-gisSearchForm", results={@Result(name={"new"}, location="/gisSearchProperty-new.jsp")})
    public String gisSearchForm() {
        this.LOGGER.debug((Object)"Entered into gisSearchForm method");
        String target = null;
        this.setSESSION(this.getSESSION());
        this.setGisCity("nmc");
        this.setGisVersion("/mapguide/");
        target = "bndry";
        if (StringUtils.equals((String)this.mode, (String)"bndry")) {
            target = "bndry";
        } else if (StringUtils.equals((String)this.mode, (String)"propType")) {
            target = "propType";
        } else if (StringUtils.equals((String)this.mode, (String)"demand")) {
            target = "demand";
        } else if (StringUtils.equals((String)this.mode, (String)"defaulter")) {
            target = "defaulter";
        }
        this.LOGGER.debug((Object)"Exit from gisSearchForm method");
        return target;
    }

    @ValidationErrorPage(value="bndry")
    public String srchByBndry() {
        this.LOGGER.debug((Object)"Entered into srchByBndry method");
        this.LOGGER.debug((Object)("srchByBndry : Zone Id : " + this.zoneId + ", " + "ward Id: " + this.wardId + ", " + "House Num : " + this.houseNum + ", " + "Owner Name :" + this.ownerName + ", " + "Session : " + this.SESSION));
        String strZoneNum = this.boundaryService.getBoundaryById(this.zoneId).getName();
        String strWardNum = "";
        String target = null;
        if (this.zoneId != null && this.zoneId != -1L) {
            try {
                List propertyList;
                StringBuilder queryStr = new StringBuilder();
                queryStr.append("from PropertyMaterlizeView pmv where pmv.zone.id=:ZoneID and pmv.isActive = true");
                if (this.wardId != null && this.wardId != -1) {
                    queryStr.append(" and pmv.ward.id=:WardID");
                }
                if (this.areaId != null && this.areaId != -1) {
                    queryStr.append(" and pmv.street.id=:AreaID");
                }
                if (this.houseNum != null && !this.houseNum.trim().isEmpty()) {
                    queryStr.append(" and pmv.houseNo like :houseNum");
                }
                if (this.ownerName != null && !this.ownerName.trim().isEmpty()) {
                    queryStr.append(" and trim(pmv.ownerName) like :OwnerName");
                }
                Query query = this.getPersistenceService().getSession().createQuery(queryStr.toString());
                if (this.zoneId != null && this.zoneId != -1L) {
                    query.setLong("ZoneID", this.zoneId.longValue());
                }
                if (this.wardId != null && this.wardId != -1) {
                    query.setInteger("WardID", this.wardId.intValue());
                }
                if (this.areaId != null && this.areaId != -1) {
                    query.setInteger("AreaID", this.areaId.intValue());
                }
                if (this.houseNum != null && !this.houseNum.trim().isEmpty()) {
                    query.setString("houseNum", this.houseNum + "%");
                }
                if (this.ownerName != null && !this.ownerName.trim().isEmpty()) {
                    query.setString("OwnerName", this.ownerName + "%");
                }
                if ((propertyList = query.list()).size() < 0) {
                    this.setSESSION(this.getSESSION());
                    this.setMode("bndry");
                    target = "nodtls";
                }
                int count = 0;
                for (PropertyMaterlizeView propMatview : propertyList) {
                    this.LOGGER.debug((Object)("srchByBndry : Property : " + propMatview));
                    if (count > 10) break;
                    this.setSearchResultList(this.getResultsFromMv(propMatview));
                    ++count;
                }
                if (this.searchResultList != null) {
                    this.setSearchResultString(this.getSearchResultsString(this.searchResultList));
                }
                this.setSearchUri("../search/searchProperty!srchByBndryForm.action");
                this.setSearchCreteria("Search By Zone, Ward,Area, Plot No/House No,Owner Name");
                this.setSearchValue("Zone Num: " + strZoneNum + ", Ward Num: " + "" + ", Plot No/House No: " + this.houseNum);
                this.LOGGER.debug((Object)("Search Criteria : " + this.getSearchCreteria()));
                this.LOGGER.debug((Object)("Search Value : " + this.getSearchValue()));
                this.setSESSION(this.getSESSION());
                this.setGisCity("nmc");
                this.setGisVersion("/mapguide/");
                this.setMode("bndry");
                target = "result";
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Exception in Search Property By Bndry ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception : " + e);
            }
        }
        this.LOGGER.debug((Object)"Exit from srchByBndry method");
        return target;
    }

    @ValidationErrorPage(value="propType")
    public String srchByPropType() {
        this.LOGGER.debug((Object)"Entered into srchByPropType method");
        this.LOGGER.debug((Object)("Zone Id : " + this.zoneId + ", " + "ward Id : " + this.wardId + ", " + "Property Type : " + this.propTypeId));
        String strZoneNum = this.boundaryService.getBoundaryById(this.zoneId).getName();
        String strWardNum = "";
        String target = null;
        String propTypeName = "";
        if (this.propTypeId != null && this.propTypeId != -1) {
            propTypeName = this.propertyTypeMasterDAO.findById(this.propTypeId, false).getType();
        }
        if (this.zoneId != null && this.zoneId != -1L) {
            try {
                List propertyList;
                StringBuilder queryStr = new StringBuilder();
                queryStr.append("from PropertyMaterlizeView pmv where pmv.zone.id=:ZoneID and pmv.isActive = true");
                if (this.wardId != null && this.wardId != -1) {
                    queryStr.append(" and pmv.ward.id=:WardID");
                }
                if (this.areaId != null && this.areaId != -1) {
                    queryStr.append(" and pmv.street.id=:AreaID");
                }
                if (this.propTypeId != null && this.propTypeId != -1) {
                    queryStr.append(" and pmv.propTypeMstrID.id =:propType ");
                }
                Query query = this.getPersistenceService().getSession().createQuery(queryStr.toString());
                if (this.zoneId != null && this.zoneId != -1L) {
                    query.setLong("ZoneID", this.zoneId.longValue());
                }
                if (this.wardId != null && this.wardId != -1) {
                    query.setInteger("WardID", this.wardId.intValue());
                }
                if (this.areaId != null && this.areaId != -1) {
                    query.setInteger("AreaID", this.areaId.intValue());
                }
                if (this.propTypeId != null && this.propTypeId != -1) {
                    query.setInteger("propType", this.propTypeId.intValue());
                }
                if ((propertyList = query.list()).size() < 0) {
                    this.setSESSION(this.getSESSION());
                    this.setMode("propType");
                    target = "nodtls";
                }
                int count = 0;
                for (PropertyMaterlizeView propMatview : propertyList) {
                    this.LOGGER.debug((Object)("srchByBndry : Property : " + propMatview));
                    if (count > 6) break;
                    this.setSearchResultList(this.getResultsFromMv(propMatview));
                    ++count;
                }
                if (this.searchResultList != null) {
                    this.setSearchResultString(this.getSearchResultsString(this.searchResultList));
                }
                this.setSearchUri("../search/searchProperty!srchByPropType.action");
                this.setSearchCreteria("Search By Zone, Ward,Area,Property Type");
                this.setSearchValue("Zone Num: " + strZoneNum + ", Ward Num: " + "" + ", Property Type: " + propTypeName);
                this.LOGGER.debug((Object)("Search Criteria : " + this.getSearchCreteria()));
                this.LOGGER.debug((Object)("Search Value : " + this.getSearchValue()));
                this.setSESSION(this.getSESSION());
                this.setGisCity("nmc");
                this.setGisVersion("/mapguide/");
                this.setMode("propType");
                target = "result";
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Exception in Search Property By Property Type ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception : " + e);
            }
        }
        this.LOGGER.debug((Object)"Exit from srchByPropType  methods");
        return target;
    }

    @ValidationErrorPage(value="demand")
    public String srchByDemand() {
        this.LOGGER.debug((Object)"Entered into srchByDemand method");
        this.LOGGER.debug((Object)("Zone Id : " + this.zoneId + ", " + "ward Id : " + this.wardId + ", " + "Property Type : " + this.propTypeId + ", " + "Demand from amt : " + this.demandFromAmt + ", " + "Demand To amt : " + this.demandToAmt));
        String strZoneNum = this.boundaryService.getBoundaryById(this.zoneId).getName();
        String strWardNum = "";
        String target = null;
        String propTypeName = "";
        if (this.propTypeId != null && this.propTypeId != -1) {
            propTypeName = this.propertyTypeMasterDAO.findById(this.propTypeId, false).getType();
        }
        if (this.zoneId != null && this.zoneId != -1L) {
            try {
                List propertyList;
                StringBuilder queryStr = new StringBuilder();
                queryStr.append("from PropertyMaterlizeView pmv where pmv.zone.id=:ZoneID and pmv.isActive = true");
                if (this.wardId != null && this.wardId != -1) {
                    queryStr.append(" and pmv.ward.id=:WardID");
                }
                if (this.areaId != null && this.areaId != -1) {
                    queryStr.append(" and pmv.street.id=:AreaID");
                }
                if (this.propTypeId != null && this.propTypeId != -1) {
                    queryStr.append(" and pmv.propTypeMstrID.id =:propType ");
                }
                if (this.demandFromAmt != null && this.demandToAmt != null) {
                    queryStr.append(" and pmv.aggrCurrDmd BETWEEN :dmdFrmAmt and :dmdToAmt ");
                }
                Query query = this.getPersistenceService().getSession().createQuery(queryStr.toString());
                if (this.zoneId != null && this.zoneId != -1L) {
                    query.setLong("ZoneID", this.zoneId.longValue());
                }
                if (this.wardId != null && this.wardId != -1) {
                    query.setInteger("WardID", this.wardId.intValue());
                }
                if (this.areaId != null && this.areaId != -1) {
                    query.setInteger("AreaID", this.areaId.intValue());
                }
                if (this.propTypeId != null && this.propTypeId != -1) {
                    query.setInteger("propType", this.propTypeId.intValue());
                }
                if (this.demandFromAmt != null && this.demandToAmt != null) {
                    query.setBigDecimal("dmdFrmAmt", this.demandFromAmt);
                    query.setBigDecimal("dmdToAmt", this.demandToAmt);
                }
                if ((propertyList = query.list()).size() < 0) {
                    this.setSESSION(this.getSESSION());
                    this.setMode("demand");
                    target = "nodtls";
                }
                int count = 0;
                for (PropertyMaterlizeView propMatview : propertyList) {
                    this.LOGGER.debug((Object)("srchByBndry : Property : " + propMatview));
                    if (count > 6) break;
                    this.setSearchResultList(this.getResultsFromMv(propMatview));
                    ++count;
                }
                if (this.searchResultList != null) {
                    this.setSearchResultString(this.getSearchResultsString(this.searchResultList));
                }
                this.setSearchUri("../search/searchProperty!srchByDemand.action");
                this.setSearchCreteria("Search By Zone, Ward,Area,Property Type,Demand");
                this.setSearchValue("Zone Num: " + strZoneNum + ", Ward Num: " + "" + ", Property Type: " + propTypeName);
                this.LOGGER.debug((Object)("Search Criteria : " + this.getSearchCreteria()));
                this.LOGGER.debug((Object)("Search Value : " + this.getSearchValue()));
                this.setSESSION(this.getSESSION());
                this.setGisCity("nmc");
                this.setGisVersion("/mapguide/");
                this.setMode("demand");
                target = "result";
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Exception in Search Property By Demand ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception : " + e);
            }
        }
        this.LOGGER.debug((Object)"Exit from srchByDemand method");
        return target;
    }

    @ValidationErrorPage(value="defaulter")
    public String srchByDefaulter() {
        this.LOGGER.debug((Object)"Entered into srchByDefaulter method");
        this.LOGGER.debug((Object)("Zone Id : " + this.zoneId + ", " + "ward Id : " + this.wardId + ", " + "Property Type : " + this.propTypeId + ", " + "Defaulter from amt : " + this.defaulterFromAmt + ", " + "Defaulter To amt : " + this.defaulterToAmt));
        String strZoneNum = this.boundaryService.getBoundaryById(this.zoneId).getName();
        String strWardNum = "";
        String target = null;
        String propTypeName = "";
        if (this.propTypeId != null && this.propTypeId != -1) {
            propTypeName = this.propertyTypeMasterDAO.findById(this.propTypeId, false).getType();
        }
        if (this.zoneId != null && this.zoneId != -1L) {
            try {
                List propertyList;
                StringBuilder queryStr = new StringBuilder();
                queryStr.append("from PropertyMaterlizeView pmv where pmv.zone.id=:ZoneID and pmv.isActive = true");
                if (this.wardId != null && this.wardId != -1) {
                    queryStr.append(" and pmv.ward.id=:WardID");
                }
                if (this.areaId != null && this.areaId != -1) {
                    queryStr.append(" and pmv.street.id=:AreaID");
                }
                if (this.propTypeId != null && this.propTypeId != -1) {
                    queryStr.append(" and pmv.propTypeMstrID.id =:propType ");
                }
                if (this.defaulterFromAmt != null && this.defaulterToAmt != null) {
                    queryStr.append(" and pmv.aggrCurrDmd - pmv.aggrCurrColl between :defaultFrmAmt and :defaultToAmt ");
                }
                Query query = this.getPersistenceService().getSession().createQuery(queryStr.toString());
                if (this.zoneId != null && this.zoneId != -1L) {
                    query.setLong("ZoneID", this.zoneId.longValue());
                }
                if (this.wardId != null && this.wardId != -1) {
                    query.setInteger("WardID", this.wardId.intValue());
                }
                if (this.areaId != null && this.areaId != -1) {
                    query.setInteger("AreaID", this.areaId.intValue());
                }
                if (this.propTypeId != null && this.propTypeId != -1) {
                    query.setInteger("propType", this.propTypeId.intValue());
                }
                if (this.defaulterFromAmt != null && this.defaulterToAmt != null) {
                    query.setBigDecimal("defaultFrmAmt", this.defaulterFromAmt);
                    query.setBigDecimal("defaultToAmt", this.defaulterToAmt);
                }
                if ((propertyList = query.list()).size() < 0) {
                    this.setSESSION(this.getSESSION());
                    this.setMode("defaulter");
                    target = "nodtls";
                }
                int count = 0;
                for (PropertyMaterlizeView propMatview : propertyList) {
                    this.LOGGER.debug((Object)("srchByBndry : Property : " + propMatview));
                    if (count > 6) break;
                    this.setSearchResultList(this.getResultsFromMv(propMatview));
                    ++count;
                }
                if (this.searchResultList != null) {
                    this.setSearchResultString(this.getSearchResultsString(this.searchResultList));
                }
                this.setSearchUri("../search/searchProperty!srchByDefaulter.action");
                this.setSearchCreteria("Search By Zone, Ward,Area,Property Type,Defaulter");
                this.setSearchValue("Zone Num: " + strZoneNum + ", Ward Num: " + "" + ", Property Type: " + propTypeName);
                this.LOGGER.debug((Object)("Search Criteria : " + this.getSearchCreteria()));
                this.LOGGER.debug((Object)("Search Value : " + this.getSearchValue()));
                this.setSESSION(this.getSESSION());
                this.setGisCity("nmc");
                this.setGisVersion("/mapguide/");
                this.setMode("defaulter");
                target = "result";
            }
            catch (Exception e) {
                this.LOGGER.error((Object)"Exception in Search Property By Defaulter ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception : " + e);
            }
        }
        this.LOGGER.debug((Object)"Exit from srchByDefaulter method");
        return target;
    }

    @SkipValidation
    public void prepare() {
        this.LOGGER.debug((Object)"Entered into prepare method");
        List zoneList = this.getPersistenceService().findAllBy("from BoundaryImpl BI where BI.boundaryType.name=? and BI.boundaryType.heirarchyType.name=? and BI.isHistory='N' order by BI.id", new Object[]{"Revenue Zone", "ELECTION"});
        this.setZoneBndryMap(CommonServices.getFormattedBndryMap((List)zoneList));
        this.LOGGER.debug((Object)("Zone id : " + this.zoneId + ", " + "Ward id : " + this.wardId));
        this.prepareWardDropDownData(this.zoneId != null, this.wardId != null);
        this.prepareAreaDropDownData(this.wardId != null, this.areaId != null);
        List propTypeList = this.getPersistenceService().findAllBy("from PropertyTypeMaster", new Object[0]);
        this.LOGGER.debug((Object)("PropTypeList : " + (propTypeList != null ? propTypeList : BigDecimal.ZERO)));
        this.addDropdownData("PropType", propTypeList);
        this.LOGGER.debug((Object)("Zone List : " + (zoneList != null ? zoneList : BigDecimal.ZERO)));
        this.LOGGER.debug((Object)"Exit from prepare method");
    }

    private void prepareWardDropDownData(boolean zoneExists, boolean wardExists) {
        this.LOGGER.debug((Object)"Entered into prepareWardDropDownData method");
        this.LOGGER.debug((Object)("Zone Exists ? : " + zoneExists + ", " + "Ward Exists ? : " + wardExists));
        if (zoneExists && wardExists) {
            List wardNewList = new ArrayList();
            wardNewList = this.getPersistenceService().findAllBy("from BoundaryImpl BI where BI.boundaryType.name=? and BI.parent.id = ? and BI.isHistory='N' order by BI.name ", new Object[]{"Revenue Ward", this.getZoneId()});
            this.addDropdownData("wardList", wardNewList);
        } else {
            this.addDropdownData("wardList", Collections.EMPTY_LIST);
        }
        this.LOGGER.debug((Object)"Exit from prepareWardDropDownData method");
    }

    private void prepareAreaDropDownData(boolean wardExists, boolean areaExists) {
        this.LOGGER.debug((Object)"Entered into prepareAreaDropDownData method");
        this.LOGGER.debug((Object)("Ward Exists ? : " + wardExists + ", " + "Area Exists ? : " + areaExists));
        if (wardExists && areaExists) {
            List areaNewList = new ArrayList();
            areaNewList = this.getPersistenceService().findAllBy("from BoundaryImpl BI where BI.boundaryType.name=? and BI.parent.id = ? and BI.isHistory='N' order by BI.name ", new Object[]{"Revenue Area", this.getWardId()});
            this.addDropdownData("areaList", areaNewList);
        } else {
            this.addDropdownData("areaList", Collections.EMPTY_LIST);
        }
        this.LOGGER.debug((Object)"Exit from prepareAreaDropDownData method");
    }

    private String getSearchResultsString(List<Map<String, String>> searchResultList) {
        this.LOGGER.debug((Object)"Entered into getSearchResultsString method");
        StringBuffer indexNum = new StringBuffer();
        StringBuffer ownerName = new StringBuffer();
        StringBuffer parcelId = new StringBuffer();
        StringBuffer address = new StringBuffer();
        StringBuffer currDemand = new StringBuffer();
        StringBuffer arrDemand = new StringBuffer();
        StringBuffer currDemandDue = new StringBuffer();
        StringBuffer concatResult = new StringBuffer();
        for (Map<String, String> propDtlMap : searchResultList) {
            indexNum.append(propDtlMap.get("indexNum"));
            indexNum.append("^");
            if (propDtlMap.get("ownerName").length() > 40) {
                ownerName.append(propDtlMap.get("ownerName").substring(0, 40));
                ownerName.append("^");
            } else {
                ownerName.append(propDtlMap.get("ownerName"));
                ownerName.append("^");
            }
            parcelId.append(propDtlMap.get("parcelId"));
            parcelId.append("^");
            if (propDtlMap.get("address").length() > 40) {
                address.append(propDtlMap.get("address").substring(0, 40));
                address.append("^");
            } else {
                address.append(propDtlMap.get("address"));
                address.append("^");
            }
            currDemand.append(propDtlMap.get("currDemand"));
            currDemand.append("^");
            arrDemand.append(propDtlMap.get("arrDemand"));
            arrDemand.append("^");
            currDemandDue.append(propDtlMap.get("currDemandDue"));
            currDemandDue.append("^");
        }
        concatResult.append(indexNum).append("@").append(ownerName).append("@").append(parcelId).append("@").append(currDemand).append("@").append(arrDemand).append("@").append(currDemandDue);
        this.LOGGER.debug((Object)("Search Results String : " + concatResult));
        this.LOGGER.debug((Object)"Exit from getSearchResultsString method");
        return concatResult.toString();
    }

    private List<Map<String, String>> getResultsFromMv(PropertyMaterlizeView pmv) {
        this.LOGGER.debug((Object)"Entered into getSearchResults method");
        this.LOGGER.debug((Object)("Index Number : " + pmv.getPropertyId()));
        if ((pmv.getPropertyId() != null || StringUtils.isNotEmpty((String)pmv.getPropertyId())) && pmv != null) {
            HashMap<String, String> searchResultMap = new HashMap<String, String>();
            searchResultMap.put("indexNum", pmv.getPropertyId());
            searchResultMap.put("ownerName", pmv.getOwnerName());
            searchResultMap.put("parcelId", pmv.getGisRefNo());
            searchResultMap.put("address", pmv.getPropertyAddress());
            searchResultMap.put("currDemand", pmv.getAggrCurrFirstHalfDmd().toString());
            searchResultMap.put("currDemandDue", pmv.getAggrCurrFirstHalfDmd().subtract(pmv.getAggrCurrFirstHalfColl()).toString());
            searchResultMap.put("arrDemand", pmv.getAggrArrDmd().subtract(pmv.getAggrArrColl()).toString());
            this.searchList.add(searchResultMap);
        }
        this.LOGGER.debug((Object)("Search list : " + (this.searchList != null ? this.searchList : BigDecimal.ZERO)));
        this.LOGGER.debug((Object)"Exit from getSearchResults method");
        return this.searchList;
    }

    public void validate() {
        this.LOGGER.debug((Object)"Entered into validate method");
        if (StringUtils.equals((String)this.mode, (String)"bndry")) {
            if (this.zoneId == null || this.zoneId == -1L) {
                this.addActionError("Select Zone.");
            }
        } else if (StringUtils.equals((String)this.mode, (String)"propType")) {
            if (this.propTypeId == null || this.propTypeId == -1) {
                this.addActionError("Select Property Type.");
            }
            if (this.zoneId == null || this.zoneId == -1L) {
                this.addActionError("Select Zone.");
            }
        } else if (StringUtils.equals((String)this.mode, (String)"defaulter")) {
            if (this.zoneId == null || this.zoneId == -1L) {
                this.addActionError("Select Zone.");
            }
            if (this.defaulterFromAmt != null) {
                if (this.defaulterToAmt != null) {
                    if (this.defaulterFromAmt.signum() == 0) {
                        this.addActionError("Please enter amount greater than zero for From Amount.");
                    }
                    if (this.defaulterToAmt.signum() == 0) {
                        this.addActionError("Please enter amount greater than zero for To Amount.");
                    }
                    if (this.defaulterFromAmt.compareTo(this.defaulterToAmt) == 1) {
                        this.addActionError("From Amount must be less than To Amount.");
                    }
                } else {
                    this.addActionError("Enter To Amount.");
                }
            } else {
                this.addActionError("Enter From Amount.");
            }
        } else if (StringUtils.equals((String)this.mode, (String)"demand")) {
            if (this.zoneId == null || this.zoneId == -1L) {
                this.addActionError("Select Zone.");
            }
            if (this.demandFromAmt != null) {
                if (this.demandToAmt != null) {
                    if (this.demandFromAmt.signum() == 0) {
                        this.addActionError("Please enter amount greater than zero for From Amount.");
                    }
                    if (this.demandToAmt.signum() == 0) {
                        this.addActionError("Please enter amount greater than zero for To Amount.");
                    }
                    if (this.demandFromAmt.compareTo(this.demandToAmt) == 1) {
                        this.addActionError("From Amount must be less than To Amount.");
                    }
                } else {
                    this.addActionError("Enter To Amount.");
                }
            } else {
                this.addActionError("Enter From Amount.");
            }
        }
        this.LOGGER.debug((Object)"Exit from validate method");
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Integer getWardId() {
        return this.wardId;
    }

    public void setWardId(Integer wardId) {
        this.wardId = wardId;
    }

    public Integer getAreaId() {
        return this.areaId;
    }

    public void setAreaId(Integer areaId) {
        this.areaId = areaId;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getHouseNum() {
        return this.houseNum;
    }

    public void setHouseNum(String houseNum) {
        this.houseNum = houseNum;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public Integer getPropTypeId() {
        return this.propTypeId;
    }

    public void setPropTypeId(Integer propTypeId) {
        this.propTypeId = propTypeId;
    }

    public List<Map<String, String>> getSearchResultList() {
        return this.searchResultList;
    }

    public void setSearchResultList(List<Map<String, String>> searchResultList) {
        this.searchResultList = searchResultList;
    }

    public String getSearchUri() {
        return this.searchUri;
    }

    public void setSearchUri(String searchUri) {
        this.searchUri = searchUri;
    }

    public String getSearchCreteria() {
        return this.searchCreteria;
    }

    public void setSearchCreteria(String searchCreteria) {
        this.searchCreteria = searchCreteria;
    }

    public String getSearchValue() {
        return this.searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    public BigDecimal getDemandFromAmt() {
        return this.demandFromAmt;
    }

    public void setDemandFromAmt(BigDecimal demandFromAmt) {
        this.demandFromAmt = demandFromAmt;
    }

    public BigDecimal getDemandToAmt() {
        return this.demandToAmt;
    }

    public void setDemandToAmt(BigDecimal demandToAmt) {
        this.demandToAmt = demandToAmt;
    }

    public BigDecimal getDefaulterFromAmt() {
        return this.defaulterFromAmt;
    }

    public void setDefaulterFromAmt(BigDecimal defaulterFromAmt) {
        this.defaulterFromAmt = defaulterFromAmt;
    }

    public BigDecimal getDefaulterToAmt() {
        return this.defaulterToAmt;
    }

    public void setDefaulterToAmt(BigDecimal defaulterToAmt) {
        this.defaulterToAmt = defaulterToAmt;
    }

    public String getSESSION() {
        return this.SESSION;
    }

    public void setSESSION(String session) {
        this.SESSION = session;
    }

    public String getSearchResultString() {
        return this.searchResultString;
    }

    public void setSearchResultString(String searchResultString) {
        this.searchResultString = searchResultString;
    }

    public String getGisVersion() {
        return this.gisVersion;
    }

    public void setGisVersion(String gisVersion) {
        this.gisVersion = gisVersion;
    }

    public String getGisCity() {
        return this.gisCity;
    }

    public void setGisCity(String gisCity) {
        this.gisCity = gisCity;
    }

    public Map<Long, String> getZoneBndryMap() {
        return this.ZoneBndryMap;
    }

    public void setZoneBndryMap(Map<Long, String> zoneBndryMap) {
        this.ZoneBndryMap = zoneBndryMap;
    }
}

