/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Actions;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.ptis.actions.common.CommonServices;
import org.egov.ptis.bean.CitizenMutationInfo;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.service.notice.NoticeService;
import org.egov.ptis.notice.PtNotice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Namespace(value="/reports")
@ResultPath(value="/WEB-INF/jsp/")
@Results(value={@Result(name={"success"}, type="stream", params={"contentType", "${contentType}", "inputName", "fileStream", "contentDisposition", "attachment; filename=${fileName}"}), @Result(name={"RENDER_NOTICE"}, location="/commons/htmlFileRenderer.jsp"), @Result(name={"new"}, location="reports/citizen-search-notice.jsp"), @Result(name={"index"}, location="reports/searchNotices.jsp")})
public class SearchNoticesAction
extends SearchFormAction {
    private static final Logger LOGGER = Logger.getLogger(SearchNoticesAction.class);
    private static final long serialVersionUID = 1L;
    protected static final String SUCCESS = "success";
    private static final String ERROR = "error";
    private static final String FROM_CLAUSE = " from PtNotice notice left join notice.basicProperty bp,PropertyMaterlizeView pmv";
    private static final String BILL_FROM_CLAUSE = " from DemandBill bill, PtNotice notice left join notice.basicProperty bp, PropertyMaterlizeView pmv";
    private static final String ORDER_BY = " order by notice.noticeDate desc";
    private static final String BILL_ORDER_BY = " order by notice.basicProperty.address.houseNoBldgApt asc";
    private String ownerName;
    private Long zoneId;
    private Long wardId;
    private String propertyType;
    private String noticeType;
    private String noticeNumber;
    private Date noticeFromDate = null;
    private Date noticeToDate = null;
    private String indexNumber;
    private String houseNumber;
    private Map<String, String> noticeTypeMap;
    private String target = "new";
    private List<PtNotice> noticeList;
    private List<CitizenMutationInfo> mutationList;
    private String contentType;
    private String fileName;
    private InputStream fileStream;
    private Long contentLength;
    private String partNo;
    @Autowired
    private PropertyTypeMasterDAO propertyTypeMasterDAO;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private NoticeService noticeService;
    private String municipal;
    private String district;
    private String reportHeader;

    @SkipValidation
    @Action(value="/searchNotices-index")
    public String index() {
        return "index";
    }

    @ValidationErrorPage(value="index")
    @Action(value="/searchNotices-search")
    public String search() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into search method");
            LOGGER.debug((Object)("Owner name : " + this.ownerName + ", " + "Notice Type : " + this.noticeType + ", " + "Zone Id : " + this.zoneId + ", " + "Ward Id : " + this.wardId + ", " + "Property type :" + this.propertyType + ", " + "Notice Number : " + this.noticeNumber + ", " + "Notice FromDate : " + this.noticeFromDate + ", " + "noticeToDate : " + this.noticeToDate + ", " + "Property Id : " + this.indexNumber + ", " + "House Number : " + this.houseNumber));
        }
        if (this.noticeType != "-1") {
            this.reportHeader = this.reportHeader + ", NoticeType: " + this.noticeType;
        }
        if (!this.ownerName.isEmpty()) {
            this.reportHeader = this.reportHeader + ", OwnerName: " + this.ownerName;
        }
        if (this.zoneId != -1L) {
            this.reportHeader = this.reportHeader + ", Zone: " + this.getBoundary(this.zoneId);
        }
        if (this.wardId != -1L) {
            this.reportHeader = this.reportHeader + ", Ward: " + this.getBoundary(this.wardId);
        }
        if (!this.propertyType.equalsIgnoreCase("-1")) {
            this.reportHeader = this.reportHeader + ", PropertyType: " + this.getPropType(this.propertyType);
        }
        if (!this.noticeNumber.isEmpty()) {
            this.reportHeader = this.reportHeader + ", noticeNum: " + this.noticeNumber;
        }
        if (this.noticeFromDate != null) {
            this.reportHeader = this.reportHeader + ", noticeDateFrom: " + this.noticeFromDate;
        }
        if (this.noticeToDate != null) {
            this.reportHeader = this.reportHeader + ", noticeDateTo: " + this.noticeToDate;
        }
        if (!this.indexNumber.isEmpty()) {
            this.reportHeader = this.reportHeader + ", propertyId: " + this.indexNumber;
        }
        if (!this.houseNumber.isEmpty()) {
            this.reportHeader = this.reportHeader + ", HouseNo: " + this.houseNumber;
        }
        this.target = "searchresult";
        super.search();
        this.noticeList = this.searchResult.getList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of notices : " + this.noticeList.size()));
            LOGGER.debug((Object)"Exit from search method");
        }
        return "index";
    }

    @SkipValidation
    @Actions(value={@Action(value="/searchNotices-citizen"), @Action(value="/public/searchNotices-citizen")})
    public String citizen() {
        return "new";
    }

    @SkipValidation
    @ValidationErrorPage(value="new")
    @Actions(value={@Action(value="/searchNotices-citizenSearch"), @Action(value="/public/searchNotices-citizenSearch")})
    public String searchNotice() {
        if (!this.indexNumber.isEmpty()) {
            this.reportHeader = this.reportHeader + ", propertyId: " + this.indexNumber;
            this.setIndexNumber(this.indexNumber);
            this.mutationList = this.getMutationsList(this.indexNumber);
        } else {
            this.addActionError(this.getText("mandatory.indexNumber"));
        }
        return "new";
    }

    private List<CitizenMutationInfo> getMutationsList(String indexNumber) {
        List mutations = this.noticeService.getListofMutations(indexNumber);
        LinkedList<CitizenMutationInfo> citizenMutationInfo = new LinkedList<CitizenMutationInfo>();
        for (PropertyMutation mt : mutations) {
            CitizenMutationInfo citizenMutationBean = new CitizenMutationInfo();
            citizenMutationBean.setAssessmentNo(indexNumber);
            citizenMutationBean.setNewOwnerName(mt.getFullTranfereeName().toString());
            citizenMutationBean.setOldOwnerName(mt.getFullTranferorName().toString());
            citizenMutationBean.setApplicationNo(mt.getApplicationNo());
            citizenMutationBean.setMutationFee(mt.getMutationFee() != null ? mt.getMutationFee() : BigDecimal.ZERO);
            citizenMutationBean.setReceiptNo(mt.getReceiptNum() != null ? mt.getReceiptNum() : "");
            citizenMutationBean.setStatus(mt.getState().getValue());
            citizenMutationBean.setNotice(this.noticeService.getNoticeByApplicationNo(mt.getApplicationNo()));
            citizenMutationBean.setAddress(mt.getBasicProperty().getAddress().toString());
            citizenMutationInfo.add(citizenMutationBean);
        }
        return citizenMutationInfo;
    }

    @ValidationErrorPage(value="index")
    @Action(value="/searchNotices-mergeAndDownload")
    public String mergeAndDownload() throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into mergeAndDownload method");
        }
        long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("mergeAndDownload : Start Time : " + startTime));
        }
        List noticeList = this.getNoticeBySearchParameter();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of notices : " + (noticeList != null ? Integer.valueOf(noticeList.size()) : BigDecimal.ZERO)));
        }
        if (null == noticeList || noticeList.size() <= 0) {
            this.addActionError(this.getText("notice.file.merge.unavailable"));
            return "index";
        }
        ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
        for (PtNotice ptNotice : noticeList) {
            try {
                if (ptNotice == null || ptNotice.getFileStore() == null) continue;
                FileStoreMapper fsm = ptNotice.getFileStore();
                File file = this.fileStoreService.fetch(fsm, "PTIS");
                byte[] bFile = FileUtils.readFileToByteArray((File)file);
                pdfs.add(new ByteArrayInputStream(bFile));
            }
            catch (Exception e) {
                LOGGER.error((Object)("mergeAndDownload : Getting notice failed for notice " + ptNotice), (Throwable)e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of pdfs : " + (pdfs != null ? Integer.valueOf(pdfs.size()) : BigDecimal.ZERO)));
        }
        try {
            HttpServletResponse response = ServletActionContext.getResponse();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] data = this.concatPDFs(pdfs, output);
            response.setHeader("Content-disposition", "attachment;filename=notice_" + this.noticeType + ".pdf");
            response.setContentType("application/pdf");
            response.setContentLength(data.length);
            response.getOutputStream().write(data);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception in Merge and Download : ", (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(ERROR, e.getMessage())));
        }
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("mergeAndDownload : End Time : " + endTime));
            LOGGER.debug((Object)("SearchNoticesAction | mergeAndDownload | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from mergeAndDownload method");
        }
        return null;
    }

    @ValidationErrorPage(value="index")
    @Action(value="/searchNotices-zipAndDownload")
    public String zipAndDownload() throws ValidationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into zipAndDownload method");
        }
        long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("zipAndDownload : Start Time : " + startTime));
        }
        HttpServletResponse response = ServletActionContext.getResponse();
        List noticeList = this.getNoticeBySearchParameter();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of notices : " + (noticeList != null ? Integer.valueOf(noticeList.size()) : BigDecimal.ZERO)));
        }
        try {
            if (null == noticeList || noticeList.size() <= 0) {
                this.addActionError(this.getText("notice.file.zip.unavailable"));
                return "index";
            }
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-disposition", "attachment;filename=notice_" + this.noticeType + ".zip");
            response.setContentType("application/zip");
            for (PtNotice ptNotice : noticeList) {
                try {
                    if (ptNotice == null || ptNotice.getFileStore() == null) continue;
                    FileStoreMapper fsm = ptNotice.getFileStore();
                    File file = this.fileStoreService.fetch(fsm, "PTIS");
                    byte[] bFile = FileUtils.readFileToByteArray((File)file);
                    zipOutputStream = this.addFilesToZip((InputStream)new ByteArrayInputStream(bFile), file.getName(), zipOutputStream);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("zipAndDownload : Getting notice failed for notice " + ptNotice), (Throwable)e);
                }
            }
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception in Zip and Download : ", (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError(ERROR, e.getMessage())));
        }
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("zipAndDownload : End Time : " + endTime));
            LOGGER.debug((Object)("SearchNoticesAction | zipAndDownload | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from zipAndDownload method");
        }
        return null;
    }

    @SkipValidation
    @Actions(value={@Action(value="/searchNotices-showNotice"), @Action(value="/public/searchNotices-showNotice")})
    public String showNotice() throws IOException {
        PtNotice ptNotice = (PtNotice)this.getPersistenceService().find("from PtNotice notice where noticeNo=?", new Object[]{this.noticeNumber});
        if (ptNotice == null) {
            this.addActionError(this.getText("DocMngr.file.unavailable"));
            return "index";
        }
        if (ptNotice != null && ptNotice.getFileStore() != null) {
            FileStoreMapper fsm = ptNotice.getFileStore();
            File file = this.fileStoreService.fetch(fsm, "PTIS");
            byte[] bFile = FileUtils.readFileToByteArray((File)file);
            ByteArrayInputStream myInputStream = new ByteArrayInputStream(bFile);
            this.fileStream = myInputStream;
            this.fileName = new StringBuffer(ptNotice.getBasicProperty().getUpicNo()).append("-").append(ptNotice.getNoticeType()).toString();
            this.contentType = "application/pdf";
            this.contentLength = file.length();
        }
        return SUCCESS;
    }

    @SkipValidation
    @Action(value="/searchNotices-reset")
    public String reset() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("reset : Before reset values : ownerName : " + this.ownerName + " zoneId : " + this.zoneId + " wardId : " + this.wardId + " propertyType : " + this.propertyType + " noticeType : " + this.noticeType + " noticeNumber : " + this.noticeNumber + " noticeFromDate : " + this.noticeFromDate + " noticeToDate : " + this.noticeToDate + " indexNumber : " + this.indexNumber + " houseNumber : " + this.houseNumber));
        }
        this.ownerName = "";
        this.zoneId = -1L;
        this.wardId = -1L;
        this.propertyType = "-1";
        this.noticeType = "-1";
        this.noticeNumber = "";
        this.noticeFromDate = null;
        this.noticeToDate = null;
        this.indexNumber = "";
        this.houseNumber = "";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit from reset method");
        }
        return "index";
    }

    public void prepare() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into prepare method");
        }
        super.prepare();
        this.municipal = this.getSession().get("citymunicipalityname").toString();
        this.district = this.getSession().get("districtName").toString();
        this.district = this.district.substring(0, 1) + this.district.substring(1, this.district.length()).toLowerCase() + " District";
        this.reportHeader = this.municipal + ", " + this.district;
        List zoneList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone".toUpperCase(), "REVENUE");
        List wardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
        List propTypeList = this.propertyTypeMasterDAO.findAll();
        this.addDropdownData("Zone", zoneList);
        this.addDropdownData("wardList", wardList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Zone id : " + this.zoneId + ", " + "Ward id : " + this.wardId));
        }
        this.addDropdownData("PropTypeMaster", propTypeList);
        this.setNoticeTypeMap(CommonServices.getNoticeTypeMstr());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Zone List : " + (zoneList != null ? zoneList : BigDecimal.ZERO)));
            LOGGER.debug((Object)("Property type List : " + (propTypeList != null ? propTypeList : BigDecimal.ZERO)));
            LOGGER.debug((Object)("Notice type map size : " + (this.noticeTypeMap != null ? Integer.valueOf(this.noticeTypeMap.size()) : BigDecimal.ZERO)));
            LOGGER.debug((Object)"Exit from prepare method");
        }
    }

    private void prepareWardDropDownData(boolean zoneExists, boolean wardExists) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into prepareWardDropDownData method");
            LOGGER.debug((Object)("Zone Exists ? : " + zoneExists + ", " + "Ward Exists ? : " + wardExists));
        }
        if (zoneExists && wardExists) {
            List wardNewList = new ArrayList();
            wardNewList = this.boundaryService.getActiveChildBoundariesByBoundaryId(this.getZoneId());
            this.addDropdownData("wardList", wardNewList);
        } else {
            this.addDropdownData("wardList", Collections.EMPTY_LIST);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit from prepareWardDropDownData method");
        }
    }

    public String getBoundary(Long boundaryId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into getBoundary method");
            LOGGER.debug((Object)("Boundary Id : " + boundaryId));
        }
        Boundary bndry = null;
        if (boundaryId != null && !boundaryId.equals(-1)) {
            bndry = this.boundaryService.getBoundaryById(boundaryId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Boundary : " + bndry));
            LOGGER.debug((Object)"Exit from getBoundary method");
        }
        return bndry.getName();
    }

    public String getPropType(String propertyType) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into getPropType method");
            LOGGER.debug((Object)("Property type id : " + propertyType));
        }
        PropertyTypeMaster propTypeMstr = this.propertyTypeMasterDAO.findById(Integer.valueOf(propertyType), false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Property type : " + propTypeMstr));
            LOGGER.debug((Object)"Exit from getPropType method");
        }
        return propTypeMstr.getType();
    }

    public String getNonHistoryOwnerName(BasicProperty basicProperty) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entered into getNonHistoryOwnerName method Basic Property " + basicProperty));
        }
        String NonHistoryOwnerName = basicProperty.getFullOwnerName();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getNonHistoryOwnerName : Non-History Owner Name : " + NonHistoryOwnerName));
            LOGGER.debug((Object)"Exit from getNonHistoryOwnerName method");
        }
        return NonHistoryOwnerName;
    }

    public SearchQuery prepareQuery(String sortField, String sortDir) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into prepareQuery method");
            LOGGER.debug((Object)("Sort Field : " + sortField + ", " + "Sort Dir : " + sortDir));
        }
        Map map = this.getCriteriaString();
        return new SearchQueryHQL(this.prepareSearchQuery(map.get("criteriaString")), this.prepareCountQuery(map.get("criteriaString")), (List)((ArrayList)map.get("params")));
    }

    private Map<String, Object> getCriteriaString() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into getCriteriaString method");
            LOGGER.debug((Object)("Notice Type : " + this.noticeType + ", " + "Zone Id : " + this.zoneId + ", " + "Ward Id : " + this.wardId + ", " + "Notice Number : " + this.noticeNumber + ", " + "Notice FromDate : " + this.noticeFromDate + ", " + "noticeToDate : " + this.noticeToDate + ", " + "Property Id : " + this.indexNumber + ", " + "House Number : " + this.houseNumber));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder criteriaString = new StringBuilder();
        criteriaString = new StringBuilder(" where notice.noticeType = ?");
        params.add(this.noticeType);
        criteriaString = "Bill".equalsIgnoreCase(this.noticeType) ? criteriaString.append(" and bill.isactive = true and bill.billnumber = notice.noticeNo and pmv.propertyId=bill.assessmentNo") : criteriaString.append(" and bp.upicNo=pmv.propertyId");
        if (this.ownerName != null && !this.ownerName.equals("")) {
            criteriaString.append(" and pmv.ownerName like ?");
            params.add("%" + this.ownerName + "%");
        }
        if (this.zoneId != null && !this.zoneId.equals(-1L)) {
            criteriaString.append(" and bp.propertyID.zone.id = ?");
            params.add(this.zoneId);
        }
        if (this.wardId != null && !this.wardId.equals(-1L)) {
            criteriaString.append(" and bp.propertyID.ward.id = ?");
            params.add(this.wardId);
        }
        if (this.propertyType != null && !this.propertyType.equals("-1")) {
            criteriaString.append(" and pmv.propTypeMstrID.id = ?");
            params.add(Long.parseLong(this.propertyType));
        }
        if (this.noticeNumber != null && !this.noticeNumber.equals("")) {
            criteriaString.append(" and notice.noticeNo = ?");
            params.add(this.noticeNumber);
        }
        if (this.noticeFromDate != null && !this.noticeFromDate.equals("DD/MM/YYYY")) {
            criteriaString.append(" and notice.noticeDate >= ?");
            params.add(this.noticeFromDate);
        }
        if (this.noticeToDate != null && !this.noticeToDate.equals("DD/MM/YYYY")) {
            Calendar nextDate = Calendar.getInstance();
            nextDate.setTime(this.noticeToDate);
            nextDate.add(5, 1);
            criteriaString.append(" and notice.noticeDate <= ?");
            params.add(nextDate.getTime());
        }
        if (this.indexNumber != null && !this.indexNumber.equals("")) {
            criteriaString.append(" and pmv.propertyId = ?");
            params.add(this.indexNumber);
        }
        if (this.houseNumber != null && !this.houseNumber.equals("")) {
            criteriaString.append(" and bp.address.houseNoBldgApt like ?");
            params.add(this.houseNumber);
        }
        map.put("criteriaString", criteriaString);
        map.put("params", params);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Criteria String : " + criteriaString));
            LOGGER.debug((Object)"Exit from getCriteriaString method");
        }
        return map;
    }

    public Object getModel() {
        return null;
    }

    public void validate() {
        if (this.noticeType == null || this.noticeType.equals("-1")) {
            this.addActionError(this.getText("mandatory.noticeType"));
        }
        if (this.noticeFromDate != null && !this.noticeFromDate.equals("DD/MM/YYYY") && (this.noticeToDate == null || this.noticeToDate.equals("DD/MM/YYYY"))) {
            this.addActionError(this.getText("mandatory.noticeTodt"));
        }
        if (this.noticeToDate != null && !this.noticeToDate.equals("DD/MM/YYYY") && (this.noticeFromDate == null || this.noticeFromDate.equals("DD/MM/YYYY"))) {
            this.addActionError(this.getText("mandatory.noticeFromdt"));
        }
        if (this.noticeFromDate != null && !this.noticeFromDate.equals("DD/MM/YYYY") && this.noticeFromDate.after(new Date())) {
            this.addActionError(this.getText("mandatory.noticeFromdtBeforeCurr"));
        }
        if (this.noticeToDate != null && !this.noticeToDate.equals("DD/MM/YYYY") && this.noticeToDate.after(new Date())) {
            this.addActionError(this.getText("mandatory.noticeTodtBeforeCurr"));
        }
        if (this.noticeFromDate != null && !this.noticeFromDate.equals("DD/MM/YYYY") && this.noticeToDate != null && !this.noticeToDate.equals("DD/MM/YYYY") && this.noticeToDate.before(this.noticeFromDate)) {
            this.addActionError(this.getText("mandatory.noticeTodtgtoreqCurr"));
        }
    }

    private List<PtNotice> getNoticeBySearchParameter() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into getNoticeBySearchParameter method");
        }
        Map map = this.getCriteriaString();
        List noticeList = this.persistenceService.findAllBy(this.prepareSearchQuery(map.get("criteriaString")), ((ArrayList)map.get("params")).toArray());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of notices : " + (noticeList != null ? Integer.valueOf(noticeList.size()) : BigDecimal.ZERO)));
            LOGGER.debug((Object)"Exit from getNoticeBySearchParameter method");
        }
        return noticeList;
    }

    private String prepareSearchQuery(Object criteria) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entered into Search Query, criteria=" + criteria));
        }
        StringBuilder searchQuery = new StringBuilder("select notice");
        searchQuery.append(this.noticeType.equals("Bill") ? BILL_FROM_CLAUSE : FROM_CLAUSE);
        searchQuery.append(criteria);
        searchQuery.append(this.noticeType.equals("Bill") ? BILL_ORDER_BY : ORDER_BY);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Search Query : " + searchQuery));
        }
        return searchQuery.toString();
    }

    private String prepareCountQuery(Object criteria) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entered into prepareCountQuery , criteria=" + criteria));
        }
        StringBuilder countQuery = new StringBuilder("select count(notice)");
        countQuery.append(this.noticeType.equals("Bill") ? BILL_FROM_CLAUSE : FROM_CLAUSE);
        countQuery.append(criteria);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Count Query : " + countQuery));
        }
        return countQuery.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] concatPDFs(List<InputStream> streamOfPDFFiles, ByteArrayOutputStream outputStream) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into concatPDFs method");
        }
        Document document = null;
        try {
            List<InputStream> pdfs = streamOfPDFFiles;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            for (InputStream pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                if (null != document) continue;
                document = new Document(pdfReader.getPageSize(1));
            }
            PdfWriter writer = PdfWriter.getInstance(document, (OutputStream)outputStream);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int pageOfCurrentReaderPDF = 0;
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(pdfReader, ++pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                }
                pageOfCurrentReaderPDF = 0;
            }
            outputStream.flush();
            document.close();
            outputStream.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception in concat PDFs : ", (Throwable)e);
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.error((Object)"Exception in concat PDFs : ", (Throwable)ioe);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit from concatPDFs method");
        }
        return outputStream.toByteArray();
    }

    protected String getContentDisposition(ReportConstants.FileFormat fileFormat) {
        return "inline; filename=report." + fileFormat.toString();
    }

    private ZipOutputStream addFilesToZip(InputStream inputStream, String noticeNo, ZipOutputStream out) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into addFilesToZip method");
        }
        byte[] buffer = new byte[1024];
        try {
            int len;
            out.setLevel(-1);
            out.putNextEntry(new ZipEntry(noticeNo.replaceAll("/", "_")));
            while ((len = inputStream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            inputStream.close();
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error((Object)"Exception in addFilesToZip : ", (Throwable)iae);
            throw new ValidationException(Arrays.asList(new ValidationError(ERROR, iae.getMessage())));
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.error((Object)"Exception in addFilesToZip : ", (Throwable)fnfe);
            throw new ValidationException(Arrays.asList(new ValidationError(ERROR, fnfe.getMessage())));
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"Exception in addFilesToZip : ", (Throwable)ioe);
            throw new ValidationException(Arrays.asList(new ValidationError(ERROR, ioe.getMessage())));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit from addFilesToZip method");
        }
        return out;
    }

    public String getFormattedBndryStr(Boundary boundary) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into getFormattedBndryStr method");
            LOGGER.debug((Object)("boundary : " + boundary));
        }
        StringBuilder formattedStr = new StringBuilder();
        if (boundary != null) {
            formattedStr.append(boundary.getBoundaryNum().toString()).append("-").append(boundary.getName());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("formattedStr : " + formattedStr.toString()));
            LOGGER.debug((Object)"Exit from getFormattedBndryStr method");
        }
        return formattedStr.toString();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    public String getNoticeType() {
        return this.noticeType;
    }

    public void setNoticeType(String noticeType) {
        this.noticeType = noticeType;
    }

    public String getNoticeNumber() {
        return this.noticeNumber;
    }

    public void setNoticeNumber(String noticeNumber) {
        this.noticeNumber = noticeNumber;
    }

    public Date getNoticeFromDate() {
        return this.noticeFromDate;
    }

    public void setNoticeFromDate(Date noticeFromDate) {
        this.noticeFromDate = noticeFromDate;
    }

    public Date getNoticeToDate() {
        return this.noticeToDate;
    }

    public void setNoticeToDate(Date noticeToDate) {
        this.noticeToDate = noticeToDate;
    }

    public String getIndexNumber() {
        return this.indexNumber;
    }

    public void setIndexNumber(String indexNumber) {
        this.indexNumber = indexNumber;
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public void setHouseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
    }

    public Map<String, String> getNoticeTypeMap() {
        return this.noticeTypeMap;
    }

    public void setNoticeTypeMap(Map<String, String> noticeTypeMap) {
        this.noticeTypeMap = noticeTypeMap;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public List<PtNotice> getNoticeList() {
        return this.noticeList;
    }

    public void setNoticeList(List<PtNotice> noticeList) {
        this.noticeList = noticeList;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public InputStream getFileStream() {
        return this.fileStream;
    }

    public void setFileStream(InputStream fileStream) {
        this.fileStream = fileStream;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public String getPartNo() {
        return this.partNo;
    }

    public void setPartNo(String partNo) {
        this.partNo = partNo;
    }

    public String getMunicipal() {
        return this.municipal;
    }

    public void setMunicipal(String municipal) {
        this.municipal = municipal;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getReportHeader() {
        return this.reportHeader;
    }

    public void setReportHeader(String reportHeader) {
        this.reportHeader = reportHeader;
    }

    public List<CitizenMutationInfo> getMutationList() {
        return this.mutationList;
    }

    public void setMutationList(List<CitizenMutationInfo> mutationList) {
        this.mutationList = mutationList;
    }
}

