/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.recovery;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CFinancialYear;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.ptis.actions.recovery.BaseRecoveryAction;
import org.egov.ptis.client.model.PropertyBillInfo;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.recovery.IntimationNotice;
import org.egov.ptis.domain.entity.recovery.Recovery;
import org.egov.ptis.domain.entity.recovery.Warrant;
import org.egov.ptis.domain.entity.recovery.WarrantFee;
import org.egov.ptis.notice.PtNotice;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"invalidUser"}, location="workflow", params={"namespace", "/workflow", "method", "inboxItemViewErrorUserInvalid"})})
public class RecoveryAction
extends BaseRecoveryAction {
    private static final long serialVersionUID = 1L;
    private final Logger LOGGER = Logger.getLogger(RecoveryAction.class);
    private Recovery recovery = new Recovery();
    @Autowired
    @Qualifier(value="ptRecoveryPeristenceService")
    private PersistenceService<Recovery, Long> recoveryService;
    protected WorkflowService<Recovery> recoveryWorkflowService;
    private static String MESSAGE = "message";
    private static String WARRANTAPPLICATIONVIEW = "warrantApplicationView";
    private static String WARRANTAPPLICATIONNEW = "warrantApplicationNew";
    private static String NOTICE156NEW = "notice156New";
    private static String NOTICE156VIEW = "notice156View";
    private static String NOTICE159NEW = "notice159New";
    private static String NOTICE159VIEW = "notice159View";
    private static String PRINT = "print";
    private UserService userService;
    @PersistenceContext
    private EntityManager entityManager;

    public RecoveryAction() {
        this.addRelatedEntity("basicProperty", BasicPropertyImpl.class);
        this.addRelatedEntity("bill", EgBill.class);
        this.addRelatedEntity("intimationNotice", IntimationNotice.class);
        this.addRelatedEntity("warrant", Warrant.class);
    }

    public StateAware getModel() {
        return this.recovery;
    }

    public void prepare() {
        if (this.recovery.getId() != null) {
            this.recovery = (Recovery)this.recoveryService.findById((Serializable)this.recovery.getId(), false);
        }
        super.prepare();
        this.setUserInfo();
    }

    public String newform() {
        String returnStr = MESSAGE;
        this.recovery.setBasicProperty(this.getPropertyView(((String[])this.parameters.get("propertyId"))[0]));
        Map wfMap = this.recovery.getBasicProperty().getPropertyWfStatus();
        BigDecimal totalArrDue = BigDecimal.valueOf(Double.valueOf(this.viewMap.get("totalArrDue").toString()));
        StringBuffer consumerId = new StringBuffer();
        consumerId.append(this.recovery.getBasicProperty().getUpicNo()).append("(Zone:").append(this.recovery.getBasicProperty().getPropertyID().getZone().getBoundaryNum()).append(" Ward:").append(this.recovery.getBasicProperty().getPropertyID().getWard().getBoundaryNum()).append(")");
        EgBill bill = this.getBil(consumerId.toString());
        if (((String)wfMap.get("WFSTATUS")).equalsIgnoreCase(Boolean.TRUE.toString()) && StringUtils.isNotEmpty((String)((String)wfMap.get("WFOWNER")))) {
            this.addActionMessage(this.getText("property.state.recovery"));
        } else if (((String)wfMap.get("WFSTATUS")).equalsIgnoreCase(Boolean.TRUE.toString()) && StringUtils.isEmpty((String)((String)wfMap.get("WFOWNER")))) {
            this.addActionMessage(this.getText("property.state.in.recovery"));
        } else if (null == bill) {
            this.addActionMessage(this.getText("bill.not.generated"));
        } else if (totalArrDue.compareTo(BigDecimal.ZERO) == 0) {
            this.addActionMessage(this.getText("tax.arrears.not"));
        } else {
            this.setupWorkflowDetails();
            this.recovery.setBill(bill);
            returnStr = "new";
        }
        return returnStr;
    }

    @ValidationErrorPage(value="new")
    public String startRecovery() {
        this.LOGGER.debug((Object)("RecoveryAction | startRecovery | Start" + this.recovery));
        this.setupWorkflowDetails();
        this.validateStartRecovery(this.recovery);
        this.recovery.getBasicProperty().setStatus(this.getPropStatusByStatusCode("NOTICE155ISSUED"));
        this.recovery.setStatus(this.getEgwStatusForModuleAndCode("PTRecovery", "NOTICE155CREATED"));
        IntimationNotice intimationNotice = this.recovery.getIntimationNotice();
        intimationNotice.setRecovery(this.recovery);
        this.recoveryService.persist((Object)this.recovery);
        Position position = null;
        this.recovery.transition().start().withOwner(position);
        this.updateWfstate("Notice 155");
        this.addActionMessage(this.getText("notice155.success"));
        this.LOGGER.debug((Object)("RecoveryAction | startRecovery | end" + this.recovery));
        return MESSAGE;
    }

    public String view() {
        if (!this.authenticateInboxItemRqst(this.recovery.getState()).booleanValue()) {
            return "invalidUser";
        }
        this.getPropertyView(this.recovery.getBasicProperty().getUpicNo());
        this.setupWorkflowDetails();
        if (this.recovery.getStatus().getCode().equalsIgnoreCase("NOTICE155GENERATED")) {
            return WARRANTAPPLICATIONNEW;
        }
        if (this.recovery.getStatus().getCode().equalsIgnoreCase("WARRANT APPLICATION PREPARED")) {
            return WARRANTAPPLICATIONVIEW;
        }
        if (this.recovery.getStatus().getCode().equalsIgnoreCase("WARRANT APPLICATION APPROVED")) {
            return NOTICE156NEW;
        }
        if (this.recovery.getStatus().getCode().equalsIgnoreCase("WARRANT NOTICE CREATED")) {
            return NOTICE156VIEW;
        }
        if (this.recovery.getStatus().getCode().equalsIgnoreCase("WARRANT NOTICE ISSUED")) {
            return NOTICE159NEW;
        }
        if (this.recovery.getStatus().getCode().equalsIgnoreCase("CEASE NOTICE CREATED")) {
            return NOTICE159VIEW;
        }
        return "view";
    }

    @ValidationErrorPage(value="view")
    public String updateWf() {
        this.updateWfstate(this.recovery.getStatus().getDescription());
        return MESSAGE;
    }

    @ValidationErrorPage(value="view")
    public String generateNotice155() {
        this.LOGGER.debug((Object)("RecoveryAction | generateNotice155 | start" + this.recovery.getIntimationNotice()));
        String noticeNo = this.propertyTaxNumberGenerator.generateRecoveryNotice("Notice 155");
        this.recovery.setStatus(this.getEgwStatusForModuleAndCode("PTRecovery", "NOTICE155GENERATED"));
        this.updateWfstate("Notice 155 Generated");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        CFinancialYear currentFinancialYear = this.propertyTaxUtil.getFinancialYearforDate(this.getCurrentDate());
        String currFinYear = currentFinancialYear.getFinYearRange();
        paramMap.put("paasoon", currFinYear);
        paramMap.put("currentDate", DDMMYYYYFORMATS.format(this.getCurrentDate()));
        paramMap.put("noticeNo", noticeNo);
        PropertyTaxUtil propertyTaxUtil = new PropertyTaxUtil();
        Map reasonwiseDues = propertyTaxUtil.getDemandDues(this.recovery.getBasicProperty().getUpicNo());
        PropertyBillInfo propertyBillInfo = new PropertyBillInfo(reasonwiseDues, this.recovery.getBasicProperty(), null);
        ReportRequest reportRequest = new ReportRequest("Notice-155", (Object)propertyBillInfo, paramMap);
        reportRequest.setPrintDialogOnOpenReport(true);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        this.reportId = this.addingReportToSession(reportOutput);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            ByteArrayInputStream Notice155PDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            PtNotice ptNotice = this.noticeService.saveNotice(null, noticeNo, "Notice 155", this.recovery.getBasicProperty(), (InputStream)Notice155PDF);
            this.recovery.getIntimationNotice().setNotice(ptNotice);
        }
        this.LOGGER.debug((Object)("RecoveryAction | generateNotice155 | end" + this.recovery.getIntimationNotice()));
        return PRINT;
    }

    @ValidationErrorPage(value="warrantApplicationNew")
    public String warrantApplication() {
        this.LOGGER.debug((Object)"RecoveryAction | warrantApplication | Start");
        ((Session)this.entityManager.unwrap(Session.class)).setFlushMode(FlushMode.MANUAL);
        this.setupWorkflowDetails();
        LinkedList<WarrantFee> warrantFess = new LinkedList<WarrantFee>();
        for (WarrantFee warrantFee : this.recovery.getWarrant().getWarrantFees()) {
            EgDemandReason demandReason = (EgDemandReason)this.persistenceService.find(" from EgDemandReason where id=" + warrantFee.getDemandReason().getId());
            warrantFee.setDemandReason(demandReason);
            warrantFess.add(warrantFee);
            this.LOGGER.debug((Object)("RecoveryAction | warrantApplication | Warrant Fee" + warrantFee));
        }
        this.recovery.getWarrant().getWarrantFees().clear();
        this.recovery.getWarrant().getWarrantFees().addAll(warrantFess);
        this.recovery.getBasicProperty().setStatus(this.getPropStatusByStatusCode("WARRANT APPLICATION PREPARED"));
        this.recovery.setStatus(this.getEgwStatusForModuleAndCode("PTRecovery", "WARRANT APPLICATION PREPARED"));
        this.updateWfstate("Warrant Application");
        this.LOGGER.debug((Object)("RecoveryAction | warrantApplication | end" + this.recovery.getWarrant()));
        ((Session)this.entityManager.unwrap(Session.class)).flush();
        this.addActionMessage(this.getText("warrantApp.success"));
        return MESSAGE;
    }

    @ValidationErrorPage(value="warrantApplicationView")
    public String generateWarrantApplicaton() {
        String noticeNo = this.propertyTaxNumberGenerator.generateRecoveryNotice("Warrant-application");
        this.recovery.getBasicProperty().setStatus(this.getPropStatusByStatusCode("WARRANT APPLICATION APPROVED"));
        this.recovery.setStatus(this.getEgwStatusForModuleAndCode("PTRecovery", "WARRANT APPLICATION APPROVED"));
        this.updateWfstate("Warrant-application");
        BigDecimal courtFee = BigDecimal.ZERO;
        BigDecimal noticeFee = BigDecimal.ZERO;
        BigDecimal warrantFee = BigDecimal.ZERO;
        for (WarrantFee fee : this.recovery.getWarrant().getWarrantFees()) {
            if (fee.getDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("WARRANT_FEE")) {
                warrantFee = fee.getAmount();
                continue;
            }
            if (fee.getDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("COURT_FEE")) {
                courtFee = fee.getAmount();
                continue;
            }
            if (!fee.getDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("NOTICE_FEE")) continue;
            noticeFee = fee.getAmount();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        CFinancialYear currentFinancialYear = this.propertyTaxUtil.getFinancialYearforDate(this.getCurrentDate());
        String currFinYear = currentFinancialYear.getFinYearRange();
        paramMap.put("paasoon", currFinYear);
        paramMap.put("noticeDate", new Date());
        paramMap.put("billNo", this.recovery.getBill().getBillNo());
        paramMap.put("warrantFee", warrantFee.toString());
        paramMap.put("courtFee", courtFee.toString());
        paramMap.put("noticeFee", noticeFee.toString());
        paramMap.put("zoneNum", this.recovery.getBasicProperty().getPropertyID().getZone().getBoundaryNum().toString());
        paramMap.put("noticeNo", noticeNo);
        PropertyTaxUtil propertyTaxUtil = new PropertyTaxUtil();
        Map reasonwiseDues = propertyTaxUtil.getDemandDues(this.recovery.getBasicProperty().getUpicNo());
        PropertyBillInfo propertyBillInfo = new PropertyBillInfo(reasonwiseDues, this.recovery.getBasicProperty(), null);
        BigDecimal totalRecoverAmt = propertyBillInfo.getGrandTotal().add(courtFee.add(warrantFee)).setScale(2);
        paramMap.put("totalAmt", totalRecoverAmt.toString());
        ReportRequest reportRequest = new ReportRequest("Warrant-application", (Object)propertyBillInfo, paramMap);
        reportRequest.setPrintDialogOnOpenReport(true);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        this.reportId = this.addingReportToSession(reportOutput);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            ByteArrayInputStream warrantApplPDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            PtNotice ptNotice = this.noticeService.saveNotice(null, noticeNo, "Warrant-application", this.recovery.getBasicProperty(), (InputStream)warrantApplPDF);
            this.recovery.getWarrant().setNotice(ptNotice);
        }
        return PRINT;
    }

    @ValidationErrorPage(value="notice156New")
    public String warrantNotice() {
        this.LOGGER.debug((Object)("RecoveryAction | warrantNotice | Start" + this.recovery.getWarrantNotice()));
        this.setupWorkflowDetails();
        this.validateWarrantNotice(this.recovery);
        this.recovery.getBasicProperty().setStatus(this.getPropStatusByStatusCode("WARRANT NOTICE CREATED"));
        this.recovery.setStatus(this.getEgwStatusForModuleAndCode("PTRecovery", "WARRANT NOTICE CREATED"));
        this.updateWfstate("Notice 156");
        this.addActionMessage(this.getText("notice156.success"));
        this.LOGGER.debug((Object)("RecoveryAction | warrantNotice | end" + this.recovery.getWarrantNotice()));
        return MESSAGE;
    }

    public String generateWarrantNotice() {
        this.LOGGER.debug((Object)("RecoveryAction | generateWarrantNotice | Start" + this.recovery.getWarrantNotice()));
        String noticeNo = this.propertyTaxNumberGenerator.generateRecoveryNotice("Notice 156");
        this.recovery.getBasicProperty().setStatus(this.getPropStatusByStatusCode("WARRANT NOTICE ISSUED"));
        this.recovery.setStatus(this.getEgwStatusForModuleAndCode("PTRecovery", "WARRANT NOTICE ISSUED"));
        this.updateWfstate("Notic 156 Generated");
        this.updateDemand(this.recovery);
        Map paramMap = this.getNotice156Param(this.recovery);
        PropertyTaxUtil propertyTaxUtil = new PropertyTaxUtil();
        Map reasonwiseDues = propertyTaxUtil.getDemandDues(this.recovery.getBasicProperty().getUpicNo());
        PropertyBillInfo propertyBillInfo = new PropertyBillInfo(reasonwiseDues, this.recovery.getBasicProperty(), null);
        String adress = this.recovery.getBasicProperty().getAddress().toString();
        BigDecimal totalRecoverAmt = propertyBillInfo.getGrandTotal().add(BigDecimal.valueOf(Double.valueOf(paramMap.get("totalWarrantFees").toString()))).setScale(2);
        paramMap.put("adress", adress);
        paramMap.put("zoneNum", this.recovery.getBasicProperty().getPropertyID().getZone().getBoundaryNum().toString());
        paramMap.put("totalRecoverAmt", totalRecoverAmt.toString());
        ReportRequest reportRequest = new ReportRequest("Warrent", (Object)propertyBillInfo, paramMap);
        reportRequest.setPrintDialogOnOpenReport(true);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        this.reportId = this.addingReportToSession(reportOutput);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            ByteArrayInputStream Notice156PDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            PtNotice ptNotice = this.noticeService.saveNotice(null, noticeNo, "Notice 156", this.recovery.getBasicProperty(), (InputStream)Notice156PDF);
            this.recovery.getWarrantNotice().setNotice(ptNotice);
        }
        this.LOGGER.debug((Object)("RecoveryAction | generateWarrantNotice | End" + this.recovery.getWarrantNotice()));
        return PRINT;
    }

    @ValidationErrorPage(value="notice159New")
    public String ceaseNotice() {
        this.LOGGER.debug((Object)("RecoveryAction | ceaseNotice | Start" + this.recovery.getCeaseNotice()));
        this.setupWorkflowDetails();
        this.validateCeaseNotice(this.recovery);
        this.recovery.getBasicProperty().setStatus(this.getPropStatusByStatusCode("CEASE NOTICE CREATED"));
        this.recovery.setStatus(this.getEgwStatusForModuleAndCode("PTRecovery", "CEASE NOTICE CREATED"));
        this.updateWfstate("Notice 159");
        this.addActionMessage(this.getText("notice159.success"));
        this.LOGGER.debug((Object)("RecoveryAction | ceaseNotice | end" + this.recovery.getCeaseNotice()));
        return MESSAGE;
    }

    @ValidationErrorPage(value="notice159View")
    public String generateCeaseNotice() {
        this.LOGGER.debug((Object)("RecoveryAction | generateCeaseNotice | Start" + this.recovery.getCeaseNotice()));
        String noticeNo = this.propertyTaxNumberGenerator.generateRecoveryNotice("Notice 159");
        this.recovery.getBasicProperty().setStatus(this.getPropStatusByStatusCode("CEASE NOTICE ISSUED"));
        this.recovery.setStatus(this.getEgwStatusForModuleAndCode("PTRecovery", "CEASE NOTICE ISSUED"));
        Position position = null;
        this.recovery.transition().progress().withNextAction("END").withStateValue("END").withOwner(position).withComments(this.workflowBean.getComments());
        Map paramMap = this.getNotice159Param(this.recovery);
        PropertyTaxUtil propertyTaxUtil = new PropertyTaxUtil();
        Map reasonwiseDues = propertyTaxUtil.getDemandDues(this.recovery.getBasicProperty().getUpicNo());
        PropertyBillInfo propertyBillInfo = new PropertyBillInfo(reasonwiseDues, this.recovery.getBasicProperty(), null);
        BigDecimal totalRecoverAmt = propertyBillInfo.getGrandTotal().add(BigDecimal.valueOf(Double.valueOf(paramMap.get("totalWarrantFees").toString()))).setScale(2);
        paramMap.put("totalRecoverAmt", totalRecoverAmt.toString());
        paramMap.put("executionDate", DDMMYYYYFORMATS.format(this.recovery.getCeaseNotice().getExecutionDate()));
        paramMap.put("currentDate", DDMMYYYYFORMATS.format(new Date()));
        paramMap.put("north", this.recovery.getBasicProperty().getPropertyID().getNorthBoundary());
        paramMap.put("south", this.recovery.getBasicProperty().getPropertyID().getSouthBoundary());
        paramMap.put("zoneNum", this.recovery.getBasicProperty().getPropertyID().getZone().getBoundaryNum().toString());
        paramMap.put("east", this.recovery.getBasicProperty().getPropertyID().getEastBoundary());
        paramMap.put("west", this.recovery.getBasicProperty().getPropertyID().getWestBoundary());
        ReportRequest reportRequest = new ReportRequest("Notice-159", (Object)propertyBillInfo, paramMap);
        reportRequest.setPrintDialogOnOpenReport(true);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        this.reportId = this.addingReportToSession(reportOutput);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            ByteArrayInputStream Notice159PDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            PtNotice ptNotice = this.noticeService.saveNotice(null, noticeNo, "Notice 159", this.recovery.getBasicProperty(), (InputStream)Notice159PDF);
            this.recovery.getCeaseNotice().setNotice(ptNotice);
        }
        this.LOGGER.debug((Object)("RecoveryAction | generateCeaseNotice | End" + this.recovery.getCeaseNotice()));
        return PRINT;
    }

    public String viewDetails() {
        this.getPropertyView(this.recovery.getBasicProperty().getUpicNo());
        return "viewDetails";
    }

    private void updateWfstate(String value) {
        this.LOGGER.debug((Object)"RecoveryAction | updateStateAndStatus | Start");
        if ("Save".equalsIgnoreCase(this.workflowBean.getActionName())) {
            Position position = null;
            this.recovery.transition().progress().withNextAction("Saved : " + value).withOwner(position).withComments(this.workflowBean.getComments());
            this.addActionMessage(this.getText("file.save"));
        } else if ("Forward".equalsIgnoreCase(this.workflowBean.getActionName())) {
            Position position = null;
            User approverUser = this.userService.getUserById(Long.valueOf(this.workflowBean.getApproverUserId()));
            this.recovery.transition().progress().withNextAction("Forwarded : " + value).withStateValue("Forward/Approve").withOwner(position).withComments(this.workflowBean.getComments());
            this.addActionMessage(this.getText("recovery.forward", new String[]{approverUser.getUsername()}));
        } else if ("Approve".equalsIgnoreCase(this.workflowBean.getActionName())) {
            Position position = null;
            User approverUser = this.userService.getUserById(this.recovery.getCreatedBy().getId());
            this.recovery.transition().progress().withNextAction("Approved : " + value).withStateValue(this.getNextState(this.recovery.getStatus().getCode())).withOwner(position).withComments(this.workflowBean.getComments());
            this.addActionMessage(this.getText("recovery.approve", new String[]{approverUser.getUsername()}));
        } else {
            Position position = null;
            User approverUser = this.userService.getUserById(Long.valueOf(this.workflowBean.getApproverUserId()));
            this.recovery.transition().start().withNextAction(value).withStateValue(this.recovery.getStatus().getCode()).withOwner(position).withComments(this.workflowBean.getComments());
            this.addActionMessage(this.getText("recovery.approve", new String[]{approverUser.getUsername()}));
        }
        this.LOGGER.debug((Object)"RecoveryAction | updateStateAndStatus | End");
    }

    public Recovery getRecovery() {
        return this.recovery;
    }

    public void setRecovery(Recovery recovery) {
        this.recovery = recovery;
    }

    public void setRecoveryService(PersistenceService<Recovery, Long> recoveryService) {
        this.recoveryService = recoveryService;
    }

    public void setRecoveryWorkflowService(WorkflowService<Recovery> recoveryWorkflowService) {
        this.recoveryWorkflowService = recoveryWorkflowService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

