/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.modify;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Area;
import org.egov.commons.Installment;
import org.egov.eis.entity.Assignment;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.models.BaseModel;
import org.egov.infstr.services.PersistenceService;
import org.egov.portal.entity.Citizen;
import org.egov.ptis.actions.common.PropertyTaxBaseAction;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyMutationMasterDAO;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.Amalgamation;
import org.egov.ptis.domain.entity.property.AmalgamationOwner;
import org.egov.ptis.domain.entity.property.Apartment;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BuiltUpProperty;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.VacantProperty;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.egov.ptis.master.service.ApartmentService;
import org.egov.ptis.master.service.FloorTypeService;
import org.egov.ptis.master.service.PropertyOccupationService;
import org.egov.ptis.master.service.PropertyUsageService;
import org.egov.ptis.master.service.RoofTypeService;
import org.egov.ptis.master.service.StructureClassificationService;
import org.egov.ptis.master.service.WallTypeService;
import org.egov.ptis.master.service.WoodTypeService;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@ResultPath(value="/WEB-INF/jsp")
@Namespace(value="/amalgamation")
@Results(value={@Result(name={"new"}, location="amalgamation/amalgamation-new.jsp"), @Result(name={"ack"}, location="amalgamation/amalgamation-ack.jsp"), @Result(name={"view"}, location="amalgamation/amalgamation-view.jsp"), @Result(name={"notice"}, location="amalgamation/amalgamation-notice.jsp")})
public class AmalgamationAction
extends PropertyTaxBaseAction {
    private static final long serialVersionUID = 1L;
    private final transient Logger logger = Logger.getLogger(this.getClass());
    protected static final String COMMON_FORM = "commonForm";
    protected static final String RESULT_ACK = "ack";
    private static final String PROPERTY_MODIFY_REJECT_SUCCESS = "property.modify.reject.success";
    private static final String PROPERTY_MODIFY_FINAL_REJECT_SUCCESS = "property.modify.final.reject.success";
    private static final String PROPERTY_MODIFY_APPROVE_SUCCESS = "property.modify.approve.success";
    private static final String PROPERTY_FORWARD_SUCCESS = "property.forward.success";
    protected static final String NOTICE = "notice";
    private BasicProperty basicProp;
    private PropertyImpl oldProperty = new PropertyImpl();
    private PropertyImpl propertyModel = new PropertyImpl();
    private PropertyImpl propWF;
    private String mode;
    private String areaOfPlot;
    private String propAddress;
    private String doorNo;
    private String pinCode;
    private Long floorTypeId;
    private Long roofTypeId;
    private Long wallTypeId;
    private Long woodTypeId;
    private String northBoundary;
    private String southBoundary;
    private String eastBoundary;
    private String westBoundary;
    private String propertyCategory;
    private String docNumber;
    private String oldPropertyTypeCode;
    private String modifyRsn;
    private PropertyTypeMaster propTypeMstr;
    private Boolean wfInitiatorRejected;
    private String[] floorNoStr = new String[100];
    private List<DocumentType> documentTypes = new ArrayList();
    private Map<Integer, String> floorNoMap;
    private Map<String, String> guardianRelationMap;
    private transient PropertyService propService;
    private Map<String, String> propTypeCategoryMap;
    private boolean allowEditDocument = Boolean.FALSE;
    private String reportId;
    private Boolean showAckBtn = Boolean.FALSE;
    private String instStartDt;
    @Autowired
    private transient PropertyPersistenceService basicPropertyService;
    @Autowired
    private transient SecurityUtils securityUtils;
    @Autowired
    private transient PropertyTypeMasterDAO propertyTypeMasterDAO;
    @Autowired
    private transient UserService userService;
    @Autowired
    private transient BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private transient PropertyMutationMasterDAO propertyMutationMasterDAO;
    private transient PersistenceService<Property, Long> propertyImplService;
    @Autowired
    private transient FloorTypeService floorTypeService;
    @Autowired
    private transient RoofTypeService roofTypeService;
    @Autowired
    private transient WallTypeService wallTypeService;
    @Autowired
    private transient WoodTypeService woodTypeService;
    @Autowired
    private transient ApartmentService apartmentService;
    @Autowired
    private transient PropertyUsageService propertyUsageService;
    @Autowired
    private transient StructureClassificationService structureClassificationService;
    @Autowired
    private transient PropertyOccupationService propertyOccupationService;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public AmalgamationAction() {
        this.propertyModel.setPropertyDetail((PropertyDetail)new BuiltUpProperty());
        this.addRelatedEntity("propertyDetail.propertyTypeMaster", PropertyTypeMaster.class);
        this.addRelatedEntity("propertyDetail.apartment", Apartment.class);
    }

    @SkipValidation
    public StateAware getModel() {
        return this.propertyModel;
    }

    public void prepare() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into preapre, ModelId: " + this.getModelId()));
        }
        Map currYearInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Installment currInstFirstHalf = (Installment)currYearInstMap.get("Current 1st Half");
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        this.instStartDt = DateUtils.between((Date)new Date(), (Date)currInstFirstHalf.getFromDate(), (Date)currInstFirstHalf.getToDate()) ? df.format(currInstFirstHalf.getFromDate()) : df.format(((Installment)currYearInstMap.get("Current 2nd Half")).getFromDate());
        super.prepare();
        this.setUserInfo();
        this.setUserDesignations();
        this.propertyByEmployee = this.propService.isEmployee(this.securityUtils.getCurrentUser());
        if (this.getModelId() != null && !this.getModelId().isEmpty()) {
            this.setBasicProp(this.basicPropertyDAO.getBasicPropertyByProperty(Long.valueOf(this.getModelId())));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("prepare: BasicProperty: " + this.basicProp));
            }
            this.propWF = (PropertyImpl)this.getPersistenceService().findByNamedQuery("WORKFLOW_PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
            if (this.propWF != null) {
                this.setProperty(this.propWF);
                this.historyMap = this.propService.populateHistory((StateAware)this.propWF);
            } else {
                this.historyMap = this.propService.populateHistory((StateAware)this.basicProp.getActiveProperty());
            }
        } else if (this.indexNumber != null && !this.indexNumber.trim().isEmpty()) {
            this.setBasicProp((BasicProperty)this.getPersistenceService().findByNamedQuery("getBasicPropertyByUpicNo", new Object[]{this.indexNumber}));
            this.preparePropertyTaxDetails((Property)this.basicProp.getActiveProperty());
        }
        this.documentTypes = this.propService.getDocumentTypesForTransactionType(TransactionType.OBJECTION);
        List usageList = this.propertyUsageService.getAllActivePropertyUsages();
        this.setFloorNoMap((Map)PropertyTaxConstants.FLOOR_MAP);
        this.setGuardianRelationMap((Map)PropertyTaxConstants.GUARDIAN_RELATION);
        this.addDropdownData("floorType", this.floorTypeService.getAllFloors());
        this.addDropdownData("roofType", this.roofTypeService.getAllRoofTypes());
        this.addDropdownData("wallType", this.wallTypeService.getAllWalls());
        this.addDropdownData("woodType", this.woodTypeService.getAllWoodTypes());
        this.addDropdownData("PropTypeMaster", this.propertyTypeMasterDAO.findAllExcludeEWSHS());
        this.addDropdownData("OccupancyList", this.propertyOccupationService.getAllPropertyOccupations());
        this.addDropdownData("StructureList", this.structureClassificationService.getAllActiveStructureTypes());
        this.addDropdownData("apartments", this.apartmentService.getAllApartments());
        this.populatePropertyTypeCategory();
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.propertyCategory})) {
            if (this.propertyCategory.equals("MIXED")) {
                usageList = this.propertyUsageService.getAllActivePropertyUsages();
            } else if (this.propertyCategory.equals("RESIDENTIAl")) {
                usageList = this.propertyUsageService.getResidentialPropertyUsages();
            } else if (this.propertyCategory.equals("NON_RESIDENTIAL")) {
                usageList = this.propertyUsageService.getNonResidentialPropertyUsages();
            }
        }
        this.addDropdownData("UsageList", usageList);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exiting from preapre, ModelId: " + this.getModelId()));
        }
    }

    @SkipValidation
    @Action(value="/amalgamation-newForm")
    public String newForm() {
        this.mode = "edit";
        this.populateFormData();
        return "new";
    }

    private void populateFormData() {
        if (this.basicProp != null) {
            this.populateAddress();
            this.setOldProperty((PropertyImpl)this.getBasicProp().getProperty());
            PropertyImpl propertyImpl = this.propWF == null && (this.propertyModel == null || this.propertyModel.getId() == null) ? (PropertyImpl)this.oldProperty.createPropertyclone() : (this.propWF != null ? this.propWF : this.propertyModel);
            this.setProperty(propertyImpl);
            this.setPropAddress(this.basicProp.getAddress().toString());
            this.populatePropertyDetails();
            this.propertyModel.setBasicProperty(this.basicProp);
            this.setOldPropertyTypeCode(this.oldProperty.getPropertyDetail().getPropertyTypeMaster().getCode());
            this.setDocNumber(this.propertyModel.getDocNumber());
            if (!this.propertyModel.getPropertyDetail().getFloorDetails().isEmpty()) {
                this.setFloorDetails((Property)this.propertyModel);
            }
            this.setAmalgamationPropsAndOwners();
        }
    }

    private void populateAddress() {
        if (this.basicProp.getPropertyOwnerInfo() != null && !this.basicProp.getPropertyOwnerInfo().isEmpty()) {
            for (PropertyOwnerInfo propOwner : this.basicProp.getPropertyOwnerInfo()) {
                List addrSet = propOwner.getOwner().getAddress();
                Iterator iterator = addrSet.iterator();
                if (!iterator.hasNext()) continue;
                Address address = (Address)iterator.next();
                this.propAddress = address.toString();
                this.doorNo = address.getHouseNoBldgApt() == null ? "N/A" : address.getHouseNoBldgApt();
                this.pinCode = address.getPinCode();
            }
        }
    }

    private void populatePropertyDetails() {
        if (this.propertyModel.getPropertyDetail().getFloorType() != null) {
            this.floorTypeId = this.propertyModel.getPropertyDetail().getFloorType().getId();
        }
        if (this.propertyModel.getPropertyDetail().getRoofType() != null) {
            this.roofTypeId = this.propertyModel.getPropertyDetail().getRoofType().getId();
        }
        if (this.propertyModel.getPropertyDetail().getWallType() != null) {
            this.wallTypeId = this.propertyModel.getPropertyDetail().getWallType().getId();
        }
        if (this.propertyModel.getPropertyDetail().getWoodType() != null) {
            this.woodTypeId = this.propertyModel.getPropertyDetail().getWoodType().getId();
        }
        if (this.propertyModel.getPropertyDetail().getSitalArea() != null) {
            this.setAreaOfPlot(this.propertyModel.getPropertyDetail().getSitalArea().getArea().toString());
        }
        if (this.basicProp.getPropertyID() != null) {
            PropertyID propertyID = this.basicProp.getPropertyID();
            this.northBoundary = propertyID.getNorthBoundary();
            this.southBoundary = propertyID.getSouthBoundary();
            this.eastBoundary = propertyID.getEastBoundary();
            this.westBoundary = propertyID.getWestBoundary();
        }
    }

    private void setAmalgamationPropsAndOwners() {
        this.populateAmalgamations();
        this.populateAmalgamationOwners();
    }

    private void populateAmalgamations() {
        if (this.propertyModel.getId() != null && !this.propertyModel.getBasicProperty().getAmalgamations().isEmpty()) {
            for (Amalgamation amal : this.propertyModel.getBasicProperty().getAmalgamations()) {
                BasicProperty amalBasicProp = this.propertyModel.getStatus() == null || this.propertyModel.getStatus() != null && this.propertyModel.getStatus().equals(PropertyTaxConstants.STATUS_WORKFLOW) ? this.basicPropertyDAO.getBasicPropertyByPropertyID(amal.getAmalgamatedProperty().getUpicNo()) : this.basicPropertyDAO.getInActiveBasicPropertyByPropertyID(amal.getAmalgamatedProperty().getUpicNo());
                for (PropertyOwnerInfo propOwner : amalBasicProp.getPropertyOwnerInfo()) {
                    List addrSet = propOwner.getOwner().getAddress();
                    Iterator iterator = addrSet.iterator();
                    if (!iterator.hasNext()) continue;
                    Address address = (Address)iterator.next();
                    amal.setAssessmentNo(amal.getAmalgamatedProperty().getUpicNo());
                    amal.setOwnerName(propOwner.getOwner().getName());
                    amal.setMobileNo(propOwner.getOwner().getMobileNumber());
                    amal.setPropertyAddress(address.toString());
                }
                this.basicProp.getAmalgamationsProxy().add(amal);
            }
        }
    }

    private void populateAmalgamationOwners() {
        if (this.propertyModel.getAmalgamationOwners().isEmpty()) {
            for (PropertyOwnerInfo ownerInfo : this.basicProp.getPropertyOwnerInfo()) {
                AmalgamationOwner amlgOwner = new AmalgamationOwner();
                amlgOwner.setOwner(ownerInfo.getOwner());
                amlgOwner.setProperty((Property)this.propertyModel);
                amlgOwner.setOwnerOfParent(true);
                this.propertyModel.getAmalgamationOwnersProxy().add(amlgOwner);
            }
        } else {
            for (AmalgamationOwner ownerInfo : this.propertyModel.getAmalgamationOwners()) {
                AmalgamationOwner amlgOwner = new AmalgamationOwner();
                amlgOwner.setOwner(ownerInfo.getOwner());
                amlgOwner.setProperty((Property)this.propertyModel);
                this.propertyModel.getAmalgamationOwnersProxy().add(amlgOwner);
            }
        }
    }

    private void setFloorDetails(Property property) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into setFloorDetails, Property: " + property));
        }
        List floors = property.getPropertyDetail().getFloorDetails();
        property.getPropertyDetail().setFloorDetailsProxy(floors);
        int i = 0;
        for (Floor flr : floors) {
            if (this.getModelId() == null) {
                try {
                    flr.setOccupancyDate(new SimpleDateFormat("dd/MM/yyyy").parse(this.instStartDt));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            this.floorNoStr[i] = (String)PropertyTaxConstants.FLOOR_MAP.get(flr.getFloorNo());
            ++i;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Exiting from setFloorDetails: ");
        }
    }

    @SkipValidation
    @Action(value="/amalgamation-forwardModify")
    public String forwardModify() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("forwardModify: Modify property started " + this.propertyModel));
        }
        this.setOldPropertyTypeCode(this.basicProp.getProperty().getPropertyDetail().getPropertyTypeMaster().getCode());
        this.validate();
        long startTimeMillis = System.currentTimeMillis();
        if (this.getModelId() != null && !this.getModelId().trim().isEmpty()) {
            this.propWF = (PropertyImpl)this.getPersistenceService().findByNamedQuery("WORKFLOW_PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("forwardModify: Workflow property: " + this.propWF));
            }
            this.basicProp = this.propWF.getBasicProperty();
            this.setBasicProp(this.basicProp);
        } else {
            this.populateBasicProp();
        }
        this.oldProperty = (PropertyImpl)this.basicProp.getProperty();
        this.setSitalArea();
        this.validateVacantLandConversion();
        if (this.hasErrors()) {
            if (this.checkDesignationsForEdit()) {
                this.allowEditDocument = Boolean.TRUE;
                return "new";
            }
            if (this.checkDesignationsForView()) {
                return "view";
            }
        }
        try {
            this.modifyBasicProp();
        }
        catch (TaxCalculatorExeption e) {
            this.addActionError(this.getText("unitrate.error"));
            this.logger.error((Object)"forwardModify : There are no Unit rates defined for chosen combinations", (Throwable)e);
            return "new";
        }
        this.transitionWorkFlow(this.propertyModel);
        this.basicProp.setUnderWorkflow(Boolean.TRUE.booleanValue());
        this.setAmalgamationsForPersist();
        this.applyAuditingAndUpdateIndex();
        this.prepareAckMsg();
        this.showAckBtn = Boolean.TRUE;
        this.addActionMessage(this.getText(PROPERTY_FORWARD_SUCCESS, new String[]{this.propertyModel.getBasicProperty().getUpicNo()}));
        long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("forwardModify: Amalgamation forwarded successfully; Time taken(ms) = " + elapsedTimeMillis));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"forwardModify: Amalgamation forward ended");
        }
        return RESULT_ACK;
    }

    private void validateVacantLandConversion() {
        PropertyTypeMaster oldPropTypeMstr = this.oldProperty.getPropertyDetail().getPropertyTypeMaster();
        if (this.propTypeMstr != null && !this.propTypeMstr.getType().equals(oldPropTypeMstr.getType()) && this.propTypeMstr.getType().equals("Vacant Land")) {
            this.addActionError(this.getText("error.nonVacantToVacant"));
        }
    }

    private void applyAuditingAndUpdateIndex() {
        this.basicPropertyService.applyAuditing((AbstractAuditable)this.propertyModel.getState());
        this.propService.updateIndexes((StateAware)this.propertyModel, this.getApplicationType());
        if (this.basicProp.getWFProperty() != null && this.basicProp.getWFProperty().getPtDemandSet() != null && !this.basicProp.getWFProperty().getPtDemandSet().isEmpty()) {
            for (Ptdemand ptDemand : this.basicProp.getWFProperty().getPtDemandSet()) {
                this.basicPropertyService.applyAuditing((BaseModel)ptDemand.getDmdCalculations());
            }
        }
        this.basicPropertyService.update((Object)this.basicProp);
    }

    private boolean checkDesignationsForView() {
        return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.userDesignationList, (CharSequence)"Bill Collector") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.userDesignationList, (CharSequence)"Commissioner") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.userDesignationList, (CharSequence)"Revenue officer");
    }

    private boolean checkDesignationsForEdit() {
        return org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.userDesignationList, (CharSequence)"Junior Assistant") || org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)this.userDesignationList, (CharSequence)"Senior Assistant") || this.getModel().getState().getNextAction() != null && this.getModel().getState().getNextAction().equalsIgnoreCase("UD Revenue Inspector Approval Pending");
    }

    private void setSitalArea() {
        if (this.areaOfPlot != null && !this.areaOfPlot.isEmpty()) {
            Area area = new Area();
            area.setArea(new Float(this.areaOfPlot));
            this.propertyModel.getPropertyDetail().setSitalArea(area);
        }
        this.propertyModel.getPropertyDetail().setPropertyTypeMaster(this.propTypeMstr);
    }

    private void setAmalgamationsForPersist() {
        this.basicProp.getAmalgamations().clear();
        for (Amalgamation amlg : this.basicProp.getAmalgamationsProxy()) {
            Amalgamation amalgamatedProp = new Amalgamation();
            BasicProperty amalBasicProp = this.basicPropertyDAO.getBasicPropertyByPropertyID(amlg.getAssessmentNo());
            amalgamatedProp.setParentProperty(this.basicProp);
            amalgamatedProp.setAmalgamatedProperty(amalBasicProp);
            amalBasicProp.setUnderWorkflow(true);
            this.basicPropertyService.applyAuditing((BaseModel)amalgamatedProp);
            this.basicProp.getAmalgamations().add(amalgamatedProp);
        }
    }

    @SkipValidation
    @Action(value="/amalgamation-view")
    public String view() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into view, BasicProperty: " + this.basicProp + ", ModelId: " + this.getModelId()));
        }
        if (this.getModelId() != null) {
            this.propertyModel = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
            this.setModifyRsn(this.propertyModel.getPropertyDetail().getPropertyMutationMaster().getCode());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("view: PropertyModel by model id: " + this.propertyModel));
            }
        }
        if (this.checkDesignationsForEdit()) {
            this.mode = "edit";
            this.allowEditDocument = Boolean.TRUE;
        } else if (this.checkDesignationsForView()) {
            this.mode = "view";
        }
        String currWfState = this.propertyModel.getState().getValue();
        this.populateFormData();
        if (currWfState.endsWith("Commissioner Approved")) {
            this.setIsApprPageReq(Boolean.FALSE);
            if (this.basicProp.getUpicNo() != null && !this.basicProp.getUpicNo().isEmpty()) {
                this.setIndexNumber(this.basicProp.getUpicNo());
            }
        }
        this.setModifyRsn(this.propertyModel.getPropertyDetail().getPropertyMutationMaster().getCode());
        this.setDocNumber(this.propertyModel.getDocNumber());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("view: ModifyReason: " + this.getModifyRsn()));
            this.logger.debug((Object)"Exiting from view");
        }
        return "view";
    }

    @SkipValidation
    @Action(value="/amalgamation-forwardView")
    public String forwardView() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Entered into forwardView");
        }
        this.validateApproverDetails();
        if (this.hasErrors()) {
            if (this.checkDesignationsForEdit()) {
                return "new";
            }
            if (this.checkDesignationsForView()) {
                return "view";
            }
        }
        this.propertyModel = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("forwardView: Workflow property: " + this.propertyModel));
        }
        this.transitionWorkFlow(this.propertyModel);
        this.propService.updateIndexes((StateAware)this.propertyModel, this.getApplicationType());
        this.basicPropertyService.update((Object)this.basicProp);
        this.setModifyRsn(this.propertyModel.getPropertyDetail().getPropertyMutationMaster().getCode());
        this.prepareAckMsg();
        this.addActionMessage(this.getText(PROPERTY_FORWARD_SUCCESS, new String[]{this.propertyModel.getBasicProperty().getUpicNo()}));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Exiting from forwardView");
        }
        return RESULT_ACK;
    }

    private void populateBasicProp() {
        if (this.basicProp == null) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.indexNumber)) {
                this.setBasicProp((BasicProperty)this.getPersistenceService().findByNamedQuery("getBasicPropertyByUpicNo", new Object[]{this.indexNumber}));
            } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.getModelId())) {
                this.setBasicProp(((PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())})).getBasicProperty());
            }
        }
    }

    public void validate() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into validate, ModifyRsn: " + this.modifyRsn));
        }
        this.propertyModel.setBasicProperty(this.basicProp);
        Date propCompletionDate = null;
        if (this.basicProp.getSource() == PropertyTaxConstants.SOURCEOFDATA_MIGRATION || this.basicProp.getSource() == PropertyTaxConstants.SOURCEOFDATA_DATAENTRY) {
            this.setOldProperty((PropertyImpl)this.getBasicProp().getProperty());
            propCompletionDate = this.propertyTaxUtil.getLowestInstallmentForProperty((Property)this.oldProperty);
        }
        if (StringUtils.isBlank((String)this.propertyModel.getPropertyDetail().getCategoryType()) || "-1".equals(this.propertyModel.getPropertyDetail().getCategoryType())) {
            this.addActionError(this.getText("mandatory.propTypeCategory"));
        }
        if (this.basicProp.getAmalgamationsProxy() == null || this.basicProp.getAmalgamationsProxy() != null && ((Amalgamation)this.basicProp.getAmalgamationsProxy().get(0)).getAssessmentNo().isEmpty()) {
            this.addActionError(this.getText("error.amalgamatedprops.required"));
        }
        this.validateOwners();
        PropertyDetail propertyDetail = this.propertyModel.getPropertyDetail();
        Date regDocDate = this.propertyModel.getBasicProperty().getRegdDocDate();
        if (this.propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
            if (propertyDetail != null) {
                this.validateVacantProperty(propertyDetail, this.eastBoundary, this.westBoundary, this.southBoundary, this.northBoundary, this.modifyRsn, propCompletionDate, null, null);
            }
        } else {
            this.validateBuiltUpProperty(propertyDetail, this.floorTypeId, this.roofTypeId, this.areaOfPlot, regDocDate, this.modifyRsn);
            this.validateFloor(this.propTypeMstr, this.propertyModel.getPropertyDetail().getFloorDetailsProxy(), (Property)this.propertyModel, this.areaOfPlot, regDocDate, this.modifyRsn, propCompletionDate);
        }
        this.validateApproverDetails();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exiting from validate, BasicProperty: " + this.getBasicProp()));
        }
    }

    private void validateOwners() {
        for (AmalgamationOwner owner : this.propertyModel.getAmalgamationOwnersProxy()) {
            if (owner == null) continue;
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getName())) {
                this.addActionError(this.getText("mandatory.ownerName"));
            }
            if (null == owner.getOwner().getGender()) {
                this.addActionError(this.getText("mandatory.gender"));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getMobileNumber())) {
                this.addActionError(this.getText("mandatory.mobilenumber"));
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getGuardianRelation())) {
                this.addActionError(this.getText("mandatory.guardianrelation"));
            }
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)owner.getOwner().getGuardian())) continue;
            this.addActionError(this.getText("mandatory.guardian"));
        }
        this.validateDuplicateMobileNo();
    }

    private void validateDuplicateMobileNo() {
        int count = this.propertyModel.getAmalgamationOwnersProxy().size();
        for (int i = 0; i < count; ++i) {
            AmalgamationOwner owner = (AmalgamationOwner)this.propertyModel.getAmalgamationOwnersProxy().get(i);
            if (owner == null) continue;
            for (int j = i + 1; j <= count - 1; ++j) {
                AmalgamationOwner owner1 = (AmalgamationOwner)this.propertyModel.getAmalgamationOwnersProxy().get(j);
                if (owner1 == null || !owner.getOwner().getMobileNumber().equalsIgnoreCase(owner1.getOwner().getMobileNumber()) || !owner.getOwner().getName().equalsIgnoreCase(owner1.getOwner().getName())) continue;
                this.addActionError(this.getText("error.owner.duplicateMobileNo", "", owner.getOwner().getMobileNumber().concat(",").concat(owner.getOwner().getName())));
            }
        }
    }

    private void modifyBasicProp() throws TaxCalculatorExeption {
        Property modProperty = null;
        Character status = PropertyTaxConstants.STATUS_WORKFLOW;
        PropertyTypeMaster proptypeMstr = this.propertyModel.getPropertyDetail().getPropertyTypeMaster();
        Date propCompletionDate = this.getCompletionDate(proptypeMstr);
        PropertyMutationMaster propMutMstr = this.propertyMutationMasterDAO.getPropertyMutationMasterByCode(this.modifyRsn);
        this.basicProp.setPropertyMutationMaster(propMutMstr);
        this.basicProp.setPropOccupationDate(propCompletionDate);
        this.createAmalgamationOwners((Property)this.propertyModel, this.basicProp, (Address)this.basicProp.getAddress());
        this.setProperty(this.propService.createProperty(this.propertyModel, this.getAreaOfPlot(), this.modifyRsn, proptypeMstr.getId().toString(), null, null, status, this.propertyModel.getDocNumber(), null, this.floorTypeId, this.roofTypeId, this.wallTypeId, this.woodTypeId, null, null, null, null, Boolean.FALSE));
        this.updatePropertyID(this.basicProp);
        this.propertyModel.setPropertyModifyReason(this.modifyRsn);
        this.propertyModel.setBasicProperty(this.basicProp);
        this.propertyModel.setEffectiveDate(propCompletionDate);
        this.changePropertyDetail(proptypeMstr);
        try {
            modProperty = this.propService.modifyDemand(this.propertyModel, this.oldProperty);
        }
        catch (TaxCalculatorExeption e) {
            this.logger.error((Object)"modifyBasicProp : Exception occured while modifying demand ", (Throwable)e);
            throw new TaxCalculatorExeption();
        }
        if (modProperty != null && !modProperty.getDocuments().isEmpty()) {
            this.propService.processAndStoreDocument(modProperty.getDocuments());
        }
        if (modProperty == null) {
            this.basicProp.addProperty((Property)this.propertyModel);
        } else {
            this.basicProp.addProperty(modProperty);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Exiting modifyBasicProp");
        }
    }

    private void changePropertyDetail(PropertyTypeMaster proptypeMstr) {
        PropertyTypeMaster vltPropTypeMstr;
        Long oldPropTypeId = this.oldProperty.getPropertyDetail().getPropertyTypeMaster().getId();
        if ((oldPropTypeId == (vltPropTypeMstr = this.propertyTypeMasterDAO.getPropertyTypeMasterByCode("VAC_LAND")).getId() && proptypeMstr.getId() != vltPropTypeMstr.getId() || oldPropTypeId != vltPropTypeMstr.getId() && proptypeMstr.getId() == vltPropTypeMstr.getId()) && !this.propertyModel.getStatus().equals(Character.valueOf('W'))) {
            if (vltPropTypeMstr != null && StringUtils.equals((String)vltPropTypeMstr.getId().toString(), (String)proptypeMstr.getId().toString())) {
                this.propService.changePropertyDetail(this.propertyModel, (PropertyDetail)new VacantProperty(), Integer.valueOf(0));
            } else {
                this.propService.changePropertyDetail(this.propertyModel, (PropertyDetail)new BuiltUpProperty(), this.propertyModel.getPropertyDetail().getNoofFloors());
            }
        }
    }

    private Date getCompletionDate(PropertyTypeMaster proptypeMstr) {
        Date propCompletionDate = !proptypeMstr.getCode().equalsIgnoreCase("VAC_LAND") ? this.propService.getLowestDtOfCompFloorWise(this.propertyModel.getPropertyDetail().getFloorDetailsProxy()) : this.propertyModel.getPropertyDetail().getDateOfCompletion();
        return propCompletionDate;
    }

    private void updatePropertyID(BasicProperty basicProperty) {
        PropertyID propertyId = basicProperty.getPropertyID();
        if (propertyId != null) {
            propertyId.setEastBoundary(this.getEastBoundary());
            propertyId.setWestBoundary(this.getWestBoundary());
            propertyId.setNorthBoundary(this.getNorthBoundary());
            propertyId.setSouthBoundary(this.getSouthBoundary());
        }
    }

    public void createAmalgamationOwners(Property property, BasicProperty basicProperty, Address ownerAddress) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("createOwners for property: " + property + ", basicProperty: " + basicProperty + ", ownerAddress: " + ownerAddress));
        }
        property.getAmalgamationOwners().clear();
        for (AmalgamationOwner ownerInfo : property.getAmalgamationOwnersProxy()) {
            if (ownerInfo != null) {
                User user = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ownerInfo.getOwner().getAadhaarNumber()) ? this.userService.getUserByAadhaarNumber(ownerInfo.getOwner().getAadhaarNumber()) : this.userService.getUserByNameAndMobileNumberForGender(ownerInfo.getOwner().getName(), ownerInfo.getOwner().getMobileNumber(), ownerInfo.getOwner().getGender());
                if (user == null) {
                    Citizen newOwner = new Citizen();
                    newOwner.setAadhaarNumber(ownerInfo.getOwner().getAadhaarNumber());
                    newOwner.setMobileNumber(ownerInfo.getOwner().getMobileNumber());
                    newOwner.setEmailId(ownerInfo.getOwner().getEmailId());
                    newOwner.setGender(ownerInfo.getOwner().getGender());
                    newOwner.setGuardian(ownerInfo.getOwner().getGuardian());
                    newOwner.setGuardianRelation(ownerInfo.getOwner().getGuardianRelation());
                    newOwner.setName(ownerInfo.getOwner().getName());
                    newOwner.setSalutation(ownerInfo.getOwner().getSalutation());
                    newOwner.setPassword("NOT SET");
                    newOwner.setUsername(this.propertyTaxUtil.generateUserName(ownerInfo.getOwner().getName()));
                    this.userService.createUser((User)newOwner);
                    ownerInfo.setProperty(property);
                    ownerInfo.setOwner((User)newOwner);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("createOwners: OwnerAddress: " + ownerAddress));
                    }
                    ownerInfo.getOwner().addAddress((Address)basicProperty.getAddress());
                } else {
                    user.setEmailId(ownerInfo.getOwner().getEmailId());
                    user.setGuardian(ownerInfo.getOwner().getGuardian());
                    user.setGuardianRelation(ownerInfo.getOwner().getGuardianRelation());
                    ownerInfo.setOwner(user);
                    ownerInfo.setProperty(property);
                }
            }
            property.addAmalgamationOwners(ownerInfo);
        }
    }

    private void populatePropertyTypeCategory() {
        if (this.propertyModel != null && this.propertyModel.getPropertyDetail() != null && this.propertyModel.getPropertyDetail().getPropertyTypeMaster() != null && !this.propertyModel.getPropertyDetail().getPropertyTypeMaster().getId().equals(-1)) {
            this.propTypeMstr = this.propertyModel.getPropertyDetail().getPropertyTypeMaster();
        } else if (this.basicProp != null) {
            this.propTypeMstr = this.basicProp.getProperty().getPropertyDetail().getPropertyTypeMaster();
        }
        if (this.propTypeMstr != null) {
            if (this.propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
                this.setPropTypeCategoryMap((Map)PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY);
            } else {
                this.setPropTypeCategoryMap((Map)PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY);
            }
        } else {
            this.setPropTypeCategoryMap(Collections.emptyMap());
        }
    }

    @SkipValidation
    @Action(value="/amalgamation-approve")
    public String approve() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Enter method approve");
        }
        this.propertyModel = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("approve: Workflow property: " + this.propertyModel));
        }
        this.basicProp = this.propertyModel.getBasicProperty();
        this.oldProperty = (PropertyImpl)this.basicProp.getProperty();
        this.transitionWorkFlow(this.propertyModel);
        this.setModifyRsn(this.propertyModel.getPropertyDetail().getPropertyMutationMaster().getCode());
        this.createPropertyStatusValues();
        this.propertyModel.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
        this.oldProperty.setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
        for (PropertyStatusValues statusValues : this.basicProp.getPropertyStatusValuesSet()) {
            this.basicPropertyService.applyAuditing((BaseModel)statusValues);
        }
        String clientSpecificDmdBill = this.propertyTaxCommonUtils.getAppConfigValue("IS_CLIENT_SPECIFIC_DEMANDBILL", "Property Tax");
        if ("Y".equalsIgnoreCase(clientSpecificDmdBill)) {
            this.propertyTaxCommonUtils.makeExistingDemandBillInactive(this.basicProp.getUpicNo());
        } else {
            this.propertyTaxUtil.makeTheEgBillAsHistory(this.basicProp);
        }
        this.propService.updateIndexes((StateAware)this.propertyModel, this.getApplicationType());
        this.basicPropertyService.update((Object)this.basicProp);
        this.setBasicProp(this.basicProp);
        this.setAckMessage(this.getText(PROPERTY_MODIFY_APPROVE_SUCCESS, new String[]{"Amalgamation of Assessment", this.propertyModel.getBasicProperty().getUpicNo()}));
        this.addActionMessage(this.getText(PROPERTY_MODIFY_APPROVE_SUCCESS, new String[]{"Amalgamation of Assessment", this.propertyModel.getBasicProperty().getUpicNo()}));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Exiting approve");
        }
        return RESULT_ACK;
    }

    private void createPropertyStatusValues() {
        PropertyTypeMaster proptypeMstr = this.propertyModel.getPropertyDetail().getPropertyTypeMaster();
        Date propCompletionDate = !proptypeMstr.getCode().equalsIgnoreCase("VAC_LAND") ? this.propService.getLowestDtOfCompFloorWise(this.propertyModel.getPropertyDetail().getFloorDetails()) : this.propertyModel.getPropertyDetail().getDateOfCompletion();
        String[] amalgPropIds = new String[10];
        int i = 0;
        for (Amalgamation amalProp : this.basicProp.getAmalgamations()) {
            amalgPropIds[i] = amalProp.getAmalgamatedProperty().getUpicNo();
            ++i;
        }
        this.basicProp.addPropertyStatusValues(this.propService.createPropStatVal(this.basicProp, this.getModifyRsn(), propCompletionDate, null, null, null, null));
        this.propService.createAmalgPropStatVal(amalgPropIds, this.basicProp);
    }

    @SkipValidation
    @Action(value="/amalgamation-reject")
    public String reject() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"reject: Property rejection started");
        }
        if (StringUtils.isBlank((String)this.approverComments)) {
            this.addActionError(this.getText("property.workflow.remarks"));
            if (this.checkDesignationsForEdit()) {
                return "new";
            }
            if (this.checkDesignationsForView()) {
                return "view";
            }
        }
        this.propertyModel = (PropertyImpl)this.getPersistenceService().findByNamedQuery("PROPERTYIMPL_BYID", new Object[]{Long.valueOf(this.getModelId())});
        if (this.propertyModel.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
            this.propertyModel.getPropertyDetail().getFloorDetails().clear();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("reject: Property: " + this.propertyModel));
        }
        BasicProperty basicProperty = this.propertyModel.getBasicProperty();
        this.setBasicProp(basicProperty);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("reject: BasicProperty: " + basicProperty));
        }
        this.transitionWorkFlow(this.propertyModel);
        if (this.propertyModel.getStatus().equals(PropertyTaxConstants.STATUS_CANCELLED)) {
            for (Amalgamation amalProp : this.basicProp.getAmalgamations()) {
                amalProp.getAmalgamatedProperty().setUnderWorkflow(false);
            }
        }
        this.propService.updateIndexes((StateAware)this.propertyModel, this.getApplicationType());
        this.propertyImplService.update((Object)this.propertyModel);
        this.setModifyRsn(this.propertyModel.getPropertyDetail().getPropertyMutationMaster().getCode());
        String username = this.getInitiator();
        Assignment wfInitiator = this.propService.getWorkflowInitiator(this.propertyModel);
        if (wfInitiator.getEmployee().getUsername().equals(this.securityUtils.getCurrentUser().getUsername())) {
            this.wfInitiatorRejected = Boolean.TRUE;
            this.setAckMessage(this.getText(PROPERTY_MODIFY_FINAL_REJECT_SUCCESS, new String[]{"Amalgamation of Assessment"}));
        } else {
            this.setAckMessage(this.getText(PROPERTY_MODIFY_REJECT_SUCCESS, new String[]{"Amalgamation of Assessment", username}));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"reject: Property rejection ended");
        }
        return RESULT_ACK;
    }

    @SkipValidation
    @Action(value="/amalgamation-printAck")
    public String printAck() {
        ReportOutput reportOutput = this.propertyTaxUtil.generateCitizenCharterAcknowledgement(this.indexNumber, "AMALGAMATION", "Amalgamation");
        this.reportId = this.reportViewerUtil.addReportToTempCache(reportOutput);
        return NOTICE;
    }

    private void prepareAckMsg() {
        String userName = this.propertyTaxUtil.getApproverUserName(this.approverPositionId);
        String action = "Amalgamation of Assessment";
        this.setAckMessage(this.getText("property.modify.forward.success", new String[]{"Amalgamation of Assessment", userName, this.propertyModel.getApplicationNo()}));
    }

    public PropertyImpl getProperty() {
        return this.propertyModel;
    }

    public void setProperty(PropertyImpl property) {
        this.propertyModel = property;
    }

    public String getApplicationType() {
        return "Amalgamation";
    }

    public String getAdditionalRule() {
        return "AMALGAMATION";
    }

    public String getPendingActions() {
        if (this.propWF != null) {
            return this.propWF.getCurrentState().getNextAction();
        }
        if (this.propertyModel.getId() != null && !this.propertyModel.getCurrentState().getValue().endsWith("Rejected")) {
            return this.propertyModel.getCurrentState().getNextAction();
        }
        return this.pendingActions;
    }

    public String getCurrentDesignation() {
        if (this.propWF != null && !this.propWF.getCurrentState().getValue().endsWith("Rejected") && !this.propWF.getCurrentState().getValue().endsWith("NEW")) {
            return this.propService.getDesignationForPositionAndUser(this.propWF.getCurrentState().getOwnerPosition().getId(), this.securityUtils.getCurrentUser().getId());
        }
        if (this.propertyModel.getId() != null && !this.propertyModel.getCurrentState().getValue().endsWith("Rejected") && !this.propertyModel.getCurrentState().getValue().endsWith("NEW")) {
            return this.propService.getDesignationForPositionAndUser(this.propertyModel.getCurrentState().getOwnerPosition().getId(), this.securityUtils.getCurrentUser().getId());
        }
        return this.currentDesignation;
    }

    public PropertyService getPropService() {
        return this.propService;
    }

    public void setPropService(PropertyService propService) {
        this.propService = propService;
    }

    public void setSecurityUtils(SecurityUtils securityUtils) {
        this.securityUtils = securityUtils;
    }

    public BasicProperty getBasicProp() {
        return this.basicProp;
    }

    public void setBasicProp(BasicProperty basicProp) {
        this.basicProp = basicProp;
    }

    public Map<Integer, String> getFloorNoMap() {
        return this.floorNoMap;
    }

    public void setFloorNoMap(Map<Integer, String> floorNoMap) {
        this.floorNoMap = floorNoMap;
    }

    public String getAreaOfPlot() {
        return this.areaOfPlot;
    }

    public void setAreaOfPlot(String areaOfPlot) {
        this.areaOfPlot = areaOfPlot;
    }

    public String getPropAddress() {
        return this.propAddress;
    }

    public void setPropAddress(String propAddress) {
        this.propAddress = propAddress;
    }

    public String getDoorNo() {
        return this.doorNo;
    }

    public void setDoorNo(String doorNo) {
        this.doorNo = doorNo;
    }

    public String getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    public PropertyImpl getOldProperty() {
        return this.oldProperty;
    }

    public void setOldProperty(PropertyImpl oldProperty) {
        this.oldProperty = oldProperty;
    }

    public Long getFloorTypeId() {
        return this.floorTypeId;
    }

    public void setFloorTypeId(Long floorTypeId) {
        this.floorTypeId = floorTypeId;
    }

    public Long getRoofTypeId() {
        return this.roofTypeId;
    }

    public void setRoofTypeId(Long roofTypeId) {
        this.roofTypeId = roofTypeId;
    }

    public Long getWallTypeId() {
        return this.wallTypeId;
    }

    public void setWallTypeId(Long wallTypeId) {
        this.wallTypeId = wallTypeId;
    }

    public Long getWoodTypeId() {
        return this.woodTypeId;
    }

    public void setWoodTypeId(Long woodTypeId) {
        this.woodTypeId = woodTypeId;
    }

    public String getNorthBoundary() {
        return this.northBoundary;
    }

    public void setNorthBoundary(String northBoundary) {
        this.northBoundary = northBoundary;
    }

    public String getSouthBoundary() {
        return this.southBoundary;
    }

    public void setSouthBoundary(String southBoundary) {
        this.southBoundary = southBoundary;
    }

    public String getEastBoundary() {
        return this.eastBoundary;
    }

    public void setEastBoundary(String eastBoundary) {
        this.eastBoundary = eastBoundary;
    }

    public String getWestBoundary() {
        return this.westBoundary;
    }

    public void setWestBoundary(String westBoundary) {
        this.westBoundary = westBoundary;
    }

    public String getPropertyCategory() {
        return this.propertyCategory;
    }

    public void setPropertyCategory(String propertyCategory) {
        this.propertyCategory = propertyCategory;
    }

    public void setPropertyImplService(PersistenceService<Property, Long> propertyImplService) {
        this.propertyImplService = propertyImplService;
    }

    public String getDocNumber() {
        return this.docNumber;
    }

    public void setDocNumber(String docNumber) {
        this.docNumber = docNumber;
    }

    public String[] getFloorNoStr() {
        return this.floorNoStr;
    }

    public void setFloorNoStr(String[] floorNoStr) {
        this.floorNoStr = floorNoStr;
    }

    public String getOldPropertyTypeCode() {
        return this.oldPropertyTypeCode;
    }

    public void setOldPropertyTypeCode(String oldPropertyTypeCode) {
        this.oldPropertyTypeCode = oldPropertyTypeCode;
    }

    public PropertyTypeMaster getPropTypeMstr() {
        return this.propTypeMstr;
    }

    public void setPropTypeMstr(PropertyTypeMaster propTypeMstr) {
        this.propTypeMstr = propTypeMstr;
    }

    public String getModifyRsn() {
        return this.modifyRsn;
    }

    public void setModifyRsn(String modifyRsn) {
        this.modifyRsn = modifyRsn;
    }

    public List<DocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public void setDocumentTypes(List<DocumentType> documentTypes) {
        this.documentTypes = documentTypes;
    }

    public String getAckMessage() {
        return this.ackMessage;
    }

    public void setAckMessage(String ackMessage) {
        this.ackMessage = ackMessage;
    }

    public Boolean getWfInitiatorRejected() {
        return this.wfInitiatorRejected;
    }

    public void setWfInitiatorRejected(Boolean wfInitiatorRejected) {
        this.wfInitiatorRejected = wfInitiatorRejected;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Map<String, String> getGuardianRelationMap() {
        return this.guardianRelationMap;
    }

    public void setGuardianRelationMap(Map<String, String> guardianRelationMap) {
        this.guardianRelationMap = guardianRelationMap;
    }

    public Map<String, String> getPropTypeCategoryMap() {
        return this.propTypeCategoryMap;
    }

    public void setPropTypeCategoryMap(Map<String, String> propTypeCategoryMap) {
        this.propTypeCategoryMap = propTypeCategoryMap;
    }

    public boolean isAllowEditDocument() {
        return this.allowEditDocument;
    }

    public void setAllowEditDocument(boolean allowEditDocument) {
        this.allowEditDocument = allowEditDocument;
    }

    public String getReportId() {
        return this.reportId;
    }

    public Boolean getShowAckBtn() {
        return this.showAckBtn;
    }

    public void setShowAckBtn(Boolean showAckBtn) {
        this.showAckBtn = showAckBtn;
    }

    public String getInstStartDt() {
        return this.instStartDt;
    }

    public void setInstStartDt(String instStartDt) {
        this.instStartDt = instStartDt;
    }
}

