/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.common;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.web.actions.workflow.GenericWorkFlowAction;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.inbox.InboxRenderServiceDeligate;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.ptis.actions.common.AjaxCommonAction;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.document.DocumentTypeDetails;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyDocs;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.WorkflowBean;
import org.egov.ptis.domain.entity.property.vacantland.LayoutApprovalAuthority;
import org.egov.ptis.domain.repository.master.vacantland.LayoutApprovalAuthorityRepository;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.property.SMSEmailService;
import org.egov.ptis.master.service.PropertyUsageService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Query;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class PropertyTaxBaseAction
extends GenericWorkFlowAction {
    private static final String UNAUTHORISED_PENALTY = "unauthorisedPenalty";
    private static final String TOTAL_TAX = "totalTax";
    private static Logger logger = Logger.getLogger(PropertyTaxBaseAction.class);
    private static final long serialVersionUID = 1L;
    protected Boolean isApprPageReq = Boolean.TRUE;
    protected String indexNumber;
    protected String modelId;
    protected String userRole;
    protected String ackMessage;
    protected String userDesgn;
    protected String wfErrorMsg;
    final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private InboxRenderServiceDeligate<StateAware> inboxRenderServiceDeligate;
    @Autowired
    protected EisCommonService eisCommonService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyImpl> propertyWorkflowService;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyService propertyService;
    private SMSEmailService sMSEmailService;
    protected PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private SecurityUtils securityUtils;
    private PropertyImpl propertyModel;
    protected WorkflowBean workflowBean;
    @Autowired
    private PropertyUsageService propertyUsageService;
    @Autowired
    protected PropertyTaxCommonUtils propertyTaxCommonUtils;
    private List<File> uploads = new ArrayList();
    private List<String> uploadFileNames = new ArrayList();
    private List<String> uploadContentTypes = new ArrayList();
    protected Map<String, BigDecimal> propertyTaxDetailsMap = new HashMap(0);
    protected List<Hashtable<String, Object>> historyMap = new ArrayList();
    protected Boolean propertyByEmployee = Boolean.TRUE;
    protected String userDesignationList;
    protected String applicationType;
    protected String initiator;
    @Autowired
    transient LayoutApprovalAuthorityRepository layoutApprovalAuthorityRepo;

    public List<File> getUpload() {
        return this.uploads;
    }

    public void setUpload(List<File> uploads) {
        this.uploads = uploads;
    }

    public List<String> getUploadFileName() {
        return this.uploadFileNames;
    }

    public void setUploadFileName(List<String> uploadFileNames) {
        this.uploadFileNames = uploadFileNames;
    }

    public List<String> getUploadContentType() {
        return this.uploadContentTypes;
    }

    public void setUploadContentType(List<String> contentTypes) {
        this.uploadContentTypes = contentTypes;
    }

    protected void processAndStoreDocumentsWithReason(BasicProperty basicProperty, String reason) {
        if (!this.uploads.isEmpty()) {
            int fileCount = 0;
            for (File file : this.uploads) {
                FileStoreMapper fileStore = this.fileStoreService.store(file, (String)this.uploadFileNames.get(fileCount), (String)this.uploadContentTypes.get(fileCount++), "PTIS");
                PropertyDocs propertyDoc = new PropertyDocs();
                propertyDoc.setSupportDoc(fileStore);
                propertyDoc.setBasicProperty(basicProperty);
                propertyDoc.setReason(reason);
                basicProperty.addDocs(propertyDoc);
            }
        }
    }

    public void validate() {
    }

    protected List<StateHistory> setUpWorkFlowHistory(Long stateId) {
        List workflowHisObj = this.inboxRenderServiceDeligate.getWorkflowHistory(stateId);
        if (this.workflowBean != null) {
            this.workflowBean.setWorkFlowHistoryItems(workflowHisObj);
        }
        return workflowHisObj;
    }

    protected void setupWorkflowDetails() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entered into setupWorkflowDetails | Start");
        }
        if (this.workflowBean != null && logger.isDebugEnabled()) {
            logger.debug((Object)("setupWorkflowDetails: Department: " + this.workflowBean.getDepartmentId() + " Designation: " + this.workflowBean.getDesignationId()));
        }
        AjaxCommonAction ajaxCommonAction = new AjaxCommonAction();
        ajaxCommonAction.setPersistenceService(this.persistenceService);
        ajaxCommonAction.setDesignationService(new DesignationService());
        ajaxCommonAction.setAssignmentService(this.getAssignmentService());
        List departmentsForLoggedInUser = this.propertyTaxUtil.getDepartmentsForLoggedInUser(this.securityUtils.getCurrentUser());
        this.workflowBean.setDepartmentList(departmentsForLoggedInUser);
        this.workflowBean.setDesignationList(Collections.emptyList());
        this.workflowBean.setAppoverUserList(Collections.emptyList());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting from setupWorkflowDetails | End");
        }
    }

    protected void validateProperty(Property property, String areaOfPlot, String dateOfCompletion, String eastBoundary, String westBoundary, String southBoundary, String northBoundary, String propTypeId, String zoneId, String propOccId, Long floorTypeId, Long roofTypeId, Long wallTypeId, Long woodTypeId, String modifyRsn, Date propCompletionDate, Long vacantLandPlotAreaId, Long layoutApprovalAuthorityId, DocumentTypeDetails documentTypeDetails) {
        PropertyTypeMaster propTypeMstr;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entered into validateProperty");
        }
        if (propTypeId == null || "-1".equals(propTypeId)) {
            this.addActionError(this.getText("mandatory.propType"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)property.getPropertyDetail().getCategoryType()) || "-1".equals(property.getPropertyDetail().getCategoryType())) {
            this.addActionError(this.getText("mandatory.propcatType"));
        }
        if (propTypeId != null && !"-1".equals(propTypeId) && (propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.id = ?", new Object[]{Long.valueOf(propTypeId)})) != null) {
            Date regDocDate = null;
            PropertyDetail propertyDetail = property.getPropertyDetail();
            if (documentTypeDetails != null && documentTypeDetails.getDocumentName() != null) {
                Date date = regDocDate = documentTypeDetails.getDocumentName().equals("Registered Document") ? documentTypeDetails.getDocumentDate() : null;
            }
            if (propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
                if (null != propertyDetail) {
                    this.validateVacantProperty(propertyDetail, eastBoundary, westBoundary, southBoundary, northBoundary, modifyRsn, propCompletionDate, vacantLandPlotAreaId, layoutApprovalAuthorityId);
                }
            } else if (null == ((PropertyImpl)property).getId() && Boolean.TRUE.equals(propertyDetail.isAppurtenantLandChecked())) {
                this.validateVacantProperty(propertyDetail, eastBoundary, westBoundary, southBoundary, northBoundary, modifyRsn, propCompletionDate, vacantLandPlotAreaId, layoutApprovalAuthorityId);
                this.validateBuiltUpProperty(propertyDetail, floorTypeId, roofTypeId, areaOfPlot, regDocDate, modifyRsn);
            } else {
                this.validateBuiltUpProperty(propertyDetail, floorTypeId, roofTypeId, areaOfPlot, regDocDate, modifyRsn);
            }
            this.validateFloor(propTypeMstr, property.getPropertyDetail().getFloorDetailsProxy(), property, areaOfPlot, regDocDate, modifyRsn, propCompletionDate);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting from validateProperty");
        }
    }

    public void validateVacantProperty(PropertyDetail propertyDetail, String eastBoundary, String westBoundary, String southBoundary, String northBoundary, String modifyRsn, Date propCompletionDate, Long vacantLandPlotAreaId, Long layoutApprovalAuthorityId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entered into validateVacantProperty");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)propertyDetail.getSurveyNumber())) {
            this.addActionError(this.getText("mandatory.surveyNo"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)propertyDetail.getPattaNumber())) {
            this.addActionError(this.getText("mandatory.pattaNum"));
        }
        if (null == propertyDetail.getSitalArea().getArea()) {
            this.addActionError(this.getText("mandatory.vacantLandArea"));
        }
        if (null == propertyDetail.getDateOfCompletion()) {
            this.addActionError(this.getText("mandatory.dtOfCmpln"));
        }
        if (null == propertyDetail.getCurrentCapitalValue()) {
            this.addActionError(this.getText("mandatory.capitalValue"));
        }
        if (null == propertyDetail.getMarketValue()) {
            this.addActionError(this.getText("mandatory.marketValue"));
        }
        if (propertyDetail.getCurrentCapitalValue() != null && propertyDetail.getCurrentCapitalValue() < Double.parseDouble("500")) {
            this.addActionError(this.getText("minvalue.capitalValue"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)eastBoundary)) {
            this.addActionError(this.getText("mandatory.eastBoundary"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)westBoundary)) {
            this.addActionError(this.getText("mandatory.westBoundary"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)southBoundary)) {
            this.addActionError(this.getText("mandatory.southBoundary"));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)northBoundary)) {
            this.addActionError(this.getText("mandatory.northBoundary"));
        }
        if (vacantLandPlotAreaId == null || Long.valueOf(-1L).equals(vacantLandPlotAreaId)) {
            this.addActionError(this.getText("mandatory.vacanland.plotarea"));
        }
        if (layoutApprovalAuthorityId == null || Long.valueOf(-1L).equals(layoutApprovalAuthorityId)) {
            this.addActionError(this.getText("mandatory.layout.authority"));
        }
        if (layoutApprovalAuthorityId != null && !Long.valueOf(-1L).equals(layoutApprovalAuthorityId) && !"No Approval".equals(((LayoutApprovalAuthority)this.layoutApprovalAuthorityRepo.findOne((Serializable)layoutApprovalAuthorityId)).getName())) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)propertyDetail.getLayoutPermitNo())) {
                this.addActionError(this.getText("mandatory.layout.permitno"));
            }
            if (propertyDetail.getLayoutPermitDate() == null) {
                this.addActionError(this.getText("mandatory.layout.permitdate"));
            }
        }
        if (null != modifyRsn && null != propCompletionDate && null != propCompletionDate && propertyDetail.getDateOfCompletion() != null && !DateUtils.compareDates((Date)propertyDetail.getDateOfCompletion(), (Date)propCompletionDate)) {
            this.addActionError(this.getText("modify.vacant.completiondate.validate"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting from validateVacantProperty");
        }
    }

    public void validateBuiltUpProperty(PropertyDetail propertyDetail, Long floorTypeId, Long roofTypeId, String areaOfPlot, Date regDocDate, String modifyRsn) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Eneterd into validateBuiltUpProperty");
        }
        if (Boolean.TRUE.equals(propertyDetail.isAppurtenantLandChecked()) && null == propertyDetail.getExtentAppartenauntLand()) {
            this.addActionError(this.getText("mandatory.extentAppartnant"));
        } else if (Boolean.FALSE.equals(propertyDetail.isAppurtenantLandChecked()) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)areaOfPlot)) {
            this.addActionError(this.getText("mandatory.extentsite"));
        } else if (Boolean.FALSE.equals(propertyDetail.isAppurtenantLandChecked()) && ("".equals(areaOfPlot) || Double.valueOf(areaOfPlot) == 0.0)) {
            this.addActionError(this.getText("mandatory.extentsite.greaterthanzero"));
        }
        if (floorTypeId == null || floorTypeId == -1L) {
            this.addActionError(this.getText("mandatory.floorType"));
        }
        if (roofTypeId == null || roofTypeId == -1L) {
            this.addActionError(this.getText("mandatory.roofType"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting from validateBuiltUpProperty");
        }
    }

    public void validateFloor(PropertyTypeMaster propTypeMstr, List<Floor> floorList, Property property, String areaOfPlot, Date regDocDate, String modifyRsn, Date propCompletionDate) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entered into validateFloor \nPropertyTypeMaster:" + propTypeMstr + ", No of floors: " + (floorList != null ? floorList : BigDecimal.ZERO)));
        }
        if (!propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND") && floorList != null && !floorList.isEmpty()) {
            for (Floor floor : floorList) {
                PropertyUsage pu;
                if (floor == null) continue;
                boolean buildingPlanNoValidationAdded = false;
                boolean buildingPlanDateValidationAdded = false;
                boolean buildingPlanPlinthAreaValidationAdded = false;
                ArrayList<String> msgParams = new ArrayList<String>();
                if (floor.getFloorNo() == null || floor.getFloorNo().equals(-10)) {
                    this.addActionError(this.getText("mandatory.floorNO"));
                }
                msgParams.add(floor.getFloorNo() != null ? (String)PropertyTaxConstants.FLOOR_MAP.get(floor.getFloorNo()) : "N/A");
                if (floor.getStructureClassification() == null || floor.getStructureClassification().getId() == null || "-1".equals(floor.getStructureClassification().getId().toString())) {
                    this.addActionError(this.getText("mandatory.constType", msgParams));
                }
                if (!floor.getUnstructuredLand().booleanValue()) {
                    if (floor.getBuiltUpArea() == null || floor.getBuiltUpArea().getLength() == null || "".equals(floor.getBuiltUpArea().getLength())) {
                        this.addActionError(this.getText("mandatory.assbleLength", msgParams));
                    }
                    if (floor.getBuiltUpArea() == null || floor.getBuiltUpArea().getBreadth() == null || "".equals(floor.getBuiltUpArea().getBreadth())) {
                        this.addActionError(this.getText("mandatory.assbleWidth", msgParams));
                    }
                }
                if (floor.getPropertyUsage() == null || null == floor.getPropertyUsage().getId() || "-1".equals(floor.getPropertyUsage().getId().toString())) {
                    this.addActionError(this.getText("mandatory.floor.usage", msgParams));
                }
                if (StringUtils.isNotBlank((String)floor.getBuildingPermissionNo())) {
                    if (floor.getBuildingPermissionDate() == null) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.date", msgParams));
                        buildingPlanDateValidationAdded = true;
                    }
                    if (floor.getBuildingPlanPlinthArea().getArea() == null) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.plintharea", msgParams));
                        buildingPlanPlinthAreaValidationAdded = true;
                    }
                }
                if (floor.getBuildingPermissionDate() != null) {
                    if (StringUtils.isBlank((String)floor.getBuildingPermissionNo())) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.number", msgParams));
                        buildingPlanNoValidationAdded = true;
                    }
                    if (floor.getBuildingPlanPlinthArea().getArea() == null && !buildingPlanPlinthAreaValidationAdded) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.plintharea", msgParams));
                    }
                }
                if (floor.getBuildingPlanPlinthArea().getArea() != null) {
                    if (floor.getBuildingPermissionDate() == null && !buildingPlanDateValidationAdded) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.date", msgParams));
                    }
                    if (StringUtils.isBlank((String)floor.getBuildingPermissionNo()) && !buildingPlanNoValidationAdded) {
                        this.addActionError(this.getText("mandatory.floor.buildingplan.number", msgParams));
                    }
                }
                if ((floor.getFirmName() == null || floor.getFirmName().isEmpty() || "".equals(floor.getFirmName())) && floor.getPropertyUsage() != null && null != floor.getPropertyUsage().getId() && !"-1".equals(floor.getPropertyUsage().getId().toString()) && (pu = this.propertyUsageService.findById(Long.valueOf(floor.getPropertyUsage().getId()))) != null && !pu.getUsageName().equalsIgnoreCase("Residence")) {
                    this.addActionError(this.getText("mandatory.floor.firmName", msgParams));
                }
                if (floor.getPropertyOccupation() == null || null == floor.getPropertyOccupation().getId() || "-1".equals(floor.getPropertyOccupation().getId().toString())) {
                    this.addActionError(this.getText("mandatory.floor.occ"));
                }
                if (floor.getConstructionDate() == null || "".equals(floor.getConstructionDate())) {
                    this.addActionError(this.getText("mandatory.floor.constrDate"));
                }
                Date effDate = this.propertyTaxUtil.getEffectiveDateForProperty();
                if (floor.getOccupancyDate() == null || "".equals(floor.getOccupancyDate())) {
                    this.addActionError(this.getText("mandatory.floor.docOcc"));
                }
                if (floor.getOccupancyDate() != null && !"".equals(floor.getOccupancyDate())) {
                    if (floor.getOccupancyDate().after(new Date())) {
                        this.addActionError(this.getText("mandatory.dtFlrBeforeCurr"));
                    }
                    if (floor.getOccupancyDate().before(effDate)) {
                        this.addActionError(this.getText("constrDate.before.6inst", msgParams));
                    }
                }
                if (floor.getOccupancyDate() != null && floor.getConstructionDate() != null && floor.getOccupancyDate().before(floor.getConstructionDate())) {
                    this.addActionError(this.getText("effectiveDate.before.constrDate.error"));
                }
                if (floor.getBuiltUpArea() == null || floor.getBuiltUpArea().getArea() == null || "".equals(floor.getBuiltUpArea().getArea())) {
                    this.addActionError(this.getText("mandatory.assbleArea"));
                } else if (StringUtils.isNotBlank((String)areaOfPlot) && (double)floor.getBuiltUpArea().getArea().floatValue() > Double.valueOf(areaOfPlot)) {
                    this.addActionError(this.getText("assbleArea.notgreaterthan.extentsite"));
                }
                if ((modifyRsn == null || modifyRsn != null && !modifyRsn.equals("ADD_OR_ALTER") && !modifyRsn.equals("BIFURCATE")) && null != regDocDate && null != floor.getOccupancyDate() && !"".equals(floor.getOccupancyDate()) && DateUtils.compareDates((Date)regDocDate, (Date)floor.getOccupancyDate())) {
                    this.addActionError(this.getText("regDate.notgreaterthan.occDate", msgParams));
                }
                if (null == modifyRsn || null == propCompletionDate || null == propCompletionDate || floor.getOccupancyDate() == null || "".equals(floor.getOccupancyDate()) || DateUtils.compareDates((Date)floor.getOccupancyDate(), (Date)propCompletionDate)) continue;
                this.addActionError(this.getText("modify.builtup.occDate.validate", msgParams));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting from validate");
        }
    }

    protected void validateHouseNumber(Long wardId, String houseNo, BasicProperty basicProperty) {
        Query qry = this.getPersistenceService().getSession().createQuery("from BasicPropertyImpl bp where bp.address.houseNoBldgApt = :houseNo and bp.boundary.id = :wardId and bp.active = 'Y'");
        qry.setParameter("houseNo", (Object)houseNo);
        qry.setParameter("wardId", (Object)wardId);
        if (!qry.list().isEmpty() && (basicProperty == null || basicProperty != null && !basicProperty.getAddress().getHouseNoBldgApt().equals(houseNo))) {
            this.addActionError(this.getText("houseNo.unique"));
        }
    }

    public void setUserInfo() {
        Designation designation;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entered into setUserInfo");
        }
        Long userId = this.securityUtils.getCurrentUser().getId();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setUserInfo: Logged in userId" + userId));
        }
        if ((designation = this.propertyTaxUtil.getDesignationForUser(userId)) != null) {
            this.setUserDesgn(designation.getName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exit from setUserInfo");
        }
    }

    public void setUserDesignations() {
        Long userId = this.securityUtils.getCurrentUser().getId();
        String designations = this.propertyTaxCommonUtils.getAllDesignationsForUser(userId);
        this.setUserDesignationList(designations);
    }

    public void transitionWorkFlow(PropertyImpl property) {
        String approvalmesg;
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Assignment wfInitiator = null;
        String nature = this.getNatureOfTask();
        String nextAction = "";
        String approverDesignation = "";
        if (!this.propertyByEmployee.booleanValue() || "Anonymous".equalsIgnoreCase(this.securityUtils.getCurrentUser().getName())) {
            this.currentState = "Created";
            Assignment assignment = this.propertyService.isCscOperator(user) != false ? this.propertyService.getMappedAssignmentForCscOperator(property.getBasicProperty()) : this.propertyService.getUserPositionByZone(property.getBasicProperty(), false);
            if (null != assignment) {
                this.approverPositionId = assignment.getPosition().getId();
                this.approverName = assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
                wfInitiator = assignment;
                approverDesignation = assignment.getDesignation().getName();
            }
        } else {
            this.currentState = null;
            if (null != this.approverPositionId && this.approverPositionId != -1L) {
                Assignment assignment = (Assignment)this.assignmentService.getAssignmentsForPosition(this.approverPositionId, new Date()).get(0);
                this.approverName = assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
                approverDesignation = assignment.getDesignation().getName();
            }
        }
        String loggedInUserDesignation = "";
        if (property.getState() != null) {
            List loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(property.getCurrentState().getOwnerPosition().getId(), user.getId(), new Date());
            String string = loggedInUserDesignation = !loggedInUserAssign.isEmpty() ? ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName() : null;
        }
        if (loggedInUserDesignation.equals("Junior Assistant") || loggedInUserDesignation.equals("Senior Assistant")) {
            loggedInUserDesignation = null;
        }
        if ("Forward".equalsIgnoreCase(this.workFlowAction) && (approverDesignation.equalsIgnoreCase("Assistant commissioner") || approverDesignation.equalsIgnoreCase("Deputy commissioner") || approverDesignation.equalsIgnoreCase("Additional Commissioner") || approverDesignation.equalsIgnoreCase("Zonal Commissioner") || approverDesignation.equalsIgnoreCase("Commissioner"))) {
            String designation;
            nextAction = property.getCurrentState().getNextAction().equalsIgnoreCase("Digital Signature Pending") ? "Digital Signature Pending" : ((designation = approverDesignation.split(" ")[0]).equalsIgnoreCase("Commissioner") ? "Commissioner Approval Pending" : designation + " " + "Commissioner Approval Pending");
        }
        if (property.getId() != null) {
            wfInitiator = this.propertyService.getWorkflowInitiator(property);
        } else if (wfInitiator == null) {
            wfInitiator = this.propertyTaxCommonUtils.getWorkflowInitiatorAssignment(user.getId());
        }
        if ("Reject".equalsIgnoreCase(this.workFlowAction)) {
            if (wfInitiator.getPosition().equals((Object)property.getState().getOwnerPosition())) {
                property.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withDateInfo(currentDate.toDate());
                property.setStatus(PropertyTaxConstants.STATUS_CANCELLED);
                property.getBasicProperty().setUnderWorkflow(Boolean.FALSE.booleanValue());
            } else {
                if (loggedInUserDesignation.equalsIgnoreCase("Revenue officer") || loggedInUserDesignation.equalsIgnoreCase("Assistant commissioner") || loggedInUserDesignation.equalsIgnoreCase("Additional Commissioner") || loggedInUserDesignation.equalsIgnoreCase("Deputy commissioner") || loggedInUserDesignation.equalsIgnoreCase("Commissioner") || loggedInUserDesignation.equalsIgnoreCase("Zonal Commissioner")) {
                    Assignment assignmentOnreject;
                    nextAction = "UD Revenue Inspector Approval Pending";
                    wfInitiator = assignmentOnreject = this.propertyService.getUserOnRejection((StateAware)property);
                    this.setInitiator(assignmentOnreject.getEmployee().getName().concat("~").concat(assignmentOnreject.getPosition().getName()));
                } else if (loggedInUserDesignation.equalsIgnoreCase("Bill Collector") || loggedInUserDesignation.equalsIgnoreCase("UD Revenue Inspector")) {
                    nextAction = "Assistant Approval Pending";
                    this.setInitiator(wfInitiator.getEmployee().getName().concat("~").concat(wfInitiator.getPosition().getName()));
                }
                String stateValue = property.getCurrentState().getValue().split(":")[0] + ":" + "Rejected";
                property.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withStateValue(stateValue).withDateInfo(currentDate.toDate()).withOwner(wfInitiator != null ? wfInitiator.getPosition() : null).withNextAction(property.getBasicProperty().getSource().equals(PropertyTaxConstants.SOURCEOFDATA_MOBILE) ? "UD Revenue Inspector Approval Pending" : nextAction);
            }
        } else {
            Position pos = "Approve".equalsIgnoreCase(this.workFlowAction) ? property.getCurrentState().getOwnerPosition() : (null != this.approverPositionId && this.approverPositionId != -1L ? (Position)this.persistenceService.find("from Position where id=?", new Object[]{this.approverPositionId}) : wfInitiator.getPosition());
            if (property.getState() == null) {
                WorkFlowMatrix wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, this.getAdditionalRule(), this.currentState, null);
                property.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(nature).withInitiator(wfInitiator != null ? wfInitiator.getPosition() : null);
            } else if (property.getCurrentState().getNextAction().equalsIgnoreCase("END")) {
                property.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withDateInfo(currentDate.toDate());
            } else {
                WorkFlowMatrix wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, this.getAdditionalRule(), property.getCurrentState().getValue(), property.getState().getNextAction(), null, loggedInUserDesignation);
                property.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(this.approverComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(StringUtils.isNotBlank((String)nextAction) ? nextAction : wfmatrix.getNextAction());
            }
        }
        if (this.approverName != null && !this.approverName.isEmpty() && !this.approverName.equalsIgnoreCase("----Choose----")) {
            approvalmesg = " Succesfully Forwarded to : ";
            this.ackMessage = this.ackMessage == null ? " Succesfully Forwarded to : " : this.ackMessage + " Succesfully Forwarded to : ";
        } else if (this.workFlowAction != null && this.workFlowAction.equalsIgnoreCase("cancel")) {
            approvalmesg = " Succesfully Cancelled.";
            String string = this.ackMessage = this.ackMessage == null ? " Succesfully Cancelled." : this.ackMessage + " Succesfully Cancelled.";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Exiting method : transitionWorkFlow");
        }
    }

    private String getNatureOfTask() {
        String nature = "NEW ASSESSMENT".equalsIgnoreCase(this.getAdditionalRule()) ? "New Assessment" : ("ALTER ASSESSMENT".equalsIgnoreCase(this.getAdditionalRule()) ? "Addition/Alteration" : ("BIFURCATE ASSESSMENT".equalsIgnoreCase(this.getAdditionalRule()) ? "Bifurcation" : ("DEMOLITION".equalsIgnoreCase(this.getAdditionalRule()) ? "Demolition" : ("EXEMPTION".equalsIgnoreCase(this.getAdditionalRule()) ? "Tax Exemption" : ("AMALGAMATION".equalsIgnoreCase(this.getAdditionalRule()) ? "Amalgamation" : ("GENERAL REVISION PETITION".equalsIgnoreCase(this.getAdditionalRule()) ? "General Revision Petition" : "PropertyImpl"))))));
        return nature;
    }

    public void validateApproverDetails() {
        if (("Forward".equals(this.workFlowAction) || "Save".equals(this.workFlowAction)) && null != this.approverPositionId && this.approverPositionId == -1L) {
            this.addActionError(this.getText("property.workflow.approver.errormessage"));
        }
        if ("Reject".equals(this.workFlowAction) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.approverComments)) {
            this.addActionError(this.getText("property.workflow.remarks"));
        }
    }

    public void buildEmailandSms(PropertyImpl property, String applicationType) {
        for (PropertyOwnerInfo ownerInfo : property.getBasicProperty().getPropertyOwnerInfo()) {
            this.buildEmailAndSms(property, ownerInfo.getOwner(), applicationType);
        }
    }

    private void buildEmailAndSms(PropertyImpl property, User user, String applicationType) {
        String mobileNumber = user.getMobileNumber();
        String emailid = user.getEmailId();
        String applicantName = user.getName();
        ArrayList<String> args = new ArrayList<String>();
        args.add(applicantName);
        String smsMsg = "";
        String emailSubject = "";
        String emailBody = "";
        Map demandCollMap = this.ptDemandDAO.getDemandCollMap((Property)property);
        if (null != property && null != property.getState()) {
            State propertyState = property.getState();
            if (propertyState.getValue().endsWith("Assistant Approved")) {
                args.add(property.getApplicationNo());
                if ("New_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.newpropertycreate.sms", args);
                    }
                    if (emailid != null) {
                        args.add(ApplicationThreadLocals.getMunicipalityName());
                        emailSubject = this.getText("msg.newpropertycreate.email.subject", new String[]{property.getApplicationNo()});
                        emailBody = this.getText("msg.newpropertycreate.email", args);
                    }
                } else if ("Alteration of Assessment".equals(applicationType) || "Alter_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.alterAssessmentForward.sms", args);
                    }
                    if (emailid != null) {
                        args.add(ApplicationThreadLocals.getMunicipalityName());
                        emailSubject = this.getText("msg.alterAssessmentForward.email.subject", new String[]{property.getApplicationNo()});
                        emailBody = this.getText("msg.alterAssessmentForward.email", args);
                    }
                } else if ("General_Revision_Petition".equals(applicationType)) {
                    smsMsg = this.getText("msg.grpcreate.sms", args);
                    args.add(ApplicationThreadLocals.getMunicipalityName());
                    emailSubject = this.getText("msg.grpcreate.email.subject", new String[]{property.getApplicationNo()});
                    emailBody = this.getText("msg.grpcreate.email", args);
                }
            } else if (propertyState.getValue().endsWith("Rejected")) {
                args.add(property.getApplicationNo());
                args.add(ApplicationThreadLocals.getMunicipalityName());
                if ("New_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.newpropertyreject.sms", args);
                    }
                    if (emailid != null) {
                        emailSubject = this.getText("msg.newpropertyreject.email.subject", new String[]{property.getApplicationNo()});
                        emailBody = this.getText("msg.newpropertyreject.email", args);
                    }
                } else if ("Alteration of Assessment".equals(applicationType) || "Alter_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.alterAssessmentReject.sms", args);
                    }
                    if (emailid != null) {
                        emailSubject = this.getText("msg.alterAssessmentReject.email.subject", new String[]{property.getApplicationNo()});
                        emailBody = this.getText("msg.alterAssessmentReject.email", args);
                    }
                } else if ("General_Revision_Petition".equals(applicationType)) {
                    smsMsg = this.getText("msg.grpreject.sms", args);
                    emailSubject = this.getText("msg.grpreject.email.subject", new String[]{property.getApplicationNo()});
                    emailBody = this.getText("msg.grpreject.email", args);
                }
            } else if (propertyState.getValue().endsWith("Commissioner Approved")) {
                args.add(property.getBasicProperty().getUpicNo());
                Map installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                Installment installmentFirstHalf = (Installment)installmentMap.get("Current 1st Half");
                args.add(((BigDecimal)demandCollMap.get(DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate()) ? "CURR_FIRSTHALF_DMD" : "CURR_SECONDHALF_DMD")).toString());
                args.add(DateUtils.getFormattedDate((Date)property.getBasicProperty().getPropOccupationDate(), (String)"dd/MM/yyyy"));
                args.add(ApplicationThreadLocals.getMunicipalityName());
                if ("New_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.newpropertyapprove.sms", args);
                    }
                    if (emailid != null) {
                        emailSubject = this.getText("msg.newpropertyapprove.email.subject", new String[]{property.getBasicProperty().getUpicNo()});
                        emailBody = this.getText("msg.newpropertyapprove.email", args);
                    }
                } else if ("Alteration of Assessment".equals(applicationType) || "Alter_Assessment".equals(applicationType)) {
                    if (mobileNumber != null) {
                        smsMsg = this.getText("msg.alterAssessmentApprove.sms", args);
                    }
                    if (emailid != null) {
                        emailSubject = this.getText("msg.alterAssessmentApprove.email.subject");
                        emailBody = this.getText("msg.alterAssessmentApprove.email", args);
                    }
                } else if ("General_Revision_Petition".equals(applicationType)) {
                    smsMsg = this.getText("msg.grpapprove.sms", args);
                    emailSubject = this.getText("msg.grpapprove.email.subject", new String[]{property.getApplicationNo()});
                    emailBody = this.getText("msg.grpapprove.email", args);
                }
            }
        }
        if (StringUtils.isNotBlank((String)mobileNumber) && StringUtils.isNotBlank((String)smsMsg)) {
            this.messagingService.sendSMS(mobileNumber, smsMsg);
        }
        if (StringUtils.isNotBlank((String)emailid) && StringUtils.isNotBlank((String)emailSubject) && StringUtils.isNotBlank((String)emailBody)) {
            this.messagingService.sendEmail(emailid, emailSubject, emailBody);
        }
    }

    public void preparePropertyTaxDetails(Property property) {
        Map installmentMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Installment installmentFirstHalf = (Installment)installmentMap.get("Current 1st Half");
        Installment installmentSecondHalf = (Installment)installmentMap.get("Current 2nd Half");
        Map demandCollMap = null;
        if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
            demandCollMap = this.propertyTaxUtil.prepareDemandDetForWorkflowProperty(property, installmentFirstHalf, installmentFirstHalf);
        } else if (DateUtils.between((Date)new Date(), (Date)installmentSecondHalf.getFromDate(), (Date)installmentSecondHalf.getToDate())) {
            demandCollMap = this.propertyTaxUtil.prepareDemandDetForWorkflowProperty(property, installmentFirstHalf, installmentSecondHalf);
        }
        Ptdemand ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        if (null != ptDemand && ptDemand.getDmdCalculations() != null && ptDemand.getDmdCalculations().getAlv() != null) {
            this.propertyTaxDetailsMap.put("ARV", ptDemand.getDmdCalculations().getAlv());
        } else {
            this.propertyTaxDetailsMap.put("ARV", BigDecimal.ZERO);
        }
        this.propertyTaxDetailsMap.put("eduCess", demandCollMap.get("Education Cess") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Education Cess"));
        this.propertyTaxDetailsMap.put("libraryCess", demandCollMap.get("Library Cess") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Library Cess"));
        if (!property.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
            this.propertyTaxDetailsMap.put("generalTax", demandCollMap.get("General Tax") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("General Tax"));
            BigDecimal totalTax = (demandCollMap.get("General Tax") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("General Tax")).add(demandCollMap.get("Education Cess") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Education Cess")).add(demandCollMap.get("Library Cess") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Library Cess"));
            if (demandCollMap.get("Unauthorized Penalty") != null) {
                this.propertyTaxDetailsMap.put(UNAUTHORISED_PENALTY, demandCollMap.get("Unauthorized Penalty"));
                this.propertyTaxDetailsMap.put(TOTAL_TAX, totalTax.add((BigDecimal)demandCollMap.get("Unauthorized Penalty")));
            } else {
                this.propertyTaxDetailsMap.put(TOTAL_TAX, totalTax);
            }
        } else {
            this.propertyTaxDetailsMap.put("vacantLandTax", demandCollMap.get("Vacant Land Tax") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Vacant Land Tax"));
            BigDecimal totalTax = (demandCollMap.get("Vacant Land Tax") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Vacant Land Tax")).add(demandCollMap.get("Library Cess") == null ? BigDecimal.ZERO : (BigDecimal)demandCollMap.get("Library Cess"));
            if (demandCollMap.get("Unauthorized Penalty") != null) {
                this.propertyTaxDetailsMap.put(UNAUTHORISED_PENALTY, demandCollMap.get("Unauthorized Penalty"));
                this.propertyTaxDetailsMap.put(TOTAL_TAX, totalTax.add((BigDecimal)demandCollMap.get("Unauthorized Penalty")));
            } else {
                this.propertyTaxDetailsMap.put(TOTAL_TAX, totalTax);
            }
            this.propertyTaxDetailsMap.put(TOTAL_TAX, totalTax);
        }
    }

    public void validateDocumentDetails(DocumentTypeDetails documentTypeDetails) {
        if (documentTypeDetails.getDocumentName() == null || "-1".equals(documentTypeDetails.getDocumentName())) {
            this.addActionError(this.getText("mandatory.doctype"));
        } else {
            this.validateCertificateDocDetails(documentTypeDetails);
            this.validateWillDocDetails(documentTypeDetails);
            this.validateDecreeDocDetails(documentTypeDetails);
            this.validateRegisteredDocDetails(documentTypeDetails);
            if ("Patta Certificate (Issued by Revenue Department)".equals(documentTypeDetails.getDocumentName()) && documentTypeDetails.getProceedingNo().isEmpty()) {
                this.addActionError(this.getText("mandatory.dtd.procno"));
            }
            if ("Patta Certificate (Issued by Revenue Department)".equals(documentTypeDetails.getDocumentName()) && documentTypeDetails.getProceedingDate() == null) {
                this.addActionError(this.getText("mandatory.dtd.procdate"));
            }
            if ("Decree by Civil Court".equals(documentTypeDetails.getDocumentName()) && documentTypeDetails.getCourtName().isEmpty()) {
                this.addActionError(this.getText("mandatory.dtd.courtname"));
            }
        }
    }

    public void validateCertificateDocDetails(DocumentTypeDetails documentTypeDetails) {
        if ("Patta Certificate (Issued by Revenue Department)".equals(documentTypeDetails.getDocumentName()) && documentTypeDetails.getDocumentNo().isEmpty()) {
            this.addActionError(this.getText("mandatory.dtd.certificate.no"));
        }
        if ("Patta Certificate (Issued by Revenue Department)".equals(documentTypeDetails.getDocumentName()) && documentTypeDetails.getDocumentDate() == null) {
            this.addActionError(this.getText("mandatory.dtd.certificate.date"));
        }
    }

    public void validateWillDocDetails(DocumentTypeDetails documentTypeDetails) {
        if (this.checkWillDocDetails(documentTypeDetails).booleanValue() && documentTypeDetails.getDocumentNo().isEmpty()) {
            this.addActionError(this.getText("mandatory.dtd.deed.no"));
        }
        if (this.checkWillDocDetails(documentTypeDetails).booleanValue() && documentTypeDetails.getDocumentDate() == null) {
            this.addActionError(this.getText("mandatory.dtd.deed.date"));
        }
    }

    public void validateDecreeDocDetails(DocumentTypeDetails documentTypeDetails) {
        if ("Decree by Civil Court".equals(documentTypeDetails.getDocumentName()) && documentTypeDetails.getDocumentNo().isEmpty()) {
            this.addActionError(this.getText("mandatory.dtd.decree.no"));
        }
        if ("Decree by Civil Court".equals(documentTypeDetails.getDocumentName()) && documentTypeDetails.getDocumentDate() == null) {
            this.addActionError(this.getText("mandatory.dtd.decree.date"));
        }
    }

    public void validateRegisteredDocDetails(DocumentTypeDetails documentTypeDetails) {
        if ("Registered Document".equals(documentTypeDetails.getDocumentName()) && documentTypeDetails.getDocumentNo().isEmpty()) {
            this.addActionError(this.getText("mandatory.dtd.registered.no"));
        }
        if ("Registered Document".equals(documentTypeDetails.getDocumentName()) && documentTypeDetails.getDocumentDate() == null) {
            this.addActionError(this.getText("mandatory.dtd.registered.date"));
        }
    }

    public Boolean checkWillDocDetails(DocumentTypeDetails documentTypeDetails) {
        return "Registered Will Document".equals(documentTypeDetails.getDocumentName()) || "Un-registered Will Document".equals(documentTypeDetails.getDocumentName());
    }

    public WorkflowBean getWorkflowBean() {
        return this.workflowBean;
    }

    public void setWorkflowBean(WorkflowBean workflowBean) {
        this.workflowBean = workflowBean;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public String getUserDesgn() {
        return this.userDesgn;
    }

    public void setUserDesgn(String userDesgn) {
        this.userDesgn = userDesgn;
    }

    public Boolean getIsApprPageReq() {
        return this.isApprPageReq;
    }

    public void setIsApprPageReq(Boolean isApprPageReq) {
        this.isApprPageReq = isApprPageReq;
    }

    public String getIndexNumber() {
        return this.indexNumber;
    }

    public void setIndexNumber(String indexNumber) {
        this.indexNumber = indexNumber;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }

    public AssignmentService getAssignmentService() {
        return this.assignmentService;
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public String getApproverName() {
        return this.approverName;
    }

    public void setApproverName(String approverName) {
        this.approverName = approverName;
    }

    public SimpleWorkflowService<PropertyImpl> getPropertyWorkflowService() {
        return this.propertyWorkflowService;
    }

    public void setPropertyWorkflowService(SimpleWorkflowService<PropertyImpl> propertyWorkflowService) {
        this.propertyWorkflowService = propertyWorkflowService;
    }

    public SMSEmailService getsMSEmailService() {
        return this.sMSEmailService;
    }

    public void setsMSEmailService(SMSEmailService sMSEmailService) {
        this.sMSEmailService = sMSEmailService;
    }

    public Boolean getPropertyByEmployee() {
        return this.propertyByEmployee;
    }

    public void setPropertyByEmployee(Boolean propertyByEmployee) {
        this.propertyByEmployee = propertyByEmployee;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public PropertyImpl getProperty() {
        return this.propertyModel;
    }

    public void setProperty(PropertyImpl property) {
        this.propertyModel = property;
    }

    public String getWfErrorMsg() {
        return this.wfErrorMsg;
    }

    public void setWfErrorMsg(String wfErrorMsg) {
        this.wfErrorMsg = wfErrorMsg;
    }

    public List<Hashtable<String, Object>> getHistoryMap() {
        return this.historyMap;
    }

    public void setHistoryMap(List<Hashtable<String, Object>> historyMap) {
        this.historyMap = historyMap;
    }

    public String getUserDesignationList() {
        return this.userDesignationList;
    }

    public void setUserDesignationList(String userDesignationList) {
        this.userDesignationList = userDesignationList;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }
}

