/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.writeOff;

import java.math.BigDecimal;
import java.util.Map;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/writeOff"})
public class WriteOffController
extends GenericWorkFlowController {
    private static final String WRITE_OFF_FORM = "writeOff-form";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    private BasicProperty basicProperty;
    private PropertyImpl propertyImpl;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    @Qualifier(value="documentTypePersistenceService")
    private PersistenceService<DocumentType, Long> documentTypePersistenceService;

    @ModelAttribute
    public Property propertyModel(@PathVariable String assessmentNo) {
        this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        if (null != this.basicProperty) {
            this.propertyImpl = this.basicProperty.getActiveProperty();
        }
        return this.propertyImpl;
    }

    @RequestMapping(value={"/form/{assessmentNo}"}, method={RequestMethod.GET})
    public String form(@PathVariable(value="assessmentNo") String assessmentNo, Model model) {
        this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        if (null != this.basicProperty && this.basicProperty.isUnderWorkflow()) {
            model.addAttribute("wfPendingMsg", (Object)"Could not do Write Off now, property is undergoing some work flow.");
            return "workFlowError";
        }
        Map propertyTaxDetails = this.ptDemandDAO.getDemandCollMap((Property)this.basicProperty.getActiveProperty());
        BigDecimal currTaxDue = ((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_DMD")).subtract((BigDecimal)propertyTaxDetails.get("CURR_FIRSTHALF_COLL"));
        BigDecimal arrearTaxDue = ((BigDecimal)propertyTaxDetails.get("ARR_DMD")).subtract((BigDecimal)propertyTaxDetails.get("ARR_COLL"));
        Map penaltyDetails = this.ptDemandDAO.getPenaltyDemandCollMap((Property)this.basicProperty.getActiveProperty());
        BigDecimal currPenaltyDue = ((BigDecimal)penaltyDetails.get("CURR_PEANLTY_DMD")).subtract((BigDecimal)penaltyDetails.get("CURR_PENALTY_COLL"));
        BigDecimal arrearPenaltyDue = ((BigDecimal)penaltyDetails.get("ARR_PENALTY_DMD")).subtract((BigDecimal)penaltyDetails.get("ARR_PENALTY_COLL"));
        model.addAttribute("currTaxDue", (Object)currTaxDue);
        model.addAttribute("arrearTaxDue", (Object)arrearTaxDue);
        model.addAttribute("currPenaltyDue", (Object)currPenaltyDue);
        model.addAttribute("arrearPenaltyDue", (Object)arrearPenaltyDue);
        model.addAttribute("isCorporation", (Object)this.propertyTaxUtil.isCorporation());
        model.addAttribute("writeOffReasons", (Object)PropertyTaxConstants.WRITEOFF_REASONS);
        model.addAttribute("installments", (Object)this.propertyTaxUtil.getInstallments(this.propertyImpl));
        model.addAttribute("documentTypes", (Object)this.documentTypePersistenceService.findAllByNamedQuery("DOCUMENTTYPE_BY_TRANSACTION_TYPE", new Object[]{TransactionType.WRITEOFF}));
        return WRITE_OFF_FORM;
    }
}

