/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.notice;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.bean.NoticeRequest;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.service.notice.RecoveryNoticeService;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/recoveryNotices"})
public class RecoveryNoticesController {
    private static final String NOTICE_REQUEST = "noticeRequest";
    private static final String NOTICE_TYPE = "noticeType";
    private static final String ASSESSMENT_NUMBERS = "assessmentNumbers";
    private static final String PTIS_RECOVERY_NOTICES_JOB = "PTISRecoveryNoticesJob";
    private static final String RECOVERY_NOTICES_TRIGGER = "Recovery Notices Trigger";
    private static final String CATEGORY_TYPES = "categoryTypes";
    private static final String PROPERTY_TYPES = "propertyTypes";
    private static final String BILL_COLLECTORS = "billCollectors";
    private static final String BLOCKS = "blocks";
    private static final String WARDS = "wards";
    private static final String NOTICE_TYPES = "noticeTypes";
    private static final String RECOVERY_FORM = "recovery-form";
    private static final String RECOVERY_ACK = "recovery-ack";
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private PropertyTypeMasterDAO propertyTypeMasterDAO;
    @Autowired
    private RecoveryNoticeService recoveryNoticeService;
    @Autowired
    private ApplicationContext beanProvider;

    @RequestMapping(value={"/form"}, method={RequestMethod.GET})
    public String form(Model model) {
        NoticeRequest noticeRequest = new NoticeRequest();
        model.addAttribute(NOTICE_REQUEST, (Object)noticeRequest);
        this.populateDropdowns(model, noticeRequest);
        return RECOVERY_FORM;
    }

    private void populateDropdowns(Model model, NoticeRequest noticeRequest) {
        List propertyTypes = this.propertyTypeMasterDAO.findAllExcludeEWSHS();
        List wards = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
        model.addAttribute(NOTICE_TYPES, (Object)PropertyTaxConstants.RECOVERY_NOTICETYPES);
        model.addAttribute(WARDS, (Object)wards);
        if (noticeRequest.getWard() != null && !noticeRequest.getWard().equals(-1L)) {
            List blocks = this.boundaryService.getActiveChildBoundariesByBoundaryId(noticeRequest.getWard());
            model.addAttribute(BLOCKS, (Object)blocks);
        } else {
            model.addAttribute(BLOCKS, Collections.emptyList());
        }
        model.addAttribute(BILL_COLLECTORS, Collections.emptyList());
        model.addAttribute(PROPERTY_TYPES, (Object)propertyTypes);
        Long propertyType = noticeRequest.getPropertyType();
        if (propertyType != null && !propertyType.equals(-1L)) {
            TreeMap propTypeCategoryMap = new TreeMap();
            PropertyTypeMaster propTypeMstr = this.propertyTypeMasterDAO.findById(Integer.valueOf(propertyType.intValue()), false);
            if (propTypeMstr.getCode().equalsIgnoreCase("VAC_LAND")) {
                propTypeCategoryMap.putAll(PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY);
            } else {
                propTypeCategoryMap.putAll(PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY);
            }
            model.addAttribute(CATEGORY_TYPES, propTypeCategoryMap);
        } else {
            model.addAttribute(CATEGORY_TYPES, Collections.emptyList());
        }
    }

    @RequestMapping(value={"/form"}, method={RequestMethod.POST})
    public String generateNotices(@Valid @ModelAttribute NoticeRequest noticeRequest, Model model, BindingResult errors) {
        this.validate(noticeRequest, errors);
        if (errors.hasErrors()) {
            model.addAttribute(NOTICE_REQUEST, (Object)noticeRequest);
            this.populateDropdowns(model, noticeRequest);
            return RECOVERY_FORM;
        }
        Long jobNumber = this.recoveryNoticeService.getLatestJobNumber();
        jobNumber = jobNumber == null ? 0L : jobNumber + 1L;
        List assessmentNumbers = this.recoveryNoticeService.generateRecoveryNotices(noticeRequest);
        if (assessmentNumbers.isEmpty()) {
            model.addAttribute(NOTICE_REQUEST, (Object)noticeRequest);
            this.populateDropdowns(model, noticeRequest);
            errors.reject("record.not.found", "record.not.found");
            return RECOVERY_FORM;
        }
        JobDetailImpl jobDetail = (JobDetailImpl)this.beanProvider.getBean("recoveryNoticeJobDetail");
        Scheduler scheduler = (Scheduler)this.beanProvider.getBean("recoveryNoticeScheduler");
        try {
            jobDetail.setName(ApplicationThreadLocals.getTenantID().concat("_").concat(PTIS_RECOVERY_NOTICES_JOB.concat(jobNumber.toString())));
            StringBuilder assessmentNoStr = new StringBuilder();
            for (String assessmentNo : assessmentNumbers) {
                assessmentNoStr.append(assessmentNo).append(", ");
            }
            assessmentNoStr.deleteCharAt(assessmentNoStr.lastIndexOf(", "));
            jobDetail.getJobDataMap().remove((Object)ASSESSMENT_NUMBERS);
            jobDetail.getJobDataMap().remove((Object)NOTICE_TYPE);
            jobDetail.getJobDataMap().put(ASSESSMENT_NUMBERS, assessmentNoStr.toString());
            jobDetail.getJobDataMap().put(NOTICE_TYPE, noticeRequest.getNoticeType());
            SimpleTriggerImpl trigger = new SimpleTriggerImpl();
            trigger.setName(ApplicationThreadLocals.getTenantID().concat("_").concat(RECOVERY_NOTICES_TRIGGER.concat(jobNumber.toString())));
            trigger.setStartTime(new Date(System.currentTimeMillis() + 100000L));
            trigger.setMisfireInstruction(1);
            scheduler.start();
            scheduler.scheduleJob((JobDetail)jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
        return RECOVERY_ACK;
    }

    private void validate(NoticeRequest noticeRequest, BindingResult errors) {
        if (StringUtils.isEmpty((String)noticeRequest.getNoticeType()) || "-1".equals(noticeRequest.getNoticeType())) {
            errors.reject("mandatory.noticetype", "mandatory.noticetype");
        }
        Boolean isSelected = Boolean.FALSE;
        if (this.isWardSelected(noticeRequest).booleanValue() || this.isBillCollectorSelected(noticeRequest).booleanValue() || this.isPropertyTypeSelected(noticeRequest).booleanValue() || this.isPropertyIdEntered(noticeRequest).booleanValue()) {
            isSelected = Boolean.TRUE;
        }
        if (!isSelected.booleanValue()) {
            errors.reject("mandatory.anyone", "mandatory.anyone");
        }
    }

    private Boolean isPropertyIdEntered(NoticeRequest noticeRequest) {
        if (StringUtils.isNotEmpty((String)noticeRequest.getPropertyId())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean isPropertyTypeSelected(NoticeRequest noticeRequest) {
        if (noticeRequest.getPropertyType() != null && !noticeRequest.getPropertyType().equals(-1L)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean isBillCollectorSelected(NoticeRequest noticeRequest) {
        if (noticeRequest.getBillCollector() != null && !noticeRequest.getBillCollector().equals(-1L)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Boolean isWardSelected(NoticeRequest noticeRequest) {
        if (noticeRequest.getWard() != null && !noticeRequest.getWard().equals(-1L)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

