/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.ptis.actions.common.CommonServices;
import org.egov.ptis.actions.reports.DCBReportHelperAdaptor;
import org.egov.ptis.actions.reports.DCBReportResult;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterHibernateDAO;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.service.report.ReportService;
import org.hibernate.SQLQuery;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/dcbReportVLT"})
public class DCBReportVLTController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private PropertyTypeMasterHibernateDAO propertyTypeMasterDAO;

    @ModelAttribute(value="wards")
    public Map<Long, String> wardBoundaries() {
        List wardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
        Map<Long, String> wardBndryMap = new HashMap();
        wardBndryMap = CommonServices.getFormattedBndryMap((List)wardList);
        wardBndryMap.put(0L, "All");
        return wardBndryMap;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String searchDcbForm(Model model) {
        model.addAttribute("DCBVLTReport", (Object)new DCBReportResult());
        model.addAttribute("mode", (Object)"ward");
        return "dcbVLT-form";
    }

    @RequestMapping(value={"/result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void dcbReportSearchResult(@RequestParam String boundaryId, @RequestParam String mode, @RequestParam String courtCase, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PropertyTypeMaster propertyTypeMaster = this.propertyTypeMasterDAO.getPropertyTypeMasterByCode("VAC_LAND");
        ArrayList<String> propertyType = new ArrayList<String>();
        propertyType.add(propertyTypeMaster.getId().toString());
        SQLQuery query = this.reportService.prepareQueryForDCBReport(Long.valueOf(boundaryId), mode, Boolean.valueOf(courtCase), propertyType);
        query.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DCBReportResult.class));
        List resultList = query.list();
        String result = "{ \"data\":" + JsonUtils.toJSON((Collection)resultList, DCBReportResult.class, DCBReportHelperAdaptor.class) + "}";
        IOUtils.write((String)result, (Writer)response.getWriter());
    }
}

