/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.mobile;

import java.math.BigDecimal;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.integration.utils.CollectionHelper;
import org.egov.ptis.client.integration.utils.SpringBeanUtil;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/public/mobile", "/mobile"})
public class MobilePaymentController {
    private static final String PAYTAX_FORM = "mobilePayment-form";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    @Qualifier(value="propertyTaxBillable")
    private PropertyTaxBillable propertyTaxBillable;
    @Autowired
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private PTBillServiceImpl ptBillServiceImpl;
    @Autowired
    private PtDemandDao ptDemandDAO;

    @RequestMapping(value={"/paytax/{assessmentNo},{ulbCode},{amountToBePaid},{mobileNumber},{emailId},{category}"}, method={RequestMethod.GET})
    public String newform(Model model, @PathVariable String assessmentNo, @PathVariable String ulbCode, @PathVariable BigDecimal amountToBePaid, @PathVariable String mobileNumber, @PathVariable String emailId, @PathVariable String category, HttpServletRequest request) throws ParseException {
        block15: {
            Property property;
            String redirectUrl = "";
            if (!this.basicPropertyDAO.isAssessmentNoExist(assessmentNo).booleanValue()) {
                model.addAttribute("errorMsg", (Object)"Assessment number not found");
                return "propertyValidation";
            }
            BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
            if (basicProperty != null && (property = basicProperty.getProperty()) != null) {
                if (property.getIsExemptedFromTax().booleanValue()) {
                    model.addAttribute("errorMsg", (Object)"Property is Exempted");
                    return "propertyValidation";
                }
                Ptdemand currentPtdemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
                BigDecimal totalTaxDue = BigDecimal.ZERO;
                String propType = property.getPropertyDetail().getPropertyTypeMaster().getCode();
                if (currentPtdemand != null) {
                    for (EgDemandDetails demandDetails : currentPtdemand.getEgDemandDetails()) {
                        if (demandDetails.getAmount().subtract(demandDetails.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0) continue;
                        totalTaxDue = totalTaxDue.add(demandDetails.getAmount().subtract(demandDetails.getAmtCollected()));
                    }
                }
                if (amountToBePaid.compareTo(totalTaxDue) > 0) {
                    model.addAttribute("errorMsg", (Object)"Paid Amount is greater than Total Amount to be paid");
                    return "propertyValidation";
                }
                if (!propType.equalsIgnoreCase("VAC_LAND") && category.equalsIgnoreCase("VLT")) {
                    model.addAttribute("errorMsg", (Object)"There is no Vacant Land record found for this assessment");
                    return "propertyValidation";
                }
                if (propType.equalsIgnoreCase("VAC_LAND") && category.equalsIgnoreCase("PT")) {
                    model.addAttribute("errorMsg", (Object)"There is no Property Tax record found for this assessment");
                    return "propertyValidation";
                }
                if (!category.equalsIgnoreCase("PT") && !category.equalsIgnoreCase("VLT")) {
                    model.addAttribute("errorMsg", (Object)"Invalid Category");
                    return "propertyValidation";
                }
            }
            try {
                BillInfoImpl billInfo = this.getBillInfo(assessmentNo, amountToBePaid, category);
                if (billInfo != null) {
                    PaymentRequest paymentRequest = SpringBeanUtil.getCollectionIntegrationService().processMobilePayments(billInfo);
                    if (paymentRequest != null) {
                        for (Object obj : paymentRequest.getRequestParameters().values()) {
                            redirectUrl = obj.toString();
                        }
                        model.addAttribute("redirectUrl", (Object)redirectUrl);
                    }
                    break block15;
                }
                model.addAttribute("errorMsg", (Object)"Bill data is incorrect");
                return "propertyValidation";
            }
            catch (ValidationException e) {
                return "propertyValidation";
            }
            catch (Exception e) {
                return "propertyValidation";
            }
        }
        return PAYTAX_FORM;
    }

    public BillInfoImpl getBillInfo(String assessmentNo, BigDecimal amountToBePaid, String category) {
        BillInfoImpl billInfoImpl = null;
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        this.propertyTaxBillable.setBasicProperty(basicProperty);
        this.propertyTaxBillable.setUserId(Long.valueOf(2L));
        ApplicationThreadLocals.setUserId((Long)2L);
        this.propertyTaxBillable.setReferenceNumber(this.propertyTaxNumberGenerator.generateBillNumber(basicProperty.getPropertyID().getWard().getBoundaryNum().toString()));
        this.propertyTaxBillable.setBillType(this.egBillDAO.getBillTypeByCode("AUTO"));
        this.propertyTaxBillable.setLevyPenalty(Boolean.TRUE);
        if (StringUtils.isNotBlank((CharSequence)category) && category.equalsIgnoreCase("VLT")) {
            this.propertyTaxBillable.setVacantLandTaxPayment(true);
        }
        EgBill egBill = this.ptBillServiceImpl.generateBill((Billable)this.propertyTaxBillable);
        CollectionHelper collectionHelper = new CollectionHelper(egBill);
        billInfoImpl = collectionHelper.prepareBillInfo(amountToBePaid, BillInfo.COLLECTIONTYPE.O, null);
        return billInfoImpl;
    }
}

