/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.masters.structureclassification;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.infra.admin.master.service.UserService;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.egov.ptis.master.service.StructureClassificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/structureclassification"})
public class CreateAndViewStructureClassificationController {
    private final StructureClassificationService structureClassificationService;
    @Autowired
    public UserService userService;

    @Autowired
    public CreateAndViewStructureClassificationController(StructureClassificationService structureClassificationService) {
        this.structureClassificationService = structureClassificationService;
    }

    @ModelAttribute
    public StructureClassification structureClassificationModel() {
        return new StructureClassification();
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("structureclassification", (Object)this.structureClassificationModel());
        return "structureclassification-create";
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String showStructureType(Model model) {
        model.addAttribute("structureclassifications", (Object)this.structureClassificationService.getAllActiveStructureTypes());
        return "structureclassification-view";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute StructureClassification structureClassification, BindingResult errors, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model) {
        if (errors.hasErrors()) {
            return "structureclassification-create";
        }
        structureClassification.setNumber(Integer.valueOf(1));
        structureClassification.setStartInstallment(this.structureClassificationService.getInstallment());
        structureClassification.setIsHistory('N');
        this.structureClassificationService.create(structureClassification);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.structcls.create.success");
        return "redirect:/structureclassification/create";
    }
}

