/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.masters.rooftype;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.ptis.domain.entity.property.RoofType;
import org.egov.ptis.master.service.RoofTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/rooftype"})
public class CreateAndViewRoofTypeController {
    private final RoofTypeService roofTypeService;
    @Autowired
    private SecurityUtils securityUtils;

    @Autowired
    public CreateAndViewRoofTypeController(RoofTypeService roofTypeService) {
        this.roofTypeService = roofTypeService;
    }

    @ModelAttribute
    public RoofType RoofTypeModel() {
        return new RoofType();
    }

    @ModelAttribute(value="roofTypes")
    public List<RoofType> listRoofTypes() {
        return this.roofTypeService.getAllRoofTypes();
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String showRoofTypes(Model model) {
        String roleName = this.roofTypeService.getRolesForUserId(this.securityUtils.getCurrentUser().getId());
        model.addAttribute("roleName", (Object)roleName);
        return "roofType-search";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create() {
        return "roofType-form";
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable Long id, Model model) {
        RoofType roofType = this.roofTypeService.getRoofTypeById(id);
        model.addAttribute("roofType", (Object)roofType);
        return "roofType-view";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute RoofType roofType, BindingResult errors, RedirectAttributes redirectAttributes, HttpServletRequest request) {
        if (errors.hasErrors()) {
            return "roofType-search";
        }
        this.roofTypeService.createRoof(roofType);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.rooftype.create.success");
        return "redirect:/rooftype/create";
    }
}

