/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.masters.mutationfee;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.ptis.domain.model.MutationFeeDetails;
import org.egov.ptis.master.service.MutationFeeService;
import org.joda.time.DateTimeComparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/mutationfee"})
public class MutationFeeController {
    private static final String MUTATION_FORM = "add-mutation-fee-form";
    private static final String MSG = "message";
    private static final String ERROR = "error";
    private final MutationFeeService mutationFeeService;

    @Autowired
    public MutationFeeController(MutationFeeService mutationFeeService) {
        this.mutationFeeService = mutationFeeService;
    }

    @ModelAttribute
    public MutationFeeDetails mutationFeeDetailsModel() {
        return new MutationFeeDetails();
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(@ModelAttribute MutationFeeDetails mutationFeeDetails, Model model) {
        return MUTATION_FORM;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute MutationFeeDetails mutationFeeDetails, BindingResult resultBinder, @RequestParam(value="fromDate") Date fromDate, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model) {
        this.mutationFeeService.generateSlabName(mutationFeeDetails);
        if (this.mutationFeeService.findExistingSlabName(mutationFeeDetails.getSlabName())) {
            if (this.mutationFeeService.getToDateBySlabName(mutationFeeDetails.getSlabName())) {
                return this.validateDateForSlabName(mutationFeeDetails, resultBinder, fromDate, redirectAttributes);
            }
            resultBinder.reject("error.mutationfee.datevalidation.fail", "error.mutationfee.datevalidation.fail");
            return MUTATION_FORM;
        }
        if (this.mutationFeeService.validateForHighLimitNull()) {
            resultBinder.reject("error.mutationfee.add.fail", "error.mutationfee.add.fail");
            return MUTATION_FORM;
        }
        if (!this.mutationFeeService.validateForMaxHighLimit(mutationFeeDetails.getLowLimit())) {
            BigDecimal high = this.mutationFeeService.getMaxHighLimit().add(BigDecimal.ONE);
            resultBinder.reject("error.mutationfee.fail", (Object[])new String[]{high.toString()}, "error.mutationfee.fail");
            return MUTATION_FORM;
        }
        this.mutationFeeService.createMutationFee(mutationFeeDetails);
        redirectAttributes.addFlashAttribute(MSG, (Object)"msg.mutationfee.create.success");
        return "redirect:/mutationfee/create";
    }

    public String validateDateForSlabName(@ModelAttribute MutationFeeDetails mutationFeeDetails, BindingResult resultBinder, @RequestParam(value="fromDate") Date fromDate, RedirectAttributes redirectAttributes) {
        if (fromDate.compareTo(this.mutationFeeService.getLatestToDateForSlabName(mutationFeeDetails.getSlabName())) >= 0) {
            this.mutationFeeService.createMutationFee(mutationFeeDetails);
            redirectAttributes.addFlashAttribute(MSG, (Object)"msg.mutationfee.create.success");
            return "redirect:/mutationfee/create";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.mutationFeeService.getLatestToDateForSlabName(mutationFeeDetails.getSlabName()));
        cal.add(5, 1);
        resultBinder.reject("error.mutationfee.fromdatevalidation.fail", (Object[])new String[]{cal.getTime().toString()}, "error.mutationfee.fromdatevalidation.fail");
        return MUTATION_FORM;
    }

    @RequestMapping(value={"/modify"}, method={RequestMethod.GET})
    public String searchMutationFee(Model model) {
        List slabNames = this.mutationFeeService.findSlabName();
        model.addAttribute("slabNames", (Object)slabNames);
        model.addAttribute("mutationFeeDetails", (Object)new MutationFeeDetails());
        return "search-mutation-fee-form";
    }

    @RequestMapping(value={"/modify/{slabName}"}, method={RequestMethod.GET})
    public String modifyMutationFee(@PathVariable String slabName, @ModelAttribute MutationFeeDetails mutationFeeDetails, RedirectAttributes redirectAttributes, Model model) {
        List mutationfee = this.mutationFeeService.findDuplicateSlabName(slabName);
        model.addAttribute("mutationfee", (Object)mutationfee);
        model.addAttribute("mutationFeeDetails", (Object)new MutationFeeDetails());
        return "modify-mutation-fee-form";
    }

    @RequestMapping(value={"/modify/{id}"}, method={RequestMethod.POST})
    public String modifyMutationFee(@PathVariable(value="id") Long id, @RequestParam(value="toDate") Date toDate, @ModelAttribute MutationFeeDetails mutationFeeDetails, RedirectAttributes redirectAttributes, BindingResult resultBinder, Model model) {
        MutationFeeDetails mfd = this.mutationFeeService.getDetailsById(id);
        Date date = new Date();
        if (DateTimeComparator.getDateOnlyInstance().compare((Object)toDate, (Object)date) >= 0) {
            mfd.setToDate(toDate);
            this.mutationFeeService.createMutationFee(mfd);
            redirectAttributes.addFlashAttribute(MSG, (Object)"msg.mutationfee.update.success");
            return "redirect:/mutationfee/modify";
        }
        redirectAttributes.addFlashAttribute(ERROR, (Object)"error.mutationfee.update.fail");
        return "redirect:/mutationfee/modify";
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String showMutationFee(@ModelAttribute MutationFeeDetails mutationFee, Model model) {
        List mutationfee = this.mutationFeeService.getAllMutationFee();
        model.addAttribute("mutationfee", (Object)mutationfee);
        return "view-mutation-fee-form";
    }
}

