/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.dashboard;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.egov.ptis.service.dashboard.RevenueDashboardService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dashboard"})
public class RevenueDashboardController {
    @Autowired
    private RevenueDashboardService revenueDashboardService;

    @RequestMapping(value={"/home"})
    public String home(HttpSession session, Model model) {
        return "dashboard/home";
    }

    @RequestMapping(value={"/performance-bar"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> performanceBar() {
        return this.revenueDashboardService.getRevenueZonewiseBar();
    }

    @RequestMapping(value={"/performance-tabular"}, produces={"application/json"})
    @ResponseBody
    public List<Map<String, Object>> performanceTabular() {
        return this.revenueDashboardService.getRevenueZonewisePerformance();
    }

    @RequestMapping(value={"/performance-tabularDrill/{zoneName}"}, produces={"application/json"})
    @ResponseBody
    public List<Map<String, Object>> performanceTabularDrill(@PathVariable String zoneName) {
        return this.revenueDashboardService.getWardwisePerformanceTab(zoneName);
    }

    @RequestMapping(value={"/revenueTrendForTheWeek"}, produces={"application/json"})
    @ResponseBody
    public List<Map<String, Object>> revenueTrendForTheWeek() {
        return this.revenueDashboardService.revenueTrendForTheWeek();
    }

    @RequestMapping(value={"/revenueTrend"}, produces={"application/json"})
    @ResponseBody
    public Map<String, List<Object>> getAnnualZonewiseBar() {
        return this.revenueDashboardService.getAnnualZonewiseBar();
    }

    @RequestMapping(value={"/target-achieved"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Collection<Double>> targetVsAchieved() {
        return this.revenueDashboardService.targetVsAchieved();
    }

    @RequestMapping(value={"/collections-paymentMode"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> collectionsPaymentMode() {
        return this.revenueDashboardService.collectionsPaymentMode();
    }

    @RequestMapping(value={"/coverage-efficiency"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> coverageEfficiency() {
        return this.revenueDashboardService.coverageEfficiency();
    }

    @RequestMapping(value={"/coverage-efficiency-ward/{zoneName}"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> coverageEfficiencyWard(@PathVariable String zoneName) {
        return this.revenueDashboardService.coverageEfficiencyWard(zoneName);
    }
}

