/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Installment;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.web.struts.actions.ReportFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.ptis.bean.ReportInfo;
import org.egov.ptis.domain.entity.property.InstDmdCollMaterializeView;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Criteria;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
public class BigBuildingRecoveryReportAction
extends ReportFormAction {
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private Date fromDate;
    private Date toDate;
    private BigDecimal arrBigBldgTaxColl = BigDecimal.ZERO;
    private BigDecimal currBigBldgTaxColl = BigDecimal.ZERO;
    private Map<String, BigDecimal> infoMap = new HashMap();
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    @SkipValidation
    public String newForm() {
        return "new";
    }

    public void validate() {
        if (this.getFromDate() == null) {
            this.addActionError(this.getText("mandatory.fromdate"));
        }
        if (this.getToDate() == null) {
            this.addActionError(this.getText("mandatory.todate"));
        }
        if (this.getFromDate() != null && this.getFromDate().after(new Date())) {
            this.addActionError(this.getText("mandatory.fromDtBeforeCurrDt"));
        }
        if (this.getToDate() != null && this.getToDate().after(new Date())) {
            this.addActionError(this.getText("mandatory.toDtBeforeCurrDt"));
        }
    }

    @ValidationErrorPage(value="new")
    public String generateBigBldgRecStmt() {
        ReportInfo reportInfo = this.prepareReportInfo();
        this.setDataSourceType(ReportDataSourceType.JAVABEAN);
        this.setReportData((Object)reportInfo);
        super.report();
        return "generate";
    }

    private ReportInfo prepareReportInfo() {
        ReportInfo reportInfo = new ReportInfo();
        Integer totalNoProps = 0;
        List instDmdCollList = this.getPersistenceService().getSession().createQuery("from InstDmdCollMaterializeView instDmdColl left join fetch instDmdColl.installment where instDmdColl.createdDate between ? and ? and instDmdColl.bigBldgTaxColl != 0 ").setDate(0, this.fromDate).setDate(1, this.toDate).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).list();
        Installment currInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        for (InstDmdCollMaterializeView instDmdCollMaterializeView : instDmdCollList) {
        }
        String fdate = this.dateFormatter.format(this.fromDate);
        String tdate = this.dateFormatter.format(this.toDate);
        this.infoMap.put("arrBigBldgTaxColl", this.arrBigBldgTaxColl.setScale(2));
        this.infoMap.put("currBigBldgTaxColl", this.currBigBldgTaxColl.setScale(2));
        reportInfo.setDateString(fdate + " to " + tdate);
        reportInfo.setTotalNoProps(totalNoProps);
        reportInfo.setDemandCollMap(this.infoMap);
        return reportInfo;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public BigDecimal getArrBigBldgTaxColl() {
        return this.arrBigBldgTaxColl;
    }

    public void setArrBigBldgTaxColl(BigDecimal arrBigBldgTaxColl) {
        this.arrBigBldgTaxColl = arrBigBldgTaxColl;
    }

    public BigDecimal getCurrBigBldgTaxColl() {
        return this.currBigBldgTaxColl;
    }

    public void setCurrBigBldgTaxColl(BigDecimal currBigBldgTaxColl) {
        this.currBigBldgTaxColl = currBigBldgTaxColl;
    }

    public Map<String, BigDecimal> getInfoMap() {
        return this.infoMap;
    }

    public void setInfoMap(Map<String, BigDecimal> infoMap) {
        this.infoMap = infoMap;
    }

    public String criteria() {
        return null;
    }

    protected String getReportTemplateName() {
        return "BigBuildingRecoveryStmt";
    }
}

