/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import com.opensymphony.xwork2.validator.annotations.Validations;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.reporting.engine.ReportDataSourceType;
import org.egov.infra.web.struts.actions.ReportFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.ptis.bean.PropertyWiseArrearInfo;
import org.egov.ptis.bean.ReportInfo;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.InstDmdCollMaterializeView;
import org.egov.ptis.domain.entity.property.PropertyMaterlizeView;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Validations
@Results(value={@Result(name={"index"}, location="arrearRegisterReport-index.jsp"), @Result(name={"generate"}, location="arrearRegisterReport-generate.jsp")})
public class ArrearRegisterReportAction
extends ReportFormAction {
    private static final long serialVersionUID = -242727189632318964L;
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private Long zoneId;
    private Long wardId;
    private Long areaId;
    private Long localityId;
    public static final String GENERATE = "generate";
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    private List<PropertyWiseArrearInfo> propertyWiseInfoList;

    public void prepare() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into prepare method");
        }
        super.prepare();
        List localityList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
        this.addDropdownData("localityList", localityList);
        List zoneList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
        List wardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
        this.addDropdownData("Zone", zoneList);
        this.addDropdownData("wardList", wardList);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Zone id : " + this.zoneId + ", Ward id : " + this.wardId));
        }
        if (this.wardId == null || this.wardId.equals(-1)) {
            this.addDropdownData("blockList", Collections.emptyList());
        }
        this.prepareBlockDropDownData(this.wardId != null, this.areaId != null);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from prepare method");
        }
    }

    private void prepareWardDropDownData(boolean zoneExists, boolean wardExists) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into prepareWardDropDownData method");
            this.LOGGER.debug((Object)("Zone Exists ? : " + zoneExists + ", Ward Exists ? : " + wardExists));
        }
        if (zoneExists && wardExists) {
            List wardList = this.boundaryService.getActiveChildBoundariesByBoundaryId(this.getZoneId());
            this.addDropdownData("wardList", wardList);
        } else {
            this.addDropdownData("wardList", Collections.emptyList());
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from prepareWardDropDownData method");
        }
    }

    private void prepareBlockDropDownData(boolean wardExists, boolean blockExists) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into prepareBlockDropDownData method");
            this.LOGGER.debug((Object)("Ward Exists ? : " + wardExists + ", Block Exists ? : " + blockExists));
        }
        if (wardExists && blockExists) {
            List blockList = this.boundaryService.getActiveChildBoundariesByBoundaryId(this.getWardId());
            this.addDropdownData("blockList", blockList);
        } else {
            this.addDropdownData("blockList", Collections.emptyList());
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from prepareWardDropDownData method");
        }
    }

    @SkipValidation
    @Action(value="/reports/arrearRegisterReport-index")
    public String index() {
        return "index";
    }

    @ValidationErrorPage(value="index")
    @Action(value="/reports/arrearRegisterReport-generateArrearReport")
    public String generateArrearReport() {
        ReportInfo reportInfo = new ReportInfo();
        this.propertyWiseInfoList = new ArrayList();
        String strZoneNum = null;
        String strWardNum = null;
        String strBlockNum = null;
        String strLocalityNum = null;
        if ((this.localityId == null || this.localityId == -1L) && this.zoneId != null && this.zoneId != -1L) {
            strZoneNum = this.boundaryService.getBoundaryById(this.zoneId).getName();
        } else if (this.localityId != null && this.localityId != -1L) {
            strLocalityNum = this.boundaryService.getBoundaryById(this.localityId).getName();
            if (this.zoneId != null && this.zoneId != -1L) {
                strZoneNum = this.boundaryService.getBoundaryById(this.zoneId).getName();
            }
        }
        if (this.wardId != null && this.wardId != -1L) {
            strWardNum = this.boundaryService.getBoundaryById(this.wardId).getName();
        }
        if (this.areaId != null && this.areaId != -1L) {
            strBlockNum = this.boundaryService.getBoundaryById(this.areaId).getName();
        }
        String strMunicipal = this.getSession().get("citymunicipalityname").toString();
        String strDistrict = this.getSession().get("districtName").toString();
        strDistrict = strDistrict.substring(0, 1) + strDistrict.substring(1, strDistrict.length()).toLowerCase();
        List propertyViewList = this.propertyTaxUtil.prepareQueryforArrearRegisterReport(this.zoneId, this.wardId, this.areaId, this.localityId);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("PropertyMaterlizeView List Size" + propertyViewList.size()));
        }
        for (PropertyMaterlizeView propMatView : propertyViewList) {
            if (propMatView.getInstDmdColl().size() == 1) {
                InstDmdCollMaterializeView currIDCMatView = (InstDmdCollMaterializeView)propMatView.getInstDmdColl().iterator().next();
                PropertyWiseArrearInfo propertyWiseInfo = this.preparePropertyWiseInfo(currIDCMatView);
                if (propertyWiseInfo == null) continue;
                this.propertyWiseInfoList.add(propertyWiseInfo);
                continue;
            }
            ArrayList idcList = new ArrayList(propMatView.getInstDmdColl());
            ArrayList<String> unitList = new ArrayList<String>();
            PropertyWiseArrearInfo propertyWiseInfoTotal = null;
            for (InstDmdCollMaterializeView instlDmdColMatView : idcList) {
                PropertyWiseArrearInfo propertyWiseInfo = this.preparePropertyWiseInfo(instlDmdColMatView);
                if (propertyWiseInfo != null) {
                    if (unitList.isEmpty()) {
                        unitList.add(propertyWiseInfo.getArrearInstallmentDesc());
                        propertyWiseInfoTotal = propertyWiseInfo;
                        continue;
                    }
                    if (unitList.contains(propertyWiseInfo.getArrearInstallmentDesc())) {
                        propertyWiseInfoTotal = this.addPropertyWiseInfo(propertyWiseInfoTotal, propertyWiseInfo);
                        continue;
                    }
                    if (unitList.contains(propertyWiseInfo.getArrearInstallmentDesc())) continue;
                    this.propertyWiseInfoList.add(propertyWiseInfoTotal);
                    unitList.add(propertyWiseInfo.getArrearInstallmentDesc());
                    propertyWiseInfoTotal = propertyWiseInfo;
                    propertyWiseInfoTotal.setIndexNumber("");
                    propertyWiseInfoTotal.setOwnerName("");
                    propertyWiseInfoTotal.setHouseNo("");
                    continue;
                }
                this.propertyWiseInfoList.add(propertyWiseInfoTotal);
            }
        }
        reportInfo.setZoneNo(strZoneNum);
        reportInfo.setWardNo(strWardNum);
        reportInfo.setBlockNo(strBlockNum);
        reportInfo.setLocalityNo(strLocalityNum);
        reportInfo.setMunicipal(strMunicipal);
        reportInfo.setDistrict(strDistrict);
        reportInfo.setPropertyWiseArrearInfoList(this.propertyWiseInfoList);
        this.setDataSourceType(ReportDataSourceType.JAVABEAN);
        this.setReportData((Object)reportInfo);
        super.report();
        return GENERATE;
    }

    private PropertyWiseArrearInfo addPropertyWiseInfo(PropertyWiseArrearInfo propertyWiseInfoTotal, PropertyWiseArrearInfo propertyInfo) {
        propertyWiseInfoTotal.setArrearLibraryCess(propertyWiseInfoTotal.getArrearLibraryCess().add(propertyInfo.getArrearLibraryCess()));
        propertyWiseInfoTotal.setArrearPropertyTax(propertyWiseInfoTotal.getArrearPropertyTax().add(propertyInfo.getArrearPropertyTax()));
        propertyWiseInfoTotal.setArrearVacantLandTax(propertyWiseInfoTotal.getArrearVacantLandTax().add(propertyInfo.getArrearVacantLandTax()));
        propertyWiseInfoTotal.setArrearPenalty(propertyWiseInfoTotal.getArrearPenalty().add(propertyInfo.getArrearPenalty()));
        propertyWiseInfoTotal.setArrearEducationCess(propertyWiseInfoTotal.getArrearEducationCess().add(propertyInfo.getArrearEducationCess()));
        propertyWiseInfoTotal.setTotalArrearTax(propertyWiseInfoTotal.getTotalArrearTax().add(propertyInfo.getTotalArrearTax()));
        return propertyWiseInfoTotal;
    }

    private PropertyWiseArrearInfo preparePropertyWiseInfo(InstDmdCollMaterializeView currInstDmdColMatView) {
        PropertyWiseArrearInfo propertyWiseInfo = this.preparePropInfo(currInstDmdColMatView.getPropMatView());
        BigDecimal totalTax = currInstDmdColMatView.getLibCessTax().add(currInstDmdColMatView.getGeneralTax().equals(BigDecimal.ZERO) ? currInstDmdColMatView.getVacantLandTax() : currInstDmdColMatView.getGeneralTax()).add(currInstDmdColMatView.getPenaltyFinesTax()).add(currInstDmdColMatView.getEduCessTax());
        propertyWiseInfo.setArrearInstallmentDesc(currInstDmdColMatView.getInstallment().getDescription());
        propertyWiseInfo.setArrearLibraryCess(currInstDmdColMatView.getLibCessTax());
        propertyWiseInfo.setArrearPropertyTax(currInstDmdColMatView.getGeneralTax());
        propertyWiseInfo.setArrearPenalty(currInstDmdColMatView.getPenaltyFinesTax());
        propertyWiseInfo.setArrearEducationCess(currInstDmdColMatView.getEduCessTax());
        propertyWiseInfo.setArrearVacantLandTax(currInstDmdColMatView.getVacantLandTax());
        propertyWiseInfo.setTotalArrearTax(totalTax);
        return propertyWiseInfo;
    }

    private PropertyWiseArrearInfo preparePropInfo(PropertyMaterlizeView propMatView) {
        PropertyWiseArrearInfo propertyWiseInfo = new PropertyWiseArrearInfo();
        propertyWiseInfo.setBasicPropId(Long.valueOf(propMatView.getBasicPropertyID().longValue()));
        propertyWiseInfo.setIndexNumber(propMatView.getPropertyId());
        propertyWiseInfo.setOwnerName(propMatView.getOwnerName());
        propertyWiseInfo.setHouseNo(propMatView.getHouseNo());
        return propertyWiseInfo;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public String criteria() {
        return null;
    }

    protected String getReportTemplateName() {
        return "ArrearRegister";
    }

    public Long getLocalityId() {
        return this.localityId;
    }

    public void setLocalityId(Long localityId) {
        this.localityId = localityId;
    }

    public Long getAreaId() {
        return this.areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public List<PropertyWiseArrearInfo> getPropertyWiseInfoList() {
        return this.propertyWiseInfoList;
    }

    public void setPropertyWiseInfoList(List<PropertyWiseArrearInfo> propertyWiseInfoList) {
        this.propertyWiseInfoList = propertyWiseInfoList;
    }
}

