/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.notice;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.MoneyUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.ptis.actions.notice.PropertyIndividualCalSheetAction;
import org.egov.ptis.bean.PropertyCalSheetInfo;
import org.egov.ptis.client.model.AreaTaxCalculationInfo;
import org.egov.ptis.client.model.ConsolidatedUnitTaxCalReport;
import org.egov.ptis.client.model.GovtPropertyInfo;
import org.egov.ptis.client.model.GovtPropertyTaxCalInfo;
import org.egov.ptis.client.model.calculator.APUnitTaxCalculationInfo;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.UnitAreaCalculationDetail;
import org.egov.ptis.domain.entity.property.UnitCalculationDetail;
import org.egov.ptis.domain.model.calculator.TaxCalculationInfo;
import org.egov.ptis.domain.model.calculator.UnitTaxCalculationInfo;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;

public class PropertyIndividualCalSheetAction
extends BaseFormAction {
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private final BigDecimal TOTAL_MONTHS = new BigDecimal("12");
    private ReportService reportService;
    private String reportId;
    private String indexNum;
    private PropertyTaxUtil propertyTaxUtil;
    SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    SimpleDateFormat yearformatter = new SimpleDateFormat("yyyy");
    private BasicProperty basicProperty;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public Object getModel() {
        return null;
    }

    public String generateCalSheet() {
        try {
            this.LOGGER.debug((Object)"Entered into generateCalSheet method");
            this.LOGGER.debug((Object)("Index Num in generateCalSheet : " + this.indexNum));
            this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(this.indexNum);
            Property property = this.basicProperty.getProperty();
            ReportRequest reportInput = null;
            reportInput = property.getPropertyDetail().getPropertyTypeMaster().getCode().equals("STATE_GOVT") || property.getPropertyDetail().getPropertyTypeMaster().getCode().equals("CENTRAL_GOVT_50") ? this.getReportInputDataForGovtProps(property) : this.getReportInputData(property);
            this.reportId = this.reportViewerUtil.addReportToTempCache(this.reportService.createReport(reportInput));
            this.LOGGER.debug((Object)"Exit from generateCalSheet method");
            return "calsheet";
        }
        catch (Exception e) {
            this.LOGGER.error((Object)"Exception in Generate Cal Sheet: ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception : " + e);
        }
    }

    private ReportRequest getReportInputDataForGovtProps(Property property) {
        ReportRequest reportInput = null;
        List unitCalculationDetails = this.getUniqueALVUnitCalcDetails(property, true);
        GovtPropertyInfo govtPropInfo = this.prepareGovtPropInfo(unitCalculationDetails, PropertyCalSheetInfo.createCalSheetInfo((Property)property));
        reportInput = new ReportRequest("IndCalSheetForGovtProperties", (Object)govtPropInfo, null);
        reportInput.setPrintDialogOnOpenReport(false);
        return reportInput;
    }

    private GovtPropertyInfo prepareGovtPropInfo(List<UnitCalculationDetail> unitCalcDetails, PropertyCalSheetInfo calSheetInfo) {
        GovtPropertyInfo govtPropertyInfo = new GovtPropertyInfo();
        for (UnitCalculationDetail unitCalcDetail : unitCalcDetails) {
            GovtPropertyTaxCalInfo govtPropTaxCalInfo = null;
            govtPropertyInfo.setArea(calSheetInfo.getArea());
            govtPropertyInfo.setWard(calSheetInfo.getWard());
            govtPropertyInfo.setHouseNumber(calSheetInfo.getHouseNumber());
            govtPropertyInfo.setIndexNo(calSheetInfo.getIndexNo());
            govtPropertyInfo.setParcelId(calSheetInfo.getParcelId());
            govtPropertyInfo.setPropertyAddress(calSheetInfo.getPropertyAddress());
            govtPropertyInfo.setPropertyOwnerName(calSheetInfo.getPropertyOwnerName());
            govtPropertyInfo.setPropertyType(calSheetInfo.getPropertyType());
            govtPropTaxCalInfo = this.prepareGovtPropTaxCalTnfo(unitCalcDetail, calSheetInfo);
            govtPropTaxCalInfo.setEffectiveDate(this.formatter.format(unitCalcDetail.getOccupancyDate()));
            govtPropertyInfo.addGovtPropTaxCalInfo(govtPropTaxCalInfo);
        }
        return govtPropertyInfo;
    }

    private GovtPropertyTaxCalInfo prepareGovtPropTaxCalTnfo(UnitCalculationDetail unitCalcDetail, PropertyCalSheetInfo calSheetInfo) {
        GovtPropertyTaxCalInfo govtPropTaxCalInfo = new GovtPropertyTaxCalInfo();
        govtPropTaxCalInfo.setAnnualLettingValue(unitCalcDetail.getAlv());
        govtPropTaxCalInfo.setBuildingCost(unitCalcDetail.getBuildingCost());
        if (PropertyTaxUtil.isNotNull((Object)unitCalcDetail.getUnitArea()) && PropertyTaxUtil.isNotZero((BigDecimal)unitCalcDetail.getUnitArea())) {
            govtPropTaxCalInfo.setPropertyArea(unitCalcDetail.getUnitArea().toString());
        } else {
            govtPropTaxCalInfo.setPropertyArea("N/A");
        }
        if (calSheetInfo.getPropertyType().equalsIgnoreCase("STATE_GOVT")) {
            govtPropTaxCalInfo.setAlvPercentage(PropertyTaxConstants.STATEGOVT_BUILDING_ALV_PERCENTAGE);
            govtPropTaxCalInfo.setAmenities("N/A");
        } else {
            govtPropTaxCalInfo.setAlvPercentage(PropertyTaxConstants.CENTRALGOVT_BUILDING_ALV_PERCENTAGE);
        }
        return govtPropTaxCalInfo;
    }

    private Map<Installment, TaxCalculationInfo> getTaxCalInfoMap(Set<Ptdemand> ptDmdSet) {
        TreeMap<Installment, TaxCalculationInfo> taxCalInfoMap = new TreeMap<Installment, TaxCalculationInfo>();
        for (Ptdemand ptdmd : ptDmdSet) {
            TaxCalculationInfo taxCalcInfo = this.propertyTaxUtil.getTaxCalInfo(ptdmd);
            if (taxCalcInfo == null) continue;
            taxCalInfoMap.put(ptdmd.getEgInstallmentMaster(), taxCalcInfo);
        }
        return taxCalInfoMap;
    }

    private List<UnitCalculationDetail> getUniqueALVUnitCalcDetails(Property property, boolean isCompareAlv) {
        this.LOGGER.debug((Object)("Entered into getUniqueALVUnitCalcDetails, property=" + property));
        String query = "from UnitCalculationDetail ucd join fetch ucd.unitAreaCalculationDetails where ucd.property = ? order by ucd.unitNumber, ucd.installmentFromDate, ucd.fromDate";
        List unitCalculationDetails = ((Session)this.entityManager.unwrap(Session.class)).createQuery(query).setEntity(0, (Object)property).list();
        ArrayList<UnitCalculationDetail> uniqueALVUnitCalcDetails = new ArrayList<UnitCalculationDetail>();
        UnitCalculationDetail prevUnitCalcDetail = null;
        for (UnitCalculationDetail unitCalcDetail : unitCalculationDetails) {
            if (uniqueALVUnitCalcDetails.isEmpty()) {
                uniqueALVUnitCalcDetails.add(new UnitCalculationDetail(unitCalcDetail));
            } else if (PropertyTaxUtil.isNotNull(prevUnitCalcDetail)) {
                if (isCompareAlv) {
                    if (prevUnitCalcDetail.getAlv().compareTo(unitCalcDetail.getAlv()) != 0) {
                        uniqueALVUnitCalcDetails.add(new UnitCalculationDetail(unitCalcDetail));
                    }
                } else if (prevUnitCalcDetail.getBuildingCost().compareTo(unitCalcDetail.getBuildingCost()) != 0) {
                    uniqueALVUnitCalcDetails.add(new UnitCalculationDetail(unitCalcDetail));
                }
            }
            prevUnitCalcDetail = unitCalcDetail;
        }
        this.LOGGER.debug((Object)("Entered into getUniqueALVUnitCalcDetails, uniqueALVUnitCalcDetails=" + uniqueALVUnitCalcDetails));
        return uniqueALVUnitCalcDetails;
    }

    private ReportRequest getReportInputData(Property property) {
        this.LOGGER.debug((Object)"Entered into getReportInputData method");
        this.LOGGER.debug((Object)("Property : " + property));
        Set ptDmdSet = property.getPtDemandSet();
        ArrayList<ConsolidatedUnitTaxCalReport> consolidatedUnitTaxCalReportList = new ArrayList<ConsolidatedUnitTaxCalReport>();
        Object taxCalInfoMap = null;
        List unitCalculationDetails = this.getUniqueALVUnitCalcDetails(property, true);
        Object unitTaxCalcInfo = null;
        TreeMap unitCalcDetails = new TreeMap();
        for (UnitCalculationDetail unitCalcDetail : unitCalculationDetails) {
            ConsolidatedUnitTaxCalReport consolidatedUnitTaxCalReport = new ConsolidatedUnitTaxCalReport();
            consolidatedUnitTaxCalReport.setAnnualLettingValue(MoneyUtils.roundOffTwo((BigDecimal)unitCalcDetail.getAlv()));
            consolidatedUnitTaxCalReport.setMonthlyRent(unitCalcDetail.getMonthlyRent().compareTo(BigDecimal.ZERO) == 0 ? null : unitCalcDetail.getMonthlyRent());
            if (PropertyTaxUtil.isNotNull((Object)unitCalcDetail.getAlv()) && PropertyTaxUtil.isNotZero((BigDecimal)unitCalcDetail.getMonthlyRent())) {
                consolidatedUnitTaxCalReport.setAnnualRentBeforeDeduction(unitCalcDetail.getMonthlyRent().multiply(this.TOTAL_MONTHS));
                BigDecimal dedAmt = consolidatedUnitTaxCalReport.getAnnualRentBeforeDeduction().divide(new BigDecimal(10));
                consolidatedUnitTaxCalReport.setDeductionAmount(MoneyUtils.roundOffTwo((BigDecimal)dedAmt));
            }
            if (this.yearformatter.format(unitCalcDetail.getInstallmentFromDate()).equals(this.yearformatter.format(unitCalcDetail.getOccupancyDate()))) {
                consolidatedUnitTaxCalReport.setInstDate(DateUtils.getDefaultFormattedDate((Date)unitCalcDetail.getOccupancyDate()));
            } else {
                consolidatedUnitTaxCalReport.setInstDate(DateUtils.getDefaultFormattedDate((Date)unitCalcDetail.getInstallmentFromDate()));
            }
            consolidatedUnitTaxCalReport.setUnitTaxCalInfo(this.prepareUnitCalculationDetails(unitCalcDetail));
            consolidatedUnitTaxCalReportList.add(consolidatedUnitTaxCalReport);
        }
        PropertyCalSheetInfo propertyCalSheetinfo = PropertyCalSheetInfo.createCalSheetInfo((Property)property);
        propertyCalSheetinfo.setConsolidatedUnitTaxCalReportList(consolidatedUnitTaxCalReportList);
        ReportRequest reportInput = new ReportRequest("IndCalculationSheet", (Object)propertyCalSheetinfo, null);
        reportInput.setPrintDialogOnOpenReport(false);
        this.LOGGER.debug((Object)"Exit from getReportInputData method");
        return reportInput;
    }

    private List<UnitTaxCalculationInfo> prepareUnitCalculationDetails(UnitCalculationDetail unitCalcDetail) {
        ArrayList<UnitTaxCalculationInfo> unitTaxes = new ArrayList<UnitTaxCalculationInfo>();
        TreeMap unitAreaDetails = new TreeMap();
        String unitId = null;
        for (UnitAreaCalculationDetail unitAreaCalcDetail : unitCalcDetail.getUnitAreaCalculationDetails()) {
            unitId = unitAreaCalcDetail.getUnitIdentifier();
            if (PropertyTaxUtil.isNull(unitAreaDetails.get(unitId))) {
                TreeSet<UnitAreaCalculationDetail> unitAreas = new TreeSet<UnitAreaCalculationDetail>((Comparator<UnitAreaCalculationDetail>)new UnitAreaCalculationDetailComparator(this, null));
                unitAreas.add(unitAreaCalcDetail);
                unitAreaDetails.put(unitId, unitAreas);
                continue;
            }
            ((Set)unitAreaDetails.get(unitId)).add(unitAreaCalcDetail);
        }
        APUnitTaxCalculationInfo unitTaxInfo = null;
        AreaTaxCalculationInfo areaTaxInfo = null;
        BigDecimal totalUnitArea = BigDecimal.ZERO;
        BigDecimal totalMonthlyRent = BigDecimal.ZERO;
        String floorNumberString = null;
        String manualALV = null;
        int i = 0;
        for (Map.Entry entry : unitAreaDetails.entrySet()) {
            unitTaxInfo = new APUnitTaxCalculationInfo();
            unitTaxInfo.setFloorNumber(unitCalcDetail.getUnitNumber().toString());
            i = 0;
            totalUnitArea = BigDecimal.ZERO;
            totalMonthlyRent = BigDecimal.ZERO;
            for (UnitAreaCalculationDetail unitArea : (Set)entry.getValue()) {
                areaTaxInfo = new AreaTaxCalculationInfo();
                floorNumberString = (String)PropertyTaxConstants.FLOOR_MAP.get(unitArea.getFloorNumber());
                if (i == 0) {
                    unitTaxInfo.setFloorNumber(PropertyTaxUtil.isNull((Object)floorNumberString) ? unitArea.getFloorNumber() : floorNumberString);
                    unitTaxInfo.setFloorNumber(PropertyTaxUtil.isNull((Object)floorNumberString) ? null : floorNumberString);
                    unitTaxInfo.setUnitOccupation(unitArea.getUnitOccupation());
                    manualALV = unitArea.getManualALV().compareTo(BigDecimal.ZERO) == 0 ? null : MoneyUtils.roundOffTwo((BigDecimal)unitArea.getManualALV()).toString();
                    unitTaxInfo.setBaseRatePerSqMtPerMonth(MoneyUtils.roundOffTwo((BigDecimal)unitArea.getBaseRentPerSqMtr()));
                }
                totalUnitArea = totalUnitArea.add(unitArea.getTaxableArea());
                totalMonthlyRent = totalMonthlyRent.add(unitArea.getMonthlyRentalValue());
                areaTaxInfo.setTaxableArea(MoneyUtils.roundOffTwo((BigDecimal)unitArea.getTaxableArea()));
                areaTaxInfo.setMonthlyBaseRent(MoneyUtils.roundOffTwo((BigDecimal)unitArea.getMonthlyBaseRent()));
                areaTaxInfo.setCalculatedTax(unitArea.getMonthlyRentalValue());
                ++i;
            }
            unitTaxInfo.setFloorArea(MoneyUtils.roundOffTwo((BigDecimal)totalUnitArea));
            unitTaxInfo.setUnitAreaInSqFt(MoneyUtils.roundOffTwo((BigDecimal)totalUnitArea.multiply(PropertyTaxConstants.SqFt)));
            unitTaxes.add((UnitTaxCalculationInfo)unitTaxInfo);
        }
        return unitTaxes;
    }

    private Map<Installment, TaxCalculationInfo> getTaxCalInfoList(Map<Installment, TaxCalculationInfo> taxCalInfoMap) {
        TreeMap<Installment, TaxCalculationInfo> taxCalInfoList = new TreeMap<Installment, TaxCalculationInfo>();
        TaxCalculationInfo firstInstTxCalInfo = null;
        TaxCalculationInfo prevTaxCalInfo = null;
        Boolean isPropertyModified = PropertyTaxUtil.isPropertyModified((Property)this.basicProperty.getProperty());
        int i = 0;
        for (Map.Entry<Installment, TaxCalculationInfo> txCalInfo : taxCalInfoMap.entrySet()) {
            if (i == 0) {
                firstInstTxCalInfo = txCalInfo.getValue();
                Boolean isMultipleBRsEffective = false;
                if (isMultipleBRsEffective.booleanValue()) continue;
                taxCalInfoList.put(txCalInfo.getKey(), firstInstTxCalInfo);
                prevTaxCalInfo = firstInstTxCalInfo;
            }
            if (++i != 1) continue;
        }
        return taxCalInfoList;
    }

    public String getIndexNum() {
        return this.indexNum;
    }

    public void setIndexNum(String indexNum) {
        this.indexNum = indexNum;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getReportId() {
        return this.reportId;
    }

    public PropertyTaxUtil getPropertyTaxUtil() {
        return this.propertyTaxUtil;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }
}

