/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.common;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Actions;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.repository.UserRepository;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.pims.commons.Designation;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.CategoryDao;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Category;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.PropertyDepartment;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.egov.ptis.domain.model.MutationFeeDetails;
import org.egov.ptis.domain.repository.PropertyDepartmentRepository;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Namespace(value="/common")
@ResultPath(value="/WEB-INF/jsp/common/")
@Results(value={@Result(name={"ward"}, location="ajaxCommon-ward.jsp"), @Result(name={"street"}, location="ajaxCommon-street.jsp"), @Result(name={"area"}, location="ajaxCommon-area.jsp"), @Result(name={"category"}, location="ajaxCommon-category.jsp"), @Result(name={"structural"}, location="ajaxCommon-structural.jsp"), @Result(name={"designationList"}, location="ajaxCommon-designationList.jsp"), @Result(name={"userList"}, location="ajaxCommon-userList.jsp"), @Result(name={"propCategory"}, location="ajaxCommon-propCategory.jsp"), @Result(name={"checkExistingCategory"}, location="ajaxCommon-checkExistingCategory.jsp"), @Result(name={"usage"}, location="ajaxCommon-usage.jsp"), @Result(name={"calculateMutationFee"}, location="ajaxCommon-calculateMutationFee.jsp"), @Result(name={"propDepartment"}, location="ajaxcommon-propdepartment.jsp"), @Result(name={"defaultcitizen"}, location="ajaxcommon-citizenfordoctype.jsp")})
public class AjaxCommonAction
extends BaseFormAction
implements ServletResponseAware {
    private static final long serialVersionUID = -2147988330701242191L;
    private static final String CATEGORY = "category";
    private static final String FAILURE = "failure";
    private static final String USAGE = "usage";
    private static final String PROP_TYPE_CATEGORY = "propCategory";
    private static final String RESULT_STRUCTURAL = "structural";
    private static final String WARD = "ward";
    private static final String AREA = "area";
    private static final String RESULT_CHECK_EXISTING_CATEGORY = "checkExistingCategory";
    private static final String RESULT_MUTATION_FEE = "calculateMutationFee";
    private static final String DEFAULT_CITIZEN_NAME = "The Holder Of The Premises";
    private static final String RECURSIVEFACTOR_N = "N";
    private Long zoneId;
    private Long wardId;
    private Long areaId;
    private Long locality;
    private Long departmentId;
    private Long designationId;
    private Integer propTypeId;
    private String usageFactor;
    private String structFactor;
    private Float revisedRate;
    private List<Boundary> wardList;
    private List<Boundary> areaList;
    private List<Boundary> streetList;
    private List<PropertyUsage> propUsageList;
    private List<Designation> designationMasterList = new ArrayList();
    private final List<User> userList = new ArrayList();
    private List<Category> categoryList;
    private List<StructureClassification> structuralClassifications;
    private String returnStream = "";
    private Map<String, String> propTypeCategoryMap = new TreeMap();
    private Date completionOccupationDate;
    private final Logger logger = Logger.getLogger(this.getClass());
    private List<String> partNumbers;
    private transient HttpServletResponse response;
    private List<Assignment> assignmentList;
    private String currentStatusCode;
    private String mobileNumber;
    private String categoryExists = "no";
    private String assessmentNo;
    private Long usageId;
    private Long structureClassId;
    private Date categoryFromDate;
    private String validationMessage = "";
    private String propTypeCategory;
    private BigDecimal partyValue;
    private BigDecimal departmentValue;
    private BigDecimal mutationFee = BigDecimal.ZERO;
    private List<PropertyDepartment> propertyDepartmentList;
    private List<DocumentType> assessmentDocumentList;
    private String assessmentDocumentType = "";
    private User defaultCitizen;
    private BigDecimal extentOfSite;
    private BigDecimal plingthArea;
    @Autowired
    private transient CategoryDao categoryDAO;
    @Autowired
    private transient BoundaryService boundaryService;
    @Autowired
    private transient DesignationService designationService;
    @Autowired
    private transient AssignmentService assignmentService;
    @Autowired
    private transient SecurityUtils securityUtils;
    @Autowired
    private transient PropertyDepartmentRepository propertyDepartmentRepository;
    @Autowired
    private transient UserRepository userRepository;

    public Object getModel() {
        return null;
    }

    @Action(value="/ajaxCommon-wardByZone")
    public String wardByZone() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into wardByZone, zoneId: " + this.zoneId));
        }
        this.wardList = new ArrayList();
        this.wardList = this.boundaryService.getActiveChildBoundariesByBoundaryId(this.getZoneId());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exiting from wardByZone, No of wards in zone: " + this.zoneId + "are " + (this.wardList != null ? this.wardList : BigDecimal.ZERO)));
        }
        return WARD;
    }

    @Action(value="/ajaxCommon-areaByWard")
    public String areaByWard() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into areaByWard, wardId: " + this.wardId));
        }
        this.areaList = new ArrayList();
        this.areaList = this.boundaryService.getActiveChildBoundariesByBoundaryId(this.getWardId());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exiting from areaByWard, No of areas in ward: " + this.wardId + " are " + (this.areaList != null ? this.areaList : BigDecimal.ZERO)));
        }
        return AREA;
    }

    @Action(value="/ajaxCommon-streetByWard")
    public String streetByWard() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into streetByWard, wardId: " + this.wardId));
        }
        this.streetList = new ArrayList();
        this.streetList = this.getPersistenceService().findAllBy("select CH.child from CrossHierarchy CH where CH.parent.id = ? ", new Object[]{this.getWardId()});
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exiting from streetByWard, No of streets in ward: " + this.wardId + " are " + (this.streetList != null ? this.streetList : BigDecimal.ZERO)));
        }
        return "street";
    }

    @Action(value="/ajaxCommon-populateDesignationsByDept")
    public String populateDesignationsByDept() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into populateUsersByDesignation : departmentId : " + this.departmentId));
        }
        if (this.departmentId != null) {
            Designation designation = this.assignmentService.getPrimaryAssignmentForUser(this.securityUtils.getCurrentUser().getId()).getDesignation();
            if (designation.getName().equals("Assistant")) {
                this.designationMasterList.add(this.designationService.getDesignationByName("Revenue Officer"));
            } else if (designation.getName().equals("Revenue Officer")) {
                this.designationMasterList.add(this.designationService.getDesignationByName("Commissioner"));
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exiting from populateUsersByDesignation : No of Designation : " + (this.designationMasterList != null ? Integer.valueOf(this.designationMasterList.size()) : BigDecimal.ZERO)));
        }
        return "designationList";
    }

    @Action(value="/ajaxCommon-populateDesignationsByDeptForRevisionPetition")
    public String populateDesignationsByDeptForRevisionPetition() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into populateUsersByDesignation : departmentId : " + this.departmentId + this.currentStatusCode));
        }
        if (this.departmentId != null) {
            Designation designation = this.assignmentService.getPrimaryAssignmentForUser(this.securityUtils.getCurrentUser().getId()).getDesignation();
            if (this.currentStatusCode == null || "".equals(this.currentStatusCode)) {
                this.designationMasterList.add(this.designationService.getDesignationByName("Commissioner"));
            } else if (this.currentStatusCode != null && !"".equals(this.currentStatusCode) && this.currentStatusCode.equals("CREATED")) {
                this.designationMasterList.add(this.designationService.getDesignationByName("Assistant"));
            } else if (this.currentStatusCode != null && !"".equals(this.currentStatusCode) && this.currentStatusCode.equals("HEARING DATE FIXED")) {
                this.designationMasterList.add(this.designationService.getDesignationByName("UD Revenue Inspector"));
            } else if (this.currentStatusCode != null && !"".equals(this.currentStatusCode) && this.currentStatusCode.equals("HEARING COMPLETED")) {
                this.designationMasterList.add(this.designationService.getDesignationByName("Revenue Officer"));
            } else if (this.currentStatusCode != null && !"".equals(this.currentStatusCode) && this.currentStatusCode.equals("INSPECTION COMPLETED")) {
                this.designationMasterList.add(this.designationService.getDesignationByName("Commissioner"));
            } else if (this.currentStatusCode != null && !"".equals(this.currentStatusCode) && this.currentStatusCode.equals("INSPECTION VERIFY")) {
                this.designationMasterList.add(this.designationService.getDesignationByName("Assistant"));
            } else if (designation.getName().equals("Assistant")) {
                this.designationMasterList.add(this.designationService.getDesignationByName("Revenue Officer"));
            } else if (designation.getName().equals("Revenue Officer")) {
                this.designationMasterList.add(this.designationService.getDesignationByName("Commissioner"));
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exiting from populateUsersByDesignation : No of Designation : " + (this.designationMasterList != null ? Integer.valueOf(this.designationMasterList.size()) : BigDecimal.ZERO)));
        }
        return "designationList";
    }

    @Action(value="/ajaxCommon-populateUsersByDeptAndDesignation")
    public String populateUsersByDeptAndDesignation() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into populateUsersByDesignation : designationId : " + this.designationId));
        }
        if (this.designationId != null && this.departmentId != null) {
            this.assignmentList = this.assignmentService.getPositionsByDepartmentAndDesignationForGivenRange(this.departmentId, this.designationId, new Date());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exiting from populateUsersByDesignation : No of users : " + (this.userList != null ? this.userList : BigDecimal.ZERO)));
        }
        return "userList";
    }

    @Action(value="/ajaxCommon-categoryByRateUsageAndStructClass")
    public String categoryByRateUsageAndStructClass() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into categoryByRateUsageAndStructClass method, Usage Factor: " + this.usageFactor + ", Structure Classification: " + this.structFactor));
        }
        PropertyUsage propUsage = (PropertyUsage)this.getPersistenceService().find("from PropertyUsage pu where pu.usageName=?", new Object[]{this.usageFactor});
        StructureClassification structureClass = (StructureClassification)this.getPersistenceService().find("from StructureClassification sc where sc.typeName=?", new Object[]{this.structFactor});
        if (propUsage != null && structureClass != null && this.revisedRate != null) {
            Conjunction conjunction = Restrictions.conjunction();
            SimpleExpression usgId = Restrictions.eq((String)"propUsage", (Object)propUsage);
            SimpleExpression classId = Restrictions.eq((String)"structureClass", (Object)structureClass);
            SimpleExpression catAmt = Restrictions.eq((String)"categoryAmount", (Object)this.revisedRate);
            conjunction.add((Criterion)usgId);
            conjunction.add((Criterion)classId);
            conjunction.add((Criterion)catAmt);
            Conjunction criterion = conjunction;
            this.categoryList = this.categoryDAO.getCategoryByRateUsageAndStructClass((Criterion)criterion);
        }
        this.addDropdownData("categoryList", this.categoryList);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Exiting from categoryByRateUsageAndStructClass method");
        }
        if (this.categoryList == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"categoryByRateUsageAndStructClass: categoryList is NULL \n Exiting from categoryByRateUsageAndStructClass");
            }
            return FAILURE;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("categoryByRateUsageAndStructClass: categoryList:" + this.categoryList + "\nExiting from categoryByRateUsageAndStructClass"));
        }
        return CATEGORY;
    }

    @Actions(value={@Action(value="/ajaxCommon-propTypeCategoryByPropType"), @Action(value="/public/ajaxCommon-propTypeCategoryByPropType")})
    public String propTypeCategoryByPropType() {
        PropertyTypeMaster propType;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into propTypeCategoryByPropType, propTypeId: " + this.propTypeId));
        }
        if ((propType = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.id=?", new Object[]{this.propTypeId.longValue()})) != null) {
            if (propType.getCode().equalsIgnoreCase("VAC_LAND")) {
                this.propTypeCategoryMap.putAll(PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY);
            } else {
                this.propTypeCategoryMap.putAll(PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY);
            }
            this.setPropTypeCategoryMap(this.propTypeCategoryMap);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"propTypeCategoryByPropType: NULL -> propType is null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exiting from propTypeCategoryByPropType, No of Categories: " + (this.propTypeCategoryMap != null ? Integer.valueOf(this.propTypeCategoryMap.size()) : BigDecimal.ZERO)));
        }
        return PROP_TYPE_CATEGORY;
    }

    @Action(value="/ajaxCommon-locationFactorsByWard")
    public String locationFactorsByWard() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into locationFactorsByWard, wardId: " + this.wardId));
        }
        this.categoryList = new ArrayList();
        this.categoryList.addAll(this.getPersistenceService().findAllBy("select bc.category from BoundaryCategory bc where bc.bndry.id = ? and bc.category.propUsage = null and bc.category.structureClass = null", new Object[]{this.wardId}));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("locationFactorsByWard: categories - " + this.categoryList));
            this.logger.debug((Object)"Exiting from locationFactorsByWard");
        }
        return CATEGORY;
    }

    @Action(value="/ajaxCommon-populateStructuralClassifications")
    public String populateStructuralClassifications() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into getStructureClassifications, Date: " + this.completionOccupationDate));
        }
        this.structuralClassifications = new ArrayList();
        try {
            if (this.completionOccupationDate.after(new SimpleDateFormat("dd/MM/yyyy").parse("01/04/2020"))) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Base Rate - Structural Factors");
                }
                this.structuralClassifications.addAll(this.getPersistenceService().findAllBy("from StructureClassification where code like 'R%'", new Object[0]));
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Rent Chart - Structural Factors");
                }
                this.structuralClassifications.addAll(this.getPersistenceService().findAllBy("from StructureClassification where code like 'R%'", new Object[0]));
            }
        }
        catch (ParseException pe) {
            this.logger.error((Object)"Error while parsing Floor Completion / occupation", (Throwable)pe);
            throw new ApplicationRuntimeException("Error while parsing Floor Completion / occupation", (Throwable)pe);
        }
        Collections.sort(this.structuralClassifications, (object1, object2) -> object1.getTypeName().compareTo(object2.getTypeName()));
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("getStructureClassifications - Structural Factors : " + this.structuralClassifications));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Exiting from getStructureClassifications");
        }
        return RESULT_STRUCTURAL;
    }

    @Actions(value={@Action(value="/ajaxCommon-getUserByMobileNo"), @Action(value="/public/ajaxCommon-getUserByMobileNo")})
    public void getUserByMobileNo() throws IOException {
        if (StringUtils.isNotBlank((String)this.mobileNumber)) {
            User user = (User)this.getPersistenceService().find("From User where mobileNumber = ?", new Object[]{this.mobileNumber});
            JSONObject jsonObject = new JSONObject();
            if (null != user) {
                jsonObject.put("exists", (Object)Boolean.TRUE);
                jsonObject.put("name", (Object)user.getName());
                jsonObject.put("mobileNumber", (Object)user.getMobileNumber());
                jsonObject.put("salutaion", (Object)user.getSalutation());
                jsonObject.put("gender", (Object)user.getGender());
                jsonObject.put("email", (Object)user.getEmailId());
                jsonObject.put("guardian", (Object)user.getGuardian());
                jsonObject.put("guardianRelarion", (Object)user.getGuardianRelation());
            }
            this.response.setContentType("application/json");
            IOUtils.write((String)jsonObject.toString(), (Writer)this.response.getWriter());
        }
    }

    @Action(value="/ajaxCommon-checkIfCategoryExists")
    public String checkIfCategoryExists() {
        Category existingCategory;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Entered into checkIfCategoryExists ");
        }
        if ((existingCategory = (Category)this.getPersistenceService().find("select bc.category from BoundaryCategory bc where bc.bndry.id = ? and bc.category.propUsage.id = ? and bc.category.structureClass.id = ? and bc.category.fromDate = ? and bc.category.isActive = true ", new Object[]{this.zoneId, this.usageId, this.structureClassId, this.categoryFromDate})) != null) {
            this.categoryExists = "yes";
            this.validationMessage = this.getText("unit.rate.exists.for.combination", new String[]{existingCategory.getCategoryAmount().toString()});
        }
        return RESULT_CHECK_EXISTING_CATEGORY;
    }

    @Actions(value={@Action(value="/ajaxCommon-usageByPropType"), @Action(value="/public/ajaxCommon-usageByPropType")})
    public String usageByPropType() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Entered into usageByPropType, propTypeId: " + this.propTypeId));
        }
        if (this.propTypeCategory.equals("MIXED")) {
            this.propUsageList = this.getPersistenceService().findAllBy("From PropertyUsage where isActive = true order by usageName ", new Object[0]);
        } else if (this.propTypeCategory.equals("RESIDENTIAl")) {
            this.propUsageList = this.getPersistenceService().findAllBy("From PropertyUsage where isResidential = true and isActive = true  order by usageName ", new Object[0]);
        } else if (this.propTypeCategory.equals("NON_RESIDENTIAL")) {
            this.propUsageList = this.getPersistenceService().findAllBy("From PropertyUsage where isResidential = false and isActive = true  order by usageName ", new Object[0]);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Exiting from usageByPropType, No of Usages: " + (this.propUsageList != null ? this.propUsageList : BigDecimal.ZERO)));
        }
        return USAGE;
    }

    @Action(value="/ajaxCommon-checkIfPropertyExists")
    public void checkIfPropertyExists() throws IOException {
        if (StringUtils.isNotBlank((String)this.assessmentNo)) {
            BasicProperty basicProperty = (BasicProperty)this.getPersistenceService().find("from BasicPropertyImpl bp where bp.oldMuncipalNum=? and bp.active='Y'", new Object[]{this.assessmentNo});
            JSONObject jsonObject = new JSONObject();
            if (null != basicProperty) {
                jsonObject.put("exists", (Object)Boolean.TRUE);
            }
            this.response.setContentType("application/json");
            IOUtils.write((String)jsonObject.toString(), (Writer)this.response.getWriter());
        }
    }

    @Action(value="/ajaxCommon-calculateMutationFee")
    public String calculateMutationFee() {
        MutationFeeDetails mutationFeeDetails;
        BigDecimal documentValue;
        BigDecimal bigDecimal = documentValue = this.partyValue.compareTo(this.departmentValue) > 0 ? this.partyValue : this.departmentValue;
        if (documentValue.compareTo(BigDecimal.ZERO) > 0 && (mutationFeeDetails = (MutationFeeDetails)this.getPersistenceService().find("from MutationFeeDetails where lowLimit <= ? and (highLimit is null OR highLimit >= ?) and toDate > now()", new Object[]{documentValue, documentValue})) != null) {
            if (mutationFeeDetails.getFlatAmount() != null && mutationFeeDetails.getFlatAmount().compareTo(BigDecimal.ZERO) > 0) {
                if (mutationFeeDetails.getIsRecursive().toString().equalsIgnoreCase(RECURSIVEFACTOR_N)) {
                    this.mutationFee = mutationFeeDetails.getFlatAmount();
                } else {
                    BigDecimal excessDocValue = documentValue.subtract(mutationFeeDetails.getLowLimit()).add(BigDecimal.ONE);
                    BigDecimal multiplicationFactor = excessDocValue.divide(mutationFeeDetails.getRecursiveFactor(), 2);
                    this.mutationFee = mutationFeeDetails.getFlatAmount().add(multiplicationFactor.multiply(mutationFeeDetails.getRecursiveAmount()));
                }
            }
            if (mutationFeeDetails.getPercentage() != null && mutationFeeDetails.getPercentage().compareTo(BigDecimal.ZERO) > 0 && mutationFeeDetails.getIsRecursive().toString().equalsIgnoreCase(RECURSIVEFACTOR_N)) {
                this.mutationFee = documentValue.multiply(mutationFeeDetails.getPercentage()).divide(PropertyTaxConstants.BIGDECIMAL_100);
            }
            this.mutationFee = this.mutationFee.setScale(0, 4);
        }
        return RESULT_MUTATION_FEE;
    }

    @Actions(value={@Action(value="/ajaxcommon-propdepartment-byproptype"), @Action(value="/public/ajaxcommon-propdepartment-byproptype")})
    public String getPropDepartmentByPropType() {
        if (this.propTypeId != null) {
            PropertyTypeMaster propTypeMstr = (PropertyTypeMaster)this.getPersistenceService().find("from PropertyTypeMaster ptm where ptm.id = ?", new Object[]{(long)this.propTypeId.intValue()});
            if (propTypeMstr.getCode().equalsIgnoreCase("STATE_GOVT")) {
                this.propertyDepartmentList = this.propertyDepartmentRepository.getAllStateDepartments();
            } else if (propTypeMstr.getCode().startsWith("CENTRAL_GOVT")) {
                this.propertyDepartmentList = this.propertyDepartmentRepository.getAllCentralDepartments();
            } else if (propTypeMstr.getCode().equals("PRIVATE")) {
                this.setPropertyDepartmentList(this.propertyDepartmentRepository.getAllPrivateDepartments());
            }
        }
        this.setPropertyDepartmentList(this.propertyDepartmentList);
        return "propDepartment";
    }

    @Actions(value={@Action(value="/ajaxcommon-defaultcitizen-fordoctype"), @Action(value="/public/ajaxcommon-defaultcitizen-fordoctype")})
    public String getDefaultCitizenForDoctype() {
        if (this.assessmentDocumentType != null) {
            this.defaultCitizen = this.userRepository.findByUsername(DEFAULT_CITIZEN_NAME);
        }
        return "defaultcitizen";
    }

    @Actions(value={@Action(value="/ajaxCommon-isAppurTenant"), @Action(value="/public/ajaxCommon-isAppurTenant")})
    public void isAppurTenant() throws IOException {
        JSONObject jsonObject = new JSONObject();
        this.response.setContentType("application/json");
        if (this.extentOfSite != null && this.plingthArea != null) {
            BigDecimal triplePlingthArea = this.plingthArea.multiply(BigDecimal.valueOf(3L));
            BigDecimal permissableArea = triplePlingthArea.compareTo(BigDecimal.valueOf(1000L)) < 0 ? triplePlingthArea : BigDecimal.valueOf(1000L);
            BigDecimal landArea = this.extentOfSite.subtract(permissableArea);
            jsonObject.put("isAppurTenantLand", landArea.compareTo(BigDecimal.ZERO) > 0);
            jsonObject.put("extentAppartenauntLand", (Object)permissableArea);
            jsonObject.put("vacantLandArea", (Object)landArea);
        } else {
            jsonObject.put("isAppurTenantLand", (Object)Boolean.FALSE);
        }
        IOUtils.write((String)jsonObject.toString(), (Writer)this.response.getWriter());
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public Long getAreaId() {
        return this.areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public String getUsageFactor() {
        return this.usageFactor;
    }

    public void setUsageFactor(String usageFactor) {
        this.usageFactor = usageFactor;
    }

    public String getStructFactor() {
        return this.structFactor;
    }

    public void setStructFactor(String structFactor) {
        this.structFactor = structFactor;
    }

    public Float getRevisedRate() {
        return this.revisedRate;
    }

    public void setRevisedRate(Float revisedRate) {
        this.revisedRate = revisedRate;
    }

    public List<Category> getCategoryList() {
        return this.categoryList;
    }

    public void setCategoryList(List<Category> categoryList) {
        this.categoryList = categoryList;
    }

    public List<Boundary> getWardList() {
        return this.wardList;
    }

    public void setWardList(List<Boundary> wardList) {
        this.wardList = wardList;
    }

    public List<Boundary> getStreetList() {
        return this.streetList;
    }

    public void setStreetList(List<Boundary> streetList) {
        this.streetList = streetList;
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public List<Designation> getDesignationMasterList() {
        return this.designationMasterList;
    }

    public void setDesignationMasterList(List<Designation> designationMasterList) {
        this.designationMasterList = designationMasterList;
    }

    public Long getDesignationId() {
        return this.designationId;
    }

    public void setDesignationId(Long designationId) {
        this.designationId = designationId;
    }

    public List<User> getUserList() {
        return this.userList;
    }

    public String getReturnStream() {
        return this.returnStream;
    }

    public void setReturnStream(String returnStream) {
        this.returnStream = returnStream;
    }

    public Integer getPropTypeId() {
        return this.propTypeId;
    }

    public void setPropTypeId(Integer propTypeId) {
        this.propTypeId = propTypeId;
    }

    public List<PropertyUsage> getPropUsageList() {
        return this.propUsageList;
    }

    public void setPropUsageList(List<PropertyUsage> propUsageList) {
        this.propUsageList = propUsageList;
    }

    public Map<String, String> getPropTypeCategoryMap() {
        return this.propTypeCategoryMap;
    }

    public void setPropTypeCategoryMap(Map<String, String> propTypeCategoryMap) {
        this.propTypeCategoryMap = propTypeCategoryMap;
    }

    public Date getCompletionOccupationDate() {
        return this.completionOccupationDate;
    }

    public void setCompletionOccupationDate(Date completionOccupationDate) {
        this.completionOccupationDate = completionOccupationDate;
    }

    public List<StructureClassification> getStructuralClassifications() {
        return this.structuralClassifications;
    }

    public void setStructuralClassifications(List<StructureClassification> structuralClassifications) {
        this.structuralClassifications = structuralClassifications;
    }

    public List<String> getPartNumbers() {
        return this.partNumbers;
    }

    public void setPartNumbers(List<String> partNumbers) {
        this.partNumbers = partNumbers;
    }

    public Long getLocality() {
        return this.locality;
    }

    public void setLocality(Long locality) {
        this.locality = locality;
    }

    public void setServletResponse(HttpServletResponse httpServletResponse) {
        this.response = httpServletResponse;
    }

    public DesignationService getDesignationService() {
        return this.designationService;
    }

    public void setDesignationService(DesignationService designationService) {
        this.designationService = designationService;
    }

    public AssignmentService getAssignmentService() {
        return this.assignmentService;
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public List<Assignment> getAssignmentList() {
        return this.assignmentList;
    }

    public void setAssignmentList(List<Assignment> assignmentList) {
        this.assignmentList = assignmentList;
    }

    public void setSecurityUtils(SecurityUtils securityUtils) {
        this.securityUtils = securityUtils;
    }

    public String getCurrentStatusCode() {
        return this.currentStatusCode;
    }

    public void setCurrentStatusCode(String currentStatusCode) {
        this.currentStatusCode = currentStatusCode;
    }

    public List<Boundary> getAreaList() {
        return this.areaList;
    }

    public void setAreaList(List<Boundary> areaList) {
        this.areaList = areaList;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getCategoryExists() {
        return this.categoryExists;
    }

    public void setCategoryExists(String categoryExists) {
        this.categoryExists = categoryExists;
    }

    public Long getUsageId() {
        return this.usageId;
    }

    public void setUsageId(Long usageId) {
        this.usageId = usageId;
    }

    public Long getStructureClassId() {
        return this.structureClassId;
    }

    public void setStructureClassId(Long structureClassId) {
        this.structureClassId = structureClassId;
    }

    public Date getCategoryFromDate() {
        return this.categoryFromDate;
    }

    public void setCategoryFromDate(Date categoryFromDate) {
        this.categoryFromDate = categoryFromDate;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    public String getPropTypeCategory() {
        return this.propTypeCategory;
    }

    public void setPropTypeCategory(String propTypeCategory) {
        this.propTypeCategory = propTypeCategory;
    }

    public void setCategoryDAO(CategoryDao categoryDAO) {
        this.categoryDAO = categoryDAO;
    }

    public void setBoundaryService(BoundaryService boundaryService) {
        this.boundaryService = boundaryService;
    }

    public String getAssessmentNo() {
        return this.assessmentNo;
    }

    public void setAssessmentNo(String assessmentNo) {
        this.assessmentNo = assessmentNo;
    }

    public BigDecimal getPartyValue() {
        return this.partyValue;
    }

    public void setPartyValue(BigDecimal partyValue) {
        this.partyValue = partyValue;
    }

    public BigDecimal getDepartmentValue() {
        return this.departmentValue;
    }

    public void setDepartmentValue(BigDecimal departmentValue) {
        this.departmentValue = departmentValue;
    }

    public BigDecimal getMutationFee() {
        return this.mutationFee;
    }

    public void setMutationFee(BigDecimal mutationFee) {
        this.mutationFee = mutationFee;
    }

    public List<PropertyDepartment> getPropertyDepartmentList() {
        return this.propertyDepartmentList;
    }

    public void setPropertyDepartmentList(List<PropertyDepartment> propertyDepartmentList) {
        this.propertyDepartmentList = propertyDepartmentList;
    }

    public List<DocumentType> getAssessmentDocumentList() {
        return this.assessmentDocumentList;
    }

    public void setAssessmentDocumentList(List<DocumentType> assessmentDocumentList) {
        this.assessmentDocumentList = assessmentDocumentList;
    }

    public String getAssessmentDocumentType() {
        return this.assessmentDocumentType;
    }

    public void setAssessmentDocumentType(String assessmentDocumentType) {
        this.assessmentDocumentType = assessmentDocumentType;
    }

    public User getDefaultCitizen() {
        return this.defaultCitizen;
    }

    public void setDefaultCitizen(User defaultCitizen) {
        this.defaultCitizen = defaultCitizen;
    }

    public BigDecimal getExtentOfSite() {
        return this.extentOfSite;
    }

    public void setExtentOfSite(BigDecimal extentOfSite) {
        this.extentOfSite = extentOfSite;
    }

    public BigDecimal getPlingthArea() {
        return this.plingthArea;
    }

    public void setPlingthArea(BigDecimal plingthArea) {
        this.plingthArea = plingthArea;
    }
}

