/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.vacancyremission;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.entity.property.VacancyRemissionApproval;
import org.egov.ptis.domain.entity.property.VacancyRemissionDetails;
import org.egov.ptis.domain.service.property.VacancyRemissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/vacancyremissionapproval/create/{assessmentNo}"})
public class VacanyRemissionApprovalController
extends GenericWorkFlowController {
    private PropertyTaxUtil propertyTaxUtil;
    private BasicProperty basicProperty;
    private VacancyRemission vacancyRemission;
    private VacancyRemissionApproval vacancyRemissionApproval;
    private VacancyRemissionService vacancyRemissionService;
    private static final String APPROVAL_POS = "approvalPosition";

    @Autowired
    public VacanyRemissionApprovalController(VacancyRemissionService vacancyRemissionService, PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
        this.vacancyRemissionService = vacancyRemissionService;
    }

    @ModelAttribute
    public VacancyRemissionApproval getVacancyRemissionApproval(@PathVariable String assessmentNo) {
        this.vacancyRemissionApproval = new VacancyRemissionApproval();
        this.vacancyRemission = this.vacancyRemissionService.getApprovedVacancyRemissionForProperty(assessmentNo);
        if (this.vacancyRemission != null) {
            this.vacancyRemissionApproval.setVacancyRemission(this.vacancyRemission);
        }
        return this.vacancyRemissionApproval;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newform(Model model, @PathVariable String assessmentNo, HttpServletRequest request) {
        if (this.vacancyRemission != null) {
            this.vacancyRemissionService.addModelAttributes(model, (BasicProperty)this.vacancyRemission.getBasicProperty());
            model.addAttribute("stateType", (Object)this.vacancyRemissionApproval.getClass().getSimpleName());
            this.prepareWorkflow(model, (StateAware)this.vacancyRemissionApproval, new WorkflowContainer());
            model.addAttribute("detailsHistory", (Object)this.vacancyRemissionService.getMonthlyDetailsHistory(this.vacancyRemission));
            if (!this.vacancyRemission.getDocuments().isEmpty()) {
                model.addAttribute("attachedDocuments", (Object)this.vacancyRemission.getDocuments());
            }
        }
        return "vacancyRemissionApproval-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String saveVacancyRemissionApproval(@Valid @ModelAttribute VacancyRemissionApproval vacancyRemissionApproval, BindingResult resultBinder, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam String workFlowAction) {
        if (resultBinder.hasErrors()) {
            if (this.vacancyRemission != null) {
                this.prepareWorkflow(model, (StateAware)vacancyRemissionApproval, new WorkflowContainer());
                model.addAttribute("stateType", (Object)this.vacancyRemission.getClass().getSimpleName());
                this.vacancyRemissionService.addModelAttributes(model, this.basicProperty);
                model.addAttribute("detailsHistory", (Object)this.vacancyRemissionService.getMonthlyDetailsHistory(this.vacancyRemission));
            }
            return "vacancyRemissionApproval-form";
        }
        Long approvalPosition = 0L;
        String approvalComent = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter(APPROVAL_POS) != null && !request.getParameter(APPROVAL_POS).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POS));
        }
        List<VacancyRemissionApproval> remissionApprovalList = new ArrayList<VacancyRemissionApproval>();
        if (this.vacancyRemission.getVacancyRemissionApproval() == null || this.vacancyRemission.getVacancyRemissionApproval().isEmpty()) {
            remissionApprovalList.add(vacancyRemissionApproval);
        } else {
            remissionApprovalList = this.vacancyRemission.getVacancyRemissionApproval();
            remissionApprovalList.add(vacancyRemissionApproval);
        }
        this.vacancyRemission.setVacancyRemissionApproval(remissionApprovalList);
        VacancyRemissionDetails remissionDetails = new VacancyRemissionDetails();
        remissionDetails.setComments(vacancyRemissionApproval.getComments());
        remissionDetails.setCheckinDate(new Date());
        remissionDetails.setVacancyRemission(this.vacancyRemission);
        this.vacancyRemission.getVacancyRemissionDetails().add(remissionDetails);
        vacancyRemissionApproval.setCheckinDate(new Date());
        this.vacancyRemissionService.saveVacancyRemissionApproval(vacancyRemissionApproval, approvalPosition, approvalComent, null, workFlowAction);
        String successMsg = "Vacancy Remission Final Approval saved and forwarded to : " + this.propertyTaxUtil.getApproverUserName(approvalPosition);
        model.addAttribute("successMessage", (Object)successMsg);
        return "vacancyRemission-success";
    }
}

