/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.vacancyremission;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.property.VacancyRemissionService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/vacancyremission"})
public class UpdateVacancyRemissionController
extends GenericWorkFlowController {
    private static final String VACANCYREMISSION_EDIT = "vacancyRemission-edit";
    private static final String VACANCYREMISSION_SUCCESS = "vacancyRemission-success";
    private static final String APPROVAL_POS = "approvalPosition";
    private final VacancyRemissionService vacancyRemissionService;
    private final PropertyTaxUtil propertyTaxUtil;
    private static final String PROPERTY_MODIFY_REJECT_FAILURE = "Initiator is not active so can not do rejection with the Assessment number :";
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;

    @Autowired
    public UpdateVacancyRemissionController(VacancyRemissionService vacancyRemissionService, PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
        this.vacancyRemissionService = vacancyRemissionService;
    }

    @ModelAttribute
    public VacancyRemission vacancyRemissionModel(@PathVariable Long id) {
        return this.vacancyRemissionService.getVacancyRemissionById(id);
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable Long id, HttpServletRequest request) {
        VacancyRemission vacancyRemission = this.vacancyRemissionService.getVacancyRemissionById(id);
        String userDesignationList = this.propertyTaxCommonUtils.getAllDesignationsForUser(this.securityUtils.getCurrentUser().getId());
        if (vacancyRemission != null) {
            model.addAttribute("stateType", (Object)vacancyRemission.getClass().getSimpleName());
            model.addAttribute("currentState", (Object)vacancyRemission.getCurrentState().getValue());
            if (!vacancyRemission.getDocuments().isEmpty()) {
                model.addAttribute("attachedDocuments", (Object)vacancyRemission.getDocuments());
            }
            model.addAttribute("userDesignationList", (Object)userDesignationList);
            model.addAttribute("designation", (Object)"Commissioner");
            this.prepareWorkflow(model, (StateAware)vacancyRemission, new WorkflowContainer());
            BasicPropertyImpl basicProperty = vacancyRemission.getBasicProperty();
            this.vacancyRemissionService.addModelAttributes(model, (BasicProperty)basicProperty);
        }
        return VACANCYREMISSION_EDIT;
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute VacancyRemission vacancyRemission, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model) {
        String senderName = vacancyRemission.getCurrentState().getSenderName();
        this.assignmentService.getPrimaryAssignmentForUser(this.securityUtils.getCurrentUser().getId());
        senderName = senderName.substring(senderName.lastIndexOf(":") + 1);
        if (!resultBinder.hasErrors()) {
            String workFlowAction = "";
            if (request.getParameter("workFlowAction") != null) {
                workFlowAction = request.getParameter("workFlowAction");
            }
            Long approvalPosition = 0L;
            String approvalComent = "";
            String successMsg = "";
            if (request.getParameter("approvalComent") != null) {
                approvalComent = request.getParameter("approvalComent");
            }
            if (request.getParameter(APPROVAL_POS) != null && !request.getParameter(APPROVAL_POS).isEmpty()) {
                approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POS));
            } else if (vacancyRemission.getCurrentState().getValue().endsWith("Assistant Forwarded") && workFlowAction.equalsIgnoreCase("Forward")) {
                approvalPosition = vacancyRemission.getState().getInitiatorPosition().getId();
            }
            Boolean propertyByEmployee = Boolean.valueOf(request.getParameter("propertyByEmployee"));
            if (!this.isWfReject(workFlowAction)) {
                this.vacancyRemissionService.saveVacancyRemission(vacancyRemission, approvalPosition, approvalComent, null, workFlowAction, propertyByEmployee);
            }
            if (this.isWfNotNoticeGen(workFlowAction)) {
                successMsg = this.isWfApprove(workFlowAction) ? "Vacancy Remission Approved Successfully in the System" : (this.isWfReject(workFlowAction) ? this.wfReject(vacancyRemission, workFlowAction, approvalPosition, approvalComent, propertyByEmployee) : (this.isWfForwardOrApprovalPending(vacancyRemission, workFlowAction) ? "Vacancy Remission Approved successfully and forwarded to : " + this.vacancyRemissionService.getInitiatorName(vacancyRemission) : "Vacancy Remission forwarded to : " + this.propertyTaxUtil.getApproverUserName(approvalPosition) + " with application number : " + vacancyRemission.getApplicationNumber()));
            }
            model.addAttribute("successMessage", (Object)successMsg);
            if (this.isWfNoticeGen(workFlowAction)) {
                String pathVars = vacancyRemission.getBasicProperty().getUpicNo() + "," + senderName;
                return "redirect:/vacancyremission/rejectionacknowledgement?pathVar=" + pathVars;
            }
            return VACANCYREMISSION_SUCCESS;
        }
        this.prepareWorkflow(model, (StateAware)vacancyRemission, new WorkflowContainer());
        BasicPropertyImpl basicProperty = vacancyRemission.getBasicProperty();
        this.vacancyRemissionService.addModelAttributes(model, (BasicProperty)basicProperty);
        return VACANCYREMISSION_EDIT;
    }

    private boolean isWfReject(String workFlowAction) {
        return workFlowAction.equalsIgnoreCase("Reject");
    }

    private boolean isWfApprove(String workFlowAction) {
        return workFlowAction.equalsIgnoreCase("Approve");
    }

    private boolean isWfNotNoticeGen(String workFlowAction) {
        return StringUtils.isNotBlank((String)workFlowAction) && !workFlowAction.equalsIgnoreCase("Generate Notice");
    }

    private boolean isWfNoticeGen(String workFlowAction) {
        return StringUtils.isNotBlank((String)workFlowAction) && workFlowAction.equalsIgnoreCase("Generate Notice");
    }

    private boolean isWfForwardOrApprovalPending(VacancyRemission vacancyRemission, String workFlowAction) {
        return workFlowAction.equalsIgnoreCase("Forward") && vacancyRemission.getCurrentState().getNextAction().equals("Assistant Approval Pending");
    }

    private String wfReject(VacancyRemission vacancyRemission, String workFlowAction, Long approvalPosition, String approvalComent, Boolean propertyByEmployee) {
        String successMsg;
        User user = this.securityUtils.getCurrentUser();
        String loggedInUserDesignation = "";
        if (vacancyRemission.getState() != null) {
            List loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(vacancyRemission.getCurrentState().getOwnerPosition().getId(), user.getId(), new Date());
            loggedInUserDesignation = !loggedInUserAssign.isEmpty() ? ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName() : null;
        }
        Assignment wfInitiator = null;
        List history = vacancyRemission.getStateHistory();
        if (!history.isEmpty() && this.vacancyRemissionService.isRoOrCommissioner(loggedInUserDesignation)) {
            wfInitiator = this.propertyService.getUserOnRejection((StateAware)vacancyRemission);
        } else if (history.isEmpty() || !this.vacancyRemissionService.isRoOrCommissioner(loggedInUserDesignation)) {
            wfInitiator = this.vacancyRemissionService.getWorkflowInitiator(vacancyRemission);
        }
        if (wfInitiator != null) {
            successMsg = "Vacancy Remission rejected successfully and forwarded to : " + this.vacancyRemissionService.getInitiatorName(vacancyRemission);
            this.vacancyRemissionService.saveVacancyRemission(vacancyRemission, approvalPosition, approvalComent, null, workFlowAction, propertyByEmployee);
        } else {
            successMsg = PROPERTY_MODIFY_REJECT_FAILURE + vacancyRemission.getBasicProperty().getUpicNo();
        }
        return successMsg;
    }
}

