/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.masters.taxrates;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.demand.bean.DemandReasonDetailsBean;
import org.egov.demand.model.EgDemandReasonDetails;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.ptis.master.service.TaxRatesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/taxrates"})
public class TaxRatesController {
    private final TaxRatesService taxRatesService;
    private static final String TAXRATE_VIEW = "taxRates-view";
    private static final String TAXRATE_EDIT = "taxrates-edit";
    private static final String GENERAL_TAX_RESD = "GEN_TAX_RESD";
    private static final String GENERAL_TAX_NONRESD = "GEN_TAX_NR";
    private static final String EDUCATIONAL_TAX = "EDU_CESS";
    private static final String REDIRECT_URL = "redirect:/taxrates/appconfig/edit";
    private static final String REDIRECT_VIEW_URL = "redirect:/taxrates/appconfig/view";
    private static final String MESSAGE = "message";
    private static final String TOTAL_TAX_RESD = "TOT_RESD_TAX";
    private static final String TOTAL_TAX_NONRESD = "TOT_NR_RESD_TAX";
    private static final String TAX_RATES_FORM = "taxRatesForm";

    @Autowired
    public TaxRatesController(TaxRatesService taxRatesService) {
        this.taxRatesService = taxRatesService;
    }

    @ModelAttribute
    public AppConfigValues taxRatesModel() {
        return new AppConfigValues();
    }

    @RequestMapping(value={"/appconfig/view"}, method={RequestMethod.GET})
    public String showAppConfigTaxRates(Model model) {
        Map taxRatesMap = this.taxRatesService.getTaxDetails();
        model.addAttribute("taxRates", (Object)taxRatesMap);
        return TAXRATE_VIEW;
    }

    @RequestMapping(value={"/appconfig/edit"}, method={RequestMethod.GET})
    public String viewTaxRates(Model model) {
        Map taxRatesMap = this.taxRatesService.getTaxDetails();
        model.addAttribute("taxRates", (Object)taxRatesMap);
        return TAXRATE_EDIT;
    }

    @RequestMapping(value={"/appconfig/edit"}, method={RequestMethod.POST})
    public String saveAppConfigTaxRates(@ModelAttribute DemandReasonDetailsBean taxRatesForm, Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String resTaxValue = request.getParameter("General Tax Residential-value");
        String nonResTaxValue = request.getParameter("General Tax Non Residential-value");
        String eduTax = request.getParameter("Education Cess-value");
        if (StringUtils.isNotBlank((CharSequence)resTaxValue) && StringUtils.isNotBlank((CharSequence)nonResTaxValue) && StringUtils.isNotBlank((CharSequence)eduTax) && this.validateTaxValues(resTaxValue, nonResTaxValue, eduTax).booleanValue()) {
            String[] rows;
            StringBuilder newTaxStr = new StringBuilder();
            AppConfigValues appConfigValue = (AppConfigValues)this.taxRatesService.getAllTaxRates().get(0);
            for (String row : rows = appConfigValue.getValue().split("\n")) {
                String[] value = row.split("=");
                if (GENERAL_TAX_RESD.equalsIgnoreCase(value[0])) {
                    newTaxStr.append("GEN_TAX_RESD=" + resTaxValue + "\n");
                    continue;
                }
                if (GENERAL_TAX_NONRESD.equalsIgnoreCase(value[0])) {
                    newTaxStr.append("GEN_TAX_NR=" + nonResTaxValue + "\n");
                    continue;
                }
                if (EDUCATIONAL_TAX.equalsIgnoreCase(value[0])) {
                    newTaxStr.append("EDU_CESS=" + eduTax + "\n");
                    continue;
                }
                newTaxStr.append(rows[rows.length - 1] == row ? value[0] + "=" + value[1] : value[0] + "=" + value[1] + "\n");
            }
            if (StringUtils.isNotBlank((CharSequence)newTaxStr)) {
                appConfigValue.setValue(newTaxStr.toString());
                this.taxRatesService.updateTaxRateAppconfig(appConfigValue);
                redirectAttributes.addFlashAttribute(MESSAGE, (Object)"msg.update.taxrates");
            }
            return REDIRECT_VIEW_URL;
        }
        redirectAttributes.addFlashAttribute(MESSAGE, (Object)"msg.taxrate.invalid");
        return REDIRECT_URL;
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String showTaxRates(Model model) {
        DemandReasonDetailsBean taxRatesForm = new DemandReasonDetailsBean();
        taxRatesForm.setDemandReasonDetails(this.taxRatesService.getTaxRates());
        model.addAttribute(TAX_RATES_FORM, (Object)taxRatesForm);
        return "taxrates-view";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String taxRatesEditView(Model model) {
        DemandReasonDetailsBean taxRatesForm = new DemandReasonDetailsBean();
        List egDemandReasonDetails = this.taxRatesService.getTaxRates();
        taxRatesForm.setDemandReasonDetails(this.taxRatesService.excludeOldTaxHeads(egDemandReasonDetails));
        model.addAttribute(TAX_RATES_FORM, (Object)taxRatesForm);
        this.addTotalTaxHeadsToModel(model);
        return "taxrates-editview";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public String saveTaxRates(@ModelAttribute DemandReasonDetailsBean taxRatesForm, Model model, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        if (!this.validate(taxRatesForm, model, request).booleanValue()) {
            return "taxrates-editview";
        }
        for (EgDemandReasonDetails egDemandReasonDetail : taxRatesForm.getDemandReasonDetails()) {
            EgDemandReasonDetails existingDemandReasonDetails = this.taxRatesService.getDemandReasonDetailsById(egDemandReasonDetail.getId());
            existingDemandReasonDetails.setPercentage(egDemandReasonDetail.getPercentage());
            this.taxRatesService.updateTaxRates(existingDemandReasonDetails);
        }
        redirectAttributes.addFlashAttribute(MESSAGE, (Object)"msg.update.taxrates");
        return "redirect:/taxrates/view";
    }

    private Boolean validateTaxValues(String newRsdTax, String newNonRsdTax, String newEduTax) {
        String[] rows;
        boolean isValid = true;
        AppConfigValues appConfigValue = (AppConfigValues)this.taxRatesService.getAllTaxRates().get(0);
        for (String row : rows = appConfigValue.getValue().split("\n")) {
            String[] value = row.split("=");
            if (!(GENERAL_TAX_RESD.equalsIgnoreCase(value[0]) && new BigDecimal(newRsdTax).compareTo(new BigDecimal(value[1])) < 0 || GENERAL_TAX_NONRESD.equalsIgnoreCase(value[0]) && new BigDecimal(newNonRsdTax).compareTo(new BigDecimal(value[1])) < 0) && (!EDUCATIONAL_TAX.equalsIgnoreCase(value[0]) || new BigDecimal(newEduTax).compareTo(new BigDecimal(value[1])) >= 0)) continue;
            isValid = false;
        }
        return isValid;
    }

    private Boolean validate(DemandReasonDetailsBean taxRatesForm, Model model, HttpServletRequest request) {
        BigDecimal netResdPercentage = BigDecimal.ZERO;
        BigDecimal netNonResdPercentage = BigDecimal.ZERO;
        BigDecimal generalTaxNr = BigDecimal.ZERO;
        BigDecimal generalTaxResd = BigDecimal.ZERO;
        BigDecimal netOtherTaxPercentage = BigDecimal.ZERO;
        ArrayList<EgDemandReasonDetails> updatedTaxRatesForm = new ArrayList<EgDemandReasonDetails>();
        for (EgDemandReasonDetails egDemandReasonDetail : taxRatesForm.getDemandReasonDetails()) {
            EgDemandReasonDetails existingDemandReasonDetails = this.taxRatesService.getDemandReasonDetailsById(egDemandReasonDetail.getId());
            existingDemandReasonDetails.setPercentage(egDemandReasonDetail.getPercentage());
            updatedTaxRatesForm.add(existingDemandReasonDetails);
            if (!(existingDemandReasonDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equals(GENERAL_TAX_RESD) || existingDemandReasonDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equals(GENERAL_TAX_NONRESD) || existingDemandReasonDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equals(EDUCATIONAL_TAX))) {
                netOtherTaxPercentage = netOtherTaxPercentage.add(existingDemandReasonDetails.getPercentage());
                continue;
            }
            if (existingDemandReasonDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equals(GENERAL_TAX_RESD)) {
                generalTaxResd = existingDemandReasonDetails.getPercentage();
                continue;
            }
            if (!existingDemandReasonDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equals(GENERAL_TAX_NONRESD)) continue;
            generalTaxNr = existingDemandReasonDetails.getPercentage();
        }
        netResdPercentage = netResdPercentage.add(generalTaxResd).add(netOtherTaxPercentage);
        netNonResdPercentage = netNonResdPercentage.add(generalTaxNr).add(netOtherTaxPercentage);
        if (new BigDecimal(request.getParameter("genTaxResd")).compareTo(netResdPercentage) != 0) {
            taxRatesForm.setDemandReasonDetails(updatedTaxRatesForm);
            model.addAttribute(MESSAGE, (Object)"msg.taxrate.resd.valid");
            model.addAttribute(TAX_RATES_FORM, (Object)taxRatesForm);
            this.addTotalTaxHeadsToModel(model);
            return false;
        }
        if (new BigDecimal(request.getParameter("genTaxNonResd")).compareTo(netNonResdPercentage) != 0) {
            taxRatesForm.setDemandReasonDetails(updatedTaxRatesForm);
            model.addAttribute(MESSAGE, (Object)"msg.taxrate.nresd.valid");
            model.addAttribute(TAX_RATES_FORM, (Object)taxRatesForm);
            this.addTotalTaxHeadsToModel(model);
            return false;
        }
        return true;
    }

    private void addTotalTaxHeadsToModel(Model model) {
        for (EgDemandReasonDetails drd : this.taxRatesService.getTaxRates()) {
            if (drd.getEgDemandReason().getEgDemandReasonMaster().getCode().equals(TOTAL_TAX_RESD)) {
                model.addAttribute("genTaxResd", (Object)drd.getPercentage().setScale(2, 2));
            }
            if (!drd.getEgDemandReason().getEgDemandReasonMaster().getCode().equals(TOTAL_TAX_NONRESD)) continue;
            model.addAttribute("genTaxNonResd", (Object)drd.getPercentage().setScale(2, 2));
        }
    }
}

