/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.egov.infra.persistence.entity.Address;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.AmalgamatedPropInfo;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.master.service.PropertyUsageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/common"})
public class AjaxCommonController {
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PropertyService propService;
    @Autowired
    private PropertyUsageService propertyUsageService;

    @RequestMapping(value={"/amalgamation/getamalgamatedpropdetails"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public AmalgamatedPropInfo getAmalgamatedPropertyDetails(@RequestParam(value="assessmentNo") String assessmentNo) {
        BigDecimal totalDue;
        boolean hasDues;
        AmalgamatedPropInfo amalgamatedProp = new AmalgamatedPropInfo();
        amalgamatedProp.setValidationMsg("");
        BasicProperty basicProp = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        if (basicProp.isUnderWorkflow()) {
            amalgamatedProp.setValidationMsg("Assessment: " + basicProp.getUpicNo() + " is under workflow!");
        }
        if (!basicProp.isActive().booleanValue()) {
            amalgamatedProp.setValidationMsg("Assessment: " + basicProp.getUpicNo() + " is deactivated!");
        }
        boolean bl = hasDues = (totalDue = this.propService.getTotalPropertyTaxDue(basicProp)).compareTo(BigDecimal.ZERO) > 0;
        if (hasDues) {
            amalgamatedProp.setValidationMsg("This property has dues!");
        } else {
            for (PropertyOwnerInfo propOwner : basicProp.getPropertyOwnerInfo()) {
                List addrSet = propOwner.getOwner().getAddress();
                Iterator iterator = addrSet.iterator();
                if (!iterator.hasNext()) continue;
                Address address = (Address)iterator.next();
                amalgamatedProp.setAssessmentNo(assessmentNo);
                amalgamatedProp.setOwnerName(propOwner.getOwner().getName());
                amalgamatedProp.setMobileNo(propOwner.getOwner().getMobileNumber());
                amalgamatedProp.setPropertyAddress(address.toString());
                amalgamatedProp.setPaymentDone(totalDue.compareTo(BigDecimal.ZERO) == 0);
            }
        }
        return amalgamatedProp;
    }

    @RequestMapping(value={"/getusagebypropertytype"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<PropertyUsage> getUsageByPropertyType(@RequestParam(value="propTypeCategory") String propTypeCategory) {
        List propUsageList = new ArrayList();
        if (propTypeCategory.equals("MIXED")) {
            propUsageList = this.propertyUsageService.getAllActivePropertyUsages();
        } else if (propTypeCategory.equals("RESIDENTIAl")) {
            propUsageList = this.propertyUsageService.getResidentialPropertyUsages();
        } else if (propTypeCategory.equals("NON_RESIDENTIAL")) {
            propUsageList = this.propertyUsageService.getNonResidentialPropertyUsages();
        }
        return propUsageList;
    }
}

