/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.view;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.service.transfer.PropertyTransferService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
@Results(value={@Result(name={"view"}, location="viewProperty-view.jsp")})
public class ViewPropertyAction
extends BaseFormAction {
    private static final long serialVersionUID = 4609817011534083012L;
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private String propertyId;
    private BasicProperty basicProperty;
    private PropertyImpl property;
    private String ownerAddress;
    private Map<String, Object> viewMap;
    private PropertyTaxUtil propertyTaxUtil;
    private String roleName;
    private boolean isDemandActive;
    private String applicationNo;
    private String applicationType;
    private String[] floorNoStr = new String[100];
    private String errorMessage;
    private String isCitizen;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private UserService UserService;
    @Autowired
    private PersistenceService<Property, Long> propertyImplService;
    @Autowired
    private PersistenceService<RevisionPetition, Long> revisionPetitionPersistenceService;
    @Autowired
    @Qualifier(value="transferOwnerService")
    private PropertyTransferService transferOwnerService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    private boolean isNagarPanchayat = false;
    private Map<String, Map<String, BigDecimal>> demandCollMap = new TreeMap();

    public StateAware getModel() {
        return this.property;
    }

    @Action(value="/view/viewProperty-viewForm")
    public String viewForm() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into viewForm method, propertyId : " + this.propertyId));
        }
        try {
            Long userId;
            Ptdemand ptDemand;
            this.viewMap = new HashMap();
            if (this.propertyId != null && !this.propertyId.isEmpty()) {
                this.setBasicProperty(this.basicPropertyDAO.getBasicPropertyByPropertyID(this.propertyId));
            } else if (this.applicationNo != null && !this.applicationNo.isEmpty()) {
                this.getBasicPropForAppNo(this.applicationNo, this.applicationType);
                this.setPropertyId(this.basicProperty.getUpicNo());
            }
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)("viewForm : BasicProperty : " + this.basicProperty));
            }
            if (this.property == null) {
                this.property = (PropertyImpl)this.getBasicProperty().getProperty();
            }
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)("viewForm : Property : " + this.property));
            }
            if ((ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)this.property)) == null) {
                this.setErrorMessage("No Tax details for current Demand period.");
                return "view";
            }
            if (this.property.getPropertyDetail().getFloorDetails().size() > 0) {
                this.setFloorDetails((Property)this.property);
            }
            this.checkIsDemandActive((Property)this.property);
            if (this.getBasicProperty().getPropertyOwnerInfo() != null && !this.getBasicProperty().getPropertyOwnerInfo().isEmpty()) {
                for (PropertyOwnerInfo propertyOwnerInfo : this.getBasicProperty().getPropertyOwnerInfo()) {
                    List addrSet = propertyOwnerInfo.getOwner().getAddress();
                    Iterator iterator = addrSet.iterator();
                    if (!iterator.hasNext()) continue;
                    Address address = (Address)iterator.next();
                    this.ownerAddress = address.toString();
                    this.viewMap.put("doorNo", address.getHouseNoBldgApt() == null ? "N/A" : address.getHouseNoBldgApt());
                }
                this.viewMap.put("ownerAddress", this.ownerAddress == null ? "N/A" : this.ownerAddress);
                this.viewMap.put("ownershipType", this.basicProperty.getProperty() != null ? this.basicProperty.getProperty().getPropertyDetail().getPropertyTypeMaster().getType() : this.property.getPropertyDetail().getPropertyTypeMaster().getType());
            }
            if (!this.property.getIsExemptedFromTax().booleanValue()) {
                this.demandCollMap = this.propertyTaxUtil.prepareDemandDetForView((Property)this.property, this.propertyTaxCommonUtils.getCurrentInstallment());
                for (Map.Entry entry : this.demandCollMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Map reasonDmd = (Map)entry.getValue();
                    if (key.equals("Current 1st Half")) {
                        this.viewMap.put("firstHalf", "Current 1st Half");
                        this.viewMap.put("firstHalfGT", reasonDmd.get("General Tax") != null ? reasonDmd.get("General Tax") : reasonDmd.get("Vacant Land Tax"));
                        this.viewMap.put("firstHalfEC", reasonDmd.get("Education Cess") != null ? reasonDmd.get("Education Cess") : BigDecimal.ZERO);
                        this.viewMap.put("firstHalfLC", reasonDmd.get("Library Cess"));
                        this.viewMap.put("firstHalfUAP", reasonDmd.get("Unauthorized Penalty") != null ? reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO);
                        this.viewMap.put("firstHalfTotal", reasonDmd.get("CURR_FIRSTHALF_DMD"));
                        this.viewMap.put("firstHalfTaxDue", ((BigDecimal)reasonDmd.get("CURR_FIRSTHALF_DMD")).subtract((BigDecimal)reasonDmd.get("CURR_FIRSTHALF_COLL")));
                        continue;
                    }
                    if (key.equals("Current 2nd Half")) {
                        this.viewMap.put("secondHalf", "Current 2nd Half");
                        this.viewMap.put("secondHalfGT", reasonDmd.get("General Tax") != null ? reasonDmd.get("General Tax") : reasonDmd.get("Vacant Land Tax"));
                        this.viewMap.put("secondHalfEC", reasonDmd.get("Education Cess") != null ? reasonDmd.get("Education Cess") : BigDecimal.ZERO);
                        this.viewMap.put("secondHalfLC", reasonDmd.get("Library Cess"));
                        this.viewMap.put("secondHalfUAP", reasonDmd.get("Unauthorized Penalty") != null ? reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO);
                        this.viewMap.put("secondHalfTotal", reasonDmd.get("CURR_SECONDHALF_DMD"));
                        this.viewMap.put("secondHalfTaxDue", ((BigDecimal)reasonDmd.get("CURR_SECONDHALF_DMD")).subtract((BigDecimal)reasonDmd.get("CURR_SECONDHALF_COLL")));
                        continue;
                    }
                    this.viewMap.put("arrears", "Arrears");
                    this.viewMap.put("arrearTax", reasonDmd.get("ARR_DMD"));
                    this.viewMap.put("totalArrDue", ((BigDecimal)reasonDmd.get("ARR_DMD")).subtract((BigDecimal)reasonDmd.get("ARR_COLL")));
                }
            }
            if (ptDemand.getDmdCalculations() != null && ptDemand.getDmdCalculations().getAlv() != null) {
                this.viewMap.put("ARV", ptDemand.getDmdCalculations().getAlv());
            } else {
                this.viewMap.put("ARV", BigDecimal.ZERO);
            }
            this.propertyTaxUtil.setPersistenceService(this.persistenceService);
            if (null != this.basicProperty.getUpicNo()) {
                this.viewMap.put("enableVacancyRemission", this.propertyTaxUtil.enableVacancyRemission(this.basicProperty.getUpicNo()));
                this.viewMap.put("enableMonthlyUpdate", this.propertyTaxUtil.enableMonthlyUpdate(this.basicProperty.getUpicNo()));
            }
            if ((userId = (Long)this.session().get("userid")) != null) {
                this.setRoleName(this.getRolesForUserId(userId));
            }
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)("viewForm : viewMap : " + this.viewMap));
                this.LOGGER.debug((Object)"Exit from method viewForm");
            }
            return "view";
        }
        catch (Exception e) {
            this.LOGGER.error((Object)"Exception in View Property: ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception in View Property : " + e);
        }
    }

    private void checkIsDemandActive(Property property) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into checkIsDemandActive");
        }
        this.isDemandActive = !property.getStatus().equals(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("checkIsDemandActive - Is demand active? : " + this.isDemandActive));
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exiting from checkIsDemandActive");
        }
    }

    private String getRolesForUserId(Long userId) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into method getRolesForUserId");
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("User id : " + userId));
        }
        ArrayList<String> roleNameList = new ArrayList<String>();
        User user = this.UserService.getUserById(userId);
        for (Role role : user.getRoles()) {
            String roleName = role.getName() != null ? role.getName() : "";
            roleNameList.add(roleName);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Exit from method getRolesForUserId with return value : " + ((Object)roleNameList).toString().toUpperCase()));
        }
        return ((Object)roleNameList).toString().toUpperCase();
    }

    private void getBasicPropForAppNo(String appNo, String appType) {
        if (appType != null && !appType.isEmpty()) {
            if (appType.equalsIgnoreCase("New_Assessment") || appType.equalsIgnoreCase("Alter_Assessment") || appType.equalsIgnoreCase("Bifuracate_Assessment")) {
                this.property = (PropertyImpl)this.propertyImplService.find("from PropertyImpl where applicationNo=?", new Object[]{appNo});
                this.setBasicProperty(this.property.getBasicProperty());
            } else if (appType.equalsIgnoreCase("Revision_Petition")) {
                RevisionPetition rp = (RevisionPetition)this.revisionPetitionPersistenceService.find("from RevisionPetition where objectionNumber=?", new Object[]{appNo});
                this.setBasicProperty(rp.getBasicProperty());
            } else if (appType.equals("Transfer_of_Ownership")) {
                PropertyMutation propertyMutation = this.transferOwnerService.getPropertyMutationByApplicationNo(appNo);
                this.setBasicProperty(propertyMutation.getBasicProperty());
            }
        }
    }

    public void setFloorDetails(Property property) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("Entered into setFloorDetails, Property: " + property));
        }
        List floors = property.getPropertyDetail().getFloorDetails();
        property.getPropertyDetail().setFloorDetailsProxy(floors);
        int i = 0;
        for (Floor flr : floors) {
            this.floorNoStr[i] = (String)PropertyTaxConstants.FLOOR_MAP.get(flr.getFloorNo());
            ++i;
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exiting from setFloorDetails: ");
        }
    }

    public String getFloorNoStr(Integer floorNo) {
        return (String)PropertyTaxConstants.FLOOR_MAP.get(floorNo);
    }

    public List<Floor> getFloorDetails() {
        return new ArrayList<Floor>(this.property.getPropertyDetail().getFloorDetails());
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public PropertyTaxUtil getPropertyTaxUtil() {
        return this.propertyTaxUtil;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public Map<String, Object> getViewMap() {
        return this.viewMap;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public boolean getIsDemandActive() {
        return this.isDemandActive;
    }

    public void setIsDemandActive(boolean isDemandActive) {
        this.isDemandActive = isDemandActive;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setBasicPropertyDAO(BasicPropertyDAO basicPropertyDAO) {
        this.basicPropertyDAO = basicPropertyDAO;
    }

    public void setPtDemandDAO(PtDemandDao ptDemandDAO) {
        this.ptDemandDAO = ptDemandDAO;
    }

    public void setUserService(UserService userService) {
        this.UserService = userService;
    }

    public String getApplicationNo() {
        return this.applicationNo;
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String[] getFloorNoStr() {
        return this.floorNoStr;
    }

    public void setFloorNoStr(String[] floorNoStr) {
        this.floorNoStr = floorNoStr;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean getIsNagarPanchayat() {
        return this.propertyTaxUtil.checkIsNagarPanchayat();
    }

    public void setIsNagarPanchayat(boolean isNagarPanchayat) {
        this.isNagarPanchayat = isNagarPanchayat;
    }

    public Map<String, Map<String, BigDecimal>> getDemandCollMap() {
        return this.demandCollMap;
    }

    public void setDemandCollMap(Map<String, Map<String, BigDecimal>> demandCollMap) {
        this.demandCollMap = demandCollMap;
    }

    public String getIsCitizen() {
        return this.isCitizen;
    }

    public void setIsCitizen(String isCitizen) {
        this.isCitizen = isCitizen;
    }

    public PropertyTaxCommonUtils getPropertyTaxCommonUtils() {
        return this.propertyTaxCommonUtils;
    }

    public void setPropertyTaxCommonUtils(PropertyTaxCommonUtils propertyTaxCommonUtils) {
        this.propertyTaxCommonUtils = propertyTaxCommonUtils;
    }
}

