/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.ResultPath;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.ptis.bean.CollectionInfo;
import org.egov.ptis.bean.ReceiptInfo;
import org.egov.ptis.bean.TaxCollectionInfo;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.hibernate.Query;
import org.hibernate.criterion.CriteriaSpecification;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@ResultPath(value="/WEB-INF/jsp/")
@Namespace(value="/reports")
@Results(value={@Result(name={"new"}, location="reports/dailyCollectionReport-new.jsp")})
public class DailyCollectionReportAction
extends BaseFormAction {
    private static final Logger LOGGER = Logger.getLogger(DailyCollectionReportAction.class);
    private static final String PAYMENT_MODE_CHEQUE = "cheque";
    private static final String PAYMENT_MODE_CASH = "cash";
    private static final String TOTAL_BY_CHEQUE = "Total By Cheque";
    private static final String TOTAL_BY_CASH = "Total By Cash";
    private static final String TOTAL = "Total";
    private static final long serialVersionUID = 1L;
    private String REPORT = "report";
    private String CURRENT = "Current";
    private String ARREAR = "Arrears";
    private String REBATE = "Rebate";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    private ReportService reportService;
    private String reportId;
    ReceiptInfo totalRcptInfo = new ReceiptInfo();
    ReceiptInfo totalCashRcptInfo = new ReceiptInfo();
    ReceiptInfo totalChequeRcptInfo = new ReceiptInfo();
    TaxCollectionInfo arrTotalCollInfo = new TaxCollectionInfo();
    TaxCollectionInfo currTotalCollInfo = new TaxCollectionInfo();
    TaxCollectionInfo rebateTotalCollInfo = new TaxCollectionInfo();
    TaxCollectionInfo arrTotalCashCollInfo = new TaxCollectionInfo();
    TaxCollectionInfo currTotalCashCollInfo = new TaxCollectionInfo();
    TaxCollectionInfo rebateTotalCashCollInfo = new TaxCollectionInfo();
    TaxCollectionInfo arrTotalChequeCollInfo = new TaxCollectionInfo();
    TaxCollectionInfo currTotalChequeCollInfo = new TaxCollectionInfo();
    TaxCollectionInfo rebateTotalChequeCollInfo = new TaxCollectionInfo();
    BigDecimal totalCashCollAmt = BigDecimal.ZERO;
    BigDecimal totalChequeCollAmt = BigDecimal.ZERO;
    BigDecimal totalOthersCollAmt = BigDecimal.ZERO;
    BigDecimal arrTotalCashCollAmt = BigDecimal.ZERO;
    BigDecimal arrTotalChequeCollAmt = BigDecimal.ZERO;
    BigDecimal currTotalCashCollAmt = BigDecimal.ZERO;
    BigDecimal currTotalChequeCollAmt = BigDecimal.ZERO;
    BigDecimal rebateTotalCashCollAmt = BigDecimal.ZERO;
    BigDecimal rebateTotalChequeCollAmt = BigDecimal.ZERO;
    private Date fromDate;
    private Date toDate;
    DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    PropertyTaxUtil propTaxUtil = new PropertyTaxUtil();
    Boolean searchForm = Boolean.TRUE;
    String currInst = null;
    private String userId;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private InstallmentDao instalDao;
    @Autowired
    private UserService userService;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        LOGGER.debug((Object)"Entered into prepare method");
        Query qry = this.persistenceService.getSession().createQuery("select distinct UI FROM User UI left join UI.roles ur left join ur.role r where r.name = :roleName AND UI.active=1 AND ur.isHistory='N' order by UI.userName");
        qry.setParameter("roleName", (Object)"Operator");
        List userList = qry.list();
        this.addDropdownData("userList", userList);
        LOGGER.debug((Object)"Exited from prepare method");
    }

    @SkipValidation
    @Action(value="/dailyCollectionReport-newForm")
    public String newForm() {
        return "new";
    }

    public void validate() {
        if (this.fromDate == null || this.fromDate.equals("")) {
            this.addActionError(this.getText("mandatory.fromdate"));
        }
        if (this.toDate == null || this.toDate.equals("")) {
            this.addActionError(this.getText("mandatory.todate"));
        }
        if (this.userId == null || this.userId.equals("-1") || this.userId.equals("")) {
            this.addActionError(this.getText("mandatory.todate"));
        }
    }

    @ValidationErrorPage(value="new")
    @Action(value="/dialyCollectionReport-generateReport", results={@Result(name={"new"}, location="/dialyCollectionReport-new.jsp")})
    public String generateReport() {
        LOGGER.debug((Object)"Eneterd into generateReport method");
        Long reportStartTime = System.currentTimeMillis();
        Module module = this.moduleDao.getModuleByName("Property Tax");
        this.currInst = this.instalDao.getInsatllmentByModuleForGivenDate(module, new Date()).getDescription();
        StringBuilder qryString = new StringBuilder("from org.egov.erpcollection.models.ReceiptHeader rh").append(" left join fetch rh.receiptInstrument rcptInst").append(" left join fetch rcptInst.instrumentType").append(" left join fetch rh.receiptDetails").append(" left join fetch rh.receiptPayeeDetails").append(" left join fetch rh.receiptMisc").append(" left join fetch rh.onlinePayment").append(" left join fetch rh.challan").append(" where rh.manualreceiptnumber is null and rh.manualreceiptdate is null").append(" and rh.status.description != 'Cancelled' and rh.service.serviceName = 'Property Tax'").append(" and rh.createdBy.id = :userId").append(" and rh.createdDate >= :fromDate").append(" and rh.createdDate <= :toDate").append(" order by rh.modifiedDate desc");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.toDate);
        calendar.add(5, 1);
        Query qry = this.persistenceService.getSession().createQuery(qryString.toString()).setParameter("fromDate", (Object)this.fromDate).setParameter("toDate", (Object)calendar.getTime()).setParameter("userId", (Object)Integer.valueOf(this.userId)).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        Long qryStartTime = System.currentTimeMillis();
        List rcptHeaderList = qry.list();
        LOGGER.debug((Object)("Main Query took " + (System.currentTimeMillis() - qryStartTime) / 1000L + "sec(s)..!"));
        LOGGER.debug((Object)("Number of records: " + rcptHeaderList.size()));
        if (rcptHeaderList != null && !rcptHeaderList.isEmpty()) {
            Long loopStartTime = System.currentTimeMillis();
            ArrayList<ReceiptInfo> rcptInfoList = new ArrayList<ReceiptInfo>();
            CollectionInfo cashCollInfo = new CollectionInfo();
            this.initializeTotalsInfo();
            for (ReceiptHeader rcptHeader : rcptHeaderList) {
                ReceiptInfo rcptInfo = new ReceiptInfo();
                rcptInfo.setReceiptNo(rcptHeader.getReceiptnumber());
                String indexNo = StringUtils.trim((String)(rcptHeader.getConsumerCode().contains("(") ? rcptHeader.getConsumerCode().substring(0, rcptHeader.getConsumerCode().indexOf(40)) : rcptHeader.getConsumerCode()));
                rcptInfo.setIndexNo(indexNo);
                rcptInfo.setWardNo(rcptHeader.getConsumerCode().substring(rcptHeader.getConsumerCode().lastIndexOf(":") + 1, rcptHeader.getConsumerCode().indexOf(")")));
                StringBuffer payMode = new StringBuffer();
                HashSet<String> paymentModes = new HashSet<String>();
                StringBuffer instrumentDetails = new StringBuffer();
                int i = 1;
                int j = 1;
                for (InstrumentHeader instrumentHead : rcptHeader.getReceiptInstrument()) {
                    if (i > 1) {
                        instrumentDetails.append("|| ");
                    }
                    if (instrumentHead.getInstrumentNumber() != null) {
                        instrumentDetails.append(instrumentHead.getInstrumentNumber()).append(", ").append(instrumentHead.getInstrumentDate() != null ? this.dateFormat.format(instrumentHead.getInstrumentDate()) : " ").append(", ").append(instrumentHead.getBankId() != null ? instrumentHead.getBankId().getName() : " ");
                    }
                    paymentModes.add(instrumentHead.getInstrumentType().getType());
                    ++i;
                }
                for (String paymentMode : paymentModes) {
                    if (j > 1) {
                        payMode.append(", ");
                    }
                    payMode.append(paymentMode);
                    ++j;
                }
                rcptInfo.setInstrumentDetails(instrumentDetails.toString());
                rcptInfo.setPaymentMode(payMode.toString());
                rcptInfo.setPayeeName(rcptHeader.getPaidBy());
                rcptInfo.setCollInfoList(this.getCollectionInfoList(rcptHeader));
                rcptInfoList.add(rcptInfo);
            }
            ArrayList<TaxCollectionInfo> cashTotalsList = new ArrayList<TaxCollectionInfo>();
            cashTotalsList.add(this.currTotalCashCollInfo);
            cashTotalsList.add(this.arrTotalCashCollInfo);
            cashTotalsList.add(this.rebateTotalCashCollInfo);
            this.totalCashRcptInfo.setCollInfoList(cashTotalsList);
            this.totalCashRcptInfo.setReceiptNo(TOTAL_BY_CASH);
            ArrayList<TaxCollectionInfo> chequeTotalsList = new ArrayList<TaxCollectionInfo>();
            chequeTotalsList.add(this.currTotalChequeCollInfo);
            chequeTotalsList.add(this.arrTotalChequeCollInfo);
            chequeTotalsList.add(this.rebateTotalChequeCollInfo);
            this.totalChequeRcptInfo.setCollInfoList(chequeTotalsList);
            this.totalChequeRcptInfo.setReceiptNo(TOTAL_BY_CHEQUE);
            ArrayList<TaxCollectionInfo> totalsList = new ArrayList<TaxCollectionInfo>();
            totalsList.add(this.currTotalCollInfo);
            totalsList.add(this.arrTotalCollInfo);
            totalsList.add(this.rebateTotalCollInfo);
            this.totalRcptInfo.setCollInfoList(totalsList);
            this.totalRcptInfo.setReceiptNo(TOTAL);
            rcptInfoList.add(this.totalCashRcptInfo);
            rcptInfoList.add(this.totalChequeRcptInfo);
            rcptInfoList.add(this.totalRcptInfo);
            cashCollInfo.setCollByCash(this.totalCashCollAmt);
            cashCollInfo.setCollByCheque(this.totalChequeCollAmt);
            cashCollInfo.setOtherColl(this.totalOthersCollAmt);
            cashCollInfo.setEduEgsArrColl(this.arrTotalCollInfo.getEduCess().add(this.arrTotalCollInfo.getEgsCess()));
            cashCollInfo.setEduEgsCurrColl(this.currTotalCollInfo.getEduCess().add(this.currTotalCollInfo.getEgsCess()));
            cashCollInfo.setTotalArrColl(this.arrTotalCollInfo.getTotal());
            cashCollInfo.setTotalCurrColl(this.currTotalCollInfo.getTotal().subtract(this.rebateTotalCollInfo.getTotal()));
            cashCollInfo.setGrandTotal(this.arrTotalCollInfo.getTotal().add(this.currTotalCollInfo.getTotal()).subtract(this.rebateTotalCollInfo.getTotal()));
            cashCollInfo.setRcptInfoList(rcptInfoList);
            User user = this.userService.getUserById(Long.valueOf(this.userId));
            cashCollInfo.setOperator(user.getUsername());
            LOGGER.debug((Object)("Loop took " + (System.currentTimeMillis() - loopStartTime) / 1000L + " sec(s)..!"));
            ReportRequest reportInput = new ReportRequest("DailyCollectionReport", (Object)cashCollInfo, null);
            reportInput.setPrintDialogOnOpenReport(true);
            this.reportId = this.reportViewerUtil.addReportToTempCache(this.reportService.createReport(reportInput));
            LOGGER.debug((Object)("Report took " + (System.currentTimeMillis() - reportStartTime) / 1000L + " sec(s)..!"));
            LOGGER.debug((Object)"Exited from generateReport method(if block)");
            return this.REPORT;
        }
        this.searchForm = Boolean.FALSE;
        LOGGER.debug((Object)"Exited from generateReport method(else block)");
        return "new";
    }

    private List<TaxCollectionInfo> getCollectionInfoList(ReceiptHeader rcptHeader) {
        LOGGER.debug((Object)"Entered into getCollectionInfoList method");
        ArrayList<TaxCollectionInfo> collInfoList = new ArrayList<TaxCollectionInfo>();
        Set rcptDetails = rcptHeader.getReceiptDetails();
        Set instHeaderList = rcptHeader.getReceiptInstrument();
        String paymentMode = null;
        for (InstrumentHeader instHeader : instHeaderList) {
            paymentMode = instHeader.getInstrumentType().getType();
        }
        TaxCollectionInfo currCollInfo = new TaxCollectionInfo();
        TaxCollectionInfo arrCollInfo = new TaxCollectionInfo();
        TaxCollectionInfo rebateCollInfo = new TaxCollectionInfo();
        currCollInfo.setTaxType(this.CURRENT);
        arrCollInfo.setTaxType(this.ARREAR);
        rebateCollInfo.setTaxType(this.REBATE);
        BigDecimal totalCurrentTax = BigDecimal.ZERO;
        BigDecimal totalArrearTax = BigDecimal.ZERO;
        BigDecimal totalRebate = BigDecimal.ZERO;
        for (ReceiptDetail rcptDetail : rcptDetails) {
            String glcode = rcptDetail.getAccounthead().getGlcode();
            if ("1402002".equals(glcode)) {
                if (this.currInst.equals(rcptDetail.getDescription().substring(16, rcptDetail.getDescription().length()))) {
                    currCollInfo.setMiscTax(currCollInfo.getMiscTax().add(rcptDetail.getCramount()));
                    this.currTotalCollInfo.setMiscTax(this.currTotalCollInfo.getMiscTax().add(rcptDetail.getCramount()));
                    if (PAYMENT_MODE_CASH.equals(paymentMode)) {
                        this.currTotalCashCollInfo.setMiscTax(this.currTotalCashCollInfo.getMiscTax().add(rcptDetail.getCramount()));
                    } else if (PAYMENT_MODE_CHEQUE.equals(paymentMode)) {
                        this.currTotalChequeCollInfo.setMiscTax(this.currTotalChequeCollInfo.getMiscTax().add(rcptDetail.getCramount()));
                    }
                    totalCurrentTax = totalCurrentTax.add(rcptDetail.getCramount() != null ? rcptDetail.getCramount() : BigDecimal.ZERO);
                    continue;
                }
                arrCollInfo.setMiscTax(arrCollInfo.getMiscTax().add(rcptDetail.getCramount()));
                this.arrTotalCollInfo.setMiscTax(this.arrTotalCollInfo.getMiscTax().add(rcptDetail.getCramount()));
                if (PAYMENT_MODE_CASH.equals(paymentMode)) {
                    this.arrTotalCashCollInfo.setMiscTax(this.arrTotalCashCollInfo.getMiscTax().add(rcptDetail.getCramount()));
                } else if (PAYMENT_MODE_CHEQUE.equals(paymentMode)) {
                    this.arrTotalChequeCollInfo.setMiscTax(this.arrTotalChequeCollInfo.getMiscTax().add(rcptDetail.getCramount()));
                }
                totalArrearTax = totalArrearTax.add(rcptDetail.getCramount() != null ? rcptDetail.getCramount() : BigDecimal.ZERO);
                continue;
            }
            if ("2202103".equals(glcode)) {
                rebateCollInfo.setGeneralTax(rebateCollInfo.getGeneralTax().add(rcptDetail.getDramount() != null ? rcptDetail.getDramount() : BigDecimal.ZERO));
                totalRebate = totalRebate.add(rcptDetail.getDramount() != null ? rcptDetail.getDramount() : BigDecimal.ZERO);
                this.rebateTotalCollInfo.setGeneralTax(this.rebateTotalCollInfo.getGeneralTax().add(rcptDetail.getDramount()));
                if (PAYMENT_MODE_CASH.equals(paymentMode)) {
                    this.rebateTotalCashCollInfo.setGeneralTax(this.rebateTotalCashCollInfo.getGeneralTax().add(rcptDetail.getDramount()));
                    continue;
                }
                if (!PAYMENT_MODE_CHEQUE.equals(paymentMode)) continue;
                this.rebateTotalChequeCollInfo.setGeneralTax(this.rebateTotalChequeCollInfo.getGeneralTax().add(rcptDetail.getDramount()));
                continue;
            }
            if (PropertyTaxConstants.GLCODEMAP_FOR_ARREARTAX.containsValue(glcode)) {
                if (((String)PropertyTaxConstants.GLCODEMAP_FOR_ARREARTAX.get("GEN_TAX")).equals(glcode)) {
                    arrCollInfo.setGeneralTax(arrCollInfo.getGeneralTax().add(rcptDetail.getCramount() != null ? rcptDetail.getCramount() : BigDecimal.ZERO));
                    this.arrTotalCollInfo.setGeneralTax(this.arrTotalCollInfo.getGeneralTax().add(rcptDetail.getCramount()));
                    if (PAYMENT_MODE_CASH.equals(paymentMode)) {
                        this.arrTotalCashCollInfo.setGeneralTax(this.arrTotalCashCollInfo.getGeneralTax().add(rcptDetail.getCramount()));
                    } else if (PAYMENT_MODE_CHEQUE.equals(paymentMode)) {
                        this.arrTotalChequeCollInfo.setGeneralTax(this.arrTotalChequeCollInfo.getGeneralTax().add(rcptDetail.getCramount()));
                    }
                } else if (((String)PropertyTaxConstants.GLCODEMAP_FOR_ARREARTAX.get("EDU_CESS")).equals(glcode)) {
                    arrCollInfo.setSewerageTax(arrCollInfo.getSewerageTax().add(rcptDetail.getCramount() != null ? rcptDetail.getCramount() : BigDecimal.ZERO));
                    this.arrTotalCollInfo.setSewerageTax(this.arrTotalCollInfo.getSewerageTax().add(rcptDetail.getCramount()));
                    if (PAYMENT_MODE_CASH.equals(paymentMode)) {
                        this.arrTotalCashCollInfo.setSewerageTax(this.arrTotalCashCollInfo.getSewerageTax().add(rcptDetail.getCramount()));
                    } else if (PAYMENT_MODE_CHEQUE.equals(paymentMode)) {
                        this.arrTotalChequeCollInfo.setSewerageTax(this.arrTotalChequeCollInfo.getSewerageTax().add(rcptDetail.getCramount()));
                    }
                } else if (((String)PropertyTaxConstants.GLCODEMAP_FOR_ARREARTAX.get("LIB_CESS")).equals(glcode)) {
                    arrCollInfo.setLightTax(arrCollInfo.getLightTax().add(rcptDetail.getCramount() != null ? rcptDetail.getCramount() : BigDecimal.ZERO));
                    this.arrTotalCollInfo.setLightTax(this.arrTotalCollInfo.getLightTax().add(rcptDetail.getCramount()));
                    if (PAYMENT_MODE_CASH.equals(paymentMode)) {
                        this.arrTotalCashCollInfo.setLightTax(this.arrTotalCashCollInfo.getLightTax().add(rcptDetail.getCramount()));
                    } else if (PAYMENT_MODE_CHEQUE.equals(paymentMode)) {
                        this.arrTotalChequeCollInfo.setLightTax(this.arrTotalChequeCollInfo.getLightTax().add(rcptDetail.getCramount()));
                    }
                } else if (((String)PropertyTaxConstants.GLCODEMAP_FOR_ARREARTAX.get("UNAUTH_PENALTY")).equals(glcode)) {
                    arrCollInfo.setWaterTax(arrCollInfo.getWaterTax().add(rcptDetail.getCramount() != null ? rcptDetail.getCramount() : BigDecimal.ZERO));
                    this.arrTotalCollInfo.setWaterTax(this.arrTotalCollInfo.getWaterTax().add(rcptDetail.getCramount()));
                    if (PAYMENT_MODE_CASH.equals(paymentMode)) {
                        this.arrTotalCashCollInfo.setWaterTax(this.arrTotalCashCollInfo.getWaterTax().add(rcptDetail.getCramount()));
                    } else if (PAYMENT_MODE_CHEQUE.equals(paymentMode)) {
                        this.arrTotalChequeCollInfo.setWaterTax(this.arrTotalChequeCollInfo.getWaterTax().add(rcptDetail.getCramount()));
                    }
                }
                totalArrearTax = totalArrearTax.add(rcptDetail.getCramount() != null ? rcptDetail.getCramount() : BigDecimal.ZERO);
                continue;
            }
            if (((String)PropertyTaxConstants.GLCODEMAP_FOR_CURRENTTAX.get("GEN_TAX")).equals(glcode)) {
                currCollInfo.setGeneralTax(rcptDetail.getCramount());
                this.currTotalCollInfo.setGeneralTax(this.currTotalCollInfo.getGeneralTax().add(rcptDetail.getCramount()));
                if (PAYMENT_MODE_CASH.equals(paymentMode)) {
                    this.currTotalCashCollInfo.setGeneralTax(this.currTotalCashCollInfo.getGeneralTax().add(rcptDetail.getCramount()));
                } else if (PAYMENT_MODE_CHEQUE.equals(paymentMode)) {
                    this.currTotalChequeCollInfo.setGeneralTax(this.currTotalChequeCollInfo.getGeneralTax().add(rcptDetail.getCramount()));
                }
            } else if (((String)PropertyTaxConstants.GLCODEMAP_FOR_CURRENTTAX.get("EDU_CESS")).equals(glcode)) {
                currCollInfo.setSewerageTax(rcptDetail.getCramount());
                this.currTotalCollInfo.setSewerageTax(this.currTotalCollInfo.getSewerageTax().add(rcptDetail.getCramount()));
                if (PAYMENT_MODE_CASH.equals(paymentMode)) {
                    this.currTotalCashCollInfo.setSewerageTax(this.currTotalCashCollInfo.getSewerageTax().add(rcptDetail.getCramount()));
                } else if (PAYMENT_MODE_CHEQUE.equals(paymentMode)) {
                    this.currTotalChequeCollInfo.setSewerageTax(this.currTotalChequeCollInfo.getSewerageTax().add(rcptDetail.getCramount()));
                }
            } else if (((String)PropertyTaxConstants.GLCODEMAP_FOR_CURRENTTAX.get("LIB_CESS")).equals(glcode)) {
                currCollInfo.setLightTax(rcptDetail.getCramount());
                this.currTotalCollInfo.setLightTax(this.currTotalCollInfo.getLightTax().add(rcptDetail.getCramount()));
                if (PAYMENT_MODE_CASH.equals(paymentMode)) {
                    this.currTotalCashCollInfo.setLightTax(this.currTotalCashCollInfo.getLightTax().add(rcptDetail.getCramount()));
                } else if (PAYMENT_MODE_CHEQUE.equals(paymentMode)) {
                    this.currTotalChequeCollInfo.setLightTax(this.currTotalChequeCollInfo.getLightTax().add(rcptDetail.getCramount()));
                }
            } else if (((String)PropertyTaxConstants.GLCODEMAP_FOR_CURRENTTAX.get("UNAUTH_PENALTY")).equals(glcode)) {
                currCollInfo.setWaterTax(rcptDetail.getCramount());
                this.currTotalCollInfo.setWaterTax(this.currTotalCollInfo.getWaterTax().add(rcptDetail.getCramount()));
                if (PAYMENT_MODE_CASH.equals(paymentMode)) {
                    this.currTotalCashCollInfo.setWaterTax(this.currTotalCashCollInfo.getWaterTax().add(rcptDetail.getCramount()));
                } else if (PAYMENT_MODE_CHEQUE.equals(paymentMode)) {
                    this.currTotalChequeCollInfo.setWaterTax(this.currTotalChequeCollInfo.getWaterTax().add(rcptDetail.getCramount()));
                }
            }
            totalCurrentTax = totalCurrentTax.add(rcptDetail.getCramount() != null ? rcptDetail.getCramount() : BigDecimal.ZERO);
        }
        this.arrTotalCollInfo.setTotal(this.arrTotalCollInfo.getTotal().add(totalArrearTax));
        this.currTotalCollInfo.setTotal(this.currTotalCollInfo.getTotal().add(totalCurrentTax));
        this.rebateTotalCollInfo.setTotal(this.rebateTotalCollInfo.getTotal().add(totalRebate));
        if (PAYMENT_MODE_CASH.equals(paymentMode)) {
            this.totalCashCollAmt = this.totalCashCollAmt.add(totalCurrentTax.add(totalArrearTax).subtract(totalRebate));
            this.arrTotalCashCollAmt = this.arrTotalCashCollAmt.add(totalArrearTax);
            this.currTotalCashCollAmt = this.currTotalCashCollAmt.add(totalCurrentTax);
            this.rebateTotalCashCollAmt = this.rebateTotalCashCollAmt.add(totalRebate);
        } else if (PAYMENT_MODE_CHEQUE.equals(paymentMode)) {
            this.totalChequeCollAmt = this.totalChequeCollAmt.add(totalCurrentTax.add(totalArrearTax).subtract(totalRebate));
            this.arrTotalChequeCollAmt = this.arrTotalChequeCollAmt.add(totalArrearTax);
            this.currTotalChequeCollAmt = this.currTotalChequeCollAmt.add(totalCurrentTax);
            this.rebateTotalChequeCollAmt = this.rebateTotalChequeCollAmt.add(totalRebate);
        } else {
            this.totalOthersCollAmt = this.totalOthersCollAmt.add(totalCurrentTax.add(totalArrearTax).subtract(totalRebate));
        }
        this.currTotalCashCollInfo.setTotal(this.currTotalCashCollAmt);
        this.arrTotalCashCollInfo.setTotal(this.arrTotalCashCollAmt);
        this.rebateTotalCashCollInfo.setTotal(this.rebateTotalCashCollAmt);
        this.currTotalChequeCollInfo.setTotal(this.currTotalChequeCollAmt);
        this.arrTotalChequeCollInfo.setTotal(this.arrTotalChequeCollAmt);
        this.rebateTotalChequeCollInfo.setTotal(this.rebateTotalChequeCollAmt);
        arrCollInfo.setTotal(totalArrearTax);
        currCollInfo.setTotal(totalCurrentTax);
        rebateCollInfo.setTotal(totalRebate);
        collInfoList.add(currCollInfo);
        collInfoList.add(arrCollInfo);
        collInfoList.add(rebateCollInfo);
        LOGGER.debug((Object)"Exited from getCollectionInfoList method");
        return collInfoList;
    }

    private void initializeTotalsInfo() {
        LOGGER.debug((Object)"Entered into initializeTotalsInfo");
        this.arrTotalCollInfo.setGeneralTax(BigDecimal.ZERO);
        this.arrTotalCollInfo.setWaterTax(BigDecimal.ZERO);
        this.arrTotalCollInfo.setBigBuildingCess(BigDecimal.ZERO);
        this.arrTotalCollInfo.setEduCess(BigDecimal.ZERO);
        this.arrTotalCollInfo.setEgsCess(BigDecimal.ZERO);
        this.arrTotalCollInfo.setFireTax(BigDecimal.ZERO);
        this.arrTotalCollInfo.setLightTax(BigDecimal.ZERO);
        this.arrTotalCollInfo.setMiscTax(BigDecimal.ZERO);
        this.arrTotalCollInfo.setSewerageTax(BigDecimal.ZERO);
        this.arrTotalCollInfo.setTotal(BigDecimal.ZERO);
        this.arrTotalCollInfo.setTaxType(this.ARREAR);
        this.currTotalCollInfo.setGeneralTax(BigDecimal.ZERO);
        this.currTotalCollInfo.setWaterTax(BigDecimal.ZERO);
        this.currTotalCollInfo.setBigBuildingCess(BigDecimal.ZERO);
        this.currTotalCollInfo.setEduCess(BigDecimal.ZERO);
        this.currTotalCollInfo.setEgsCess(BigDecimal.ZERO);
        this.currTotalCollInfo.setFireTax(BigDecimal.ZERO);
        this.currTotalCollInfo.setLightTax(BigDecimal.ZERO);
        this.currTotalCollInfo.setMiscTax(BigDecimal.ZERO);
        this.currTotalCollInfo.setSewerageTax(BigDecimal.ZERO);
        this.currTotalCollInfo.setTotal(BigDecimal.ZERO);
        this.currTotalCollInfo.setTaxType(this.CURRENT);
        this.rebateTotalCollInfo.setGeneralTax(BigDecimal.ZERO);
        this.rebateTotalCollInfo.setTotal(BigDecimal.ZERO);
        this.rebateTotalCollInfo.setTaxType(this.REBATE);
        this.arrTotalCashCollInfo.setGeneralTax(BigDecimal.ZERO);
        this.arrTotalCashCollInfo.setWaterTax(BigDecimal.ZERO);
        this.arrTotalCashCollInfo.setBigBuildingCess(BigDecimal.ZERO);
        this.arrTotalCashCollInfo.setEduCess(BigDecimal.ZERO);
        this.arrTotalCashCollInfo.setEgsCess(BigDecimal.ZERO);
        this.arrTotalCashCollInfo.setFireTax(BigDecimal.ZERO);
        this.arrTotalCashCollInfo.setLightTax(BigDecimal.ZERO);
        this.arrTotalCashCollInfo.setMiscTax(BigDecimal.ZERO);
        this.arrTotalCashCollInfo.setSewerageTax(BigDecimal.ZERO);
        this.arrTotalCashCollInfo.setTotal(BigDecimal.ZERO);
        this.arrTotalCashCollInfo.setTaxType(this.ARREAR);
        this.currTotalCashCollInfo.setGeneralTax(BigDecimal.ZERO);
        this.currTotalCashCollInfo.setWaterTax(BigDecimal.ZERO);
        this.currTotalCashCollInfo.setBigBuildingCess(BigDecimal.ZERO);
        this.currTotalCashCollInfo.setEduCess(BigDecimal.ZERO);
        this.currTotalCashCollInfo.setEgsCess(BigDecimal.ZERO);
        this.currTotalCashCollInfo.setFireTax(BigDecimal.ZERO);
        this.currTotalCashCollInfo.setLightTax(BigDecimal.ZERO);
        this.currTotalCashCollInfo.setMiscTax(BigDecimal.ZERO);
        this.currTotalCashCollInfo.setSewerageTax(BigDecimal.ZERO);
        this.currTotalCashCollInfo.setTotal(BigDecimal.ZERO);
        this.currTotalCashCollInfo.setTaxType(this.CURRENT);
        this.rebateTotalCashCollInfo.setGeneralTax(BigDecimal.ZERO);
        this.rebateTotalCashCollInfo.setTotal(BigDecimal.ZERO);
        this.rebateTotalCashCollInfo.setTaxType(this.REBATE);
        this.arrTotalChequeCollInfo.setGeneralTax(BigDecimal.ZERO);
        this.arrTotalChequeCollInfo.setWaterTax(BigDecimal.ZERO);
        this.arrTotalChequeCollInfo.setBigBuildingCess(BigDecimal.ZERO);
        this.arrTotalChequeCollInfo.setEduCess(BigDecimal.ZERO);
        this.arrTotalChequeCollInfo.setEgsCess(BigDecimal.ZERO);
        this.arrTotalChequeCollInfo.setFireTax(BigDecimal.ZERO);
        this.arrTotalChequeCollInfo.setLightTax(BigDecimal.ZERO);
        this.arrTotalChequeCollInfo.setMiscTax(BigDecimal.ZERO);
        this.arrTotalChequeCollInfo.setSewerageTax(BigDecimal.ZERO);
        this.arrTotalChequeCollInfo.setTotal(BigDecimal.ZERO);
        this.arrTotalChequeCollInfo.setTaxType(this.ARREAR);
        this.currTotalChequeCollInfo.setGeneralTax(BigDecimal.ZERO);
        this.currTotalChequeCollInfo.setWaterTax(BigDecimal.ZERO);
        this.currTotalChequeCollInfo.setBigBuildingCess(BigDecimal.ZERO);
        this.currTotalChequeCollInfo.setEduCess(BigDecimal.ZERO);
        this.currTotalChequeCollInfo.setEgsCess(BigDecimal.ZERO);
        this.currTotalChequeCollInfo.setFireTax(BigDecimal.ZERO);
        this.currTotalChequeCollInfo.setLightTax(BigDecimal.ZERO);
        this.currTotalChequeCollInfo.setMiscTax(BigDecimal.ZERO);
        this.currTotalChequeCollInfo.setSewerageTax(BigDecimal.ZERO);
        this.currTotalChequeCollInfo.setTotal(BigDecimal.ZERO);
        this.currTotalChequeCollInfo.setTaxType(this.CURRENT);
        this.rebateTotalChequeCollInfo.setGeneralTax(BigDecimal.ZERO);
        this.rebateTotalChequeCollInfo.setTotal(BigDecimal.ZERO);
        this.rebateTotalChequeCollInfo.setTaxType(this.REBATE);
        LOGGER.debug((Object)"Exited from initializeTotalsInfo method");
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getReportId() {
        return this.reportId;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Boolean getSearchForm() {
        return this.searchForm;
    }

    public void setSearchForm(Boolean searchForm) {
        this.searchForm = searchForm;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

