/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.Action;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.viewer.ReportViewerUtil;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.ptis.bean.RecoveryInfo;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class DailyAbstractRecoveryReportAction
extends BaseFormAction {
    private static final String REPORT = "report";
    private static final long serialVersionUID = 1L;
    private ReportService reportService;
    private String reportId;
    @Autowired
    private ReportViewerUtil reportViewerUtil;

    public Object getModel() {
        return null;
    }

    @Action(value="/reports/dailyAbstractRecoveryReport.action")
    public String execute() {
        ArrayList<RecoveryInfo> resultList = new ArrayList<RecoveryInfo>();
        StringBuffer qryString = new StringBuffer("select CREATED_DATE, ").append("SUM(decode(glcode, '").append("4311001").append("', amount,'").append("4311002").append("', amount, 0)) as GeneralTax, ").append("SUM(decode(glcode, '").append("4311011").append("', amount,'").append("4311012").append("', amount, 0)) as FireTax, ").append("SUM(decode(glcode, '").append("4311021").append("', amount,'").append("4311022").append("', amount, 0)) as WaterTax, ").append("SUM(decode(glcode, '").append("4311031").append("', amount,'").append("4311032").append("', amount, 0)) as SewerageTax, ").append("SUM(decode(glcode, '").append("4311041").append("', amount,'").append("4311042").append("', amount, 0)) as LightTax, ").append("SUM(decode(glcode, '").append("4312001").append("', amount,'").append("4312002").append("', amount, 0)) as EduCessTax, ").append("SUM(decode(glcode, '").append("4311003").append("', amount,'").append("4311004").append("', amount, 0)) as BigBldgTax, ").append("SUM(decode(glcode, '").append("4312003").append("', amount,'").append("4312004").append("', amount, 0)) as EgsTax ").append("FROM ").append("(SELECT TRUNC(CH.created_date) AS CREATED_DATE, COA.glcode AS GLCODE, SUM(cd.cramount) AS AMOUNT ").append("FROM EGCL_COLLECTIONHEADER CH, EGCL_COLLECTIONDETAILS CD, EGW_STATUS ST, EG_SERVICEDETAILS SD, chartofaccounts COA ").append("WHERE CH.id = cd.id_collectionheader ").append("AND CH.id_status = ST.ID AND ST.MODULETYPE = 'ReceiptHeader' AND ST.description = 'Approved' ").append("AND CH.id_service = SD.ID ").append("AND SD.code = 'PT' ").append("AND CD.id_accounthead = COA.ID ");
        StringBuffer groupByString = new StringBuffer("GROUP BY TRUNC(CH.created_date), COA.glcode) ").append("GROUP BY CREATED_DATE ").append("ORDER BY CREATED_DATE DESC ");
        resultList.add(this.prepareRowOne(qryString, groupByString));
        resultList.add(this.prepareRowTwo(qryString, groupByString));
        resultList.add(this.prepareRowThree(qryString, groupByString));
        resultList.add(this.prepareRowFour(qryString, groupByString));
        resultList.add(this.prepareRowFive(qryString, groupByString));
        Map reportParams = this.prepareReportParams();
        ReportRequest reportRequest = new ReportRequest("DailyAbstractRecoveryReport", resultList, reportParams);
        this.reportId = this.reportViewerUtil.addReportToTempCache(this.reportService.createReport(reportRequest));
        return REPORT;
    }

    private Map<String, Object> prepareReportParams() {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        Calendar reportFromDate = Calendar.getInstance();
        Calendar reportToDate = Calendar.getInstance();
        int currMonth = reportFromDate.get(2);
        if (currMonth < 3) {
            reportFromDate.add(1, -1);
        }
        reportFromDate.set(5, 1);
        reportFromDate.set(2, 3);
        reportParams.put("reportFDate", reportFromDate.getTime());
        reportToDate.add(5, -1);
        reportParams.put("reportTDate", reportToDate.getTime());
        Calendar currDate = Calendar.getInstance();
        int year = Integer.valueOf(String.valueOf(currDate.get(1)).substring(2));
        String currFinYear = null;
        String prevFinYear = null;
        if (currMonth > 2) {
            currFinYear = String.valueOf(year) + "-" + String.valueOf(year + 1);
            prevFinYear = String.valueOf(year - 1) + "-" + String.valueOf(year);
        } else {
            currFinYear = String.valueOf(year - 1) + "-" + String.valueOf(year);
            prevFinYear = String.valueOf(year - 2) + "-" + String.valueOf(year - 1);
        }
        reportParams.put("currFinYear", currFinYear);
        reportParams.put("prevFinYear", prevFinYear);
        return reportParams;
    }

    private RecoveryInfo prepareRowOne(StringBuffer qry, StringBuffer groupByClause) {
        Calendar fromDate = Calendar.getInstance();
        Calendar toDate = Calendar.getInstance();
        int currMonth = fromDate.get(2);
        if (currMonth < 3) {
            fromDate.add(1, -1);
        }
        fromDate.set(2, 3);
        fromDate.set(5, 1);
        toDate.add(2, -1);
        toDate.set(5, toDate.getActualMaximum(5));
        String whereClause = "AND TRUNC(CH.created_date) >= :fromDate AND TRUNC(CH.created_date) <= :toDate ";
        StringBuffer sqlQry = new StringBuffer(qry).append(whereClause).append(groupByClause);
        return this.prepareReportData(sqlQry, fromDate, toDate);
    }

    private RecoveryInfo prepareRowTwo(StringBuffer qry, StringBuffer groupByClause) {
        Calendar fromDate = Calendar.getInstance();
        fromDate.add(5, -1);
        String whereClause = "AND TRUNC(CH.created_date) = :fromDate ";
        StringBuffer sqlQry = new StringBuffer(qry).append(whereClause).append(groupByClause);
        return this.prepareReportData(sqlQry, fromDate, null);
    }

    private RecoveryInfo prepareRowThree(StringBuffer qry, StringBuffer groupByClause) {
        Calendar fromDate = Calendar.getInstance();
        Calendar toDate = Calendar.getInstance();
        fromDate.set(5, 1);
        toDate.add(5, -2);
        String whereClause = "AND TRUNC(CH.created_date) >= :fromDate AND TRUNC(CH.created_date) <= :toDate ";
        StringBuffer sqlQry = new StringBuffer(qry).append(whereClause).append(groupByClause);
        return this.prepareReportData(sqlQry, fromDate, toDate);
    }

    private RecoveryInfo prepareRowFour(StringBuffer qry, StringBuffer groupByClause) {
        Calendar.getInstance().set(Calendar.getInstance().get(1), 3, 1);
        Calendar fromDate = Calendar.getInstance();
        Calendar toDate = Calendar.getInstance();
        fromDate.set(5, 1);
        toDate.add(5, -1);
        String whereClause = "AND TRUNC(CH.created_date) >= :fromDate AND TRUNC(CH.created_date) <= :toDate ";
        StringBuffer sqlQry = new StringBuffer(qry).append(whereClause).append(groupByClause);
        return this.prepareReportData(sqlQry, fromDate, toDate);
    }

    private RecoveryInfo prepareRowFive(StringBuffer qry, StringBuffer groupByClause) {
        Calendar fromDate = Calendar.getInstance();
        int currMonth = fromDate.get(2);
        if (currMonth < 3) {
            fromDate.add(1, -1);
        }
        Calendar toDate = Calendar.getInstance();
        fromDate.set(2, 3);
        fromDate.set(5, 1);
        toDate.add(5, -1);
        String whereClause = "AND TRUNC(CH.created_date) >= :fromDate AND TRUNC(CH.created_date) <= :toDate ";
        StringBuffer sqlQry = new StringBuffer(qry).append(whereClause).append(groupByClause);
        return this.prepareReportData(sqlQry, fromDate, toDate);
    }

    private RecoveryInfo prepareReportData(StringBuffer qry, Calendar fDate, Calendar tDate) {
        RecoveryInfo recInfo = new RecoveryInfo();
        SQLQuery sqlQry = this.persistenceService.getSession().createSQLQuery(qry.toString());
        if (fDate != null) {
            recInfo.setFromDate(fDate.getTime());
            sqlQry.setDate("fromDate", fDate.getTime());
        }
        if (tDate != null) {
            recInfo.setToDate(tDate.getTime());
            sqlQry.setDate("toDate", tDate.getTime());
        }
        List currFinYearResList = sqlQry.list();
        if (fDate != null) {
            fDate.add(1, -1);
            sqlQry.setDate("fromDate", fDate.getTime());
        }
        if (tDate != null) {
            tDate.add(1, -1);
            sqlQry.setDate("toDate", tDate.getTime());
        }
        List prevFinYearResList = sqlQry.list();
        for (Object[] currFinYearRec : currFinYearResList) {
            recInfo.setGenTax(recInfo.getGenTax().add((BigDecimal)currFinYearRec[1]));
            recInfo.setFireTax(recInfo.getFireTax().add((BigDecimal)currFinYearRec[2]));
            recInfo.setWaterTax(recInfo.getWaterTax().add((BigDecimal)currFinYearRec[3]));
            recInfo.setSewerageTax(recInfo.getSewerageTax().add((BigDecimal)currFinYearRec[4]));
            recInfo.setLightTax(recInfo.getLightTax().add((BigDecimal)currFinYearRec[5]));
            recInfo.setEduCess(recInfo.getEduCess().add((BigDecimal)currFinYearRec[6]));
            recInfo.setBigBldgTax(recInfo.getBigBldgTax().add((BigDecimal)currFinYearRec[7]));
            recInfo.setEgsCess(recInfo.getEgsCess().add((BigDecimal)currFinYearRec[8]));
        }
        recInfo.setTotCurrYearColl(recInfo.getGenTax().add(recInfo.getFireTax()).add(recInfo.getWaterTax()).add(recInfo.getSewerageTax()).add(recInfo.getLightTax()).add(recInfo.getEduCess()).add(recInfo.getBigBldgTax()).add(recInfo.getEgsCess()));
        BigDecimal total = BigDecimal.ZERO;
        for (Object[] prevFinYearRec : prevFinYearResList) {
            total = total.add((BigDecimal)prevFinYearRec[1]).add((BigDecimal)prevFinYearRec[2]).add((BigDecimal)prevFinYearRec[3]).add((BigDecimal)prevFinYearRec[4]).add((BigDecimal)prevFinYearRec[5]).add((BigDecimal)prevFinYearRec[6]).add((BigDecimal)prevFinYearRec[7]).add((BigDecimal)prevFinYearRec[8]);
        }
        recInfo.setTotPrevYearColl(total);
        return recInfo;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getReportId() {
        return this.reportId;
    }
}

