/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.reports;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.MoneyUtils;
import org.egov.ptis.actions.reports.BoundryWisePropUsgeBean;
import org.egov.ptis.domain.dao.property.PropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.dao.property.PropertyUsageDAO;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class BoundaryWisePropUsgeDelegate {
    private static final Logger LOGGER = Logger.getLogger(BoundaryWisePropUsgeDelegate.class);
    @Autowired
    PropertyUsageDAO propertyUsageDAO;
    @Autowired
    PropertyTypeMasterDAO propertyTypeMasterDAO;
    @Autowired
    PropertyDAO propertyDAO;
    @Autowired
    private BoundaryService boundaryService;

    public Map<Integer, TreeMap<Integer, BoundryWisePropUsgeBean>> getBoundaryWiseList(List boundaryList, Integer bndryNo, List<PropertyTypeMaster> propMstrList) {
        LOGGER.debug((Object)"Entered into getBoundaryWiseList method");
        LOGGER.debug((Object)("Boundary number : " + bndryNo + ", " + "Boundary List : " + (boundaryList != null ? boundaryList : BigDecimal.ZERO)));
        TreeMap<Integer, TreeMap<Integer, BoundryWisePropUsgeBean>> boundaryMap = null;
        TreeMap<Integer, BoundryWisePropUsgeBean> propUsageIDMap = null;
        TreeMap<Integer, BoundryWisePropUsgeBean> propUsag = null;
        BigDecimal aggArrearDmdTot = BigDecimal.ZERO;
        BigDecimal aggCurrentDmdTot = BigDecimal.ZERO;
        Integer aggTotalProps = 0;
        BoundryWisePropUsgeBean indTotBean = null;
        int propAggTot = 1900;
        int propIndTotNum = 5000;
        int propNullId = 900;
        if (boundaryList != null && !boundaryList.isEmpty()) {
            boundaryMap = new TreeMap<Integer, TreeMap<Integer, BoundryWisePropUsgeBean>>();
            int i = 0;
            while (i < boundaryList.size()) {
                BoundryWisePropUsgeBean bndryBean;
                Object[] innrBndryObj;
                ++propNullId;
                Object[] outBndryObj = (Object[])boundaryList.get(i);
                propUsageIDMap = new TreeMap<Integer, BoundryWisePropUsgeBean>();
                this.prpUsageMapWithDmyVals(propUsageIDMap, null, propMstrList);
                aggArrearDmdTot = BigDecimal.ZERO;
                aggCurrentDmdTot = BigDecimal.ZERO;
                BigDecimal innerBndryObj = BigDecimal.ZERO;
                innerBndryObj.setScale(2);
                aggTotalProps = 0;
                int j = i;
                while (j < boundaryList.size() && (innrBndryObj = (Object[])boundaryList.get(j))[0].equals(outBndryObj[0])) {
                    Integer propTypeId = ((Long)innrBndryObj[1]).intValue();
                    if (propTypeId == null || propTypeId.equals("")) {
                        bndryBean = new BoundryWisePropUsgeBean();
                        this.prpUsageMap(bndryBean, innrBndryObj, propUsageIDMap, null, Integer.valueOf(propNullId));
                        aggTotalProps = aggTotalProps + (Integer)innrBndryObj[4];
                        aggArrearDmdTot = aggArrearDmdTot.add((BigDecimal)innrBndryObj[2]);
                        aggCurrentDmdTot = aggCurrentDmdTot.add((BigDecimal)innrBndryObj[3]);
                    } else if (propUsageIDMap.containsKey(propTypeId)) {
                        bndryBean = (BoundryWisePropUsgeBean)propUsageIDMap.get(propTypeId);
                        this.prpUsageMap(bndryBean, innrBndryObj, propUsageIDMap, "withUsage", null);
                        aggTotalProps = aggTotalProps + (Integer)innrBndryObj[4];
                        aggArrearDmdTot = aggArrearDmdTot.add((BigDecimal)innrBndryObj[2]);
                        aggCurrentDmdTot = aggCurrentDmdTot.add((BigDecimal)innrBndryObj[3]);
                    }
                    LOGGER.debug((Object)("Aggregate Total Properties : " + aggTotalProps + ", " + "Aggregate Total Arrears Demand : " + aggArrearDmdTot + ", " + "Aggregate Total Current Demand : " + aggCurrentDmdTot));
                    ++j;
                    ++i;
                }
                bndryBean = new BoundryWisePropUsgeBean();
                bndryBean.setArrDmd(MoneyUtils.roundOff((BigDecimal)aggArrearDmdTot));
                bndryBean.setCurrDmd(MoneyUtils.roundOff((BigDecimal)aggCurrentDmdTot));
                bndryBean.setPropCount(aggTotalProps);
                bndryBean.setTotalDemand(MoneyUtils.roundOff((BigDecimal)aggArrearDmdTot.add(aggCurrentDmdTot)));
                LOGGER.debug((Object)("Total Properties : " + bndryBean.getPropCount() + ", " + "Arrears Demand : " + bndryBean.getArrDmd() + ", " + "Current Demand : " + bndryBean.getArrDmd() + ", " + "Total Demand : " + bndryBean.getTotalDemand()));
                propUsageIDMap.put(propAggTot + 1, bndryBean);
                boundaryMap.put((Integer)outBndryObj[0], propUsageIDMap);
            }
            List propIndTotList = this.getTotPropUsage(bndryNo);
            LOGGER.debug((Object)("propIndTotList size : " + (propIndTotList != null ? Integer.valueOf(propIndTotList.size()) : BigDecimal.ZERO)));
            if (propIndTotList != null && !propIndTotList.isEmpty()) {
                int propUsageIndTot = 2500;
                propUsag = new TreeMap<Integer, BoundryWisePropUsgeBean>();
                this.prpUsageMapWithDmyVals(null, propUsag, propMstrList);
                this.propNAUsageMapWithDmyVals(null, Integer.valueOf(propNullId), propUsag, propMstrList);
                BoundryWisePropUsgeBean indAggTotBean = null;
                BigDecimal indAggDemand = BigDecimal.ZERO;
                BigDecimal indCurrDemand = BigDecimal.ZERO;
                BigDecimal indTotalDemand = BigDecimal.ZERO;
                Integer indaggPropCnt = 0;
                for (Object propObject : propIndTotList) {
                    Object[] totList = (Object[])propObject;
                    BigDecimal totalDemand = BigDecimal.ZERO;
                    Integer indPropCount = 0;
                    if (totList[0] == null || totList[0].equals("")) {
                        indPropCount = propNullId;
                        indAggDemand = indAggDemand.add((BigDecimal)totList[2]);
                        indCurrDemand = indCurrDemand.add((BigDecimal)totList[3]);
                        indTotalDemand = indTotalDemand.add((BigDecimal)totList[2]).add((BigDecimal)totList[3]);
                        indaggPropCnt = indaggPropCnt + (Integer)totList[1];
                    } else {
                        indPropCount = ((Long)totList[0]).intValue();
                        indAggDemand = indAggDemand.add((BigDecimal)totList[2]);
                        indCurrDemand = indCurrDemand.add((BigDecimal)totList[3]);
                        indTotalDemand = indTotalDemand.add((BigDecimal)totList[2]).add((BigDecimal)totList[3]);
                        indaggPropCnt = indaggPropCnt + (Integer)totList[1];
                    }
                    indTotBean = new BoundryWisePropUsgeBean();
                    indTotBean.setPropCount((Integer)totList[1]);
                    indTotBean.setArrDmd(MoneyUtils.roundOff((BigDecimal)((BigDecimal)totList[2])));
                    indTotBean.setCurrDmd(MoneyUtils.roundOff((BigDecimal)((BigDecimal)totList[3])));
                    totalDemand = totalDemand.add((BigDecimal)totList[2]).add((BigDecimal)totList[3]);
                    indTotBean.setTotalDemand(MoneyUtils.roundOff((BigDecimal)totalDemand));
                    propUsag.put(indPropCount, indTotBean);
                    LOGGER.debug((Object)("Individual Aggregate Property count : " + indaggPropCnt + ", " + "Individual Current Demand : " + indCurrDemand + ", " + "Individual Arrears Demand : " + indAggDemand + ", " + "Individual Total Demand : " + indTotalDemand));
                }
                indAggTotBean = new BoundryWisePropUsgeBean();
                indAggTotBean.setArrDmd(MoneyUtils.roundOff((BigDecimal)indAggDemand));
                indAggTotBean.setCurrDmd(MoneyUtils.roundOff((BigDecimal)indCurrDemand));
                indAggTotBean.setTotalDemand(MoneyUtils.roundOff((BigDecimal)indTotalDemand));
                indAggTotBean.setPropCount(indaggPropCnt);
                LOGGER.debug((Object)("Total Properties : " + indAggTotBean.getPropCount() + ", " + "Arrears Demand : " + indAggTotBean.getArrDmd() + ", " + "Current Demand : " + indAggTotBean.getCurrDmd() + ", " + "Total Demand : " + indAggTotBean.getTotalDemand()));
                propUsag.put(propUsageIndTot, indAggTotBean);
                boundaryMap.put(propIndTotNum, propUsag);
            }
        }
        LOGGER.debug((Object)("Boundary Map : " + (boundaryMap != null ? boundaryMap : BigDecimal.ZERO)));
        LOGGER.debug((Object)"Exit from getBoundaryWiseList method");
        return boundaryMap;
    }

    public void prpUsageMap(BoundryWisePropUsgeBean bndryBean, Object[] bndryObj, Map<Integer, BoundryWisePropUsgeBean> propUsageIDMap, String usgage, Integer propNullId) {
        LOGGER.debug((Object)"Entered into prpUsageMap method");
        BigDecimal totalDemand = BigDecimal.ZERO;
        BigDecimal arrDmd = BigDecimal.ZERO;
        BigDecimal currDmd = BigDecimal.ZERO;
        Integer propCount = 0;
        Integer propId = 0;
        arrDmd = arrDmd.add((BigDecimal)bndryObj[2]);
        currDmd = currDmd.add((BigDecimal)bndryObj[3]);
        BigDecimal bndryObjAvAmt = BigDecimal.ZERO;
        totalDemand = totalDemand.add(arrDmd).add(currDmd);
        propCount = (Integer)bndryObj[4];
        if (usgage == null) {
            propId = propNullId;
        } else if (usgage != null && usgage.equals("withUsage")) {
            propId = ((Long)bndryObj[1]).intValue();
        }
        bndryBean.setArrDmd(MoneyUtils.roundOff((BigDecimal)arrDmd));
        bndryBean.setCurrDmd(MoneyUtils.roundOff((BigDecimal)currDmd));
        bndryBean.setPropCount(propCount);
        bndryBean.setTotalDemand(MoneyUtils.roundOff((BigDecimal)totalDemand));
        propUsageIDMap.put(propId, bndryBean);
        LOGGER.debug((Object)("Property Id : " + propId + ", " + "Total Properties : " + bndryBean.getPropCount() + ", " + "Arrears Demand : " + bndryBean.getArrDmd() + ", " + "Current Demand : " + bndryBean.getCurrDmd() + ", " + "Total Demand : " + bndryBean.getTotalDemand()));
        LOGGER.debug((Object)"Exit from prpUsageMap method");
    }

    public void prpUsageMapWithDmyVals(Map<Integer, BoundryWisePropUsgeBean> propUsageIDMap, Map<Integer, BoundryWisePropUsgeBean> propUsag, List<PropertyTypeMaster> propMstrList) {
        LOGGER.debug((Object)"Entered into prpUsageMapWithDmyVals method");
        LOGGER.debug((Object)("PropertyUsageId Map size : " + (propUsageIDMap != null ? Integer.valueOf(propUsageIDMap.size()) : BigDecimal.ZERO)));
        LOGGER.debug((Object)("PropertyUsage Map size : " + (propUsag != null ? Integer.valueOf(propUsag.size()) : BigDecimal.ZERO)));
        LOGGER.debug((Object)("All Property Usage List : " + (propMstrList != null ? propMstrList : BigDecimal.ZERO)));
        for (int propUsge = 0; propUsge < propMstrList.size(); ++propUsge) {
            BoundryWisePropUsgeBean beanWithZeroVal = new BoundryWisePropUsgeBean();
            beanWithZeroVal.setArrDmd(BigDecimal.ZERO);
            beanWithZeroVal.setCurrDmd(BigDecimal.ZERO);
            beanWithZeroVal.setPropCount(Integer.valueOf(0));
            beanWithZeroVal.setTotalDemand(BigDecimal.ZERO);
            LOGGER.debug((Object)("Total Properties : " + beanWithZeroVal.getPropCount() + ", " + "Arrears Demand : " + beanWithZeroVal.getArrDmd() + ", " + "Current Demand : " + beanWithZeroVal.getCurrDmd() + ", " + "Total Demand : " + beanWithZeroVal.getTotalDemand()));
            if (propUsageIDMap == null) {
                propUsag.put(propMstrList.get(propUsge).getId().intValue(), beanWithZeroVal);
                continue;
            }
            propUsageIDMap.put(propMstrList.get(propUsge).getId().intValue(), beanWithZeroVal);
        }
        LOGGER.debug((Object)"Exit from prpUsageMapWithDmyVals method");
    }

    public void propNAUsageMapWithDmyVals(Map<Integer, BoundryWisePropUsgeBean> propUsageIDMap, Integer propNAUsgeId, Map<Integer, BoundryWisePropUsgeBean> propUsag, List<PropertyTypeMaster> propMstrList) {
        LOGGER.debug((Object)"Entered into propNAUsageMapWithDmyVals method");
        LOGGER.debug((Object)("PropertyUsageId Map size : " + (propUsageIDMap != null ? Integer.valueOf(propUsageIDMap.size()) : BigDecimal.ZERO)));
        LOGGER.debug((Object)("PropetyNAUsageId : " + propNAUsgeId));
        LOGGER.debug((Object)("PropertyUsage Map size : " + (propUsag != null ? Integer.valueOf(propUsag.size()) : BigDecimal.ZERO)));
        for (int propUsge = 0; propUsge < propMstrList.size(); ++propUsge) {
            BoundryWisePropUsgeBean beanWithZeroVal = new BoundryWisePropUsgeBean();
            beanWithZeroVal.setArrDmd(BigDecimal.ZERO);
            beanWithZeroVal.setCurrDmd(BigDecimal.ZERO);
            beanWithZeroVal.setPropCount(Integer.valueOf(0));
            beanWithZeroVal.setTotalDemand(BigDecimal.ZERO);
            LOGGER.debug((Object)("Total Properties : " + beanWithZeroVal.getPropCount() + ", " + "Arrears Demand : " + beanWithZeroVal.getArrDmd() + ", " + "Current Demand : " + beanWithZeroVal.getCurrDmd() + ", " + "Total Demand : " + beanWithZeroVal.getTotalDemand()));
            if (propUsageIDMap == null) {
                propUsag.put(propNAUsgeId, beanWithZeroVal);
                continue;
            }
            propUsageIDMap.put(propNAUsgeId, beanWithZeroVal);
        }
        LOGGER.debug((Object)"Exit from propNAUsageMapWithDmyVals method");
    }

    public List getZoneList() {
        LOGGER.debug((Object)"Entered into getZoneList method");
        List zoneList = null;
        Criterion criterion = null;
        ProjectionList projection = Projections.projectionList().add((Projection)Projections.property((String)"zone.id")).add((Projection)Projections.property((String)"propTypeMstrID.id")).add((Projection)Projections.sum((String)"aggrArrDmd")).add((Projection)Projections.sum((String)"aggrCurrDmd")).add((Projection)Projections.count((String)"basicPropertyID")).add((Projection)Projections.groupProperty((String)"zone.id")).add((Projection)Projections.groupProperty((String)"propTypeMstrID"));
        Order order = Order.asc((String)"zone.id");
        zoneList = this.propertyDAO.getPropMaterlizeViewList((Projection)projection, criterion, order);
        LOGGER.debug((Object)("Zone list : " + (zoneList != null ? zoneList : BigDecimal.ZERO)));
        LOGGER.debug((Object)"Exit from getZoneList method");
        return zoneList;
    }

    public List getTotPropUsage(Integer bndryNo) {
        LOGGER.debug((Object)"Entered into getTotPropUsage method");
        LOGGER.debug((Object)("Boundary Number : " + bndryNo));
        List wardList = null;
        SimpleExpression criterion = null;
        Object vacantCrit = null;
        Conjunction conjun = Restrictions.conjunction();
        ProjectionList projection = Projections.projectionList().add((Projection)Projections.property((String)"propTypeMstrID.id")).add((Projection)Projections.count((String)"basicPropertyID")).add((Projection)Projections.sum((String)"aggrArrDmd")).add((Projection)Projections.sum((String)"aggrCurrDmd")).add((Projection)Projections.groupProperty((String)"propTypeMstrID"));
        if (bndryNo != null) {
            criterion = Restrictions.like((String)"zone.id", (Object)bndryNo);
            conjun.add((Criterion)criterion);
        }
        wardList = this.propertyDAO.getPropMaterlizeViewList((Projection)projection, (Criterion)conjun, null);
        LOGGER.debug((Object)("Ward list : " + (wardList != null ? wardList : BigDecimal.ZERO)));
        LOGGER.debug((Object)"Exit from getTotPropUsage method");
        return wardList;
    }

    public List getWardList(Integer zoneNo) {
        LOGGER.debug((Object)"Entered into getWardList method");
        LOGGER.debug((Object)("Zone Number : " + zoneNo));
        Object wardList = null;
        Conjunction conjun = Restrictions.conjunction();
        if (zoneNo > 0) {
            SimpleExpression criterion = Restrictions.like((String)"zone.id", (Object)zoneNo);
            conjun.add((Criterion)criterion);
            Integer vacTypeId = this.getPropertyIdbyCode("OPEN_PLOT");
            ProjectionList projection = Projections.projectionList().add((Projection)Projections.property((String)"ward.id")).add((Projection)Projections.property((String)"propTypeMstrID.id")).add((Projection)Projections.sum((String)"aggrArrDmd")).add((Projection)Projections.sum((String)"aggrCurrDmd")).add((Projection)Projections.count((String)"basicPropertyID")).add((Projection)Projections.groupProperty((String)"ward.id")).add((Projection)Projections.groupProperty((String)"propTypeMstrID"));
            Order order = Order.asc((String)"ward.id");
            wardList = this.propertyDAO.getPropMaterlizeViewList((Projection)projection, (Criterion)conjun, order);
        }
        LOGGER.debug((Object)("Ward list : " + (wardList != null ? wardList : BigDecimal.ZERO)));
        LOGGER.debug((Object)"Exit from getWardList method");
        return wardList;
    }

    public String getBndryNameById(long bndryID) {
        Boundary bndryObj;
        LOGGER.debug((Object)"Entered into getBndryNameById method");
        LOGGER.debug((Object)("Boundary Id : " + bndryID));
        String bndName = null;
        if (bndryID > 0L && (bndryObj = this.boundaryService.getBoundaryById(Long.valueOf(bndryID))) != null) {
            bndName = bndryObj.getName();
        }
        LOGGER.debug((Object)("Boundary Name : " + bndName));
        LOGGER.debug((Object)"Exit from getBndryNameById method");
        return bndName;
    }

    private Integer getPropertyIdbyCode(String code) {
        LOGGER.debug((Object)"Entered into getPropertyIdbyCode method");
        PropertyTypeMaster vacMaster = this.propertyTypeMasterDAO.getPropertyTypeMasterByCode(code);
        LOGGER.debug((Object)"Exit from getPropertyIdbyCode method");
        return vacMaster.getId().intValue();
    }

    public Map<Integer, Map<String, BoundryWisePropUsgeBean>> getZoneAndPropertyTypeWiseList(Map<Integer, TreeMap<Integer, BoundryWisePropUsgeBean>> zonePropTypeMap) {
        LOGGER.debug((Object)"Entered into getZoneAndPropertyTypeWiseList method");
        LOGGER.debug((Object)("ZonePropTypeMap : " + (zonePropTypeMap != null ? zonePropTypeMap : BigDecimal.ZERO)));
        TreeMap<Integer, Map<String, BoundryWisePropUsgeBean>> zonePropertyTypeMap = null;
        Map<String, BoundryWisePropUsgeBean> propTypeMap = null;
        zonePropertyTypeMap = new TreeMap<Integer, Map<String, BoundryWisePropUsgeBean>>();
        for (Integer zoneId : zonePropTypeMap.keySet()) {
            LOGGER.debug((Object)("Zone Id : " + zoneId));
            TreeMap<Integer, BoundryWisePropUsgeBean> propTypesMap = zonePropTypeMap.get(zoneId);
            LOGGER.debug((Object)("propTypesMap: " + (propTypesMap != null ? propTypesMap : BigDecimal.ZERO)));
            propTypeMap = new TreeMap();
            propTypeMap = this.initPropTypeMap(propTypeMap);
            for (Integer propTypeId : propTypesMap.keySet()) {
                LOGGER.debug((Object)("propTypeId : " + propTypeId));
                if (propTypeId > 1900) {
                    propTypeMap.put("TotalAgg", propTypesMap.get(propTypeId));
                    continue;
                }
                if (propTypeId < 1900 && propTypeId > 900) continue;
                propTypeMap.put(propTypeId.toString(), propTypesMap.get(propTypeId));
            }
            LOGGER.debug((Object)("PropertyType map : " + (propTypeMap != null ? propTypeMap : BigDecimal.ZERO)));
            zonePropertyTypeMap.put(zoneId, propTypeMap);
        }
        LOGGER.debug((Object)("ZonePropertyType map : " + (zonePropertyTypeMap != null ? zonePropertyTypeMap : BigDecimal.ZERO)));
        LOGGER.debug((Object)"Exit from getZoneAndPropertyTypeWiseList method");
        return zonePropertyTypeMap;
    }

    private void sumUsagesByCategory(String propType, Map<String, BoundryWisePropUsgeBean> propTypeMap, BoundryWisePropUsgeBean bean) {
        LOGGER.debug((Object)"Entered into sumUsagesByCategory method");
        LOGGER.debug((Object)("Property Type : " + propType));
        LOGGER.debug((Object)("PropTypeMap : " + (propTypeMap != null ? propTypeMap : BigDecimal.ZERO)));
        BoundryWisePropUsgeBean newBean = new BoundryWisePropUsgeBean();
        BoundryWisePropUsgeBean existingBean = propTypeMap.get(propType);
        LOGGER.debug((Object)"Existing Bean Details : ");
        LOGGER.debug((Object)("Total Properties : " + existingBean.getPropCount() + ", " + "Arrears Demand : " + existingBean.getArrDmd() + ", " + "Current Demand : " + existingBean.getCurrDmd() + ", " + "Total Demand : " + existingBean.getTotalDemand()));
        newBean.setArrDmd(existingBean.getArrDmd().add(bean.getArrDmd()));
        newBean.setCurrDmd(existingBean.getCurrDmd().add(bean.getCurrDmd()));
        newBean.setTotalDemand(existingBean.getTotalDemand().add(bean.getTotalDemand()));
        newBean.setPropCount(Integer.valueOf(existingBean.getPropCount() + bean.getPropCount()));
        propTypeMap.remove(propType);
        propTypeMap.put(propType, newBean);
        LOGGER.debug((Object)"New Bean Details : ");
        LOGGER.debug((Object)("Total Properties : " + newBean.getPropCount() + ", " + "Arrears Demand : " + newBean.getArrDmd() + ", " + "Current Demand : " + newBean.getCurrDmd() + ", " + "Total Demand : " + newBean.getTotalDemand()));
        LOGGER.debug((Object)"Exit from sumUsagesByCategory method");
    }

    private String getPropertyType(String usageName) {
        LOGGER.debug((Object)"Entered into getPropertyType method");
        LOGGER.debug((Object)("Usage Name : " + usageName));
        String propertyType = null;
        if (usageName != null) {
            if ("C1, D1, D2, E1, E2, E3".contains(usageName)) {
                propertyType = "C1, D1, D2, E1, E2, E3";
            } else if ("A1, A2, A3, A4, A5, A6, B1, B2, C2, C3, C4".contains(usageName)) {
                propertyType = "A1, A2, A3, A4, A5, A6, B1, B2, C2, C3, C4";
            } else if ("C5, D3, E4".contains(usageName)) {
                propertyType = "C5, D3, E4";
            }
        }
        LOGGER.debug((Object)("Property Type : " + propertyType));
        LOGGER.debug((Object)"Exit from getPropertyType method");
        return propertyType;
    }

    private Map<String, BoundryWisePropUsgeBean> initPropTypeMap(Map<String, BoundryWisePropUsgeBean> propTypeMap) {
        LOGGER.debug((Object)"Entered into initPropTypeMap method");
        LOGGER.debug((Object)("PropTypeMap : " + (propTypeMap != null ? propTypeMap : BigDecimal.ZERO)));
        BoundryWisePropUsgeBean bean = new BoundryWisePropUsgeBean();
        bean.setArrDmd(BigDecimal.ZERO);
        bean.setCurrDmd(BigDecimal.ZERO);
        bean.setTotalDemand(BigDecimal.ZERO);
        bean.setPropCount(Integer.valueOf(0));
        List propTypeMstrList = this.propertyTypeMasterDAO.findAll();
        for (PropertyTypeMaster propTypeMstr : propTypeMstrList) {
            propTypeMap.put(propTypeMstr.getId().toString(), bean);
        }
        LOGGER.debug((Object)("PropTypeMap : " + (propTypeMap != null ? propTypeMap : BigDecimal.ZERO)));
        LOGGER.debug((Object)"Exit from initPropTypeMap method");
        return propTypeMap;
    }
}

