/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.actions.bills;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.ptis.actions.common.CommonServices;
import org.egov.ptis.domain.entity.demand.BulkBillGeneration;
import org.egov.ptis.domain.service.bill.BillService;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="bulkBillGeneration-new.jsp"), @Result(name={"ack"}, location="bulkBillGeneration-ack.jsp")})
public class BulkBillGenerationAction
extends BaseFormAction {
    private static final long serialVersionUID = -4113611719476196791L;
    Logger LOGGER = Logger.getLogger(this.getClass());
    public static final String RESULT_ACK = "ack";
    private Long zoneId;
    private Long wardId;
    private Map<Long, String> ZoneBndryMap;
    private String ackMessage;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private BillService billService;
    private List<Boundary> wardList = new ArrayList();

    public Object getModel() {
        return null;
    }

    @SkipValidation
    @Action(value="/bills/bulkBillGeneration-newForm")
    public String newForm() {
        return "new";
    }

    public void prepare() {
        try {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)"Entered into prepare method");
                this.LOGGER.debug((Object)("Zone id : " + this.zoneId + ", " + "Ward id : " + this.wardId));
            }
            List zoneList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
            this.setZoneBndryMap(CommonServices.getFormattedBndryMap((List)zoneList));
            List wardList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
            this.addDropdownData("wardList", wardList);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug((Object)"Exit from prepare method");
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Bill Generation Exception : " + e);
        }
    }

    @SkipValidation
    private void prepareWardDropDownData(boolean zoneExists, boolean wardExists) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Entered into prepareWardDropDownData method");
            this.LOGGER.debug((Object)("Zone exists ? : " + zoneExists + ", " + "Ward exists ? : " + wardExists));
        }
        if (zoneExists && wardExists) {
            List wardNewList = new ArrayList();
            wardNewList = this.boundaryService.getActiveChildBoundariesByBoundaryId(this.getZoneId());
            this.addDropdownData("wardList", wardNewList);
        } else {
            this.addDropdownData("wardList", Collections.EMPTY_LIST);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)"Exit from prepareWardDropDownData method");
        }
    }

    public void validate() {
        if (this.zoneId == null || this.zoneId == -1L) {
            this.addActionError(this.getText("mandatory.zone"));
        }
    }

    @ValidationErrorPage(value="new")
    @Action(value="/bills/bulkBillGeneration-generateBills")
    public String generateBills() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("generateBills method started for zone " + this.zoneId + " and ward number :" + this.wardId));
        }
        BulkBillGeneration bulkBill = null;
        String wardMessage = "";
        Module module = this.moduleService.getModuleByName("Property Tax");
        Installment currentInstall = this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
        List bbgList = this.billService.getBulkBill(this.zoneId, this.wardId, currentInstall);
        if (bbgList != null && !bbgList.isEmpty()) {
            bulkBill = (BulkBillGeneration)bbgList.get(0);
        }
        if (bulkBill == null) {
            bulkBill = this.billService.saveBulkBill(this.zoneId, this.wardId, currentInstall);
            if (this.wardId != null && this.wardId != -1L) {
                wardMessage = ", Ward " + bulkBill.getWard().getName();
            }
            this.setAckMessage("Bill generation scheduled for zone " + bulkBill.getZone().getName() + wardMessage + " and for Installment " + currentInstall.getDescription() + ", you can check the bill generation status using ");
        } else {
            if (this.wardId != null && this.wardId != -1L) {
                wardMessage = ", Ward " + bulkBill.getWard().getName();
            }
            this.setAckMessage("Bill generation already scheduled for zone " + bulkBill.getZone().getName() + wardMessage + " and for Installment " + currentInstall.getDescription() + ", you can check the bill generation status after some time using ");
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug((Object)("generateBills method started for zone " + this.zoneId + " and ward number :" + this.wardId));
        }
        return RESULT_ACK;
    }

    public List<Boundary> getWardList() {
        return this.wardList;
    }

    public void setWardList(List<Boundary> wardList) {
        this.wardList = wardList;
    }

    public Long getWardId() {
        return this.wardId;
    }

    public void setWardId(Long wardId) {
        this.wardId = wardId;
    }

    public String getAckMessage() {
        return this.ackMessage;
    }

    public void setAckMessage(String ackMessage) {
        this.ackMessage = ackMessage;
    }

    public Long getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(Long zoneId) {
        this.zoneId = zoneId;
    }

    public Map<Long, String> getZoneBndryMap() {
        return this.ZoneBndryMap;
    }

    public void setZoneBndryMap(Map<Long, String> zoneBndryMap) {
        this.ZoneBndryMap = zoneBndryMap;
    }
}

