/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.digitalsignature;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.PropertyStatusDAO;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.entity.property.VacancyRemissionApproval;
import org.egov.ptis.domain.repository.vacancyremission.VacancyRemissionApprovalRepository;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/digitalSignature"})
public class DigitalSignatureWorkflowController {
    private static final String SUCCESS_MESSAGE = "successMessage";
    private static final String FALSE = "false";
    private static final String APPLICATION_NO = "applicationNo";
    private static final String DIGISIGN_SUCCESS_MESSAGE = "Digitally Signed Successfully";
    private static final String NOTICE_SUCCESS_MESSAGE = "Notice Generated Successfully";
    private static final String STR_DEMOLITION = "Demolition";
    private static final String BIFURCATE = "Bifurcate";
    private static final String ALTER = "Alter";
    private static final String CREATE = "Create";
    private static final String GRP = "GRP";
    private static final String DIGITAL_SIGNATURE_SUCCESS = "digitalSignature-success";
    private static final String AMALG = "Amalgamation";
    private static final String INITIATOR_INACTIVE_MESSAGE = "Digital signature can not be completed as initiator assignment is inactive for the applicatoin number: ";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyImpl> propertyWorkflowService;
    @Autowired
    private PropertyPersistenceService basicPropertyService;
    @Autowired
    private RevisionPetitionService revisionPetitionService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyMutation> transferWorkflowService;
    @Autowired
    @Qualifier(value="workflowService")
    protected SimpleWorkflowService<RevisionPetition> revisionPetitionWorkFlowService;
    @Autowired
    private PropertyStatusDAO propertyStatusDAO;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;
    @Autowired
    private VacancyRemissionApprovalRepository vacancyRemissionApprovalRepository;

    @RequestMapping(value={"/propertyTax/transitionWorkflow"})
    public String transitionWorkflow(HttpServletRequest request, Model model) {
        String fileStoreIds = request.getParameter("fileStoreId");
        String isDigiEnabled = request.getParameter("isDigiEnabled");
        String[] fileStoreId = fileStoreIds.split(",");
        Boolean assignmentExsits = Boolean.TRUE;
        String applicationNumber = null;
        for (String id : fileStoreId) {
            applicationNumber = (String)this.getCurrentSession().createQuery("select notice.applicationNumber from PtNotice notice where notice.fileStore.fileStoreId = :id").setParameter("id", (Object)id).uniqueResult();
            PropertyImpl property = this.getPropertyByApplicationNo(applicationNumber);
            assignmentExsits = property != null ? this.updateProperty(property) : this.updateOthers(applicationNumber);
            if (!assignmentExsits.booleanValue()) break;
        }
        if (!assignmentExsits.booleanValue()) {
            model.addAttribute(SUCCESS_MESSAGE, (Object)(INITIATOR_INACTIVE_MESSAGE + applicationNumber));
        } else if (isDigiEnabled != null && isDigiEnabled.equals(FALSE)) {
            model.addAttribute(SUCCESS_MESSAGE, (Object)NOTICE_SUCCESS_MESSAGE);
        } else {
            model.addAttribute(SUCCESS_MESSAGE, (Object)DIGISIGN_SUCCESS_MESSAGE);
        }
        if (assignmentExsits.booleanValue()) {
            model.addAttribute("fileStoreId", (Object)(fileStoreId.length == 1 ? fileStoreId[0] : ""));
        }
        return DIGITAL_SIGNATURE_SUCCESS;
    }

    private Boolean updateProperty(PropertyImpl property) {
        BasicProperty basicProperty = property.getBasicProperty();
        String applicationType = this.transition(property);
        List assignments = this.getCurrentOwnerAssignments((StateAware)property);
        if (assignments.isEmpty()) {
            return Boolean.FALSE;
        }
        this.propertyService.updateIndexes((StateAware)property, (String)this.getApplicationTypes().get(applicationType));
        this.basicPropertyService.update((Object)basicProperty);
        return Boolean.TRUE;
    }

    private Boolean updateOthers(String applicationNumber) {
        RevisionPetition revisionPetition = this.getRevisionPetitionByApplicationNo(applicationNumber);
        if (revisionPetition != null) {
            return this.updateRevisionPetition(revisionPetition);
        }
        PropertyMutation propertyMutation = this.getPropertyMutationByApplicationNo(applicationNumber);
        if (propertyMutation != null) {
            return this.updatePropertyMutation(propertyMutation);
        }
        return this.updateVacanyRemission(applicationNumber);
    }

    private Boolean updateRevisionPetition(RevisionPetition revisionPetition) {
        this.transition(revisionPetition);
        List assignments = this.getCurrentOwnerAssignments((StateAware)revisionPetition);
        if (assignments.isEmpty()) {
            return Boolean.FALSE;
        }
        this.propertyService.updateIndexes((StateAware)revisionPetition, "RP".equalsIgnoreCase(revisionPetition.getType()) ? "Revision_Petition" : "General_Revision_Petition");
        this.revisionPetitionService.updateRevisionPetition(revisionPetition);
        return Boolean.TRUE;
    }

    private Boolean updatePropertyMutation(PropertyMutation propertyMutation) {
        BasicProperty basicProperty = propertyMutation.getBasicProperty();
        this.transition(propertyMutation);
        List assignments = this.getCurrentOwnerAssignments((StateAware)propertyMutation);
        if (assignments.isEmpty()) {
            return Boolean.FALSE;
        }
        this.propertyService.updateIndexes((StateAware)propertyMutation, "Transfer_of_Ownership");
        this.basicPropertyService.persist((Object)basicProperty);
        return Boolean.TRUE;
    }

    private Boolean updateVacanyRemission(String applicationNumber) {
        VacancyRemission vacancyRemission = this.getVacancyRemissionByApplicationNo(applicationNumber);
        if (vacancyRemission != null) {
            BasicPropertyImpl basicProperty = vacancyRemission.getBasicProperty();
            this.transition(vacancyRemission);
            List assignments = this.getCurrentOwnerAssignments((StateAware)vacancyRemission);
            if (assignments.isEmpty()) {
                return Boolean.FALSE;
            }
            this.propertyService.updateIndexes((StateAware)vacancyRemission, "Vacancy_Remission");
            this.vacancyRemissionApprovalRepository.save(vacancyRemission.getVacancyRemissionApproval().get(0));
            this.basicPropertyService.persist((Object)basicProperty);
        }
        return Boolean.TRUE;
    }

    private List<Assignment> getCurrentOwnerAssignments(StateAware stateAware) {
        return this.assignmentService.getAssignmentsForPosition(stateAware.getState().getOwnerPosition().getId(), new Date());
    }

    private VacancyRemission getVacancyRemissionByApplicationNo(String applicationNumber) {
        return (VacancyRemission)this.getCurrentSession().createQuery("from VacancyRemission where applicationNumber = :applicationNo").setParameter(APPLICATION_NO, (Object)applicationNumber).uniqueResult();
    }

    private PropertyMutation getPropertyMutationByApplicationNo(String applicationNumber) {
        return (PropertyMutation)this.getCurrentSession().createQuery("from PropertyMutation where applicationNo = :applicationNo").setParameter(APPLICATION_NO, (Object)applicationNumber).uniqueResult();
    }

    private RevisionPetition getRevisionPetitionByApplicationNo(String applicationNumber) {
        return (RevisionPetition)this.getCurrentSession().createQuery("from RevisionPetition where objectionNumber = :applicationNo").setParameter(APPLICATION_NO, (Object)applicationNumber).uniqueResult();
    }

    private PropertyImpl getPropertyByApplicationNo(String applicationNumber) {
        return (PropertyImpl)this.getCurrentSession().createQuery("from PropertyImpl where applicationNo = :applicationNo").setParameter(APPLICATION_NO, (Object)applicationNumber).uniqueResult();
    }

    private Map<String, String> getApplicationTypes() {
        HashMap<String, String> applicationTypes = new HashMap<String, String>();
        applicationTypes.put(CREATE, "New_Assessment");
        applicationTypes.put(ALTER, "Alter_Assessment");
        applicationTypes.put(BIFURCATE, "Bifuracate_Assessment");
        applicationTypes.put(STR_DEMOLITION, STR_DEMOLITION);
        applicationTypes.put(GRP, "General_Revision_Petition");
        applicationTypes.put("Exemption", "Tax_Exemption");
        applicationTypes.put(AMALG, AMALG);
        return applicationTypes;
    }

    private String transition(PropertyImpl property) {
        String applicationType = property.getCurrentState().getValue().split(":")[0];
        if (this.propertyService.isMeesevaUser(property.getCreatedBy()).booleanValue()) {
            property.transition().end();
            property.getBasicProperty().setUnderWorkflow(false);
        } else {
            User user = this.securityUtils.getCurrentUser();
            DateTime currentDate = new DateTime();
            Position initiator = property.getCurrentState().getInitiatorPosition();
            if (initiator == null) {
                Assignment wfInitiator = this.getWorkflowInitiator((StateAware)property, property.getBasicProperty());
                initiator = wfInitiator != null ? wfInitiator.getPosition() : null;
            }
            String currentState = property.getCurrentState().getValue().split(":")[0] + ":" + "Digitally Signed";
            property.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withStateValue(currentState).withDateInfo(currentDate.toDate()).withOwner(initiator).withNextAction("Notice Print Pending");
        }
        return applicationType;
    }

    private void transition(RevisionPetition revPetition) {
        if (this.propertyService.isMeesevaUser(revPetition.getCreatedBy()).booleanValue()) {
            revPetition.getBasicProperty().setStatus(this.propertyStatusDAO.getPropertyStatusByCode("ASSESSED"));
            revPetition.getBasicProperty().getProperty().setStatus(PropertyTaxConstants.STATUS_ISHISTORY);
            revPetition.getBasicProperty().setUnderWorkflow(Boolean.FALSE.booleanValue());
            revPetition.getProperty().setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
            revPetition.transition().end();
        } else {
            User user = this.securityUtils.getCurrentUser();
            Position initiator = revPetition.getCurrentState().getInitiatorPosition();
            if (initiator == null) {
                Assignment wfInitiator = this.getWorkflowInitiator((StateAware)revPetition, revPetition.getBasicProperty());
                initiator = wfInitiator != null ? wfInitiator.getPosition() : null;
            }
            revPetition.transition().progressWithStateCopy().withStateValue(revPetition.getType().concat(":").concat("Digitally Signed")).withOwner(initiator).withSenderName(user.getUsername() + "::" + user.getName()).withDateInfo(new DateTime().toDate()).withNextAction("Print Special Notice");
        }
    }

    public void transition(PropertyMutation propertyMutation) {
        if (this.propertyService.isMeesevaUser(propertyMutation.getCreatedBy()).booleanValue() || propertyMutation.getType().equals("FULL TRANSFER")) {
            propertyMutation.transition().end();
            propertyMutation.getBasicProperty().setUnderWorkflow(false);
        } else {
            DateTime currentDate = new DateTime();
            User user = this.securityUtils.getCurrentUser();
            Position initiator = propertyMutation.getCurrentState().getInitiatorPosition();
            if (initiator == null) {
                Assignment wfInitiator = this.getWorkflowInitiator((StateAware)propertyMutation, propertyMutation.getBasicProperty());
                initiator = wfInitiator != null ? wfInitiator.getPosition() : null;
            }
            propertyMutation.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withStateValue("Digitally Signed").withDateInfo(currentDate.toDate()).withOwner(initiator).withNextAction("Transfer Notice Print Pending");
        }
    }

    private void transition(VacancyRemission vacancyRemission) {
        if (this.propertyService.isMeesevaUser(vacancyRemission.getCreatedBy()).booleanValue()) {
            vacancyRemission.transition().end();
            vacancyRemission.getBasicProperty().setUnderWorkflow(false);
        } else {
            DateTime currentDate = new DateTime();
            User user = this.securityUtils.getCurrentUser();
            Position initiator = vacancyRemission.getCurrentState().getInitiatorPosition();
            if (initiator == null) {
                Assignment wfInitiator = this.getWorkflowInitiator((StateAware)vacancyRemission, (BasicProperty)vacancyRemission.getBasicProperty());
                initiator = wfInitiator != null ? wfInitiator.getPosition() : null;
            }
            VacancyRemissionApproval vacancyRemissionApproval = (VacancyRemissionApproval)vacancyRemission.getVacancyRemissionApproval().get(0);
            vacancyRemissionApproval.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withStateValue("Digitally Signed").withDateInfo(currentDate.toDate()).withOwner(initiator).withNextAction("Notice Print Pending");
        }
    }

    private Assignment getWorkflowInitiator(StateAware state, BasicProperty basicProperty) {
        Assignment wfInitiator = null;
        if (basicProperty.getSource().equals(PropertyTaxConstants.SOURCEOFDATA_ONLINE)) {
            if (!state.getStateHistory().isEmpty()) {
                wfInitiator = (Assignment)this.assignmentService.getAssignmentsForPosition(((StateHistory)state.getStateHistory().get(0)).getOwnerPosition().getId(), new Date()).get(0);
            }
        } else {
            wfInitiator = this.propertyService.isEmployee(state.getCreatedBy()) != false && !"Anonymous".equalsIgnoreCase(state.getCreatedBy().getName()) ? (Assignment)this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(state.getCreatedBy().getId()).get(0) : (!state.getStateHistory().isEmpty() ? (Assignment)this.assignmentService.getAssignmentsForPosition(((StateHistory)state.getStateHistory().get(0)).getOwnerPosition().getId(), new Date()).get(0) : (Assignment)this.assignmentService.getAssignmentsForPosition(state.getState().getOwnerPosition().getId(), new Date()).get(0));
        }
        return wfInitiator;
    }

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @RequestMapping(value={"/propertyTax/downloadSignedNotice"})
    public void downloadSignedNotice(HttpServletRequest request, HttpServletResponse response) {
        String signedFileStoreId = request.getParameter("signedFileStoreId");
        File file = this.fileStoreService.fetch(signedFileStoreId, "PTIS");
        FileStoreMapper fileStoreMapper = this.fileStoreMapperRepository.findByFileStoreId(signedFileStoreId);
        response.setContentType("application/pdf");
        response.setContentType("application/octet-stream");
        response.setHeader("content-disposition", "attachment; filename=\"" + fileStoreMapper.getFileName() + "\"");
        try (FileInputStream inStream = new FileInputStream(file);){
            ServletOutputStream outStream = response.getOutputStream();
            int bytesRead = -1;
            byte[] buffer = FileUtils.readFileToByteArray((File)file);
            while ((bytesRead = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
        }
        catch (FileNotFoundException fileNotFoundExcep) {
            throw new ApplicationRuntimeException("Exception while loading file : " + fileNotFoundExcep);
        }
        catch (IOException ioExcep) {
            throw new ApplicationRuntimeException("Exception while downloading notice : " + ioExcep);
        }
    }
}

