/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.deactivation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.PropertyDeactivation;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.service.deactivation.PropertyDeactivationService;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/deactivation"})
public class PropertyDeactivationController
extends GenericWorkFlowController {
    private static final String BASIC_PROPERTY = "basicproperty";
    private static final String ORIGINAL_PROPERTY = "originalAssessment";
    private static final String DEACTIVATE_REASONS = "deactivationReasons";
    private static final String DEACT_FORM = "deactivation-form";
    private static final String BOGUS_PROPERTY = "Bogus Property";
    private static final String NO_PROP_ERROR = "error.noproperty";
    private static final String DOCS_LIST = "documentsList";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PropertyPersistenceService basicPropertyService;
    @Autowired
    private PropertyDeactivationService propertyDeactivationService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PropertyService propertyService;
    BasicProperty basicProperty;
    PropertyImpl propertyImpl = new PropertyImpl();
    PropertyImpl oldProperty;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @ModelAttribute
    public PropertyDeactivation propertyDeactivation() {
        return new PropertyDeactivation();
    }

    @ModelAttribute(value="documentsList")
    public List<DocumentType> documentsList(@ModelAttribute PropertyDeactivation propertyDeactivation) {
        return this.propertyDeactivationService.getDocuments(TransactionType.DEACTIVATE);
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String deactivationForm(Model model) {
        List deactivationReasons = this.propertyDeactivationService.getDeactivationReasons();
        model.addAttribute("propertyDeactivation", (Object)new PropertyDeactivation());
        model.addAttribute(DEACTIVATE_REASONS, (Object)deactivationReasons);
        return DEACT_FORM;
    }

    @RequestMapping(value={"/search/{assessmentNo}"}, method={RequestMethod.POST})
    public String deactivationSearchForm(@ModelAttribute PropertyDeactivation propertyDeactivation, Model model, BindingResult resultBinder, @PathVariable(value="assessmentNo") String assessmentNo, HttpServletRequest request, Errors errors) {
        List deactivationReasons = this.propertyDeactivationService.getDeactivationReasons();
        model.addAttribute(BASIC_PROPERTY, (Object)propertyDeactivation.getBasicproperty());
        model.addAttribute("reasonMaster", (Object)propertyDeactivation.getReasonMaster());
        model.addAttribute(ORIGINAL_PROPERTY, (Object)propertyDeactivation.getOriginalAssessment());
        model.addAttribute(DEACTIVATE_REASONS, (Object)deactivationReasons);
        this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        BasicProperty orgBasicProp = this.basicPropertyDAO.getBasicPropertyByPropertyID(propertyDeactivation.getOriginalAssessment());
        if (this.basicProperty == null) {
            resultBinder.rejectValue(BASIC_PROPERTY, NO_PROP_ERROR);
            return DEACT_FORM;
        }
        boolean isPropChildUnderWF = this.propertyTaxUtil.checkForParentUsedInBifurcation(this.basicProperty.getUpicNo());
        if (this.basicProperty.isUnderWorkflow() || isPropChildUnderWF) {
            resultBinder.rejectValue(BASIC_PROPERTY, "error.prop.under.wf");
            return DEACT_FORM;
        }
        if (!BOGUS_PROPERTY.equalsIgnoreCase(propertyDeactivation.getReasonMaster())) {
            if (orgBasicProp == null || this.basicProperty.getUpicNo().equals(orgBasicProp.getUpicNo())) {
                resultBinder.rejectValue(ORIGINAL_PROPERTY, NO_PROP_ERROR);
                return DEACT_FORM;
            }
            Map orgPropDetails = this.propertyDeactivationService.getPropertyDetails(orgBasicProp);
            List orgPropWCDetails = this.propertyService.getWCDetails(orgBasicProp.getUpicNo(), request);
            model.addAttribute("orgPropDetails", (Object)orgPropDetails);
            model.addAttribute("orgPropWCDetails", (Object)orgPropWCDetails);
        } else {
            Map propDetails = this.propertyDeactivationService.getPropertyDetails(this.basicProperty);
            List wcDetails = this.propertyService.getWCDetails(this.basicProperty.getUpicNo(), request);
            boolean hasActiveWC = this.propertyDeactivationService.checkActiveWC(wcDetails);
            model.addAttribute("propDetails", (Object)propDetails);
            model.addAttribute("wcDetails", (Object)wcDetails);
            model.addAttribute("hasActiveWC", (Object)hasActiveWC);
        }
        List documentTypes = this.propertyService.getDocumentTypesForTransactionType(TransactionType.DEACTIVATE);
        model.addAttribute("documentTypes", (Object)documentTypes);
        return DEACT_FORM;
    }

    @RequestMapping(value={"/update/{assessmentNo}"}, method={RequestMethod.POST})
    public String deactivationFormSubmit(@ModelAttribute PropertyDeactivation propertyDeactivation, BindingResult resultBinder, RedirectAttributes redirectAttrs, Model model, @PathVariable(value="assessmentNo") String assessmentNo) {
        this.basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        ArrayList documents = new ArrayList();
        if (this.basicProperty == null) {
            resultBinder.rejectValue(BASIC_PROPERTY, NO_PROP_ERROR);
            return DEACT_FORM;
        }
        if (this.basicProperty.isUnderWorkflow()) {
            resultBinder.rejectValue(BASIC_PROPERTY, "error.prop.under.wf");
            return DEACT_FORM;
        }
        if (propertyDeactivation.getOriginalAssessment() == null && !BOGUS_PROPERTY.equalsIgnoreCase(propertyDeactivation.getReasonMaster())) {
            resultBinder.rejectValue(ORIGINAL_PROPERTY, NO_PROP_ERROR);
            return DEACT_FORM;
        }
        documents.addAll(propertyDeactivation.getDocuments());
        propertyDeactivation.getDocuments().clear();
        propertyDeactivation.setDocuments(documents);
        this.processAndStoreApplicationDocuments(propertyDeactivation);
        PropertyStatusValues propStatusValues = this.propertyService.createPropStatVal(this.basicProperty, "DEACTIVATE", null, null, null, null, null);
        propertyDeactivation.setBasicproperty(this.basicProperty.getId());
        this.propertyDeactivationService.save(propertyDeactivation);
        this.basicProperty.setActive(Boolean.valueOf(false));
        this.basicProperty.setModifiedDate(new Date());
        this.basicProperty.addPropertyStatusValues(propStatusValues);
        this.basicPropertyService.persist((Object)this.basicProperty);
        model.addAttribute("message", (Object)"deactivate.ack.msg");
        model.addAttribute("assessmentNo", (Object)assessmentNo);
        return "deactivation-success";
    }

    protected void processAndStoreApplicationDocuments(PropertyDeactivation dsd) {
        if (!dsd.getDocuments().isEmpty()) {
            for (Document applicationDocument : dsd.getDocuments()) {
                applicationDocument.setType(this.propertyDeactivationService.getDocType(applicationDocument.getType().getName()));
                applicationDocument.setFiles(this.addToFileStore(applicationDocument.getFile()));
            }
        }
    }

    protected Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "PTIS");
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("err.input.stream", (Throwable)e);
                }
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

