/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.web.controller.transactions.dataentry;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.model.ArrearsInfo;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/addarrears"})
public class AddArrearsController {
    private static final String ADDARREARS_FORM = "addArrears-form";
    private static final String ADDARREARS_SUCCESS = "addArrears-success";
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private DemandGenericDao demandGenericDao;
    @Autowired
    private PersistenceService<Ptdemand, Long> persistenceService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    @ModelAttribute
    public ArrearsInfo getArrearsInfo() {
        return new ArrearsInfo();
    }

    @RequestMapping(value={"/form/{assessmentNo}"}, method={RequestMethod.GET})
    public String newform(Model model, @PathVariable String assessmentNo, HttpServletRequest request) throws ParseException {
        PropertyImpl property;
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        Date installmentDate = this.getInstallmentDate();
        Module module = this.moduleDao.getModuleByName("Property Tax");
        if (basicProperty != null && (property = basicProperty.getActiveProperty()) != null) {
            Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, installmentDate);
            Ptdemand ptDemand = (Ptdemand)this.persistenceService.find("from  Ptdemand ptd where ptd.egptProperty =? and ptd.egInstallmentMaster.id =? ", new Object[]{property, this.propertyTaxCommonUtils.getCurrentInstallment().getId()});
            Boolean arrearDemandExists = this.checkDemandExistsForInstallment(ptDemand, installment);
            model.addAttribute("propertyType", (Object)property.getPropertyDetail().getPropertyTypeMaster().getCode());
            model.addAttribute("arrearsMessage", (Object)("Arrears as on " + installment.getDescription()));
            if (arrearDemandExists.booleanValue()) {
                model.addAttribute("errorMsg", (Object)("Arrears are already added for the installment " + installment.getDescription()));
                return "propertyValidation";
            }
        }
        return ADDARREARS_FORM;
    }

    private Date getInstallmentDate() throws ParseException {
        SimpleDateFormat dateformat = new SimpleDateFormat("dd/MM/yyyy");
        Date installmentDate = dateformat.parse("01/04/2015");
        return installmentDate;
    }

    private Boolean checkDemandExistsForInstallment(Ptdemand ptDemand, Installment installment) {
        Boolean demandDetailsExist = false;
        for (EgDemandDetails demandDetails : ptDemand.getEgDemandDetails()) {
            if (!demandDetails.getEgDemandReason().getEgInstallmentMaster().equals((Object)installment)) continue;
            demandDetailsExist = true;
            break;
        }
        return demandDetailsExist;
    }

    @RequestMapping(value={"/form/{assessmentNo}"}, method={RequestMethod.POST})
    public String saveArrears(@Valid @ModelAttribute ArrearsInfo arrearsInfo, @PathVariable String assessmentNo, BindingResult errors, RedirectAttributes redirectAttrs, Model model) throws ParseException {
        if (errors.hasErrors()) {
            return ADDARREARS_FORM;
        }
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        Ptdemand ptDemand = (Ptdemand)this.persistenceService.find("from  Ptdemand ptd where ptd.egptProperty =? and ptd.egInstallmentMaster.id =? ", new Object[]{basicProperty.getActiveProperty(), this.propertyTaxCommonUtils.getCurrentInstallment().getId()});
        this.addDemandDetails(arrearsInfo, ptDemand);
        this.persistenceService.update((Object)ptDemand);
        model.addAttribute("successMessage", (Object)"Arrears are added successfully!");
        return ADDARREARS_SUCCESS;
    }

    private void addDemandDetails(ArrearsInfo arrearsInfo, Ptdemand ptDemand) throws ParseException {
        EgDemandDetails demandDetails;
        EgDemandReason demandReason;
        Module module = this.moduleDao.getModuleByName("Property Tax");
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, this.getInstallmentDate());
        if (arrearsInfo.getGeneralTax() != null && arrearsInfo.getGeneralTax().compareTo(BigDecimal.ZERO) == 1) {
            demandReason = this.demandGenericDao.getEgDemandReasonByCodeInstallmentModule("GEN_TAX", installment, module, null);
            demandDetails = this.propertyService.createDemandDetails(arrearsInfo.getGeneralTax(), null, demandReason, installment);
            ptDemand.getEgDemandDetails().add(demandDetails);
        }
        if (arrearsInfo.getVacantLandTax() != null && arrearsInfo.getVacantLandTax().compareTo(BigDecimal.ZERO) == 1) {
            demandReason = this.demandGenericDao.getEgDemandReasonByCodeInstallmentModule("VAC_LAND_TAX", installment, module, null);
            demandDetails = this.propertyService.createDemandDetails(arrearsInfo.getVacantLandTax(), null, demandReason, installment);
            ptDemand.getEgDemandDetails().add(demandDetails);
        }
        if (arrearsInfo.getLibraryCess() != null && arrearsInfo.getLibraryCess().compareTo(BigDecimal.ZERO) == 1) {
            demandReason = this.demandGenericDao.getEgDemandReasonByCodeInstallmentModule("LIB_CESS", installment, module, null);
            demandDetails = this.propertyService.createDemandDetails(arrearsInfo.getLibraryCess(), null, demandReason, installment);
            ptDemand.getEgDemandDetails().add(demandDetails);
        }
        if (arrearsInfo.getEducationCess() != null && arrearsInfo.getEducationCess().compareTo(BigDecimal.ZERO) == 1) {
            demandReason = this.demandGenericDao.getEgDemandReasonByCodeInstallmentModule("EDU_CESS", installment, module, null);
            demandDetails = this.propertyService.createDemandDetails(arrearsInfo.getEducationCess(), null, demandReason, installment);
            ptDemand.getEgDemandDetails().add(demandDetails);
        }
        if (arrearsInfo.getUnauthorizedPenalty() != null && arrearsInfo.getUnauthorizedPenalty().compareTo(BigDecimal.ZERO) == 1) {
            demandReason = this.demandGenericDao.getEgDemandReasonByCodeInstallmentModule("UNAUTH_PENALTY", installment, module, null);
            demandDetails = this.propertyService.createDemandDetails(arrearsInfo.getUnauthorizedPenalty(), null, demandReason, installment);
            ptDemand.getEgDemandDetails().add(demandDetails);
        }
        if (arrearsInfo.getLatePaymentPenalty() != null && arrearsInfo.getLatePaymentPenalty().compareTo(BigDecimal.ZERO) == 1) {
            demandReason = this.demandGenericDao.getEgDemandReasonByCodeInstallmentModule("PENALTY_FINES", installment, module, null);
            demandDetails = this.propertyService.createDemandDetails(arrearsInfo.getLatePaymentPenalty(), null, demandReason, installment);
            ptDemand.getEgDemandDetails().add(demandDetails);
        }
    }
}

